# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_11.models.live_tv_service_status import LiveTvServiceStatus
from typing import Optional, Set
from typing_extensions import Self

class LiveTvServiceInfo(BaseModel):
    """
    Class ServiceInfo.
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name.", alias="Name")
    home_page_url: Optional[StrictStr] = Field(default=None, description="Gets or sets the home page URL.", alias="HomePageUrl")
    status: Optional[LiveTvServiceStatus] = Field(default=None, description="Gets or sets the status.", alias="Status")
    status_message: Optional[StrictStr] = Field(default=None, description="Gets or sets the status message.", alias="StatusMessage")
    version: Optional[StrictStr] = Field(default=None, description="Gets or sets the version.", alias="Version")
    has_update_available: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance has update available.", alias="HasUpdateAvailable")
    is_visible: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is visible.", alias="IsVisible")
    tuners: Optional[List[StrictStr]] = Field(default=None, alias="Tuners")
    __properties: ClassVar[List[str]] = ["Name", "HomePageUrl", "Status", "StatusMessage", "Version", "HasUpdateAvailable", "IsVisible", "Tuners"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LiveTvServiceInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['Name'] = None

        # set to None if home_page_url (nullable) is None
        # and model_fields_set contains the field
        if self.home_page_url is None and "home_page_url" in self.model_fields_set:
            _dict['HomePageUrl'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['StatusMessage'] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['Version'] = None

        # set to None if tuners (nullable) is None
        # and model_fields_set contains the field
        if self.tuners is None and "tuners" in self.model_fields_set:
            _dict['Tuners'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LiveTvServiceInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Name": obj.get("Name"),
            "HomePageUrl": obj.get("HomePageUrl"),
            "Status": obj.get("Status"),
            "StatusMessage": obj.get("StatusMessage"),
            "Version": obj.get("Version"),
            "HasUpdateAvailable": obj.get("HasUpdateAvailable"),
            "IsVisible": obj.get("IsVisible"),
            "Tuners": obj.get("Tuners")
        })
        return _obj


