# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_11.models.lyric_line_cue import LyricLineCue
from typing import Optional, Set
from typing_extensions import Self

class LyricLine(BaseModel):
    """
    Lyric model.
    """ # noqa: E501
    text: Optional[StrictStr] = Field(default=None, description="Gets the text of this lyric line.", alias="Text")
    start: Optional[StrictInt] = Field(default=None, description="Gets the start time in ticks.", alias="Start")
    cues: Optional[List[LyricLineCue]] = Field(default=None, description="Gets the time-aligned cues for the song's lyrics.", alias="Cues")
    __properties: ClassVar[List[str]] = ["Text", "Start", "Cues"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LyricLine from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cues (list)
        _items = []
        if self.cues:
            for _item_cues in self.cues:
                if _item_cues:
                    _items.append(_item_cues.to_dict())
            _dict['Cues'] = _items
        # set to None if start (nullable) is None
        # and model_fields_set contains the field
        if self.start is None and "start" in self.model_fields_set:
            _dict['Start'] = None

        # set to None if cues (nullable) is None
        # and model_fields_set contains the field
        if self.cues is None and "cues" in self.model_fields_set:
            _dict['Cues'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LyricLine from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Text": obj.get("Text"),
            "Start": obj.get("Start"),
            "Cues": [LyricLineCue.from_dict(_item) for _item in obj["Cues"]] if obj.get("Cues") is not None else None
        })
        return _obj


