# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class LyricMetadata(BaseModel):
    """
    LyricMetadata model.
    """ # noqa: E501
    artist: Optional[StrictStr] = Field(default=None, description="Gets or sets the song artist.", alias="Artist")
    album: Optional[StrictStr] = Field(default=None, description="Gets or sets the album this song is on.", alias="Album")
    title: Optional[StrictStr] = Field(default=None, description="Gets or sets the title of the song.", alias="Title")
    author: Optional[StrictStr] = Field(default=None, description="Gets or sets the author of the lyric data.", alias="Author")
    length: Optional[StrictInt] = Field(default=None, description="Gets or sets the length of the song in ticks.", alias="Length")
    by: Optional[StrictStr] = Field(default=None, description="Gets or sets who the LRC file was created by.", alias="By")
    offset: Optional[StrictInt] = Field(default=None, description="Gets or sets the lyric offset compared to audio in ticks.", alias="Offset")
    creator: Optional[StrictStr] = Field(default=None, description="Gets or sets the software used to create the LRC file.", alias="Creator")
    version: Optional[StrictStr] = Field(default=None, description="Gets or sets the version of the creator used.", alias="Version")
    is_synced: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this lyric is synced.", alias="IsSynced")
    __properties: ClassVar[List[str]] = ["Artist", "Album", "Title", "Author", "Length", "By", "Offset", "Creator", "Version", "IsSynced"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LyricMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if artist (nullable) is None
        # and model_fields_set contains the field
        if self.artist is None and "artist" in self.model_fields_set:
            _dict['Artist'] = None

        # set to None if album (nullable) is None
        # and model_fields_set contains the field
        if self.album is None and "album" in self.model_fields_set:
            _dict['Album'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['Title'] = None

        # set to None if author (nullable) is None
        # and model_fields_set contains the field
        if self.author is None and "author" in self.model_fields_set:
            _dict['Author'] = None

        # set to None if length (nullable) is None
        # and model_fields_set contains the field
        if self.length is None and "length" in self.model_fields_set:
            _dict['Length'] = None

        # set to None if by (nullable) is None
        # and model_fields_set contains the field
        if self.by is None and "by" in self.model_fields_set:
            _dict['By'] = None

        # set to None if offset (nullable) is None
        # and model_fields_set contains the field
        if self.offset is None and "offset" in self.model_fields_set:
            _dict['Offset'] = None

        # set to None if creator (nullable) is None
        # and model_fields_set contains the field
        if self.creator is None and "creator" in self.model_fields_set:
            _dict['Creator'] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['Version'] = None

        # set to None if is_synced (nullable) is None
        # and model_fields_set contains the field
        if self.is_synced is None and "is_synced" in self.model_fields_set:
            _dict['IsSynced'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LyricMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Artist": obj.get("Artist"),
            "Album": obj.get("Album"),
            "Title": obj.get("Title"),
            "Author": obj.get("Author"),
            "Length": obj.get("Length"),
            "By": obj.get("By"),
            "Offset": obj.get("Offset"),
            "Creator": obj.get("Creator"),
            "Version": obj.get("Version"),
            "IsSynced": obj.get("IsSynced")
        })
        return _obj


