# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_11.models.media_path_info import MediaPathInfo
from typing import Optional, Set
from typing_extensions import Self

class MediaPathDto(BaseModel):
    """
    Media Path dto.
    """ # noqa: E501
    name: StrictStr = Field(description="Gets or sets the name of the library.", alias="Name")
    path: Optional[StrictStr] = Field(default=None, description="Gets or sets the path to add.", alias="Path")
    path_info: Optional[MediaPathInfo] = Field(default=None, description="Gets or sets the path info.", alias="PathInfo")
    __properties: ClassVar[List[str]] = ["Name", "Path", "PathInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MediaPathDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of path_info
        if self.path_info:
            _dict['PathInfo'] = self.path_info.to_dict()
        # set to None if path (nullable) is None
        # and model_fields_set contains the field
        if self.path is None and "path" in self.model_fields_set:
            _dict['Path'] = None

        # set to None if path_info (nullable) is None
        # and model_fields_set contains the field
        if self.path_info is None and "path_info" in self.model_fields_set:
            _dict['PathInfo'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MediaPathDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Name": obj.get("Name"),
            "Path": obj.get("Path"),
            "PathInfo": MediaPathInfo.from_dict(obj["PathInfo"]) if obj.get("PathInfo") is not None else None
        })
        return _obj


