# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_11.models.media_segment_type import MediaSegmentType
from typing import Optional, Set
from typing_extensions import Self

class MediaSegmentDto(BaseModel):
    """
    Api model for MediaSegment's.
    """ # noqa: E501
    id: Optional[UUID] = Field(default=None, description="Gets or sets the id of the media segment.", alias="Id")
    item_id: Optional[UUID] = Field(default=None, description="Gets or sets the id of the associated item.", alias="ItemId")
    type: Optional[MediaSegmentType] = Field(default=MediaSegmentType.UNKNOWN, description="Gets or sets the type of content this segment defines.", alias="Type")
    start_ticks: Optional[StrictInt] = Field(default=None, description="Gets or sets the start of the segment.", alias="StartTicks")
    end_ticks: Optional[StrictInt] = Field(default=None, description="Gets or sets the end of the segment.", alias="EndTicks")
    __properties: ClassVar[List[str]] = ["Id", "ItemId", "Type", "StartTicks", "EndTicks"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MediaSegmentDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MediaSegmentDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Id": obj.get("Id"),
            "ItemId": obj.get("ItemId"),
            "Type": obj.get("Type") if obj.get("Type") is not None else MediaSegmentType.UNKNOWN,
            "StartTicks": obj.get("StartTicks"),
            "EndTicks": obj.get("EndTicks")
        })
        return _obj


