# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_11.models.iso_type import IsoType
from jellyfin.generated.api_10_11.models.media_attachment import MediaAttachment
from jellyfin.generated.api_10_11.models.media_protocol import MediaProtocol
from jellyfin.generated.api_10_11.models.media_source_type import MediaSourceType
from jellyfin.generated.api_10_11.models.media_stream import MediaStream
from jellyfin.generated.api_10_11.models.media_stream_protocol import MediaStreamProtocol
from jellyfin.generated.api_10_11.models.transport_stream_timestamp import TransportStreamTimestamp
from jellyfin.generated.api_10_11.models.video3_d_format import Video3DFormat
from jellyfin.generated.api_10_11.models.video_type import VideoType
from typing import Optional, Set
from typing_extensions import Self

class MediaSourceInfo(BaseModel):
    """
    MediaSourceInfo
    """ # noqa: E501
    protocol: Optional[MediaProtocol] = Field(default=None, alias="Protocol")
    id: Optional[StrictStr] = Field(default=None, alias="Id")
    path: Optional[StrictStr] = Field(default=None, alias="Path")
    encoder_path: Optional[StrictStr] = Field(default=None, alias="EncoderPath")
    encoder_protocol: Optional[MediaProtocol] = Field(default=None, alias="EncoderProtocol")
    type: Optional[MediaSourceType] = Field(default=None, alias="Type")
    container: Optional[StrictStr] = Field(default=None, alias="Container")
    size: Optional[StrictInt] = Field(default=None, alias="Size")
    name: Optional[StrictStr] = Field(default=None, alias="Name")
    is_remote: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the media is remote.  Differentiate internet url vs local network.", alias="IsRemote")
    e_tag: Optional[StrictStr] = Field(default=None, alias="ETag")
    run_time_ticks: Optional[StrictInt] = Field(default=None, alias="RunTimeTicks")
    read_at_native_framerate: Optional[StrictBool] = Field(default=None, alias="ReadAtNativeFramerate")
    ignore_dts: Optional[StrictBool] = Field(default=None, alias="IgnoreDts")
    ignore_index: Optional[StrictBool] = Field(default=None, alias="IgnoreIndex")
    gen_pts_input: Optional[StrictBool] = Field(default=None, alias="GenPtsInput")
    supports_transcoding: Optional[StrictBool] = Field(default=None, alias="SupportsTranscoding")
    supports_direct_stream: Optional[StrictBool] = Field(default=None, alias="SupportsDirectStream")
    supports_direct_play: Optional[StrictBool] = Field(default=None, alias="SupportsDirectPlay")
    is_infinite_stream: Optional[StrictBool] = Field(default=None, alias="IsInfiniteStream")
    use_most_compatible_transcoding_profile: Optional[StrictBool] = Field(default=False, alias="UseMostCompatibleTranscodingProfile")
    requires_opening: Optional[StrictBool] = Field(default=None, alias="RequiresOpening")
    open_token: Optional[StrictStr] = Field(default=None, alias="OpenToken")
    requires_closing: Optional[StrictBool] = Field(default=None, alias="RequiresClosing")
    live_stream_id: Optional[StrictStr] = Field(default=None, alias="LiveStreamId")
    buffer_ms: Optional[StrictInt] = Field(default=None, alias="BufferMs")
    requires_looping: Optional[StrictBool] = Field(default=None, alias="RequiresLooping")
    supports_probing: Optional[StrictBool] = Field(default=None, alias="SupportsProbing")
    video_type: Optional[VideoType] = Field(default=None, alias="VideoType")
    iso_type: Optional[IsoType] = Field(default=None, alias="IsoType")
    video3_d_format: Optional[Video3DFormat] = Field(default=None, alias="Video3DFormat")
    media_streams: Optional[List[MediaStream]] = Field(default=None, alias="MediaStreams")
    media_attachments: Optional[List[MediaAttachment]] = Field(default=None, alias="MediaAttachments")
    formats: Optional[List[StrictStr]] = Field(default=None, alias="Formats")
    bitrate: Optional[StrictInt] = Field(default=None, alias="Bitrate")
    fallback_max_streaming_bitrate: Optional[StrictInt] = Field(default=None, alias="FallbackMaxStreamingBitrate")
    timestamp: Optional[TransportStreamTimestamp] = Field(default=None, alias="Timestamp")
    required_http_headers: Optional[Dict[str, Optional[StrictStr]]] = Field(default=None, alias="RequiredHttpHeaders")
    transcoding_url: Optional[StrictStr] = Field(default=None, alias="TranscodingUrl")
    transcoding_sub_protocol: Optional[MediaStreamProtocol] = Field(default=None, description="Media streaming protocol.  Lowercase for backwards compatibility.", alias="TranscodingSubProtocol")
    transcoding_container: Optional[StrictStr] = Field(default=None, alias="TranscodingContainer")
    analyze_duration_ms: Optional[StrictInt] = Field(default=None, alias="AnalyzeDurationMs")
    default_audio_stream_index: Optional[StrictInt] = Field(default=None, alias="DefaultAudioStreamIndex")
    default_subtitle_stream_index: Optional[StrictInt] = Field(default=None, alias="DefaultSubtitleStreamIndex")
    has_segments: Optional[StrictBool] = Field(default=None, alias="HasSegments")
    __properties: ClassVar[List[str]] = ["Protocol", "Id", "Path", "EncoderPath", "EncoderProtocol", "Type", "Container", "Size", "Name", "IsRemote", "ETag", "RunTimeTicks", "ReadAtNativeFramerate", "IgnoreDts", "IgnoreIndex", "GenPtsInput", "SupportsTranscoding", "SupportsDirectStream", "SupportsDirectPlay", "IsInfiniteStream", "UseMostCompatibleTranscodingProfile", "RequiresOpening", "OpenToken", "RequiresClosing", "LiveStreamId", "BufferMs", "RequiresLooping", "SupportsProbing", "VideoType", "IsoType", "Video3DFormat", "MediaStreams", "MediaAttachments", "Formats", "Bitrate", "FallbackMaxStreamingBitrate", "Timestamp", "RequiredHttpHeaders", "TranscodingUrl", "TranscodingSubProtocol", "TranscodingContainer", "AnalyzeDurationMs", "DefaultAudioStreamIndex", "DefaultSubtitleStreamIndex", "HasSegments"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MediaSourceInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in media_streams (list)
        _items = []
        if self.media_streams:
            for _item_media_streams in self.media_streams:
                if _item_media_streams:
                    _items.append(_item_media_streams.to_dict())
            _dict['MediaStreams'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in media_attachments (list)
        _items = []
        if self.media_attachments:
            for _item_media_attachments in self.media_attachments:
                if _item_media_attachments:
                    _items.append(_item_media_attachments.to_dict())
            _dict['MediaAttachments'] = _items
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['Id'] = None

        # set to None if path (nullable) is None
        # and model_fields_set contains the field
        if self.path is None and "path" in self.model_fields_set:
            _dict['Path'] = None

        # set to None if encoder_path (nullable) is None
        # and model_fields_set contains the field
        if self.encoder_path is None and "encoder_path" in self.model_fields_set:
            _dict['EncoderPath'] = None

        # set to None if encoder_protocol (nullable) is None
        # and model_fields_set contains the field
        if self.encoder_protocol is None and "encoder_protocol" in self.model_fields_set:
            _dict['EncoderProtocol'] = None

        # set to None if container (nullable) is None
        # and model_fields_set contains the field
        if self.container is None and "container" in self.model_fields_set:
            _dict['Container'] = None

        # set to None if size (nullable) is None
        # and model_fields_set contains the field
        if self.size is None and "size" in self.model_fields_set:
            _dict['Size'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['Name'] = None

        # set to None if e_tag (nullable) is None
        # and model_fields_set contains the field
        if self.e_tag is None and "e_tag" in self.model_fields_set:
            _dict['ETag'] = None

        # set to None if run_time_ticks (nullable) is None
        # and model_fields_set contains the field
        if self.run_time_ticks is None and "run_time_ticks" in self.model_fields_set:
            _dict['RunTimeTicks'] = None

        # set to None if open_token (nullable) is None
        # and model_fields_set contains the field
        if self.open_token is None and "open_token" in self.model_fields_set:
            _dict['OpenToken'] = None

        # set to None if live_stream_id (nullable) is None
        # and model_fields_set contains the field
        if self.live_stream_id is None and "live_stream_id" in self.model_fields_set:
            _dict['LiveStreamId'] = None

        # set to None if buffer_ms (nullable) is None
        # and model_fields_set contains the field
        if self.buffer_ms is None and "buffer_ms" in self.model_fields_set:
            _dict['BufferMs'] = None

        # set to None if video_type (nullable) is None
        # and model_fields_set contains the field
        if self.video_type is None and "video_type" in self.model_fields_set:
            _dict['VideoType'] = None

        # set to None if iso_type (nullable) is None
        # and model_fields_set contains the field
        if self.iso_type is None and "iso_type" in self.model_fields_set:
            _dict['IsoType'] = None

        # set to None if video3_d_format (nullable) is None
        # and model_fields_set contains the field
        if self.video3_d_format is None and "video3_d_format" in self.model_fields_set:
            _dict['Video3DFormat'] = None

        # set to None if media_streams (nullable) is None
        # and model_fields_set contains the field
        if self.media_streams is None and "media_streams" in self.model_fields_set:
            _dict['MediaStreams'] = None

        # set to None if media_attachments (nullable) is None
        # and model_fields_set contains the field
        if self.media_attachments is None and "media_attachments" in self.model_fields_set:
            _dict['MediaAttachments'] = None

        # set to None if formats (nullable) is None
        # and model_fields_set contains the field
        if self.formats is None and "formats" in self.model_fields_set:
            _dict['Formats'] = None

        # set to None if bitrate (nullable) is None
        # and model_fields_set contains the field
        if self.bitrate is None and "bitrate" in self.model_fields_set:
            _dict['Bitrate'] = None

        # set to None if fallback_max_streaming_bitrate (nullable) is None
        # and model_fields_set contains the field
        if self.fallback_max_streaming_bitrate is None and "fallback_max_streaming_bitrate" in self.model_fields_set:
            _dict['FallbackMaxStreamingBitrate'] = None

        # set to None if timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.timestamp is None and "timestamp" in self.model_fields_set:
            _dict['Timestamp'] = None

        # set to None if required_http_headers (nullable) is None
        # and model_fields_set contains the field
        if self.required_http_headers is None and "required_http_headers" in self.model_fields_set:
            _dict['RequiredHttpHeaders'] = None

        # set to None if transcoding_url (nullable) is None
        # and model_fields_set contains the field
        if self.transcoding_url is None and "transcoding_url" in self.model_fields_set:
            _dict['TranscodingUrl'] = None

        # set to None if transcoding_container (nullable) is None
        # and model_fields_set contains the field
        if self.transcoding_container is None and "transcoding_container" in self.model_fields_set:
            _dict['TranscodingContainer'] = None

        # set to None if analyze_duration_ms (nullable) is None
        # and model_fields_set contains the field
        if self.analyze_duration_ms is None and "analyze_duration_ms" in self.model_fields_set:
            _dict['AnalyzeDurationMs'] = None

        # set to None if default_audio_stream_index (nullable) is None
        # and model_fields_set contains the field
        if self.default_audio_stream_index is None and "default_audio_stream_index" in self.model_fields_set:
            _dict['DefaultAudioStreamIndex'] = None

        # set to None if default_subtitle_stream_index (nullable) is None
        # and model_fields_set contains the field
        if self.default_subtitle_stream_index is None and "default_subtitle_stream_index" in self.model_fields_set:
            _dict['DefaultSubtitleStreamIndex'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MediaSourceInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Protocol": obj.get("Protocol"),
            "Id": obj.get("Id"),
            "Path": obj.get("Path"),
            "EncoderPath": obj.get("EncoderPath"),
            "EncoderProtocol": obj.get("EncoderProtocol"),
            "Type": obj.get("Type"),
            "Container": obj.get("Container"),
            "Size": obj.get("Size"),
            "Name": obj.get("Name"),
            "IsRemote": obj.get("IsRemote"),
            "ETag": obj.get("ETag"),
            "RunTimeTicks": obj.get("RunTimeTicks"),
            "ReadAtNativeFramerate": obj.get("ReadAtNativeFramerate"),
            "IgnoreDts": obj.get("IgnoreDts"),
            "IgnoreIndex": obj.get("IgnoreIndex"),
            "GenPtsInput": obj.get("GenPtsInput"),
            "SupportsTranscoding": obj.get("SupportsTranscoding"),
            "SupportsDirectStream": obj.get("SupportsDirectStream"),
            "SupportsDirectPlay": obj.get("SupportsDirectPlay"),
            "IsInfiniteStream": obj.get("IsInfiniteStream"),
            "UseMostCompatibleTranscodingProfile": obj.get("UseMostCompatibleTranscodingProfile") if obj.get("UseMostCompatibleTranscodingProfile") is not None else False,
            "RequiresOpening": obj.get("RequiresOpening"),
            "OpenToken": obj.get("OpenToken"),
            "RequiresClosing": obj.get("RequiresClosing"),
            "LiveStreamId": obj.get("LiveStreamId"),
            "BufferMs": obj.get("BufferMs"),
            "RequiresLooping": obj.get("RequiresLooping"),
            "SupportsProbing": obj.get("SupportsProbing"),
            "VideoType": obj.get("VideoType"),
            "IsoType": obj.get("IsoType"),
            "Video3DFormat": obj.get("Video3DFormat"),
            "MediaStreams": [MediaStream.from_dict(_item) for _item in obj["MediaStreams"]] if obj.get("MediaStreams") is not None else None,
            "MediaAttachments": [MediaAttachment.from_dict(_item) for _item in obj["MediaAttachments"]] if obj.get("MediaAttachments") is not None else None,
            "Formats": obj.get("Formats"),
            "Bitrate": obj.get("Bitrate"),
            "FallbackMaxStreamingBitrate": obj.get("FallbackMaxStreamingBitrate"),
            "Timestamp": obj.get("Timestamp"),
            "RequiredHttpHeaders": obj.get("RequiredHttpHeaders"),
            "TranscodingUrl": obj.get("TranscodingUrl"),
            "TranscodingSubProtocol": obj.get("TranscodingSubProtocol"),
            "TranscodingContainer": obj.get("TranscodingContainer"),
            "AnalyzeDurationMs": obj.get("AnalyzeDurationMs"),
            "DefaultAudioStreamIndex": obj.get("DefaultAudioStreamIndex"),
            "DefaultSubtitleStreamIndex": obj.get("DefaultSubtitleStreamIndex"),
            "HasSegments": obj.get("HasSegments")
        })
        return _obj


