# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_11.models.collection_type import CollectionType
from jellyfin.generated.api_10_11.models.country_info import CountryInfo
from jellyfin.generated.api_10_11.models.culture_dto import CultureDto
from jellyfin.generated.api_10_11.models.external_id_info import ExternalIdInfo
from jellyfin.generated.api_10_11.models.name_value_pair import NameValuePair
from jellyfin.generated.api_10_11.models.parental_rating import ParentalRating
from typing import Optional, Set
from typing_extensions import Self

class MetadataEditorInfo(BaseModel):
    """
    A class representing metadata editor information.
    """ # noqa: E501
    parental_rating_options: Optional[List[ParentalRating]] = Field(default=None, description="Gets or sets the parental rating options.", alias="ParentalRatingOptions")
    countries: Optional[List[CountryInfo]] = Field(default=None, description="Gets or sets the countries.", alias="Countries")
    cultures: Optional[List[CultureDto]] = Field(default=None, description="Gets or sets the cultures.", alias="Cultures")
    external_id_infos: Optional[List[ExternalIdInfo]] = Field(default=None, description="Gets or sets the external id infos.", alias="ExternalIdInfos")
    content_type: Optional[CollectionType] = Field(default=None, description="Gets or sets the content type.", alias="ContentType")
    content_type_options: Optional[List[NameValuePair]] = Field(default=None, description="Gets or sets the content type options.", alias="ContentTypeOptions")
    __properties: ClassVar[List[str]] = ["ParentalRatingOptions", "Countries", "Cultures", "ExternalIdInfos", "ContentType", "ContentTypeOptions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MetadataEditorInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in parental_rating_options (list)
        _items = []
        if self.parental_rating_options:
            for _item_parental_rating_options in self.parental_rating_options:
                if _item_parental_rating_options:
                    _items.append(_item_parental_rating_options.to_dict())
            _dict['ParentalRatingOptions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in countries (list)
        _items = []
        if self.countries:
            for _item_countries in self.countries:
                if _item_countries:
                    _items.append(_item_countries.to_dict())
            _dict['Countries'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cultures (list)
        _items = []
        if self.cultures:
            for _item_cultures in self.cultures:
                if _item_cultures:
                    _items.append(_item_cultures.to_dict())
            _dict['Cultures'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in external_id_infos (list)
        _items = []
        if self.external_id_infos:
            for _item_external_id_infos in self.external_id_infos:
                if _item_external_id_infos:
                    _items.append(_item_external_id_infos.to_dict())
            _dict['ExternalIdInfos'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in content_type_options (list)
        _items = []
        if self.content_type_options:
            for _item_content_type_options in self.content_type_options:
                if _item_content_type_options:
                    _items.append(_item_content_type_options.to_dict())
            _dict['ContentTypeOptions'] = _items
        # set to None if content_type (nullable) is None
        # and model_fields_set contains the field
        if self.content_type is None and "content_type" in self.model_fields_set:
            _dict['ContentType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MetadataEditorInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ParentalRatingOptions": [ParentalRating.from_dict(_item) for _item in obj["ParentalRatingOptions"]] if obj.get("ParentalRatingOptions") is not None else None,
            "Countries": [CountryInfo.from_dict(_item) for _item in obj["Countries"]] if obj.get("Countries") is not None else None,
            "Cultures": [CultureDto.from_dict(_item) for _item in obj["Cultures"]] if obj.get("Cultures") is not None else None,
            "ExternalIdInfos": [ExternalIdInfo.from_dict(_item) for _item in obj["ExternalIdInfos"]] if obj.get("ExternalIdInfos") is not None else None,
            "ContentType": obj.get("ContentType"),
            "ContentTypeOptions": [NameValuePair.from_dict(_item) for _item in obj["ContentTypeOptions"]] if obj.get("ContentTypeOptions") is not None else None
        })
        return _obj


