# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PublicSystemInfo(BaseModel):
    """
    PublicSystemInfo
    """ # noqa: E501
    local_address: Optional[StrictStr] = Field(default=None, description="Gets or sets the local address.", alias="LocalAddress")
    server_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name of the server.", alias="ServerName")
    version: Optional[StrictStr] = Field(default=None, description="Gets or sets the server version.", alias="Version")
    product_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the product name. This is the AssemblyProduct name.", alias="ProductName")
    operating_system: Optional[StrictStr] = Field(default=None, description="Gets or sets the operating system.", alias="OperatingSystem")
    id: Optional[StrictStr] = Field(default=None, description="Gets or sets the id.", alias="Id")
    startup_wizard_completed: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the startup wizard is completed.", alias="StartupWizardCompleted")
    __properties: ClassVar[List[str]] = ["LocalAddress", "ServerName", "Version", "ProductName", "OperatingSystem", "Id", "StartupWizardCompleted"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublicSystemInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if local_address (nullable) is None
        # and model_fields_set contains the field
        if self.local_address is None and "local_address" in self.model_fields_set:
            _dict['LocalAddress'] = None

        # set to None if server_name (nullable) is None
        # and model_fields_set contains the field
        if self.server_name is None and "server_name" in self.model_fields_set:
            _dict['ServerName'] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['Version'] = None

        # set to None if product_name (nullable) is None
        # and model_fields_set contains the field
        if self.product_name is None and "product_name" in self.model_fields_set:
            _dict['ProductName'] = None

        # set to None if operating_system (nullable) is None
        # and model_fields_set contains the field
        if self.operating_system is None and "operating_system" in self.model_fields_set:
            _dict['OperatingSystem'] = None

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['Id'] = None

        # set to None if startup_wizard_completed (nullable) is None
        # and model_fields_set contains the field
        if self.startup_wizard_completed is None and "startup_wizard_completed" in self.model_fields_set:
            _dict['StartupWizardCompleted'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublicSystemInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "LocalAddress": obj.get("LocalAddress"),
            "ServerName": obj.get("ServerName"),
            "Version": obj.get("Version"),
            "ProductName": obj.get("ProductName"),
            "OperatingSystem": obj.get("OperatingSystem"),
            "Id": obj.get("Id"),
            "StartupWizardCompleted": obj.get("StartupWizardCompleted")
        })
        return _obj


