# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from jellyfin.generated.api_10_11.models.image_type import ImageType
from jellyfin.generated.api_10_11.models.rating_type import RatingType
from typing import Optional, Set
from typing_extensions import Self

class RemoteImageInfo(BaseModel):
    """
    Class RemoteImageInfo.
    """ # noqa: E501
    provider_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name of the provider.", alias="ProviderName")
    url: Optional[StrictStr] = Field(default=None, description="Gets or sets the URL.", alias="Url")
    thumbnail_url: Optional[StrictStr] = Field(default=None, description="Gets or sets a url used for previewing a smaller version.", alias="ThumbnailUrl")
    height: Optional[StrictInt] = Field(default=None, description="Gets or sets the height.", alias="Height")
    width: Optional[StrictInt] = Field(default=None, description="Gets or sets the width.", alias="Width")
    community_rating: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the community rating.", alias="CommunityRating")
    vote_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the vote count.", alias="VoteCount")
    language: Optional[StrictStr] = Field(default=None, description="Gets or sets the language.", alias="Language")
    type: Optional[ImageType] = Field(default=None, description="Gets or sets the type.", alias="Type")
    rating_type: Optional[RatingType] = Field(default=None, description="Gets or sets the type of the rating.", alias="RatingType")
    __properties: ClassVar[List[str]] = ["ProviderName", "Url", "ThumbnailUrl", "Height", "Width", "CommunityRating", "VoteCount", "Language", "Type", "RatingType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RemoteImageInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if provider_name (nullable) is None
        # and model_fields_set contains the field
        if self.provider_name is None and "provider_name" in self.model_fields_set:
            _dict['ProviderName'] = None

        # set to None if url (nullable) is None
        # and model_fields_set contains the field
        if self.url is None and "url" in self.model_fields_set:
            _dict['Url'] = None

        # set to None if thumbnail_url (nullable) is None
        # and model_fields_set contains the field
        if self.thumbnail_url is None and "thumbnail_url" in self.model_fields_set:
            _dict['ThumbnailUrl'] = None

        # set to None if height (nullable) is None
        # and model_fields_set contains the field
        if self.height is None and "height" in self.model_fields_set:
            _dict['Height'] = None

        # set to None if width (nullable) is None
        # and model_fields_set contains the field
        if self.width is None and "width" in self.model_fields_set:
            _dict['Width'] = None

        # set to None if community_rating (nullable) is None
        # and model_fields_set contains the field
        if self.community_rating is None and "community_rating" in self.model_fields_set:
            _dict['CommunityRating'] = None

        # set to None if vote_count (nullable) is None
        # and model_fields_set contains the field
        if self.vote_count is None and "vote_count" in self.model_fields_set:
            _dict['VoteCount'] = None

        # set to None if language (nullable) is None
        # and model_fields_set contains the field
        if self.language is None and "language" in self.model_fields_set:
            _dict['Language'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RemoteImageInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ProviderName": obj.get("ProviderName"),
            "Url": obj.get("Url"),
            "ThumbnailUrl": obj.get("ThumbnailUrl"),
            "Height": obj.get("Height"),
            "Width": obj.get("Width"),
            "CommunityRating": obj.get("CommunityRating"),
            "VoteCount": obj.get("VoteCount"),
            "Language": obj.get("Language"),
            "Type": obj.get("Type"),
            "RatingType": obj.get("RatingType")
        })
        return _obj


