# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class RemoteSearchResult(BaseModel):
    """
    RemoteSearchResult
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name.", alias="Name")
    provider_ids: Optional[Dict[str, Optional[StrictStr]]] = Field(default=None, description="Gets or sets the provider ids.", alias="ProviderIds")
    production_year: Optional[StrictInt] = Field(default=None, description="Gets or sets the year.", alias="ProductionYear")
    index_number: Optional[StrictInt] = Field(default=None, alias="IndexNumber")
    index_number_end: Optional[StrictInt] = Field(default=None, alias="IndexNumberEnd")
    parent_index_number: Optional[StrictInt] = Field(default=None, alias="ParentIndexNumber")
    premiere_date: Optional[datetime] = Field(default=None, alias="PremiereDate")
    image_url: Optional[StrictStr] = Field(default=None, alias="ImageUrl")
    search_provider_name: Optional[StrictStr] = Field(default=None, alias="SearchProviderName")
    overview: Optional[StrictStr] = Field(default=None, alias="Overview")
    album_artist: Optional[RemoteSearchResult] = Field(default=None, alias="AlbumArtist")
    artists: Optional[List[RemoteSearchResult]] = Field(default=None, alias="Artists")
    __properties: ClassVar[List[str]] = ["Name", "ProviderIds", "ProductionYear", "IndexNumber", "IndexNumberEnd", "ParentIndexNumber", "PremiereDate", "ImageUrl", "SearchProviderName", "Overview", "AlbumArtist", "Artists"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RemoteSearchResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of album_artist
        if self.album_artist:
            _dict['AlbumArtist'] = self.album_artist.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in artists (list)
        _items = []
        if self.artists:
            for _item_artists in self.artists:
                if _item_artists:
                    _items.append(_item_artists.to_dict())
            _dict['Artists'] = _items
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['Name'] = None

        # set to None if provider_ids (nullable) is None
        # and model_fields_set contains the field
        if self.provider_ids is None and "provider_ids" in self.model_fields_set:
            _dict['ProviderIds'] = None

        # set to None if production_year (nullable) is None
        # and model_fields_set contains the field
        if self.production_year is None and "production_year" in self.model_fields_set:
            _dict['ProductionYear'] = None

        # set to None if index_number (nullable) is None
        # and model_fields_set contains the field
        if self.index_number is None and "index_number" in self.model_fields_set:
            _dict['IndexNumber'] = None

        # set to None if index_number_end (nullable) is None
        # and model_fields_set contains the field
        if self.index_number_end is None and "index_number_end" in self.model_fields_set:
            _dict['IndexNumberEnd'] = None

        # set to None if parent_index_number (nullable) is None
        # and model_fields_set contains the field
        if self.parent_index_number is None and "parent_index_number" in self.model_fields_set:
            _dict['ParentIndexNumber'] = None

        # set to None if premiere_date (nullable) is None
        # and model_fields_set contains the field
        if self.premiere_date is None and "premiere_date" in self.model_fields_set:
            _dict['PremiereDate'] = None

        # set to None if image_url (nullable) is None
        # and model_fields_set contains the field
        if self.image_url is None and "image_url" in self.model_fields_set:
            _dict['ImageUrl'] = None

        # set to None if search_provider_name (nullable) is None
        # and model_fields_set contains the field
        if self.search_provider_name is None and "search_provider_name" in self.model_fields_set:
            _dict['SearchProviderName'] = None

        # set to None if overview (nullable) is None
        # and model_fields_set contains the field
        if self.overview is None and "overview" in self.model_fields_set:
            _dict['Overview'] = None

        # set to None if album_artist (nullable) is None
        # and model_fields_set contains the field
        if self.album_artist is None and "album_artist" in self.model_fields_set:
            _dict['AlbumArtist'] = None

        # set to None if artists (nullable) is None
        # and model_fields_set contains the field
        if self.artists is None and "artists" in self.model_fields_set:
            _dict['Artists'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RemoteSearchResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Name": obj.get("Name"),
            "ProviderIds": obj.get("ProviderIds"),
            "ProductionYear": obj.get("ProductionYear"),
            "IndexNumber": obj.get("IndexNumber"),
            "IndexNumberEnd": obj.get("IndexNumberEnd"),
            "ParentIndexNumber": obj.get("ParentIndexNumber"),
            "PremiereDate": obj.get("PremiereDate"),
            "ImageUrl": obj.get("ImageUrl"),
            "SearchProviderName": obj.get("SearchProviderName"),
            "Overview": obj.get("Overview"),
            "AlbumArtist": RemoteSearchResult.from_dict(obj["AlbumArtist"]) if obj.get("AlbumArtist") is not None else None,
            "Artists": [RemoteSearchResult.from_dict(_item) for _item in obj["Artists"]] if obj.get("Artists") is not None else None
        })
        return _obj

# TODO: Rewrite to not use raise_errors
RemoteSearchResult.model_rebuild(raise_errors=False)

