# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from jellyfin.generated.api_10_11.models.base_item_kind import BaseItemKind
from jellyfin.generated.api_10_11.models.media_type import MediaType
from typing import Optional, Set
from typing_extensions import Self

class SearchHint(BaseModel):
    """
    Class SearchHintResult.
    """ # noqa: E501
    item_id: Optional[UUID] = Field(default=None, description="Gets or sets the item id.", alias="ItemId")
    id: Optional[UUID] = Field(default=None, description="Gets or sets the item id.", alias="Id")
    name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name.", alias="Name")
    matched_term: Optional[StrictStr] = Field(default=None, description="Gets or sets the matched term.", alias="MatchedTerm")
    index_number: Optional[StrictInt] = Field(default=None, description="Gets or sets the index number.", alias="IndexNumber")
    production_year: Optional[StrictInt] = Field(default=None, description="Gets or sets the production year.", alias="ProductionYear")
    parent_index_number: Optional[StrictInt] = Field(default=None, description="Gets or sets the parent index number.", alias="ParentIndexNumber")
    primary_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the image tag.", alias="PrimaryImageTag")
    thumb_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the thumb image tag.", alias="ThumbImageTag")
    thumb_image_item_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the thumb image item identifier.", alias="ThumbImageItemId")
    backdrop_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the backdrop image tag.", alias="BackdropImageTag")
    backdrop_image_item_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the backdrop image item identifier.", alias="BackdropImageItemId")
    type: Optional[BaseItemKind] = Field(default=None, description="The base item kind.", alias="Type")
    is_folder: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is folder.", alias="IsFolder")
    run_time_ticks: Optional[StrictInt] = Field(default=None, description="Gets or sets the run time ticks.", alias="RunTimeTicks")
    media_type: Optional[MediaType] = Field(default=MediaType.UNKNOWN, description="Media types.", alias="MediaType")
    start_date: Optional[datetime] = Field(default=None, description="Gets or sets the start date.", alias="StartDate")
    end_date: Optional[datetime] = Field(default=None, description="Gets or sets the end date.", alias="EndDate")
    series: Optional[StrictStr] = Field(default=None, description="Gets or sets the series.", alias="Series")
    status: Optional[StrictStr] = Field(default=None, description="Gets or sets the status.", alias="Status")
    album: Optional[StrictStr] = Field(default=None, description="Gets or sets the album.", alias="Album")
    album_id: Optional[UUID] = Field(default=None, description="Gets or sets the album id.", alias="AlbumId")
    album_artist: Optional[StrictStr] = Field(default=None, description="Gets or sets the album artist.", alias="AlbumArtist")
    artists: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the artists.", alias="Artists")
    song_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the song count.", alias="SongCount")
    episode_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the episode count.", alias="EpisodeCount")
    channel_id: Optional[UUID] = Field(default=None, description="Gets or sets the channel identifier.", alias="ChannelId")
    channel_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name of the channel.", alias="ChannelName")
    primary_image_aspect_ratio: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the primary image aspect ratio.", alias="PrimaryImageAspectRatio")
    __properties: ClassVar[List[str]] = ["ItemId", "Id", "Name", "MatchedTerm", "IndexNumber", "ProductionYear", "ParentIndexNumber", "PrimaryImageTag", "ThumbImageTag", "ThumbImageItemId", "BackdropImageTag", "BackdropImageItemId", "Type", "IsFolder", "RunTimeTicks", "MediaType", "StartDate", "EndDate", "Series", "Status", "Album", "AlbumId", "AlbumArtist", "Artists", "SongCount", "EpisodeCount", "ChannelId", "ChannelName", "PrimaryImageAspectRatio"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SearchHint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if matched_term (nullable) is None
        # and model_fields_set contains the field
        if self.matched_term is None and "matched_term" in self.model_fields_set:
            _dict['MatchedTerm'] = None

        # set to None if index_number (nullable) is None
        # and model_fields_set contains the field
        if self.index_number is None and "index_number" in self.model_fields_set:
            _dict['IndexNumber'] = None

        # set to None if production_year (nullable) is None
        # and model_fields_set contains the field
        if self.production_year is None and "production_year" in self.model_fields_set:
            _dict['ProductionYear'] = None

        # set to None if parent_index_number (nullable) is None
        # and model_fields_set contains the field
        if self.parent_index_number is None and "parent_index_number" in self.model_fields_set:
            _dict['ParentIndexNumber'] = None

        # set to None if primary_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.primary_image_tag is None and "primary_image_tag" in self.model_fields_set:
            _dict['PrimaryImageTag'] = None

        # set to None if thumb_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.thumb_image_tag is None and "thumb_image_tag" in self.model_fields_set:
            _dict['ThumbImageTag'] = None

        # set to None if thumb_image_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.thumb_image_item_id is None and "thumb_image_item_id" in self.model_fields_set:
            _dict['ThumbImageItemId'] = None

        # set to None if backdrop_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.backdrop_image_tag is None and "backdrop_image_tag" in self.model_fields_set:
            _dict['BackdropImageTag'] = None

        # set to None if backdrop_image_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.backdrop_image_item_id is None and "backdrop_image_item_id" in self.model_fields_set:
            _dict['BackdropImageItemId'] = None

        # set to None if is_folder (nullable) is None
        # and model_fields_set contains the field
        if self.is_folder is None and "is_folder" in self.model_fields_set:
            _dict['IsFolder'] = None

        # set to None if run_time_ticks (nullable) is None
        # and model_fields_set contains the field
        if self.run_time_ticks is None and "run_time_ticks" in self.model_fields_set:
            _dict['RunTimeTicks'] = None

        # set to None if start_date (nullable) is None
        # and model_fields_set contains the field
        if self.start_date is None and "start_date" in self.model_fields_set:
            _dict['StartDate'] = None

        # set to None if end_date (nullable) is None
        # and model_fields_set contains the field
        if self.end_date is None and "end_date" in self.model_fields_set:
            _dict['EndDate'] = None

        # set to None if series (nullable) is None
        # and model_fields_set contains the field
        if self.series is None and "series" in self.model_fields_set:
            _dict['Series'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['Status'] = None

        # set to None if album (nullable) is None
        # and model_fields_set contains the field
        if self.album is None and "album" in self.model_fields_set:
            _dict['Album'] = None

        # set to None if album_id (nullable) is None
        # and model_fields_set contains the field
        if self.album_id is None and "album_id" in self.model_fields_set:
            _dict['AlbumId'] = None

        # set to None if album_artist (nullable) is None
        # and model_fields_set contains the field
        if self.album_artist is None and "album_artist" in self.model_fields_set:
            _dict['AlbumArtist'] = None

        # set to None if song_count (nullable) is None
        # and model_fields_set contains the field
        if self.song_count is None and "song_count" in self.model_fields_set:
            _dict['SongCount'] = None

        # set to None if episode_count (nullable) is None
        # and model_fields_set contains the field
        if self.episode_count is None and "episode_count" in self.model_fields_set:
            _dict['EpisodeCount'] = None

        # set to None if channel_id (nullable) is None
        # and model_fields_set contains the field
        if self.channel_id is None and "channel_id" in self.model_fields_set:
            _dict['ChannelId'] = None

        # set to None if channel_name (nullable) is None
        # and model_fields_set contains the field
        if self.channel_name is None and "channel_name" in self.model_fields_set:
            _dict['ChannelName'] = None

        # set to None if primary_image_aspect_ratio (nullable) is None
        # and model_fields_set contains the field
        if self.primary_image_aspect_ratio is None and "primary_image_aspect_ratio" in self.model_fields_set:
            _dict['PrimaryImageAspectRatio'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SearchHint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ItemId": obj.get("ItemId"),
            "Id": obj.get("Id"),
            "Name": obj.get("Name"),
            "MatchedTerm": obj.get("MatchedTerm"),
            "IndexNumber": obj.get("IndexNumber"),
            "ProductionYear": obj.get("ProductionYear"),
            "ParentIndexNumber": obj.get("ParentIndexNumber"),
            "PrimaryImageTag": obj.get("PrimaryImageTag"),
            "ThumbImageTag": obj.get("ThumbImageTag"),
            "ThumbImageItemId": obj.get("ThumbImageItemId"),
            "BackdropImageTag": obj.get("BackdropImageTag"),
            "BackdropImageItemId": obj.get("BackdropImageItemId"),
            "Type": obj.get("Type"),
            "IsFolder": obj.get("IsFolder"),
            "RunTimeTicks": obj.get("RunTimeTicks"),
            "MediaType": obj.get("MediaType") if obj.get("MediaType") is not None else MediaType.UNKNOWN,
            "StartDate": obj.get("StartDate"),
            "EndDate": obj.get("EndDate"),
            "Series": obj.get("Series"),
            "Status": obj.get("Status"),
            "Album": obj.get("Album"),
            "AlbumId": obj.get("AlbumId"),
            "AlbumArtist": obj.get("AlbumArtist"),
            "Artists": obj.get("Artists"),
            "SongCount": obj.get("SongCount"),
            "EpisodeCount": obj.get("EpisodeCount"),
            "ChannelId": obj.get("ChannelId"),
            "ChannelName": obj.get("ChannelName"),
            "PrimaryImageAspectRatio": obj.get("PrimaryImageAspectRatio")
        })
        return _obj


