# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_11.models.base_item_dto import BaseItemDto
from jellyfin.generated.api_10_11.models.client_capabilities_dto import ClientCapabilitiesDto
from jellyfin.generated.api_10_11.models.general_command_type import GeneralCommandType
from jellyfin.generated.api_10_11.models.media_type import MediaType
from jellyfin.generated.api_10_11.models.player_state_info import PlayerStateInfo
from jellyfin.generated.api_10_11.models.queue_item import QueueItem
from jellyfin.generated.api_10_11.models.session_user_info import SessionUserInfo
from jellyfin.generated.api_10_11.models.transcoding_info import TranscodingInfo
from typing import Optional, Set
from typing_extensions import Self

class SessionInfoDto(BaseModel):
    """
    Session info DTO.
    """ # noqa: E501
    play_state: Optional[PlayerStateInfo] = Field(default=None, description="Gets or sets the play state.", alias="PlayState")
    additional_users: Optional[List[SessionUserInfo]] = Field(default=None, description="Gets or sets the additional users.", alias="AdditionalUsers")
    capabilities: Optional[ClientCapabilitiesDto] = Field(default=None, description="Gets or sets the client capabilities.", alias="Capabilities")
    remote_end_point: Optional[StrictStr] = Field(default=None, description="Gets or sets the remote end point.", alias="RemoteEndPoint")
    playable_media_types: Optional[List[MediaType]] = Field(default=None, description="Gets or sets the playable media types.", alias="PlayableMediaTypes")
    id: Optional[StrictStr] = Field(default=None, description="Gets or sets the id.", alias="Id")
    user_id: Optional[UUID] = Field(default=None, description="Gets or sets the user id.", alias="UserId")
    user_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the username.", alias="UserName")
    client: Optional[StrictStr] = Field(default=None, description="Gets or sets the type of the client.", alias="Client")
    last_activity_date: Optional[datetime] = Field(default=None, description="Gets or sets the last activity date.", alias="LastActivityDate")
    last_playback_check_in: Optional[datetime] = Field(default=None, description="Gets or sets the last playback check in.", alias="LastPlaybackCheckIn")
    last_paused_date: Optional[datetime] = Field(default=None, description="Gets or sets the last paused date.", alias="LastPausedDate")
    device_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name of the device.", alias="DeviceName")
    device_type: Optional[StrictStr] = Field(default=None, description="Gets or sets the type of the device.", alias="DeviceType")
    now_playing_item: Optional[BaseItemDto] = Field(default=None, description="Gets or sets the now playing item.", alias="NowPlayingItem")
    now_viewing_item: Optional[BaseItemDto] = Field(default=None, description="Gets or sets the now viewing item.", alias="NowViewingItem")
    device_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the device id.", alias="DeviceId")
    application_version: Optional[StrictStr] = Field(default=None, description="Gets or sets the application version.", alias="ApplicationVersion")
    transcoding_info: Optional[TranscodingInfo] = Field(default=None, description="Gets or sets the transcoding info.", alias="TranscodingInfo")
    is_active: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this session is active.", alias="IsActive")
    supports_media_control: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the session supports media control.", alias="SupportsMediaControl")
    supports_remote_control: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the session supports remote control.", alias="SupportsRemoteControl")
    now_playing_queue: Optional[List[QueueItem]] = Field(default=None, description="Gets or sets the now playing queue.", alias="NowPlayingQueue")
    now_playing_queue_full_items: Optional[List[BaseItemDto]] = Field(default=None, description="Gets or sets the now playing queue full items.", alias="NowPlayingQueueFullItems")
    has_custom_device_name: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the session has a custom device name.", alias="HasCustomDeviceName")
    playlist_item_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the playlist item id.", alias="PlaylistItemId")
    server_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the server id.", alias="ServerId")
    user_primary_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the user primary image tag.", alias="UserPrimaryImageTag")
    supported_commands: Optional[List[GeneralCommandType]] = Field(default=None, description="Gets or sets the supported commands.", alias="SupportedCommands")
    __properties: ClassVar[List[str]] = ["PlayState", "AdditionalUsers", "Capabilities", "RemoteEndPoint", "PlayableMediaTypes", "Id", "UserId", "UserName", "Client", "LastActivityDate", "LastPlaybackCheckIn", "LastPausedDate", "DeviceName", "DeviceType", "NowPlayingItem", "NowViewingItem", "DeviceId", "ApplicationVersion", "TranscodingInfo", "IsActive", "SupportsMediaControl", "SupportsRemoteControl", "NowPlayingQueue", "NowPlayingQueueFullItems", "HasCustomDeviceName", "PlaylistItemId", "ServerId", "UserPrimaryImageTag", "SupportedCommands"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SessionInfoDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of play_state
        if self.play_state:
            _dict['PlayState'] = self.play_state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in additional_users (list)
        _items = []
        if self.additional_users:
            for _item_additional_users in self.additional_users:
                if _item_additional_users:
                    _items.append(_item_additional_users.to_dict())
            _dict['AdditionalUsers'] = _items
        # override the default output from pydantic by calling `to_dict()` of capabilities
        if self.capabilities:
            _dict['Capabilities'] = self.capabilities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of now_playing_item
        if self.now_playing_item:
            _dict['NowPlayingItem'] = self.now_playing_item.to_dict()
        # override the default output from pydantic by calling `to_dict()` of now_viewing_item
        if self.now_viewing_item:
            _dict['NowViewingItem'] = self.now_viewing_item.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transcoding_info
        if self.transcoding_info:
            _dict['TranscodingInfo'] = self.transcoding_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in now_playing_queue (list)
        _items = []
        if self.now_playing_queue:
            for _item_now_playing_queue in self.now_playing_queue:
                if _item_now_playing_queue:
                    _items.append(_item_now_playing_queue.to_dict())
            _dict['NowPlayingQueue'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in now_playing_queue_full_items (list)
        _items = []
        if self.now_playing_queue_full_items:
            for _item_now_playing_queue_full_items in self.now_playing_queue_full_items:
                if _item_now_playing_queue_full_items:
                    _items.append(_item_now_playing_queue_full_items.to_dict())
            _dict['NowPlayingQueueFullItems'] = _items
        # set to None if play_state (nullable) is None
        # and model_fields_set contains the field
        if self.play_state is None and "play_state" in self.model_fields_set:
            _dict['PlayState'] = None

        # set to None if additional_users (nullable) is None
        # and model_fields_set contains the field
        if self.additional_users is None and "additional_users" in self.model_fields_set:
            _dict['AdditionalUsers'] = None

        # set to None if capabilities (nullable) is None
        # and model_fields_set contains the field
        if self.capabilities is None and "capabilities" in self.model_fields_set:
            _dict['Capabilities'] = None

        # set to None if remote_end_point (nullable) is None
        # and model_fields_set contains the field
        if self.remote_end_point is None and "remote_end_point" in self.model_fields_set:
            _dict['RemoteEndPoint'] = None

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['Id'] = None

        # set to None if user_name (nullable) is None
        # and model_fields_set contains the field
        if self.user_name is None and "user_name" in self.model_fields_set:
            _dict['UserName'] = None

        # set to None if client (nullable) is None
        # and model_fields_set contains the field
        if self.client is None and "client" in self.model_fields_set:
            _dict['Client'] = None

        # set to None if last_paused_date (nullable) is None
        # and model_fields_set contains the field
        if self.last_paused_date is None and "last_paused_date" in self.model_fields_set:
            _dict['LastPausedDate'] = None

        # set to None if device_name (nullable) is None
        # and model_fields_set contains the field
        if self.device_name is None and "device_name" in self.model_fields_set:
            _dict['DeviceName'] = None

        # set to None if device_type (nullable) is None
        # and model_fields_set contains the field
        if self.device_type is None and "device_type" in self.model_fields_set:
            _dict['DeviceType'] = None

        # set to None if now_playing_item (nullable) is None
        # and model_fields_set contains the field
        if self.now_playing_item is None and "now_playing_item" in self.model_fields_set:
            _dict['NowPlayingItem'] = None

        # set to None if now_viewing_item (nullable) is None
        # and model_fields_set contains the field
        if self.now_viewing_item is None and "now_viewing_item" in self.model_fields_set:
            _dict['NowViewingItem'] = None

        # set to None if device_id (nullable) is None
        # and model_fields_set contains the field
        if self.device_id is None and "device_id" in self.model_fields_set:
            _dict['DeviceId'] = None

        # set to None if application_version (nullable) is None
        # and model_fields_set contains the field
        if self.application_version is None and "application_version" in self.model_fields_set:
            _dict['ApplicationVersion'] = None

        # set to None if transcoding_info (nullable) is None
        # and model_fields_set contains the field
        if self.transcoding_info is None and "transcoding_info" in self.model_fields_set:
            _dict['TranscodingInfo'] = None

        # set to None if now_playing_queue (nullable) is None
        # and model_fields_set contains the field
        if self.now_playing_queue is None and "now_playing_queue" in self.model_fields_set:
            _dict['NowPlayingQueue'] = None

        # set to None if now_playing_queue_full_items (nullable) is None
        # and model_fields_set contains the field
        if self.now_playing_queue_full_items is None and "now_playing_queue_full_items" in self.model_fields_set:
            _dict['NowPlayingQueueFullItems'] = None

        # set to None if playlist_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.playlist_item_id is None and "playlist_item_id" in self.model_fields_set:
            _dict['PlaylistItemId'] = None

        # set to None if server_id (nullable) is None
        # and model_fields_set contains the field
        if self.server_id is None and "server_id" in self.model_fields_set:
            _dict['ServerId'] = None

        # set to None if user_primary_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.user_primary_image_tag is None and "user_primary_image_tag" in self.model_fields_set:
            _dict['UserPrimaryImageTag'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SessionInfoDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "PlayState": PlayerStateInfo.from_dict(obj["PlayState"]) if obj.get("PlayState") is not None else None,
            "AdditionalUsers": [SessionUserInfo.from_dict(_item) for _item in obj["AdditionalUsers"]] if obj.get("AdditionalUsers") is not None else None,
            "Capabilities": ClientCapabilitiesDto.from_dict(obj["Capabilities"]) if obj.get("Capabilities") is not None else None,
            "RemoteEndPoint": obj.get("RemoteEndPoint"),
            "PlayableMediaTypes": obj.get("PlayableMediaTypes"),
            "Id": obj.get("Id"),
            "UserId": obj.get("UserId"),
            "UserName": obj.get("UserName"),
            "Client": obj.get("Client"),
            "LastActivityDate": obj.get("LastActivityDate"),
            "LastPlaybackCheckIn": obj.get("LastPlaybackCheckIn"),
            "LastPausedDate": obj.get("LastPausedDate"),
            "DeviceName": obj.get("DeviceName"),
            "DeviceType": obj.get("DeviceType"),
            "NowPlayingItem": BaseItemDto.from_dict(obj["NowPlayingItem"]) if obj.get("NowPlayingItem") is not None else None,
            "NowViewingItem": BaseItemDto.from_dict(obj["NowViewingItem"]) if obj.get("NowViewingItem") is not None else None,
            "DeviceId": obj.get("DeviceId"),
            "ApplicationVersion": obj.get("ApplicationVersion"),
            "TranscodingInfo": TranscodingInfo.from_dict(obj["TranscodingInfo"]) if obj.get("TranscodingInfo") is not None else None,
            "IsActive": obj.get("IsActive"),
            "SupportsMediaControl": obj.get("SupportsMediaControl"),
            "SupportsRemoteControl": obj.get("SupportsRemoteControl"),
            "NowPlayingQueue": [QueueItem.from_dict(_item) for _item in obj["NowPlayingQueue"]] if obj.get("NowPlayingQueue") is not None else None,
            "NowPlayingQueueFullItems": [BaseItemDto.from_dict(_item) for _item in obj["NowPlayingQueueFullItems"]] if obj.get("NowPlayingQueueFullItems") is not None else None,
            "HasCustomDeviceName": obj.get("HasCustomDeviceName"),
            "PlaylistItemId": obj.get("PlaylistItemId"),
            "ServerId": obj.get("ServerId"),
            "UserPrimaryImageTag": obj.get("UserPrimaryImageTag"),
            "SupportedCommands": obj.get("SupportedCommands")
        })
        return _obj


