# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_11.models.folder_storage_dto import FolderStorageDto
from jellyfin.generated.api_10_11.models.library_storage_dto import LibraryStorageDto
from typing import Optional, Set
from typing_extensions import Self

class SystemStorageDto(BaseModel):
    """
    Contains informations about the systems storage.
    """ # noqa: E501
    program_data_folder: Optional[FolderStorageDto] = Field(default=None, description="Gets or sets the Storage information of the program data folder.", alias="ProgramDataFolder")
    web_folder: Optional[FolderStorageDto] = Field(default=None, description="Gets or sets the Storage information of the web UI resources folder.", alias="WebFolder")
    image_cache_folder: Optional[FolderStorageDto] = Field(default=None, description="Gets or sets the Storage information of the folder where images are cached.", alias="ImageCacheFolder")
    cache_folder: Optional[FolderStorageDto] = Field(default=None, description="Gets or sets the Storage information of the cache folder.", alias="CacheFolder")
    log_folder: Optional[FolderStorageDto] = Field(default=None, description="Gets or sets the Storage information of the folder where logfiles are saved to.", alias="LogFolder")
    internal_metadata_folder: Optional[FolderStorageDto] = Field(default=None, description="Gets or sets the Storage information of the folder where metadata is stored.", alias="InternalMetadataFolder")
    transcoding_temp_folder: Optional[FolderStorageDto] = Field(default=None, description="Gets or sets the Storage information of the transcoding cache.", alias="TranscodingTempFolder")
    libraries: Optional[List[LibraryStorageDto]] = Field(default=None, description="Gets or sets the storage informations of all libraries.", alias="Libraries")
    __properties: ClassVar[List[str]] = ["ProgramDataFolder", "WebFolder", "ImageCacheFolder", "CacheFolder", "LogFolder", "InternalMetadataFolder", "TranscodingTempFolder", "Libraries"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SystemStorageDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of program_data_folder
        if self.program_data_folder:
            _dict['ProgramDataFolder'] = self.program_data_folder.to_dict()
        # override the default output from pydantic by calling `to_dict()` of web_folder
        if self.web_folder:
            _dict['WebFolder'] = self.web_folder.to_dict()
        # override the default output from pydantic by calling `to_dict()` of image_cache_folder
        if self.image_cache_folder:
            _dict['ImageCacheFolder'] = self.image_cache_folder.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cache_folder
        if self.cache_folder:
            _dict['CacheFolder'] = self.cache_folder.to_dict()
        # override the default output from pydantic by calling `to_dict()` of log_folder
        if self.log_folder:
            _dict['LogFolder'] = self.log_folder.to_dict()
        # override the default output from pydantic by calling `to_dict()` of internal_metadata_folder
        if self.internal_metadata_folder:
            _dict['InternalMetadataFolder'] = self.internal_metadata_folder.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transcoding_temp_folder
        if self.transcoding_temp_folder:
            _dict['TranscodingTempFolder'] = self.transcoding_temp_folder.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in libraries (list)
        _items = []
        if self.libraries:
            for _item_libraries in self.libraries:
                if _item_libraries:
                    _items.append(_item_libraries.to_dict())
            _dict['Libraries'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SystemStorageDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ProgramDataFolder": FolderStorageDto.from_dict(obj["ProgramDataFolder"]) if obj.get("ProgramDataFolder") is not None else None,
            "WebFolder": FolderStorageDto.from_dict(obj["WebFolder"]) if obj.get("WebFolder") is not None else None,
            "ImageCacheFolder": FolderStorageDto.from_dict(obj["ImageCacheFolder"]) if obj.get("ImageCacheFolder") is not None else None,
            "CacheFolder": FolderStorageDto.from_dict(obj["CacheFolder"]) if obj.get("CacheFolder") is not None else None,
            "LogFolder": FolderStorageDto.from_dict(obj["LogFolder"]) if obj.get("LogFolder") is not None else None,
            "InternalMetadataFolder": FolderStorageDto.from_dict(obj["InternalMetadataFolder"]) if obj.get("InternalMetadataFolder") is not None else None,
            "TranscodingTempFolder": FolderStorageDto.from_dict(obj["TranscodingTempFolder"]) if obj.get("TranscodingTempFolder") is not None else None,
            "Libraries": [LibraryStorageDto.from_dict(_item) for _item in obj["Libraries"]] if obj.get("Libraries") is not None else None
        })
        return _obj


