# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from jellyfin.generated.api_10_11.models.hardware_acceleration_type import HardwareAccelerationType
from jellyfin.generated.api_10_11.models.transcode_reason import TranscodeReason
from typing import Optional, Set
from typing_extensions import Self

class TranscodingInfo(BaseModel):
    """
    Class holding information on a running transcode.
    """ # noqa: E501
    audio_codec: Optional[StrictStr] = Field(default=None, description="Gets or sets the thread count used for encoding.", alias="AudioCodec")
    video_codec: Optional[StrictStr] = Field(default=None, description="Gets or sets the thread count used for encoding.", alias="VideoCodec")
    container: Optional[StrictStr] = Field(default=None, description="Gets or sets the thread count used for encoding.", alias="Container")
    is_video_direct: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the video is passed through.", alias="IsVideoDirect")
    is_audio_direct: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the audio is passed through.", alias="IsAudioDirect")
    bitrate: Optional[StrictInt] = Field(default=None, description="Gets or sets the bitrate.", alias="Bitrate")
    framerate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the framerate.", alias="Framerate")
    completion_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the completion percentage.", alias="CompletionPercentage")
    width: Optional[StrictInt] = Field(default=None, description="Gets or sets the video width.", alias="Width")
    height: Optional[StrictInt] = Field(default=None, description="Gets or sets the video height.", alias="Height")
    audio_channels: Optional[StrictInt] = Field(default=None, description="Gets or sets the audio channels.", alias="AudioChannels")
    hardware_acceleration_type: Optional[HardwareAccelerationType] = Field(default=None, description="Gets or sets the hardware acceleration type.", alias="HardwareAccelerationType")
    transcode_reasons: Optional[List[TranscodeReason]] = Field(default=None, description="Gets or sets the transcode reasons.", alias="TranscodeReasons")
    __properties: ClassVar[List[str]] = ["AudioCodec", "VideoCodec", "Container", "IsVideoDirect", "IsAudioDirect", "Bitrate", "Framerate", "CompletionPercentage", "Width", "Height", "AudioChannels", "HardwareAccelerationType", "TranscodeReasons"]

    @field_validator('transcode_reasons')
    def transcode_reasons_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set([]):
                raise ValueError("each list item must be one of ()")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TranscodingInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if audio_codec (nullable) is None
        # and model_fields_set contains the field
        if self.audio_codec is None and "audio_codec" in self.model_fields_set:
            _dict['AudioCodec'] = None

        # set to None if video_codec (nullable) is None
        # and model_fields_set contains the field
        if self.video_codec is None and "video_codec" in self.model_fields_set:
            _dict['VideoCodec'] = None

        # set to None if container (nullable) is None
        # and model_fields_set contains the field
        if self.container is None and "container" in self.model_fields_set:
            _dict['Container'] = None

        # set to None if bitrate (nullable) is None
        # and model_fields_set contains the field
        if self.bitrate is None and "bitrate" in self.model_fields_set:
            _dict['Bitrate'] = None

        # set to None if framerate (nullable) is None
        # and model_fields_set contains the field
        if self.framerate is None and "framerate" in self.model_fields_set:
            _dict['Framerate'] = None

        # set to None if completion_percentage (nullable) is None
        # and model_fields_set contains the field
        if self.completion_percentage is None and "completion_percentage" in self.model_fields_set:
            _dict['CompletionPercentage'] = None

        # set to None if width (nullable) is None
        # and model_fields_set contains the field
        if self.width is None and "width" in self.model_fields_set:
            _dict['Width'] = None

        # set to None if height (nullable) is None
        # and model_fields_set contains the field
        if self.height is None and "height" in self.model_fields_set:
            _dict['Height'] = None

        # set to None if audio_channels (nullable) is None
        # and model_fields_set contains the field
        if self.audio_channels is None and "audio_channels" in self.model_fields_set:
            _dict['AudioChannels'] = None

        # set to None if hardware_acceleration_type (nullable) is None
        # and model_fields_set contains the field
        if self.hardware_acceleration_type is None and "hardware_acceleration_type" in self.model_fields_set:
            _dict['HardwareAccelerationType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TranscodingInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AudioCodec": obj.get("AudioCodec"),
            "VideoCodec": obj.get("VideoCodec"),
            "Container": obj.get("Container"),
            "IsVideoDirect": obj.get("IsVideoDirect"),
            "IsAudioDirect": obj.get("IsAudioDirect"),
            "Bitrate": obj.get("Bitrate"),
            "Framerate": obj.get("Framerate"),
            "CompletionPercentage": obj.get("CompletionPercentage"),
            "Width": obj.get("Width"),
            "Height": obj.get("Height"),
            "AudioChannels": obj.get("AudioChannels"),
            "HardwareAccelerationType": obj.get("HardwareAccelerationType"),
            "TranscodeReasons": obj.get("TranscodeReasons")
        })
        return _obj


