# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_11.models.dlna_profile_type import DlnaProfileType
from jellyfin.generated.api_10_11.models.encoding_context import EncodingContext
from jellyfin.generated.api_10_11.models.media_stream_protocol import MediaStreamProtocol
from jellyfin.generated.api_10_11.models.profile_condition import ProfileCondition
from jellyfin.generated.api_10_11.models.transcode_seek_info import TranscodeSeekInfo
from typing import Optional, Set
from typing_extensions import Self

class TranscodingProfile(BaseModel):
    """
    A class for transcoding profile information.  Note for client developers: Conditions defined in MediaBrowser.Model.Dlna.CodecProfile has higher priority and can override values defined here.
    """ # noqa: E501
    container: Optional[StrictStr] = Field(default=None, description="Gets or sets the container.", alias="Container")
    type: Optional[DlnaProfileType] = Field(default=None, description="Gets or sets the DLNA profile type.", alias="Type")
    video_codec: Optional[StrictStr] = Field(default=None, description="Gets or sets the video codec.", alias="VideoCodec")
    audio_codec: Optional[StrictStr] = Field(default=None, description="Gets or sets the audio codec.", alias="AudioCodec")
    protocol: Optional[MediaStreamProtocol] = Field(default=None, description="Media streaming protocol.  Lowercase for backwards compatibility.", alias="Protocol")
    estimate_content_length: Optional[StrictBool] = Field(default=False, description="Gets or sets a value indicating whether the content length should be estimated.", alias="EstimateContentLength")
    enable_mpegts_m2_ts_mode: Optional[StrictBool] = Field(default=False, description="Gets or sets a value indicating whether M2TS mode is enabled.", alias="EnableMpegtsM2TsMode")
    transcode_seek_info: Optional[TranscodeSeekInfo] = Field(default=TranscodeSeekInfo.AUTO, description="Gets or sets the transcoding seek info mode.", alias="TranscodeSeekInfo")
    copy_timestamps: Optional[StrictBool] = Field(default=False, description="Gets or sets a value indicating whether timestamps should be copied.", alias="CopyTimestamps")
    context: Optional[EncodingContext] = Field(default=EncodingContext.STREAMING, description="Gets or sets the encoding context.", alias="Context")
    enable_subtitles_in_manifest: Optional[StrictBool] = Field(default=False, description="Gets or sets a value indicating whether subtitles are allowed in the manifest.", alias="EnableSubtitlesInManifest")
    max_audio_channels: Optional[StrictStr] = Field(default=None, description="Gets or sets the maximum audio channels.", alias="MaxAudioChannels")
    min_segments: Optional[StrictInt] = Field(default=0, description="Gets or sets the minimum amount of segments.", alias="MinSegments")
    segment_length: Optional[StrictInt] = Field(default=0, description="Gets or sets the segment length.", alias="SegmentLength")
    break_on_non_key_frames: Optional[StrictBool] = Field(default=False, description="Gets or sets a value indicating whether breaking the video stream on non-keyframes is supported.", alias="BreakOnNonKeyFrames")
    conditions: Optional[List[ProfileCondition]] = Field(default=None, description="Gets or sets the profile conditions.", alias="Conditions")
    enable_audio_vbr_encoding: Optional[StrictBool] = Field(default=True, description="Gets or sets a value indicating whether variable bitrate encoding is supported.", alias="EnableAudioVbrEncoding")
    __properties: ClassVar[List[str]] = ["Container", "Type", "VideoCodec", "AudioCodec", "Protocol", "EstimateContentLength", "EnableMpegtsM2TsMode", "TranscodeSeekInfo", "CopyTimestamps", "Context", "EnableSubtitlesInManifest", "MaxAudioChannels", "MinSegments", "SegmentLength", "BreakOnNonKeyFrames", "Conditions", "EnableAudioVbrEncoding"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TranscodingProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in conditions (list)
        _items = []
        if self.conditions:
            for _item_conditions in self.conditions:
                if _item_conditions:
                    _items.append(_item_conditions.to_dict())
            _dict['Conditions'] = _items
        # set to None if max_audio_channels (nullable) is None
        # and model_fields_set contains the field
        if self.max_audio_channels is None and "max_audio_channels" in self.model_fields_set:
            _dict['MaxAudioChannels'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TranscodingProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Container": obj.get("Container"),
            "Type": obj.get("Type"),
            "VideoCodec": obj.get("VideoCodec"),
            "AudioCodec": obj.get("AudioCodec"),
            "Protocol": obj.get("Protocol"),
            "EstimateContentLength": obj.get("EstimateContentLength") if obj.get("EstimateContentLength") is not None else False,
            "EnableMpegtsM2TsMode": obj.get("EnableMpegtsM2TsMode") if obj.get("EnableMpegtsM2TsMode") is not None else False,
            "TranscodeSeekInfo": obj.get("TranscodeSeekInfo") if obj.get("TranscodeSeekInfo") is not None else TranscodeSeekInfo.AUTO,
            "CopyTimestamps": obj.get("CopyTimestamps") if obj.get("CopyTimestamps") is not None else False,
            "Context": obj.get("Context") if obj.get("Context") is not None else EncodingContext.STREAMING,
            "EnableSubtitlesInManifest": obj.get("EnableSubtitlesInManifest") if obj.get("EnableSubtitlesInManifest") is not None else False,
            "MaxAudioChannels": obj.get("MaxAudioChannels"),
            "MinSegments": obj.get("MinSegments") if obj.get("MinSegments") is not None else 0,
            "SegmentLength": obj.get("SegmentLength") if obj.get("SegmentLength") is not None else 0,
            "BreakOnNonKeyFrames": obj.get("BreakOnNonKeyFrames") if obj.get("BreakOnNonKeyFrames") is not None else False,
            "Conditions": [ProfileCondition.from_dict(_item) for _item in obj["Conditions"]] if obj.get("Conditions") is not None else None,
            "EnableAudioVbrEncoding": obj.get("EnableAudioVbrEncoding") if obj.get("EnableAudioVbrEncoding") is not None else True
        })
        return _obj


