# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_11.models.access_schedule import AccessSchedule
from jellyfin.generated.api_10_11.models.sync_play_user_access_type import SyncPlayUserAccessType
from jellyfin.generated.api_10_11.models.unrated_item import UnratedItem
from typing import Optional, Set
from typing_extensions import Self

class UserPolicy(BaseModel):
    """
    UserPolicy
    """ # noqa: E501
    is_administrator: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is administrator.", alias="IsAdministrator")
    is_hidden: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is hidden.", alias="IsHidden")
    enable_collection_management: Optional[StrictBool] = Field(default=False, description="Gets or sets a value indicating whether this instance can manage collections.", alias="EnableCollectionManagement")
    enable_subtitle_management: Optional[StrictBool] = Field(default=False, description="Gets or sets a value indicating whether this instance can manage subtitles.", alias="EnableSubtitleManagement")
    enable_lyric_management: Optional[StrictBool] = Field(default=False, description="Gets or sets a value indicating whether this user can manage lyrics.", alias="EnableLyricManagement")
    is_disabled: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is disabled.", alias="IsDisabled")
    max_parental_rating: Optional[StrictInt] = Field(default=None, description="Gets or sets the max parental rating.", alias="MaxParentalRating")
    max_parental_sub_rating: Optional[StrictInt] = Field(default=None, alias="MaxParentalSubRating")
    blocked_tags: Optional[List[StrictStr]] = Field(default=None, alias="BlockedTags")
    allowed_tags: Optional[List[StrictStr]] = Field(default=None, alias="AllowedTags")
    enable_user_preference_access: Optional[StrictBool] = Field(default=None, alias="EnableUserPreferenceAccess")
    access_schedules: Optional[List[AccessSchedule]] = Field(default=None, alias="AccessSchedules")
    block_unrated_items: Optional[List[UnratedItem]] = Field(default=None, alias="BlockUnratedItems")
    enable_remote_control_of_other_users: Optional[StrictBool] = Field(default=None, alias="EnableRemoteControlOfOtherUsers")
    enable_shared_device_control: Optional[StrictBool] = Field(default=None, alias="EnableSharedDeviceControl")
    enable_remote_access: Optional[StrictBool] = Field(default=None, alias="EnableRemoteAccess")
    enable_live_tv_management: Optional[StrictBool] = Field(default=None, alias="EnableLiveTvManagement")
    enable_live_tv_access: Optional[StrictBool] = Field(default=None, alias="EnableLiveTvAccess")
    enable_media_playback: Optional[StrictBool] = Field(default=None, alias="EnableMediaPlayback")
    enable_audio_playback_transcoding: Optional[StrictBool] = Field(default=None, alias="EnableAudioPlaybackTranscoding")
    enable_video_playback_transcoding: Optional[StrictBool] = Field(default=None, alias="EnableVideoPlaybackTranscoding")
    enable_playback_remuxing: Optional[StrictBool] = Field(default=None, alias="EnablePlaybackRemuxing")
    force_remote_source_transcoding: Optional[StrictBool] = Field(default=None, alias="ForceRemoteSourceTranscoding")
    enable_content_deletion: Optional[StrictBool] = Field(default=None, alias="EnableContentDeletion")
    enable_content_deletion_from_folders: Optional[List[StrictStr]] = Field(default=None, alias="EnableContentDeletionFromFolders")
    enable_content_downloading: Optional[StrictBool] = Field(default=None, alias="EnableContentDownloading")
    enable_sync_transcoding: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether [enable synchronize].", alias="EnableSyncTranscoding")
    enable_media_conversion: Optional[StrictBool] = Field(default=None, alias="EnableMediaConversion")
    enabled_devices: Optional[List[StrictStr]] = Field(default=None, alias="EnabledDevices")
    enable_all_devices: Optional[StrictBool] = Field(default=None, alias="EnableAllDevices")
    enabled_channels: Optional[List[UUID]] = Field(default=None, alias="EnabledChannels")
    enable_all_channels: Optional[StrictBool] = Field(default=None, alias="EnableAllChannels")
    enabled_folders: Optional[List[UUID]] = Field(default=None, alias="EnabledFolders")
    enable_all_folders: Optional[StrictBool] = Field(default=None, alias="EnableAllFolders")
    invalid_login_attempt_count: Optional[StrictInt] = Field(default=None, alias="InvalidLoginAttemptCount")
    login_attempts_before_lockout: Optional[StrictInt] = Field(default=None, alias="LoginAttemptsBeforeLockout")
    max_active_sessions: Optional[StrictInt] = Field(default=None, alias="MaxActiveSessions")
    enable_public_sharing: Optional[StrictBool] = Field(default=None, alias="EnablePublicSharing")
    blocked_media_folders: Optional[List[UUID]] = Field(default=None, alias="BlockedMediaFolders")
    blocked_channels: Optional[List[UUID]] = Field(default=None, alias="BlockedChannels")
    remote_client_bitrate_limit: Optional[StrictInt] = Field(default=None, alias="RemoteClientBitrateLimit")
    authentication_provider_id: StrictStr = Field(alias="AuthenticationProviderId")
    password_reset_provider_id: StrictStr = Field(alias="PasswordResetProviderId")
    sync_play_access: Optional[SyncPlayUserAccessType] = Field(default=None, description="Gets or sets a value indicating what SyncPlay features the user can access.", alias="SyncPlayAccess")
    __properties: ClassVar[List[str]] = ["IsAdministrator", "IsHidden", "EnableCollectionManagement", "EnableSubtitleManagement", "EnableLyricManagement", "IsDisabled", "MaxParentalRating", "MaxParentalSubRating", "BlockedTags", "AllowedTags", "EnableUserPreferenceAccess", "AccessSchedules", "BlockUnratedItems", "EnableRemoteControlOfOtherUsers", "EnableSharedDeviceControl", "EnableRemoteAccess", "EnableLiveTvManagement", "EnableLiveTvAccess", "EnableMediaPlayback", "EnableAudioPlaybackTranscoding", "EnableVideoPlaybackTranscoding", "EnablePlaybackRemuxing", "ForceRemoteSourceTranscoding", "EnableContentDeletion", "EnableContentDeletionFromFolders", "EnableContentDownloading", "EnableSyncTranscoding", "EnableMediaConversion", "EnabledDevices", "EnableAllDevices", "EnabledChannels", "EnableAllChannels", "EnabledFolders", "EnableAllFolders", "InvalidLoginAttemptCount", "LoginAttemptsBeforeLockout", "MaxActiveSessions", "EnablePublicSharing", "BlockedMediaFolders", "BlockedChannels", "RemoteClientBitrateLimit", "AuthenticationProviderId", "PasswordResetProviderId", "SyncPlayAccess"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserPolicy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in access_schedules (list)
        _items = []
        if self.access_schedules:
            for _item_access_schedules in self.access_schedules:
                if _item_access_schedules:
                    _items.append(_item_access_schedules.to_dict())
            _dict['AccessSchedules'] = _items
        # set to None if max_parental_rating (nullable) is None
        # and model_fields_set contains the field
        if self.max_parental_rating is None and "max_parental_rating" in self.model_fields_set:
            _dict['MaxParentalRating'] = None

        # set to None if max_parental_sub_rating (nullable) is None
        # and model_fields_set contains the field
        if self.max_parental_sub_rating is None and "max_parental_sub_rating" in self.model_fields_set:
            _dict['MaxParentalSubRating'] = None

        # set to None if blocked_tags (nullable) is None
        # and model_fields_set contains the field
        if self.blocked_tags is None and "blocked_tags" in self.model_fields_set:
            _dict['BlockedTags'] = None

        # set to None if allowed_tags (nullable) is None
        # and model_fields_set contains the field
        if self.allowed_tags is None and "allowed_tags" in self.model_fields_set:
            _dict['AllowedTags'] = None

        # set to None if access_schedules (nullable) is None
        # and model_fields_set contains the field
        if self.access_schedules is None and "access_schedules" in self.model_fields_set:
            _dict['AccessSchedules'] = None

        # set to None if block_unrated_items (nullable) is None
        # and model_fields_set contains the field
        if self.block_unrated_items is None and "block_unrated_items" in self.model_fields_set:
            _dict['BlockUnratedItems'] = None

        # set to None if enable_content_deletion_from_folders (nullable) is None
        # and model_fields_set contains the field
        if self.enable_content_deletion_from_folders is None and "enable_content_deletion_from_folders" in self.model_fields_set:
            _dict['EnableContentDeletionFromFolders'] = None

        # set to None if enabled_devices (nullable) is None
        # and model_fields_set contains the field
        if self.enabled_devices is None and "enabled_devices" in self.model_fields_set:
            _dict['EnabledDevices'] = None

        # set to None if enabled_channels (nullable) is None
        # and model_fields_set contains the field
        if self.enabled_channels is None and "enabled_channels" in self.model_fields_set:
            _dict['EnabledChannels'] = None

        # set to None if enabled_folders (nullable) is None
        # and model_fields_set contains the field
        if self.enabled_folders is None and "enabled_folders" in self.model_fields_set:
            _dict['EnabledFolders'] = None

        # set to None if blocked_media_folders (nullable) is None
        # and model_fields_set contains the field
        if self.blocked_media_folders is None and "blocked_media_folders" in self.model_fields_set:
            _dict['BlockedMediaFolders'] = None

        # set to None if blocked_channels (nullable) is None
        # and model_fields_set contains the field
        if self.blocked_channels is None and "blocked_channels" in self.model_fields_set:
            _dict['BlockedChannels'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserPolicy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "IsAdministrator": obj.get("IsAdministrator"),
            "IsHidden": obj.get("IsHidden"),
            "EnableCollectionManagement": obj.get("EnableCollectionManagement") if obj.get("EnableCollectionManagement") is not None else False,
            "EnableSubtitleManagement": obj.get("EnableSubtitleManagement") if obj.get("EnableSubtitleManagement") is not None else False,
            "EnableLyricManagement": obj.get("EnableLyricManagement") if obj.get("EnableLyricManagement") is not None else False,
            "IsDisabled": obj.get("IsDisabled"),
            "MaxParentalRating": obj.get("MaxParentalRating"),
            "MaxParentalSubRating": obj.get("MaxParentalSubRating"),
            "BlockedTags": obj.get("BlockedTags"),
            "AllowedTags": obj.get("AllowedTags"),
            "EnableUserPreferenceAccess": obj.get("EnableUserPreferenceAccess"),
            "AccessSchedules": [AccessSchedule.from_dict(_item) for _item in obj["AccessSchedules"]] if obj.get("AccessSchedules") is not None else None,
            "BlockUnratedItems": obj.get("BlockUnratedItems"),
            "EnableRemoteControlOfOtherUsers": obj.get("EnableRemoteControlOfOtherUsers"),
            "EnableSharedDeviceControl": obj.get("EnableSharedDeviceControl"),
            "EnableRemoteAccess": obj.get("EnableRemoteAccess"),
            "EnableLiveTvManagement": obj.get("EnableLiveTvManagement"),
            "EnableLiveTvAccess": obj.get("EnableLiveTvAccess"),
            "EnableMediaPlayback": obj.get("EnableMediaPlayback"),
            "EnableAudioPlaybackTranscoding": obj.get("EnableAudioPlaybackTranscoding"),
            "EnableVideoPlaybackTranscoding": obj.get("EnableVideoPlaybackTranscoding"),
            "EnablePlaybackRemuxing": obj.get("EnablePlaybackRemuxing"),
            "ForceRemoteSourceTranscoding": obj.get("ForceRemoteSourceTranscoding"),
            "EnableContentDeletion": obj.get("EnableContentDeletion"),
            "EnableContentDeletionFromFolders": obj.get("EnableContentDeletionFromFolders"),
            "EnableContentDownloading": obj.get("EnableContentDownloading"),
            "EnableSyncTranscoding": obj.get("EnableSyncTranscoding"),
            "EnableMediaConversion": obj.get("EnableMediaConversion"),
            "EnabledDevices": obj.get("EnabledDevices"),
            "EnableAllDevices": obj.get("EnableAllDevices"),
            "EnabledChannels": obj.get("EnabledChannels"),
            "EnableAllChannels": obj.get("EnableAllChannels"),
            "EnabledFolders": obj.get("EnabledFolders"),
            "EnableAllFolders": obj.get("EnableAllFolders"),
            "InvalidLoginAttemptCount": obj.get("InvalidLoginAttemptCount"),
            "LoginAttemptsBeforeLockout": obj.get("LoginAttemptsBeforeLockout"),
            "MaxActiveSessions": obj.get("MaxActiveSessions"),
            "EnablePublicSharing": obj.get("EnablePublicSharing"),
            "BlockedMediaFolders": obj.get("BlockedMediaFolders"),
            "BlockedChannels": obj.get("BlockedChannels"),
            "RemoteClientBitrateLimit": obj.get("RemoteClientBitrateLimit"),
            "AuthenticationProviderId": obj.get("AuthenticationProviderId"),
            "PasswordResetProviderId": obj.get("PasswordResetProviderId"),
            "SyncPlayAccess": obj.get("SyncPlayAccess")
        })
        return _obj


