# Developer Guide

## Contribute

This section outlines how to contribute effectively to the `simtools` project.

- [Getting Started as Developer](getting_started_as_developer.md): Set up your development environment.
- [First Steps](developer_guidelines.md): How to begin contributing.
- [Coding Guidelines](coding_guidelines.md): Code style and best practices.
- [Pull Requests](pull_requests.md): How to open a PR via [GitHub](https://github.com/gammasim/simtools/pulls).
- [Documentation](documentation.md): Contributing to user and developer documentation.
- [Testing](testing.md): Writing unit and integration tests.

## Automatic Processes

- [Continuous Integration](continuous_integration.md): Automated testing and checks.
- [Deployment](releases.md#release-and-deploy): Automated deployment of releases.

## Containers

All software components of `simtools` are available as OCI-compatible container images.

- [Running simtools containers](../user-guide/getting_started.md#container-images)
- [Building simtools images](simtools_build_images.md):

## Preparing simtools Releases

- [Prepare and Deploy](release.md): How to prepare and deploy a new release of `simtools`.

```{toctree}
:hidden:
:maxdepth: 1
getting_started_as_developer.md
developer_guidelines.md
coding_guidelines.md
pull_requests.md
documentation.md
testing.md
continuous_integration.md
simtools_build_images.md
release.md
```
