# fupi

A brute-force shortcut to fix python import hell. Acronym standing for... um, Fixing-Up Python Imports. 

Sure, let's go with that. 

## Usage

Simply import fupi in your project:

```python
import fupi
```

This automatically adds relevant directories (like `src` and `test`) to your Python path, making imports work seamlessly across your project structure.

## Configuration

No configuration is needed if you use the defaults: 
- Add `src` and `test` folders and subfolders, 
- Skip folders `setup`, `venv*`, and `*egg*`.  

### .ENV File Config

To use different / more folder names, simply add the following to an existing .env file, or
create a new `*.env` or `fupi.env` file:

```
FUPI_ADD_DIRS="src,test"
FUPI_SKIP_DIRS="setup,venv*,*egg*"
```

The `FUPI_ADD_DIRS` will be string-matched against folders in your project, and on exact match, will include that folder and all subfolders into your sys.path.

The `FUPI_SKIP_DIRS` is a collection of regex patterns to skip, with string begin and end tags added (`^value$`).  Thus you can simply add a list of folder names, or use basic wildcard * characters. If
you want to get crazy with regex, be my guest - but understand the value will be wrapped (`^value$`).

The `FUPI_SKIP_DIRS` will also always append patters to disqualify any path starting with a period('.')
or an underscore('_') (i.e., `'\.*'` and `'\_*'`), which should catch most common skipped folders like
`.git`, `__pycache__`, etc.

### Environment Variable Config

Alternatively, you can add the above to os.envars before you `import fupi`.  Note, this process does NOT
use `dotenv`, which would also load into os.envars, although the behavior is similar, just restricted
to only `FUPI_*` configs.  Similar to the .env approach above, simply add a comma-delimited list of all folder names / regex patterns. 