# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InfraAlertConditionArgs', 'InfraAlertCondition']

@pulumi.input_type
class InfraAlertConditionArgs:
    def __init__(__self__, *,
                 policy_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 comparison: Optional[pulumi.Input[_builtins.str]] = None,
                 critical: Optional[pulumi.Input['InfraAlertConditionCriticalArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 event: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 process_where: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_url: Optional[pulumi.Input[_builtins.str]] = None,
                 select: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_close_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 warning: Optional[pulumi.Input['InfraAlertConditionWarningArgs']] = None,
                 where: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InfraAlertCondition resource.
        :param pulumi.Input[_builtins.str] policy_id: The ID of the alert policy where this condition should be used.
        :param pulumi.Input[_builtins.str] type: The type of Infrastructure alert condition.  Valid values are  `infra_process_running`, `infra_metric`, and `infra_host_not_reporting`.
        :param pulumi.Input[_builtins.str] comparison: The operator used to evaluate the threshold value.  Valid values are `above`, `below`, and `equal`.  Supported by the `infra_metric` and `infra_process_running` condition types.
        :param pulumi.Input['InfraAlertConditionCriticalArgs'] critical: Identifies the threshold parameters for opening a critical alert incident. See Thresholds below for details.
        :param pulumi.Input[_builtins.str] description: The description of the Infrastructure alert condition.
        :param pulumi.Input[_builtins.bool] enabled: Whether the condition is turned on or off.  Valid values are `true` and `false`.  Defaults to `true`.
        :param pulumi.Input[_builtins.str] event: The metric event; for example, `SystemSample` or `StorageSample`.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[_builtins.str] integration_provider: For alerts on integrations, use this instead of `event`.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[_builtins.str] name: The Infrastructure alert condition's name.
        :param pulumi.Input[_builtins.str] process_where: Any filters applied to processes; for example: `commandName = 'java'`.  Required by the `infra_process_running` condition type.
        :param pulumi.Input[_builtins.str] runbook_url: Runbook URL to display in notifications.
        :param pulumi.Input[_builtins.str] select: The attribute name to identify the metric being targeted; for example, `cpuPercent`, `diskFreePercent`, or `memoryResidentSizeBytes`.  The underlying API will automatically populate this value for Infrastructure integrations (for example `diskFreePercent`), so make sure to explicitly include this value to avoid diff issues.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[_builtins.int] violation_close_timer: Determines how much time will pass (in hours) before an incident is automatically closed. Valid values are `1 2 4 8 12 24 48 72`. Defaults to 24. If `0` is provided, default of `24` is used and will have configuration drift during the apply phase until a valid value is provided.
               
               ```
               Warning: This resource will use the account ID linked to your API key. At the moment it is not possible to dynamically set the account ID.
               ```
        :param pulumi.Input['InfraAlertConditionWarningArgs'] warning: Identifies the threshold parameters for opening a warning alert incident. See Thresholds below for details.
        :param pulumi.Input[_builtins.str] where: If applicable, this identifies any Infrastructure host filters used; for example: `hostname LIKE '%cassandra%'`.
        """
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "type", type)
        if comparison is not None:
            pulumi.set(__self__, "comparison", comparison)
        if critical is not None:
            pulumi.set(__self__, "critical", critical)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if event is not None:
            pulumi.set(__self__, "event", event)
        if integration_provider is not None:
            pulumi.set(__self__, "integration_provider", integration_provider)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if process_where is not None:
            pulumi.set(__self__, "process_where", process_where)
        if runbook_url is not None:
            pulumi.set(__self__, "runbook_url", runbook_url)
        if select is not None:
            pulumi.set(__self__, "select", select)
        if violation_close_timer is not None:
            pulumi.set(__self__, "violation_close_timer", violation_close_timer)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)
        if where is not None:
            pulumi.set(__self__, "where", where)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the alert policy where this condition should be used.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of Infrastructure alert condition.  Valid values are  `infra_process_running`, `infra_metric`, and `infra_host_not_reporting`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def comparison(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operator used to evaluate the threshold value.  Valid values are `above`, `below`, and `equal`.  Supported by the `infra_metric` and `infra_process_running` condition types.
        """
        return pulumi.get(self, "comparison")

    @comparison.setter
    def comparison(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comparison", value)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> Optional[pulumi.Input['InfraAlertConditionCriticalArgs']]:
        """
        Identifies the threshold parameters for opening a critical alert incident. See Thresholds below for details.
        """
        return pulumi.get(self, "critical")

    @critical.setter
    def critical(self, value: Optional[pulumi.Input['InfraAlertConditionCriticalArgs']]):
        pulumi.set(self, "critical", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Infrastructure alert condition.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the condition is turned on or off.  Valid values are `true` and `false`.  Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def event(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The metric event; for example, `SystemSample` or `StorageSample`.  Supported by the `infra_metric` condition type.
        """
        return pulumi.get(self, "event")

    @event.setter
    def event(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event", value)

    @_builtins.property
    @pulumi.getter(name="integrationProvider")
    def integration_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For alerts on integrations, use this instead of `event`.  Supported by the `infra_metric` condition type.
        """
        return pulumi.get(self, "integration_provider")

    @integration_provider.setter
    def integration_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_provider", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Infrastructure alert condition's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="processWhere")
    def process_where(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Any filters applied to processes; for example: `commandName = 'java'`.  Required by the `infra_process_running` condition type.
        """
        return pulumi.get(self, "process_where")

    @process_where.setter
    def process_where(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "process_where", value)

    @_builtins.property
    @pulumi.getter(name="runbookUrl")
    def runbook_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Runbook URL to display in notifications.
        """
        return pulumi.get(self, "runbook_url")

    @runbook_url.setter
    def runbook_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runbook_url", value)

    @_builtins.property
    @pulumi.getter
    def select(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute name to identify the metric being targeted; for example, `cpuPercent`, `diskFreePercent`, or `memoryResidentSizeBytes`.  The underlying API will automatically populate this value for Infrastructure integrations (for example `diskFreePercent`), so make sure to explicitly include this value to avoid diff issues.  Supported by the `infra_metric` condition type.
        """
        return pulumi.get(self, "select")

    @select.setter
    def select(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "select", value)

    @_builtins.property
    @pulumi.getter(name="violationCloseTimer")
    def violation_close_timer(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Determines how much time will pass (in hours) before an incident is automatically closed. Valid values are `1 2 4 8 12 24 48 72`. Defaults to 24. If `0` is provided, default of `24` is used and will have configuration drift during the apply phase until a valid value is provided.

        ```
        Warning: This resource will use the account ID linked to your API key. At the moment it is not possible to dynamically set the account ID.
        ```
        """
        return pulumi.get(self, "violation_close_timer")

    @violation_close_timer.setter
    def violation_close_timer(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "violation_close_timer", value)

    @_builtins.property
    @pulumi.getter
    def warning(self) -> Optional[pulumi.Input['InfraAlertConditionWarningArgs']]:
        """
        Identifies the threshold parameters for opening a warning alert incident. See Thresholds below for details.
        """
        return pulumi.get(self, "warning")

    @warning.setter
    def warning(self, value: Optional[pulumi.Input['InfraAlertConditionWarningArgs']]):
        pulumi.set(self, "warning", value)

    @_builtins.property
    @pulumi.getter
    def where(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If applicable, this identifies any Infrastructure host filters used; for example: `hostname LIKE '%cassandra%'`.
        """
        return pulumi.get(self, "where")

    @where.setter
    def where(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "where", value)


@pulumi.input_type
class _InfraAlertConditionState:
    def __init__(__self__, *,
                 comparison: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.int]] = None,
                 critical: Optional[pulumi.Input['InfraAlertConditionCriticalArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 event: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 process_where: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_url: Optional[pulumi.Input[_builtins.str]] = None,
                 select: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.int]] = None,
                 violation_close_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 warning: Optional[pulumi.Input['InfraAlertConditionWarningArgs']] = None,
                 where: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InfraAlertCondition resources.
        :param pulumi.Input[_builtins.str] comparison: The operator used to evaluate the threshold value.  Valid values are `above`, `below`, and `equal`.  Supported by the `infra_metric` and `infra_process_running` condition types.
        :param pulumi.Input[_builtins.int] created_at: The timestamp the alert condition was created.
        :param pulumi.Input['InfraAlertConditionCriticalArgs'] critical: Identifies the threshold parameters for opening a critical alert incident. See Thresholds below for details.
        :param pulumi.Input[_builtins.str] description: The description of the Infrastructure alert condition.
        :param pulumi.Input[_builtins.bool] enabled: Whether the condition is turned on or off.  Valid values are `true` and `false`.  Defaults to `true`.
        :param pulumi.Input[_builtins.str] entity_guid: The unique entity identifier of the condition in New Relic.
        :param pulumi.Input[_builtins.str] event: The metric event; for example, `SystemSample` or `StorageSample`.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[_builtins.str] integration_provider: For alerts on integrations, use this instead of `event`.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[_builtins.str] name: The Infrastructure alert condition's name.
        :param pulumi.Input[_builtins.str] policy_id: The ID of the alert policy where this condition should be used.
        :param pulumi.Input[_builtins.str] process_where: Any filters applied to processes; for example: `commandName = 'java'`.  Required by the `infra_process_running` condition type.
        :param pulumi.Input[_builtins.str] runbook_url: Runbook URL to display in notifications.
        :param pulumi.Input[_builtins.str] select: The attribute name to identify the metric being targeted; for example, `cpuPercent`, `diskFreePercent`, or `memoryResidentSizeBytes`.  The underlying API will automatically populate this value for Infrastructure integrations (for example `diskFreePercent`), so make sure to explicitly include this value to avoid diff issues.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[_builtins.str] type: The type of Infrastructure alert condition.  Valid values are  `infra_process_running`, `infra_metric`, and `infra_host_not_reporting`.
        :param pulumi.Input[_builtins.int] updated_at: The timestamp the alert condition was last updated.
        :param pulumi.Input[_builtins.int] violation_close_timer: Determines how much time will pass (in hours) before an incident is automatically closed. Valid values are `1 2 4 8 12 24 48 72`. Defaults to 24. If `0` is provided, default of `24` is used and will have configuration drift during the apply phase until a valid value is provided.
               
               ```
               Warning: This resource will use the account ID linked to your API key. At the moment it is not possible to dynamically set the account ID.
               ```
        :param pulumi.Input['InfraAlertConditionWarningArgs'] warning: Identifies the threshold parameters for opening a warning alert incident. See Thresholds below for details.
        :param pulumi.Input[_builtins.str] where: If applicable, this identifies any Infrastructure host filters used; for example: `hostname LIKE '%cassandra%'`.
        """
        if comparison is not None:
            pulumi.set(__self__, "comparison", comparison)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if critical is not None:
            pulumi.set(__self__, "critical", critical)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entity_guid is not None:
            pulumi.set(__self__, "entity_guid", entity_guid)
        if event is not None:
            pulumi.set(__self__, "event", event)
        if integration_provider is not None:
            pulumi.set(__self__, "integration_provider", integration_provider)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if process_where is not None:
            pulumi.set(__self__, "process_where", process_where)
        if runbook_url is not None:
            pulumi.set(__self__, "runbook_url", runbook_url)
        if select is not None:
            pulumi.set(__self__, "select", select)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if violation_close_timer is not None:
            pulumi.set(__self__, "violation_close_timer", violation_close_timer)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)
        if where is not None:
            pulumi.set(__self__, "where", where)

    @_builtins.property
    @pulumi.getter
    def comparison(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operator used to evaluate the threshold value.  Valid values are `above`, `below`, and `equal`.  Supported by the `infra_metric` and `infra_process_running` condition types.
        """
        return pulumi.get(self, "comparison")

    @comparison.setter
    def comparison(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comparison", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timestamp the alert condition was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> Optional[pulumi.Input['InfraAlertConditionCriticalArgs']]:
        """
        Identifies the threshold parameters for opening a critical alert incident. See Thresholds below for details.
        """
        return pulumi.get(self, "critical")

    @critical.setter
    def critical(self, value: Optional[pulumi.Input['InfraAlertConditionCriticalArgs']]):
        pulumi.set(self, "critical", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Infrastructure alert condition.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the condition is turned on or off.  Valid values are `true` and `false`.  Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="entityGuid")
    def entity_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique entity identifier of the condition in New Relic.
        """
        return pulumi.get(self, "entity_guid")

    @entity_guid.setter
    def entity_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_guid", value)

    @_builtins.property
    @pulumi.getter
    def event(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The metric event; for example, `SystemSample` or `StorageSample`.  Supported by the `infra_metric` condition type.
        """
        return pulumi.get(self, "event")

    @event.setter
    def event(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event", value)

    @_builtins.property
    @pulumi.getter(name="integrationProvider")
    def integration_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For alerts on integrations, use this instead of `event`.  Supported by the `infra_metric` condition type.
        """
        return pulumi.get(self, "integration_provider")

    @integration_provider.setter
    def integration_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_provider", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Infrastructure alert condition's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the alert policy where this condition should be used.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter(name="processWhere")
    def process_where(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Any filters applied to processes; for example: `commandName = 'java'`.  Required by the `infra_process_running` condition type.
        """
        return pulumi.get(self, "process_where")

    @process_where.setter
    def process_where(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "process_where", value)

    @_builtins.property
    @pulumi.getter(name="runbookUrl")
    def runbook_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Runbook URL to display in notifications.
        """
        return pulumi.get(self, "runbook_url")

    @runbook_url.setter
    def runbook_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runbook_url", value)

    @_builtins.property
    @pulumi.getter
    def select(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute name to identify the metric being targeted; for example, `cpuPercent`, `diskFreePercent`, or `memoryResidentSizeBytes`.  The underlying API will automatically populate this value for Infrastructure integrations (for example `diskFreePercent`), so make sure to explicitly include this value to avoid diff issues.  Supported by the `infra_metric` condition type.
        """
        return pulumi.get(self, "select")

    @select.setter
    def select(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "select", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Infrastructure alert condition.  Valid values are  `infra_process_running`, `infra_metric`, and `infra_host_not_reporting`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timestamp the alert condition was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="violationCloseTimer")
    def violation_close_timer(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Determines how much time will pass (in hours) before an incident is automatically closed. Valid values are `1 2 4 8 12 24 48 72`. Defaults to 24. If `0` is provided, default of `24` is used and will have configuration drift during the apply phase until a valid value is provided.

        ```
        Warning: This resource will use the account ID linked to your API key. At the moment it is not possible to dynamically set the account ID.
        ```
        """
        return pulumi.get(self, "violation_close_timer")

    @violation_close_timer.setter
    def violation_close_timer(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "violation_close_timer", value)

    @_builtins.property
    @pulumi.getter
    def warning(self) -> Optional[pulumi.Input['InfraAlertConditionWarningArgs']]:
        """
        Identifies the threshold parameters for opening a warning alert incident. See Thresholds below for details.
        """
        return pulumi.get(self, "warning")

    @warning.setter
    def warning(self, value: Optional[pulumi.Input['InfraAlertConditionWarningArgs']]):
        pulumi.set(self, "warning", value)

    @_builtins.property
    @pulumi.getter
    def where(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If applicable, this identifies any Infrastructure host filters used; for example: `hostname LIKE '%cassandra%'`.
        """
        return pulumi.get(self, "where")

    @where.setter
    def where(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "where", value)


@pulumi.type_token("newrelic:index/infraAlertCondition:InfraAlertCondition")
class InfraAlertCondition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comparison: Optional[pulumi.Input[_builtins.str]] = None,
                 critical: Optional[pulumi.Input[Union['InfraAlertConditionCriticalArgs', 'InfraAlertConditionCriticalArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 event: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 process_where: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_url: Optional[pulumi.Input[_builtins.str]] = None,
                 select: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_close_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 warning: Optional[pulumi.Input[Union['InfraAlertConditionWarningArgs', 'InfraAlertConditionWarningArgsDict']]] = None,
                 where: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Use this resource to create and manage Infrastructure alert conditions in New Relic.

        > **WARNING:** The `InfraAlertCondition` resource is deprecated and will be removed in the next major release. The resource NrqlAlertCondition would be a preferred alternative to configure alert conditions - in most cases, feature parity can be achieved with a NRQL query. For more details and examples on moving away from infra alert conditions to the NRQL based alternative, please check out these examples.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.AlertPolicy("foo", name="foo")
        high_disk_usage = newrelic.InfraAlertCondition("high_disk_usage",
            policy_id=foo.id,
            name="High disk usage",
            description="Warning if disk usage goes above 80% and critical alert if goes above 90%",
            type="infra_metric",
            event="StorageSample",
            select="diskUsedPercent",
            comparison="above",
            where="(hostname LIKE '%frontend%')",
            critical={
                "duration": 25,
                "value": 90,
                "time_function": "all",
            },
            warning={
                "duration": 10,
                "value": 80,
                "time_function": "all",
            })
        high_db_conn_count = newrelic.InfraAlertCondition("high_db_conn_count",
            policy_id=foo.id,
            name="High database connection count",
            description="Critical alert when the number of database connections goes above 90",
            type="infra_metric",
            event="DatastoreSample",
            select="provider.databaseConnections.Average",
            comparison="above",
            where="(hostname LIKE '%db%')",
            integration_provider="RdsDbInstance",
            critical={
                "duration": 25,
                "value": 90,
                "time_function": "all",
            })
        process_not_running = newrelic.InfraAlertCondition("process_not_running",
            policy_id=foo.id,
            name="Process not running (/usr/bin/ruby)",
            description="Critical alert when ruby isn't running",
            type="infra_process_running",
            comparison="equal",
            where="hostname = 'web01'",
            process_where="commandName = '/usr/bin/ruby'",
            critical={
                "duration": 5,
                "value": 0,
            })
        host_not_reporting = newrelic.InfraAlertCondition("host_not_reporting",
            policy_id=foo.id,
            name="Host not reporting",
            description="Critical alert when the host is not reporting",
            type="infra_host_not_reporting",
            where="(hostname LIKE '%frontend%')",
            critical={
                "duration": 5,
            })
        ```

        ## Thresholds

        The `critical` and `warning` threshold mapping supports the following arguments:

          * `duration` - (Required) Identifies the number of minutes the threshold must be passed or met for the alert to trigger. Threshold durations must be between 1 and 60 minutes (inclusive).
          * `value` - (Optional) Threshold value, computed against the `comparison` operator. Supported by `infra_metric` and `infra_process_running` alert condition types.
          * `time_function` - (Optional) Indicates if the condition needs to be sustained or to just break the threshold once; `all` or `any`. Supported by the `infra_metric` alert condition type.

        ## Tags

        Manage infra alert condition tags with `EntityTags`. For up-to-date documentation about the tagging resource, please check EntityTags

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.AlertPolicy("foo", name="foo policy")
        foo_infra_alert_condition = newrelic.InfraAlertCondition("foo",
            policy_id=foo.id,
            name="foo infra condition",
            description="Warning if disk usage goes above 80% and critical alert if goes above 90%",
            type="infra_metric",
            event="StorageSample",
            select="diskUsedPercent",
            comparison="above",
            where="(hostname LIKE '%frontend%')",
            critical={
                "duration": 25,
                "value": 90,
                "time_function": "all",
            },
            warning={
                "duration": 10,
                "value": 80,
                "time_function": "all",
            })
        my_condition_entity_tags = newrelic.EntityTags("my_condition_entity_tags",
            guid=foo_infra_alert_condition.entity_guid,
            tags=[
                {
                    "key": "my-key",
                    "values": [
                        "my-value",
                        "my-other-value",
                    ],
                },
                {
                    "key": "my-key-2",
                    "values": ["my-value-2"],
                },
            ])
        ```

        ## Import

        Infrastructure alert conditions can be imported using a composite ID of `<policy_id>:<condition_id>`, e.g.

        ```sh
        $ pulumi import newrelic:index/infraAlertCondition:InfraAlertCondition main 12345:67890
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comparison: The operator used to evaluate the threshold value.  Valid values are `above`, `below`, and `equal`.  Supported by the `infra_metric` and `infra_process_running` condition types.
        :param pulumi.Input[Union['InfraAlertConditionCriticalArgs', 'InfraAlertConditionCriticalArgsDict']] critical: Identifies the threshold parameters for opening a critical alert incident. See Thresholds below for details.
        :param pulumi.Input[_builtins.str] description: The description of the Infrastructure alert condition.
        :param pulumi.Input[_builtins.bool] enabled: Whether the condition is turned on or off.  Valid values are `true` and `false`.  Defaults to `true`.
        :param pulumi.Input[_builtins.str] event: The metric event; for example, `SystemSample` or `StorageSample`.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[_builtins.str] integration_provider: For alerts on integrations, use this instead of `event`.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[_builtins.str] name: The Infrastructure alert condition's name.
        :param pulumi.Input[_builtins.str] policy_id: The ID of the alert policy where this condition should be used.
        :param pulumi.Input[_builtins.str] process_where: Any filters applied to processes; for example: `commandName = 'java'`.  Required by the `infra_process_running` condition type.
        :param pulumi.Input[_builtins.str] runbook_url: Runbook URL to display in notifications.
        :param pulumi.Input[_builtins.str] select: The attribute name to identify the metric being targeted; for example, `cpuPercent`, `diskFreePercent`, or `memoryResidentSizeBytes`.  The underlying API will automatically populate this value for Infrastructure integrations (for example `diskFreePercent`), so make sure to explicitly include this value to avoid diff issues.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[_builtins.str] type: The type of Infrastructure alert condition.  Valid values are  `infra_process_running`, `infra_metric`, and `infra_host_not_reporting`.
        :param pulumi.Input[_builtins.int] violation_close_timer: Determines how much time will pass (in hours) before an incident is automatically closed. Valid values are `1 2 4 8 12 24 48 72`. Defaults to 24. If `0` is provided, default of `24` is used and will have configuration drift during the apply phase until a valid value is provided.
               
               ```
               Warning: This resource will use the account ID linked to your API key. At the moment it is not possible to dynamically set the account ID.
               ```
        :param pulumi.Input[Union['InfraAlertConditionWarningArgs', 'InfraAlertConditionWarningArgsDict']] warning: Identifies the threshold parameters for opening a warning alert incident. See Thresholds below for details.
        :param pulumi.Input[_builtins.str] where: If applicable, this identifies any Infrastructure host filters used; for example: `hostname LIKE '%cassandra%'`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InfraAlertConditionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to create and manage Infrastructure alert conditions in New Relic.

        > **WARNING:** The `InfraAlertCondition` resource is deprecated and will be removed in the next major release. The resource NrqlAlertCondition would be a preferred alternative to configure alert conditions - in most cases, feature parity can be achieved with a NRQL query. For more details and examples on moving away from infra alert conditions to the NRQL based alternative, please check out these examples.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.AlertPolicy("foo", name="foo")
        high_disk_usage = newrelic.InfraAlertCondition("high_disk_usage",
            policy_id=foo.id,
            name="High disk usage",
            description="Warning if disk usage goes above 80% and critical alert if goes above 90%",
            type="infra_metric",
            event="StorageSample",
            select="diskUsedPercent",
            comparison="above",
            where="(hostname LIKE '%frontend%')",
            critical={
                "duration": 25,
                "value": 90,
                "time_function": "all",
            },
            warning={
                "duration": 10,
                "value": 80,
                "time_function": "all",
            })
        high_db_conn_count = newrelic.InfraAlertCondition("high_db_conn_count",
            policy_id=foo.id,
            name="High database connection count",
            description="Critical alert when the number of database connections goes above 90",
            type="infra_metric",
            event="DatastoreSample",
            select="provider.databaseConnections.Average",
            comparison="above",
            where="(hostname LIKE '%db%')",
            integration_provider="RdsDbInstance",
            critical={
                "duration": 25,
                "value": 90,
                "time_function": "all",
            })
        process_not_running = newrelic.InfraAlertCondition("process_not_running",
            policy_id=foo.id,
            name="Process not running (/usr/bin/ruby)",
            description="Critical alert when ruby isn't running",
            type="infra_process_running",
            comparison="equal",
            where="hostname = 'web01'",
            process_where="commandName = '/usr/bin/ruby'",
            critical={
                "duration": 5,
                "value": 0,
            })
        host_not_reporting = newrelic.InfraAlertCondition("host_not_reporting",
            policy_id=foo.id,
            name="Host not reporting",
            description="Critical alert when the host is not reporting",
            type="infra_host_not_reporting",
            where="(hostname LIKE '%frontend%')",
            critical={
                "duration": 5,
            })
        ```

        ## Thresholds

        The `critical` and `warning` threshold mapping supports the following arguments:

          * `duration` - (Required) Identifies the number of minutes the threshold must be passed or met for the alert to trigger. Threshold durations must be between 1 and 60 minutes (inclusive).
          * `value` - (Optional) Threshold value, computed against the `comparison` operator. Supported by `infra_metric` and `infra_process_running` alert condition types.
          * `time_function` - (Optional) Indicates if the condition needs to be sustained or to just break the threshold once; `all` or `any`. Supported by the `infra_metric` alert condition type.

        ## Tags

        Manage infra alert condition tags with `EntityTags`. For up-to-date documentation about the tagging resource, please check EntityTags

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.AlertPolicy("foo", name="foo policy")
        foo_infra_alert_condition = newrelic.InfraAlertCondition("foo",
            policy_id=foo.id,
            name="foo infra condition",
            description="Warning if disk usage goes above 80% and critical alert if goes above 90%",
            type="infra_metric",
            event="StorageSample",
            select="diskUsedPercent",
            comparison="above",
            where="(hostname LIKE '%frontend%')",
            critical={
                "duration": 25,
                "value": 90,
                "time_function": "all",
            },
            warning={
                "duration": 10,
                "value": 80,
                "time_function": "all",
            })
        my_condition_entity_tags = newrelic.EntityTags("my_condition_entity_tags",
            guid=foo_infra_alert_condition.entity_guid,
            tags=[
                {
                    "key": "my-key",
                    "values": [
                        "my-value",
                        "my-other-value",
                    ],
                },
                {
                    "key": "my-key-2",
                    "values": ["my-value-2"],
                },
            ])
        ```

        ## Import

        Infrastructure alert conditions can be imported using a composite ID of `<policy_id>:<condition_id>`, e.g.

        ```sh
        $ pulumi import newrelic:index/infraAlertCondition:InfraAlertCondition main 12345:67890
        ```

        :param str resource_name: The name of the resource.
        :param InfraAlertConditionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InfraAlertConditionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comparison: Optional[pulumi.Input[_builtins.str]] = None,
                 critical: Optional[pulumi.Input[Union['InfraAlertConditionCriticalArgs', 'InfraAlertConditionCriticalArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 event: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 process_where: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_url: Optional[pulumi.Input[_builtins.str]] = None,
                 select: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_close_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 warning: Optional[pulumi.Input[Union['InfraAlertConditionWarningArgs', 'InfraAlertConditionWarningArgsDict']]] = None,
                 where: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InfraAlertConditionArgs.__new__(InfraAlertConditionArgs)

            __props__.__dict__["comparison"] = comparison
            __props__.__dict__["critical"] = critical
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["event"] = event
            __props__.__dict__["integration_provider"] = integration_provider
            __props__.__dict__["name"] = name
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["process_where"] = process_where
            __props__.__dict__["runbook_url"] = runbook_url
            __props__.__dict__["select"] = select
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["violation_close_timer"] = violation_close_timer
            __props__.__dict__["warning"] = warning
            __props__.__dict__["where"] = where
            __props__.__dict__["created_at"] = None
            __props__.__dict__["entity_guid"] = None
            __props__.__dict__["updated_at"] = None
        super(InfraAlertCondition, __self__).__init__(
            'newrelic:index/infraAlertCondition:InfraAlertCondition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comparison: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.int]] = None,
            critical: Optional[pulumi.Input[Union['InfraAlertConditionCriticalArgs', 'InfraAlertConditionCriticalArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            entity_guid: Optional[pulumi.Input[_builtins.str]] = None,
            event: Optional[pulumi.Input[_builtins.str]] = None,
            integration_provider: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            process_where: Optional[pulumi.Input[_builtins.str]] = None,
            runbook_url: Optional[pulumi.Input[_builtins.str]] = None,
            select: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.int]] = None,
            violation_close_timer: Optional[pulumi.Input[_builtins.int]] = None,
            warning: Optional[pulumi.Input[Union['InfraAlertConditionWarningArgs', 'InfraAlertConditionWarningArgsDict']]] = None,
            where: Optional[pulumi.Input[_builtins.str]] = None) -> 'InfraAlertCondition':
        """
        Get an existing InfraAlertCondition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comparison: The operator used to evaluate the threshold value.  Valid values are `above`, `below`, and `equal`.  Supported by the `infra_metric` and `infra_process_running` condition types.
        :param pulumi.Input[_builtins.int] created_at: The timestamp the alert condition was created.
        :param pulumi.Input[Union['InfraAlertConditionCriticalArgs', 'InfraAlertConditionCriticalArgsDict']] critical: Identifies the threshold parameters for opening a critical alert incident. See Thresholds below for details.
        :param pulumi.Input[_builtins.str] description: The description of the Infrastructure alert condition.
        :param pulumi.Input[_builtins.bool] enabled: Whether the condition is turned on or off.  Valid values are `true` and `false`.  Defaults to `true`.
        :param pulumi.Input[_builtins.str] entity_guid: The unique entity identifier of the condition in New Relic.
        :param pulumi.Input[_builtins.str] event: The metric event; for example, `SystemSample` or `StorageSample`.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[_builtins.str] integration_provider: For alerts on integrations, use this instead of `event`.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[_builtins.str] name: The Infrastructure alert condition's name.
        :param pulumi.Input[_builtins.str] policy_id: The ID of the alert policy where this condition should be used.
        :param pulumi.Input[_builtins.str] process_where: Any filters applied to processes; for example: `commandName = 'java'`.  Required by the `infra_process_running` condition type.
        :param pulumi.Input[_builtins.str] runbook_url: Runbook URL to display in notifications.
        :param pulumi.Input[_builtins.str] select: The attribute name to identify the metric being targeted; for example, `cpuPercent`, `diskFreePercent`, or `memoryResidentSizeBytes`.  The underlying API will automatically populate this value for Infrastructure integrations (for example `diskFreePercent`), so make sure to explicitly include this value to avoid diff issues.  Supported by the `infra_metric` condition type.
        :param pulumi.Input[_builtins.str] type: The type of Infrastructure alert condition.  Valid values are  `infra_process_running`, `infra_metric`, and `infra_host_not_reporting`.
        :param pulumi.Input[_builtins.int] updated_at: The timestamp the alert condition was last updated.
        :param pulumi.Input[_builtins.int] violation_close_timer: Determines how much time will pass (in hours) before an incident is automatically closed. Valid values are `1 2 4 8 12 24 48 72`. Defaults to 24. If `0` is provided, default of `24` is used and will have configuration drift during the apply phase until a valid value is provided.
               
               ```
               Warning: This resource will use the account ID linked to your API key. At the moment it is not possible to dynamically set the account ID.
               ```
        :param pulumi.Input[Union['InfraAlertConditionWarningArgs', 'InfraAlertConditionWarningArgsDict']] warning: Identifies the threshold parameters for opening a warning alert incident. See Thresholds below for details.
        :param pulumi.Input[_builtins.str] where: If applicable, this identifies any Infrastructure host filters used; for example: `hostname LIKE '%cassandra%'`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InfraAlertConditionState.__new__(_InfraAlertConditionState)

        __props__.__dict__["comparison"] = comparison
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["critical"] = critical
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["entity_guid"] = entity_guid
        __props__.__dict__["event"] = event
        __props__.__dict__["integration_provider"] = integration_provider
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["process_where"] = process_where
        __props__.__dict__["runbook_url"] = runbook_url
        __props__.__dict__["select"] = select
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["violation_close_timer"] = violation_close_timer
        __props__.__dict__["warning"] = warning
        __props__.__dict__["where"] = where
        return InfraAlertCondition(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comparison(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The operator used to evaluate the threshold value.  Valid values are `above`, `below`, and `equal`.  Supported by the `infra_metric` and `infra_process_running` condition types.
        """
        return pulumi.get(self, "comparison")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.int]:
        """
        The timestamp the alert condition was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def critical(self) -> pulumi.Output[Optional['outputs.InfraAlertConditionCritical']]:
        """
        Identifies the threshold parameters for opening a critical alert incident. See Thresholds below for details.
        """
        return pulumi.get(self, "critical")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Infrastructure alert condition.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the condition is turned on or off.  Valid values are `true` and `false`.  Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="entityGuid")
    def entity_guid(self) -> pulumi.Output[_builtins.str]:
        """
        The unique entity identifier of the condition in New Relic.
        """
        return pulumi.get(self, "entity_guid")

    @_builtins.property
    @pulumi.getter
    def event(self) -> pulumi.Output[_builtins.str]:
        """
        The metric event; for example, `SystemSample` or `StorageSample`.  Supported by the `infra_metric` condition type.
        """
        return pulumi.get(self, "event")

    @_builtins.property
    @pulumi.getter(name="integrationProvider")
    def integration_provider(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        For alerts on integrations, use this instead of `event`.  Supported by the `infra_metric` condition type.
        """
        return pulumi.get(self, "integration_provider")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The Infrastructure alert condition's name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the alert policy where this condition should be used.
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter(name="processWhere")
    def process_where(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Any filters applied to processes; for example: `commandName = 'java'`.  Required by the `infra_process_running` condition type.
        """
        return pulumi.get(self, "process_where")

    @_builtins.property
    @pulumi.getter(name="runbookUrl")
    def runbook_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Runbook URL to display in notifications.
        """
        return pulumi.get(self, "runbook_url")

    @_builtins.property
    @pulumi.getter
    def select(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The attribute name to identify the metric being targeted; for example, `cpuPercent`, `diskFreePercent`, or `memoryResidentSizeBytes`.  The underlying API will automatically populate this value for Infrastructure integrations (for example `diskFreePercent`), so make sure to explicitly include this value to avoid diff issues.  Supported by the `infra_metric` condition type.
        """
        return pulumi.get(self, "select")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of Infrastructure alert condition.  Valid values are  `infra_process_running`, `infra_metric`, and `infra_host_not_reporting`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.int]:
        """
        The timestamp the alert condition was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="violationCloseTimer")
    def violation_close_timer(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Determines how much time will pass (in hours) before an incident is automatically closed. Valid values are `1 2 4 8 12 24 48 72`. Defaults to 24. If `0` is provided, default of `24` is used and will have configuration drift during the apply phase until a valid value is provided.

        ```
        Warning: This resource will use the account ID linked to your API key. At the moment it is not possible to dynamically set the account ID.
        ```
        """
        return pulumi.get(self, "violation_close_timer")

    @_builtins.property
    @pulumi.getter
    def warning(self) -> pulumi.Output[Optional['outputs.InfraAlertConditionWarning']]:
        """
        Identifies the threshold parameters for opening a warning alert incident. See Thresholds below for details.
        """
        return pulumi.get(self, "warning")

    @_builtins.property
    @pulumi.getter
    def where(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If applicable, this identifies any Infrastructure host filters used; for example: `hostname LIKE '%cassandra%'`.
        """
        return pulumi.get(self, "where")

