# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkloadArgs', 'Workload']

@pulumi.input_type
class WorkloadArgs:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_guids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 entity_search_queries: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadEntitySearchQueryArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status_config_automatic: Optional[pulumi.Input['WorkloadStatusConfigAutomaticArgs']] = None,
                 status_config_static: Optional[pulumi.Input['WorkloadStatusConfigStaticArgs']] = None):
        """
        The set of arguments for constructing a Workload resource.
        :param pulumi.Input[_builtins.str] account_id: The New Relic account ID where you want to create the workload.
        :param pulumi.Input[_builtins.str] description: Relevant information about the workload.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entity_guids: A list of entity GUIDs manually assigned to this workload. At least one of either `entity_guids` or `entity_search_query` is required.
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadEntitySearchQueryArgs']]] entity_search_queries: A list of search queries that define a dynamic workload. At least one of either `entity_guids` or `entity_search_query` is required. See Nested entity_search_query blocks below for details.
        :param pulumi.Input[_builtins.str] name: The workload's name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scope_account_ids: A list of account IDs that will be used to get entities from.
        :param pulumi.Input['WorkloadStatusConfigAutomaticArgs'] status_config_automatic: An input object used to represent an automatic status configuration.See Nested status_config_automatic blocks below for details.
        :param pulumi.Input['WorkloadStatusConfigStaticArgs'] status_config_static: A list of static status configurations. You can only configure one static status for a workload.See Nested status_config_static blocks below for details.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity_guids is not None:
            pulumi.set(__self__, "entity_guids", entity_guids)
        if entity_search_queries is not None:
            pulumi.set(__self__, "entity_search_queries", entity_search_queries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scope_account_ids is not None:
            pulumi.set(__self__, "scope_account_ids", scope_account_ids)
        if status_config_automatic is not None:
            pulumi.set(__self__, "status_config_automatic", status_config_automatic)
        if status_config_static is not None:
            pulumi.set(__self__, "status_config_static", status_config_static)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The New Relic account ID where you want to create the workload.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Relevant information about the workload.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="entityGuids")
    def entity_guids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of entity GUIDs manually assigned to this workload. At least one of either `entity_guids` or `entity_search_query` is required.
        """
        return pulumi.get(self, "entity_guids")

    @entity_guids.setter
    def entity_guids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "entity_guids", value)

    @_builtins.property
    @pulumi.getter(name="entitySearchQueries")
    def entity_search_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadEntitySearchQueryArgs']]]]:
        """
        A list of search queries that define a dynamic workload. At least one of either `entity_guids` or `entity_search_query` is required. See Nested entity_search_query blocks below for details.
        """
        return pulumi.get(self, "entity_search_queries")

    @entity_search_queries.setter
    def entity_search_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadEntitySearchQueryArgs']]]]):
        pulumi.set(self, "entity_search_queries", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workload's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="scopeAccountIds")
    def scope_account_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of account IDs that will be used to get entities from.
        """
        return pulumi.get(self, "scope_account_ids")

    @scope_account_ids.setter
    def scope_account_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scope_account_ids", value)

    @_builtins.property
    @pulumi.getter(name="statusConfigAutomatic")
    def status_config_automatic(self) -> Optional[pulumi.Input['WorkloadStatusConfigAutomaticArgs']]:
        """
        An input object used to represent an automatic status configuration.See Nested status_config_automatic blocks below for details.
        """
        return pulumi.get(self, "status_config_automatic")

    @status_config_automatic.setter
    def status_config_automatic(self, value: Optional[pulumi.Input['WorkloadStatusConfigAutomaticArgs']]):
        pulumi.set(self, "status_config_automatic", value)

    @_builtins.property
    @pulumi.getter(name="statusConfigStatic")
    def status_config_static(self) -> Optional[pulumi.Input['WorkloadStatusConfigStaticArgs']]:
        """
        A list of static status configurations. You can only configure one static status for a workload.See Nested status_config_static blocks below for details.
        """
        return pulumi.get(self, "status_config_static")

    @status_config_static.setter
    def status_config_static(self, value: Optional[pulumi.Input['WorkloadStatusConfigStaticArgs']]):
        pulumi.set(self, "status_config_static", value)


@pulumi.input_type
class _WorkloadState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 composite_entity_search_query: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_guids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 entity_search_queries: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadEntitySearchQueryArgs']]]] = None,
                 guid: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permalink: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status_config_automatic: Optional[pulumi.Input['WorkloadStatusConfigAutomaticArgs']] = None,
                 status_config_static: Optional[pulumi.Input['WorkloadStatusConfigStaticArgs']] = None,
                 workload_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Workload resources.
        :param pulumi.Input[_builtins.str] account_id: The New Relic account ID where you want to create the workload.
        :param pulumi.Input[_builtins.str] composite_entity_search_query: The composite query used to compose a dynamic workload.
        :param pulumi.Input[_builtins.str] description: Relevant information about the workload.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entity_guids: A list of entity GUIDs manually assigned to this workload. At least one of either `entity_guids` or `entity_search_query` is required.
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadEntitySearchQueryArgs']]] entity_search_queries: A list of search queries that define a dynamic workload. At least one of either `entity_guids` or `entity_search_query` is required. See Nested entity_search_query blocks below for details.
        :param pulumi.Input[_builtins.str] guid: The unique entity identifier of the workload in New Relic.
        :param pulumi.Input[_builtins.str] name: The workload's name.
        :param pulumi.Input[_builtins.str] permalink: The URL of the workload.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scope_account_ids: A list of account IDs that will be used to get entities from.
        :param pulumi.Input['WorkloadStatusConfigAutomaticArgs'] status_config_automatic: An input object used to represent an automatic status configuration.See Nested status_config_automatic blocks below for details.
        :param pulumi.Input['WorkloadStatusConfigStaticArgs'] status_config_static: A list of static status configurations. You can only configure one static status for a workload.See Nested status_config_static blocks below for details.
        :param pulumi.Input[_builtins.str] workload_id: The unique entity identifier of the workload.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if composite_entity_search_query is not None:
            pulumi.set(__self__, "composite_entity_search_query", composite_entity_search_query)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity_guids is not None:
            pulumi.set(__self__, "entity_guids", entity_guids)
        if entity_search_queries is not None:
            pulumi.set(__self__, "entity_search_queries", entity_search_queries)
        if guid is not None:
            pulumi.set(__self__, "guid", guid)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permalink is not None:
            pulumi.set(__self__, "permalink", permalink)
        if scope_account_ids is not None:
            pulumi.set(__self__, "scope_account_ids", scope_account_ids)
        if status_config_automatic is not None:
            pulumi.set(__self__, "status_config_automatic", status_config_automatic)
        if status_config_static is not None:
            pulumi.set(__self__, "status_config_static", status_config_static)
        if workload_id is not None:
            pulumi.set(__self__, "workload_id", workload_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The New Relic account ID where you want to create the workload.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="compositeEntitySearchQuery")
    def composite_entity_search_query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The composite query used to compose a dynamic workload.
        """
        return pulumi.get(self, "composite_entity_search_query")

    @composite_entity_search_query.setter
    def composite_entity_search_query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "composite_entity_search_query", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Relevant information about the workload.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="entityGuids")
    def entity_guids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of entity GUIDs manually assigned to this workload. At least one of either `entity_guids` or `entity_search_query` is required.
        """
        return pulumi.get(self, "entity_guids")

    @entity_guids.setter
    def entity_guids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "entity_guids", value)

    @_builtins.property
    @pulumi.getter(name="entitySearchQueries")
    def entity_search_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadEntitySearchQueryArgs']]]]:
        """
        A list of search queries that define a dynamic workload. At least one of either `entity_guids` or `entity_search_query` is required. See Nested entity_search_query blocks below for details.
        """
        return pulumi.get(self, "entity_search_queries")

    @entity_search_queries.setter
    def entity_search_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadEntitySearchQueryArgs']]]]):
        pulumi.set(self, "entity_search_queries", value)

    @_builtins.property
    @pulumi.getter
    def guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique entity identifier of the workload in New Relic.
        """
        return pulumi.get(self, "guid")

    @guid.setter
    def guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guid", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workload's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def permalink(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the workload.
        """
        return pulumi.get(self, "permalink")

    @permalink.setter
    def permalink(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permalink", value)

    @_builtins.property
    @pulumi.getter(name="scopeAccountIds")
    def scope_account_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of account IDs that will be used to get entities from.
        """
        return pulumi.get(self, "scope_account_ids")

    @scope_account_ids.setter
    def scope_account_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scope_account_ids", value)

    @_builtins.property
    @pulumi.getter(name="statusConfigAutomatic")
    def status_config_automatic(self) -> Optional[pulumi.Input['WorkloadStatusConfigAutomaticArgs']]:
        """
        An input object used to represent an automatic status configuration.See Nested status_config_automatic blocks below for details.
        """
        return pulumi.get(self, "status_config_automatic")

    @status_config_automatic.setter
    def status_config_automatic(self, value: Optional[pulumi.Input['WorkloadStatusConfigAutomaticArgs']]):
        pulumi.set(self, "status_config_automatic", value)

    @_builtins.property
    @pulumi.getter(name="statusConfigStatic")
    def status_config_static(self) -> Optional[pulumi.Input['WorkloadStatusConfigStaticArgs']]:
        """
        A list of static status configurations. You can only configure one static status for a workload.See Nested status_config_static blocks below for details.
        """
        return pulumi.get(self, "status_config_static")

    @status_config_static.setter
    def status_config_static(self, value: Optional[pulumi.Input['WorkloadStatusConfigStaticArgs']]):
        pulumi.set(self, "status_config_static", value)

    @_builtins.property
    @pulumi.getter(name="workloadId")
    def workload_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique entity identifier of the workload.
        """
        return pulumi.get(self, "workload_id")

    @workload_id.setter
    def workload_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workload_id", value)


@pulumi.type_token("newrelic:plugins/workload:Workload")
class Workload(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_guids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 entity_search_queries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadEntitySearchQueryArgs', 'WorkloadEntitySearchQueryArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status_config_automatic: Optional[pulumi.Input[Union['WorkloadStatusConfigAutomaticArgs', 'WorkloadStatusConfigAutomaticArgsDict']]] = None,
                 status_config_static: Optional[pulumi.Input[Union['WorkloadStatusConfigStaticArgs', 'WorkloadStatusConfigStaticArgsDict']]] = None,
                 __props__=None):
        """
        Use this resource to create, update, and delete a New Relic One workload.

        A New Relic User API key is required to provision this resource.  Set the `api_key`
        attribute in the `provider` block or the `NEW_RELIC_API_KEY` environment
        variable with your User API key.

        ## Example Usage

        Include entities with a certain string on the name.
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.plugins.Workload("foo",
            name="Example workload",
            account_id="12345678",
            entity_guids=["MjUyMDUyOHxBUE18QVBQTElDQVRJT058MjE1MDM3Nzk1"],
            entity_search_queries=[{
                "query": "name like '%Example application%'",
            }],
            scope_account_ids=["12345678"])
        ```

        Include entities with a set of tags.
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.plugins.Workload("foo",
            name="Example workload with tags",
            account_id="12345678",
            entity_guids=["MjUyMDUyOHxBUE18QVBQTElDQVRJT058MjE1MDM3Nzk1"],
            entity_search_queries=[{
                "query": "tags.accountId = '12345678' AND tags.environment='production' AND tags.language='java'",
            }],
            scope_account_ids=["12345678"])
        ```

        Include entities with a set of tags.
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.plugins.Workload("foo",
            name="Example workload with tags",
            account_id="12345678",
            entity_guids=["MjUyMDUyOHxBUE18QVBQTElDQVRJT058MjE1MDM3Nzk1"],
            entity_search_queries=[{
                "query": "tags.accountId = '12345678' AND tags.environment='production' AND tags.language='java'",
            }],
            scope_account_ids=["12345678"])
        ```

        Include automatic status

        > The global status of your workload is a quick indicator of the workload health. You can configure it to be calculated automatically, and you can also set an alert and get a notification whenever the workload stops being operational. Alternatively, you can communicate a certain status of the workload by setting up a static value and a description. [See our docs](https://docs.newrelic.com/docs/workloads/use-workloads/workloads/workload-status)

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.plugins.Workload("foo",
            name="Example workload",
            account_id="12345678",
            entity_guids=["MjUyMDUyOHxBUE18QVBQTElDQVRJT058MjE1MDM3Nzk1"],
            entity_search_queries=[{
                "query": "name like '%Example application%'",
            }],
            scope_account_ids=["12345678"],
            description="Description",
            status_config_automatic={
                "enabled": True,
                "remaining_entities_rule": {
                    "remaining_entities_rule_rollup": {
                        "strategy": "BEST_STATUS_WINS",
                        "threshold_type": "FIXED",
                        "threshold_value": 100,
                        "group_by": "ENTITY_TYPE",
                    },
                },
                "rules": [{
                    "entity_guids": ["MjUyMDUyOHxBUE18QVBQTElDQVRJT058MjE1MDM3Nzk1"],
                    "nrql_queries": [{
                        "query": "name like '%Example application2%'",
                    }],
                    "rollup": {
                        "strategy": "BEST_STATUS_WINS",
                        "threshold_type": "FIXED",
                        "threshold_value": 100,
                    },
                }],
            })
        ```

        Include static status

        > You can use this during maintenance tasks or any other time you want to provide a fixed status for your workload. This overrides all automatic rules. [See our docs](https://docs.newrelic.com/docs/workloads/use-workloads/workloads/workload-status#configure-static)

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.plugins.Workload("foo",
            name="Example workload",
            account_id="12345678",
            entity_guids=["MjUyMDUyOHxBUE18QVBQTElDQVRJT058MjE1MDM3Nzk1"],
            entity_search_queries=[{
                "query": "name like '%Example application%'",
            }],
            scope_account_ids=["12345678"],
            description="Description",
            status_config_static={
                "description": "test",
                "enabled": True,
                "status": "OPERATIONAL",
                "summary": "summary of the status",
            })
        ```

        ## Import

        New Relic workloads can be imported using a concatenated string of the format

         `<account_id>:<workload_id>:<guid>`, e.g.

        bash

        ```sh
        $ pulumi import newrelic:plugins/workload:Workload foo 12345678:1456:MjUyMDUyOHxBUE18QVBRTElDQVRJT058MjE1MDM3Nzk1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The New Relic account ID where you want to create the workload.
        :param pulumi.Input[_builtins.str] description: Relevant information about the workload.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entity_guids: A list of entity GUIDs manually assigned to this workload. At least one of either `entity_guids` or `entity_search_query` is required.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkloadEntitySearchQueryArgs', 'WorkloadEntitySearchQueryArgsDict']]]] entity_search_queries: A list of search queries that define a dynamic workload. At least one of either `entity_guids` or `entity_search_query` is required. See Nested entity_search_query blocks below for details.
        :param pulumi.Input[_builtins.str] name: The workload's name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scope_account_ids: A list of account IDs that will be used to get entities from.
        :param pulumi.Input[Union['WorkloadStatusConfigAutomaticArgs', 'WorkloadStatusConfigAutomaticArgsDict']] status_config_automatic: An input object used to represent an automatic status configuration.See Nested status_config_automatic blocks below for details.
        :param pulumi.Input[Union['WorkloadStatusConfigStaticArgs', 'WorkloadStatusConfigStaticArgsDict']] status_config_static: A list of static status configurations. You can only configure one static status for a workload.See Nested status_config_static blocks below for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[WorkloadArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to create, update, and delete a New Relic One workload.

        A New Relic User API key is required to provision this resource.  Set the `api_key`
        attribute in the `provider` block or the `NEW_RELIC_API_KEY` environment
        variable with your User API key.

        ## Example Usage

        Include entities with a certain string on the name.
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.plugins.Workload("foo",
            name="Example workload",
            account_id="12345678",
            entity_guids=["MjUyMDUyOHxBUE18QVBQTElDQVRJT058MjE1MDM3Nzk1"],
            entity_search_queries=[{
                "query": "name like '%Example application%'",
            }],
            scope_account_ids=["12345678"])
        ```

        Include entities with a set of tags.
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.plugins.Workload("foo",
            name="Example workload with tags",
            account_id="12345678",
            entity_guids=["MjUyMDUyOHxBUE18QVBQTElDQVRJT058MjE1MDM3Nzk1"],
            entity_search_queries=[{
                "query": "tags.accountId = '12345678' AND tags.environment='production' AND tags.language='java'",
            }],
            scope_account_ids=["12345678"])
        ```

        Include entities with a set of tags.
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.plugins.Workload("foo",
            name="Example workload with tags",
            account_id="12345678",
            entity_guids=["MjUyMDUyOHxBUE18QVBQTElDQVRJT058MjE1MDM3Nzk1"],
            entity_search_queries=[{
                "query": "tags.accountId = '12345678' AND tags.environment='production' AND tags.language='java'",
            }],
            scope_account_ids=["12345678"])
        ```

        Include automatic status

        > The global status of your workload is a quick indicator of the workload health. You can configure it to be calculated automatically, and you can also set an alert and get a notification whenever the workload stops being operational. Alternatively, you can communicate a certain status of the workload by setting up a static value and a description. [See our docs](https://docs.newrelic.com/docs/workloads/use-workloads/workloads/workload-status)

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.plugins.Workload("foo",
            name="Example workload",
            account_id="12345678",
            entity_guids=["MjUyMDUyOHxBUE18QVBQTElDQVRJT058MjE1MDM3Nzk1"],
            entity_search_queries=[{
                "query": "name like '%Example application%'",
            }],
            scope_account_ids=["12345678"],
            description="Description",
            status_config_automatic={
                "enabled": True,
                "remaining_entities_rule": {
                    "remaining_entities_rule_rollup": {
                        "strategy": "BEST_STATUS_WINS",
                        "threshold_type": "FIXED",
                        "threshold_value": 100,
                        "group_by": "ENTITY_TYPE",
                    },
                },
                "rules": [{
                    "entity_guids": ["MjUyMDUyOHxBUE18QVBQTElDQVRJT058MjE1MDM3Nzk1"],
                    "nrql_queries": [{
                        "query": "name like '%Example application2%'",
                    }],
                    "rollup": {
                        "strategy": "BEST_STATUS_WINS",
                        "threshold_type": "FIXED",
                        "threshold_value": 100,
                    },
                }],
            })
        ```

        Include static status

        > You can use this during maintenance tasks or any other time you want to provide a fixed status for your workload. This overrides all automatic rules. [See our docs](https://docs.newrelic.com/docs/workloads/use-workloads/workloads/workload-status#configure-static)

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.plugins.Workload("foo",
            name="Example workload",
            account_id="12345678",
            entity_guids=["MjUyMDUyOHxBUE18QVBQTElDQVRJT058MjE1MDM3Nzk1"],
            entity_search_queries=[{
                "query": "name like '%Example application%'",
            }],
            scope_account_ids=["12345678"],
            description="Description",
            status_config_static={
                "description": "test",
                "enabled": True,
                "status": "OPERATIONAL",
                "summary": "summary of the status",
            })
        ```

        ## Import

        New Relic workloads can be imported using a concatenated string of the format

         `<account_id>:<workload_id>:<guid>`, e.g.

        bash

        ```sh
        $ pulumi import newrelic:plugins/workload:Workload foo 12345678:1456:MjUyMDUyOHxBUE18QVBRTElDQVRJT058MjE1MDM3Nzk1
        ```

        :param str resource_name: The name of the resource.
        :param WorkloadArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkloadArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_guids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 entity_search_queries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadEntitySearchQueryArgs', 'WorkloadEntitySearchQueryArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status_config_automatic: Optional[pulumi.Input[Union['WorkloadStatusConfigAutomaticArgs', 'WorkloadStatusConfigAutomaticArgsDict']]] = None,
                 status_config_static: Optional[pulumi.Input[Union['WorkloadStatusConfigStaticArgs', 'WorkloadStatusConfigStaticArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkloadArgs.__new__(WorkloadArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["description"] = description
            __props__.__dict__["entity_guids"] = entity_guids
            __props__.__dict__["entity_search_queries"] = entity_search_queries
            __props__.__dict__["name"] = name
            __props__.__dict__["scope_account_ids"] = scope_account_ids
            __props__.__dict__["status_config_automatic"] = status_config_automatic
            __props__.__dict__["status_config_static"] = status_config_static
            __props__.__dict__["composite_entity_search_query"] = None
            __props__.__dict__["guid"] = None
            __props__.__dict__["permalink"] = None
            __props__.__dict__["workload_id"] = None
        super(Workload, __self__).__init__(
            'newrelic:plugins/workload:Workload',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            composite_entity_search_query: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            entity_guids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            entity_search_queries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadEntitySearchQueryArgs', 'WorkloadEntitySearchQueryArgsDict']]]]] = None,
            guid: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            permalink: Optional[pulumi.Input[_builtins.str]] = None,
            scope_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status_config_automatic: Optional[pulumi.Input[Union['WorkloadStatusConfigAutomaticArgs', 'WorkloadStatusConfigAutomaticArgsDict']]] = None,
            status_config_static: Optional[pulumi.Input[Union['WorkloadStatusConfigStaticArgs', 'WorkloadStatusConfigStaticArgsDict']]] = None,
            workload_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Workload':
        """
        Get an existing Workload resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The New Relic account ID where you want to create the workload.
        :param pulumi.Input[_builtins.str] composite_entity_search_query: The composite query used to compose a dynamic workload.
        :param pulumi.Input[_builtins.str] description: Relevant information about the workload.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entity_guids: A list of entity GUIDs manually assigned to this workload. At least one of either `entity_guids` or `entity_search_query` is required.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkloadEntitySearchQueryArgs', 'WorkloadEntitySearchQueryArgsDict']]]] entity_search_queries: A list of search queries that define a dynamic workload. At least one of either `entity_guids` or `entity_search_query` is required. See Nested entity_search_query blocks below for details.
        :param pulumi.Input[_builtins.str] guid: The unique entity identifier of the workload in New Relic.
        :param pulumi.Input[_builtins.str] name: The workload's name.
        :param pulumi.Input[_builtins.str] permalink: The URL of the workload.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scope_account_ids: A list of account IDs that will be used to get entities from.
        :param pulumi.Input[Union['WorkloadStatusConfigAutomaticArgs', 'WorkloadStatusConfigAutomaticArgsDict']] status_config_automatic: An input object used to represent an automatic status configuration.See Nested status_config_automatic blocks below for details.
        :param pulumi.Input[Union['WorkloadStatusConfigStaticArgs', 'WorkloadStatusConfigStaticArgsDict']] status_config_static: A list of static status configurations. You can only configure one static status for a workload.See Nested status_config_static blocks below for details.
        :param pulumi.Input[_builtins.str] workload_id: The unique entity identifier of the workload.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkloadState.__new__(_WorkloadState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["composite_entity_search_query"] = composite_entity_search_query
        __props__.__dict__["description"] = description
        __props__.__dict__["entity_guids"] = entity_guids
        __props__.__dict__["entity_search_queries"] = entity_search_queries
        __props__.__dict__["guid"] = guid
        __props__.__dict__["name"] = name
        __props__.__dict__["permalink"] = permalink
        __props__.__dict__["scope_account_ids"] = scope_account_ids
        __props__.__dict__["status_config_automatic"] = status_config_automatic
        __props__.__dict__["status_config_static"] = status_config_static
        __props__.__dict__["workload_id"] = workload_id
        return Workload(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The New Relic account ID where you want to create the workload.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="compositeEntitySearchQuery")
    def composite_entity_search_query(self) -> pulumi.Output[_builtins.str]:
        """
        The composite query used to compose a dynamic workload.
        """
        return pulumi.get(self, "composite_entity_search_query")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Relevant information about the workload.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="entityGuids")
    def entity_guids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of entity GUIDs manually assigned to this workload. At least one of either `entity_guids` or `entity_search_query` is required.
        """
        return pulumi.get(self, "entity_guids")

    @_builtins.property
    @pulumi.getter(name="entitySearchQueries")
    def entity_search_queries(self) -> pulumi.Output[Optional[Sequence['outputs.WorkloadEntitySearchQuery']]]:
        """
        A list of search queries that define a dynamic workload. At least one of either `entity_guids` or `entity_search_query` is required. See Nested entity_search_query blocks below for details.
        """
        return pulumi.get(self, "entity_search_queries")

    @_builtins.property
    @pulumi.getter
    def guid(self) -> pulumi.Output[_builtins.str]:
        """
        The unique entity identifier of the workload in New Relic.
        """
        return pulumi.get(self, "guid")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The workload's name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permalink(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the workload.
        """
        return pulumi.get(self, "permalink")

    @_builtins.property
    @pulumi.getter(name="scopeAccountIds")
    def scope_account_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of account IDs that will be used to get entities from.
        """
        return pulumi.get(self, "scope_account_ids")

    @_builtins.property
    @pulumi.getter(name="statusConfigAutomatic")
    def status_config_automatic(self) -> pulumi.Output[Optional['outputs.WorkloadStatusConfigAutomatic']]:
        """
        An input object used to represent an automatic status configuration.See Nested status_config_automatic blocks below for details.
        """
        return pulumi.get(self, "status_config_automatic")

    @_builtins.property
    @pulumi.getter(name="statusConfigStatic")
    def status_config_static(self) -> pulumi.Output[Optional['outputs.WorkloadStatusConfigStatic']]:
        """
        A list of static status configurations. You can only configure one static status for a workload.See Nested status_config_static blocks below for details.
        """
        return pulumi.get(self, "status_config_static")

    @_builtins.property
    @pulumi.getter(name="workloadId")
    def workload_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique entity identifier of the workload.
        """
        return pulumi.get(self, "workload_id")

