# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StepMonitorArgs', 'StepMonitor']

@pulumi.input_type
class StepMonitorArgs:
    def __init__(__self__, *,
                 period: pulumi.Input[_builtins.str],
                 status: pulumi.Input[_builtins.str],
                 steps: pulumi.Input[Sequence[pulumi.Input['StepMonitorStepArgs']]],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 browsers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_screenshot_on_failure_and_script: Optional[pulumi.Input[_builtins.bool]] = None,
                 location_privates: Optional[pulumi.Input[Sequence[pulumi.Input['StepMonitorLocationPrivateArgs']]]] = None,
                 locations_publics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_type: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_type_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['StepMonitorTagArgs']]]] = None,
                 use_unsupported_legacy_runtime: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a StepMonitor resource.
        :param pulumi.Input[_builtins.str] period: The interval at which this monitor should run. Valid values are `EVERY_MINUTE`, `EVERY_5_MINUTES`, `EVERY_10_MINUTES`, `EVERY_15_MINUTES`, `EVERY_30_MINUTES`, `EVERY_HOUR`, `EVERY_6_HOURS`, `EVERY_12_HOURS`, or `EVERY_DAY`.
        :param pulumi.Input[_builtins.str] status: The run state of the monitor. (`ENABLED` or `DISABLED`).
        :param pulumi.Input[Sequence[pulumi.Input['StepMonitorStepArgs']]] steps: The steps that make up the script the monitor will run. See Nested steps blocks below for details.
        :param pulumi.Input[_builtins.str] account_id: The account in which the Synthetics monitor will be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] browsers: The multiple browsers list on which synthetic monitors will run. Valid values are `CHROME` and `FIREFOX`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] devices: The multiple devices list on which synthetic monitors will run. Valid values are `DESKTOP`, `MOBILE_LANDSCAPE`, `MOBILE_PORTRAIT`, `TABLET_LANDSCAPE` and `TABLET_PORTRAIT`.
        :param pulumi.Input[_builtins.bool] enable_screenshot_on_failure_and_script: Capture a screenshot during job execution.
        :param pulumi.Input[Sequence[pulumi.Input['StepMonitorLocationPrivateArgs']]] location_privates: The location the monitor will run from. At least one of `locations_public` or `location_private` is required. See Nested locations_private blocks below for details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations_publics: The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. You don't need the `AWS_` prefix as the provider uses NerdGraph. At least one of either `locations_public` or `location_private` is required.
        :param pulumi.Input[_builtins.str] name: The name for the monitor.
        :param pulumi.Input[_builtins.str] runtime_type: The runtime that the monitor will use to run jobs (`CHROME_BROWSER`).
        :param pulumi.Input[_builtins.str] runtime_type_version: The specific semver version of the runtime type.
        :param pulumi.Input[Sequence[pulumi.Input['StepMonitorTagArgs']]] tags: The tags that will be associated with the monitor. See Nested tag blocks below for details.
        """
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "steps", steps)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if browsers is not None:
            pulumi.set(__self__, "browsers", browsers)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if enable_screenshot_on_failure_and_script is not None:
            pulumi.set(__self__, "enable_screenshot_on_failure_and_script", enable_screenshot_on_failure_and_script)
        if location_privates is not None:
            pulumi.set(__self__, "location_privates", location_privates)
        if locations_publics is not None:
            pulumi.set(__self__, "locations_publics", locations_publics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if runtime_type is not None:
            pulumi.set(__self__, "runtime_type", runtime_type)
        if runtime_type_version is not None:
            pulumi.set(__self__, "runtime_type_version", runtime_type_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_unsupported_legacy_runtime is not None:
            pulumi.set(__self__, "use_unsupported_legacy_runtime", use_unsupported_legacy_runtime)

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Input[_builtins.str]:
        """
        The interval at which this monitor should run. Valid values are `EVERY_MINUTE`, `EVERY_5_MINUTES`, `EVERY_10_MINUTES`, `EVERY_15_MINUTES`, `EVERY_30_MINUTES`, `EVERY_HOUR`, `EVERY_6_HOURS`, `EVERY_12_HOURS`, or `EVERY_DAY`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.str]:
        """
        The run state of the monitor. (`ENABLED` or `DISABLED`).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def steps(self) -> pulumi.Input[Sequence[pulumi.Input['StepMonitorStepArgs']]]:
        """
        The steps that make up the script the monitor will run. See Nested steps blocks below for details.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: pulumi.Input[Sequence[pulumi.Input['StepMonitorStepArgs']]]):
        pulumi.set(self, "steps", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account in which the Synthetics monitor will be created.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def browsers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The multiple browsers list on which synthetic monitors will run. Valid values are `CHROME` and `FIREFOX`.
        """
        return pulumi.get(self, "browsers")

    @browsers.setter
    def browsers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "browsers", value)

    @_builtins.property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The multiple devices list on which synthetic monitors will run. Valid values are `DESKTOP`, `MOBILE_LANDSCAPE`, `MOBILE_PORTRAIT`, `TABLET_LANDSCAPE` and `TABLET_PORTRAIT`.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "devices", value)

    @_builtins.property
    @pulumi.getter(name="enableScreenshotOnFailureAndScript")
    def enable_screenshot_on_failure_and_script(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Capture a screenshot during job execution.
        """
        return pulumi.get(self, "enable_screenshot_on_failure_and_script")

    @enable_screenshot_on_failure_and_script.setter
    def enable_screenshot_on_failure_and_script(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_screenshot_on_failure_and_script", value)

    @_builtins.property
    @pulumi.getter(name="locationPrivates")
    def location_privates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StepMonitorLocationPrivateArgs']]]]:
        """
        The location the monitor will run from. At least one of `locations_public` or `location_private` is required. See Nested locations_private blocks below for details.
        """
        return pulumi.get(self, "location_privates")

    @location_privates.setter
    def location_privates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StepMonitorLocationPrivateArgs']]]]):
        pulumi.set(self, "location_privates", value)

    @_builtins.property
    @pulumi.getter(name="locationsPublics")
    def locations_publics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. You don't need the `AWS_` prefix as the provider uses NerdGraph. At least one of either `locations_public` or `location_private` is required.
        """
        return pulumi.get(self, "locations_publics")

    @locations_publics.setter
    def locations_publics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "locations_publics", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the monitor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The runtime that the monitor will use to run jobs (`CHROME_BROWSER`).
        """
        return pulumi.get(self, "runtime_type")

    @runtime_type.setter
    def runtime_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_type", value)

    @_builtins.property
    @pulumi.getter(name="runtimeTypeVersion")
    def runtime_type_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specific semver version of the runtime type.
        """
        return pulumi.get(self, "runtime_type_version")

    @runtime_type_version.setter
    def runtime_type_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_type_version", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StepMonitorTagArgs']]]]:
        """
        The tags that will be associated with the monitor. See Nested tag blocks below for details.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StepMonitorTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="useUnsupportedLegacyRuntime")
    def use_unsupported_legacy_runtime(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "use_unsupported_legacy_runtime")

    @use_unsupported_legacy_runtime.setter
    def use_unsupported_legacy_runtime(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_unsupported_legacy_runtime", value)


@pulumi.input_type
class _StepMonitorState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 browsers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_screenshot_on_failure_and_script: Optional[pulumi.Input[_builtins.bool]] = None,
                 guid: Optional[pulumi.Input[_builtins.str]] = None,
                 location_privates: Optional[pulumi.Input[Sequence[pulumi.Input['StepMonitorLocationPrivateArgs']]]] = None,
                 locations_publics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 period_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 runtime_type: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_type_version: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input['StepMonitorStepArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['StepMonitorTagArgs']]]] = None,
                 use_unsupported_legacy_runtime: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering StepMonitor resources.
        :param pulumi.Input[_builtins.str] account_id: The account in which the Synthetics monitor will be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] browsers: The multiple browsers list on which synthetic monitors will run. Valid values are `CHROME` and `FIREFOX`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] devices: The multiple devices list on which synthetic monitors will run. Valid values are `DESKTOP`, `MOBILE_LANDSCAPE`, `MOBILE_PORTRAIT`, `TABLET_LANDSCAPE` and `TABLET_PORTRAIT`.
        :param pulumi.Input[_builtins.bool] enable_screenshot_on_failure_and_script: Capture a screenshot during job execution.
        :param pulumi.Input[_builtins.str] guid: The unique entity identifier of the monitor in New Relic.
        :param pulumi.Input[Sequence[pulumi.Input['StepMonitorLocationPrivateArgs']]] location_privates: The location the monitor will run from. At least one of `locations_public` or `location_private` is required. See Nested locations_private blocks below for details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations_publics: The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. You don't need the `AWS_` prefix as the provider uses NerdGraph. At least one of either `locations_public` or `location_private` is required.
        :param pulumi.Input[_builtins.str] monitor_id: The monitor id of the synthetics step monitor (not to be confused with the GUID of the monitor).
        :param pulumi.Input[_builtins.str] name: The name for the monitor.
        :param pulumi.Input[_builtins.str] period: The interval at which this monitor should run. Valid values are `EVERY_MINUTE`, `EVERY_5_MINUTES`, `EVERY_10_MINUTES`, `EVERY_15_MINUTES`, `EVERY_30_MINUTES`, `EVERY_HOUR`, `EVERY_6_HOURS`, `EVERY_12_HOURS`, or `EVERY_DAY`.
        :param pulumi.Input[_builtins.int] period_in_minutes: The interval in minutes at which Synthetic monitor should run.
        :param pulumi.Input[_builtins.str] runtime_type: The runtime that the monitor will use to run jobs (`CHROME_BROWSER`).
        :param pulumi.Input[_builtins.str] runtime_type_version: The specific semver version of the runtime type.
        :param pulumi.Input[_builtins.str] status: The run state of the monitor. (`ENABLED` or `DISABLED`).
        :param pulumi.Input[Sequence[pulumi.Input['StepMonitorStepArgs']]] steps: The steps that make up the script the monitor will run. See Nested steps blocks below for details.
        :param pulumi.Input[Sequence[pulumi.Input['StepMonitorTagArgs']]] tags: The tags that will be associated with the monitor. See Nested tag blocks below for details.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if browsers is not None:
            pulumi.set(__self__, "browsers", browsers)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if enable_screenshot_on_failure_and_script is not None:
            pulumi.set(__self__, "enable_screenshot_on_failure_and_script", enable_screenshot_on_failure_and_script)
        if guid is not None:
            pulumi.set(__self__, "guid", guid)
        if location_privates is not None:
            pulumi.set(__self__, "location_privates", location_privates)
        if locations_publics is not None:
            pulumi.set(__self__, "locations_publics", locations_publics)
        if monitor_id is not None:
            pulumi.set(__self__, "monitor_id", monitor_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_in_minutes is not None:
            pulumi.set(__self__, "period_in_minutes", period_in_minutes)
        if runtime_type is not None:
            pulumi.set(__self__, "runtime_type", runtime_type)
        if runtime_type_version is not None:
            pulumi.set(__self__, "runtime_type_version", runtime_type_version)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_unsupported_legacy_runtime is not None:
            pulumi.set(__self__, "use_unsupported_legacy_runtime", use_unsupported_legacy_runtime)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account in which the Synthetics monitor will be created.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def browsers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The multiple browsers list on which synthetic monitors will run. Valid values are `CHROME` and `FIREFOX`.
        """
        return pulumi.get(self, "browsers")

    @browsers.setter
    def browsers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "browsers", value)

    @_builtins.property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The multiple devices list on which synthetic monitors will run. Valid values are `DESKTOP`, `MOBILE_LANDSCAPE`, `MOBILE_PORTRAIT`, `TABLET_LANDSCAPE` and `TABLET_PORTRAIT`.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "devices", value)

    @_builtins.property
    @pulumi.getter(name="enableScreenshotOnFailureAndScript")
    def enable_screenshot_on_failure_and_script(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Capture a screenshot during job execution.
        """
        return pulumi.get(self, "enable_screenshot_on_failure_and_script")

    @enable_screenshot_on_failure_and_script.setter
    def enable_screenshot_on_failure_and_script(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_screenshot_on_failure_and_script", value)

    @_builtins.property
    @pulumi.getter
    def guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique entity identifier of the monitor in New Relic.
        """
        return pulumi.get(self, "guid")

    @guid.setter
    def guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guid", value)

    @_builtins.property
    @pulumi.getter(name="locationPrivates")
    def location_privates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StepMonitorLocationPrivateArgs']]]]:
        """
        The location the monitor will run from. At least one of `locations_public` or `location_private` is required. See Nested locations_private blocks below for details.
        """
        return pulumi.get(self, "location_privates")

    @location_privates.setter
    def location_privates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StepMonitorLocationPrivateArgs']]]]):
        pulumi.set(self, "location_privates", value)

    @_builtins.property
    @pulumi.getter(name="locationsPublics")
    def locations_publics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. You don't need the `AWS_` prefix as the provider uses NerdGraph. At least one of either `locations_public` or `location_private` is required.
        """
        return pulumi.get(self, "locations_publics")

    @locations_publics.setter
    def locations_publics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "locations_publics", value)

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The monitor id of the synthetics step monitor (not to be confused with the GUID of the monitor).
        """
        return pulumi.get(self, "monitor_id")

    @monitor_id.setter
    def monitor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the monitor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The interval at which this monitor should run. Valid values are `EVERY_MINUTE`, `EVERY_5_MINUTES`, `EVERY_10_MINUTES`, `EVERY_15_MINUTES`, `EVERY_30_MINUTES`, `EVERY_HOUR`, `EVERY_6_HOURS`, `EVERY_12_HOURS`, or `EVERY_DAY`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodInMinutes")
    def period_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The interval in minutes at which Synthetic monitor should run.
        """
        return pulumi.get(self, "period_in_minutes")

    @period_in_minutes.setter
    def period_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The runtime that the monitor will use to run jobs (`CHROME_BROWSER`).
        """
        return pulumi.get(self, "runtime_type")

    @runtime_type.setter
    def runtime_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_type", value)

    @_builtins.property
    @pulumi.getter(name="runtimeTypeVersion")
    def runtime_type_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specific semver version of the runtime type.
        """
        return pulumi.get(self, "runtime_type_version")

    @runtime_type_version.setter
    def runtime_type_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_type_version", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The run state of the monitor. (`ENABLED` or `DISABLED`).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StepMonitorStepArgs']]]]:
        """
        The steps that make up the script the monitor will run. See Nested steps blocks below for details.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StepMonitorStepArgs']]]]):
        pulumi.set(self, "steps", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StepMonitorTagArgs']]]]:
        """
        The tags that will be associated with the monitor. See Nested tag blocks below for details.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StepMonitorTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="useUnsupportedLegacyRuntime")
    def use_unsupported_legacy_runtime(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "use_unsupported_legacy_runtime")

    @use_unsupported_legacy_runtime.setter
    def use_unsupported_legacy_runtime(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_unsupported_legacy_runtime", value)


@pulumi.type_token("newrelic:synthetics/stepMonitor:StepMonitor")
class StepMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 browsers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_screenshot_on_failure_and_script: Optional[pulumi.Input[_builtins.bool]] = None,
                 location_privates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StepMonitorLocationPrivateArgs', 'StepMonitorLocationPrivateArgsDict']]]]] = None,
                 locations_publics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_type: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_type_version: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StepMonitorStepArgs', 'StepMonitorStepArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StepMonitorTagArgs', 'StepMonitorTagArgsDict']]]]] = None,
                 use_unsupported_legacy_runtime: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.synthetics.StepMonitor("foo",
            name="Sample Step Monitor",
            enable_screenshot_on_failure_and_script=True,
            locations_publics=[
                "US_EAST_1",
                "US_EAST_2",
            ],
            period="EVERY_6_HOURS",
            status="ENABLED",
            runtime_type="CHROME_BROWSER",
            runtime_type_version="100",
            devices=[
                "DESKTOP",
                "MOBILE_PORTRAIT",
                "TABLET_LANDSCAPE",
            ],
            browsers=["CHROME"],
            steps=[{
                "ordinal": 0,
                "type": "NAVIGATE",
                "values": ["https://www.newrelic.com"],
            }],
            tags=[{
                "key": "some_key",
                "values": ["some_value"],
            }])
        ```
        See additional examples.

        ## Additional Examples

        ### Create a monitor with a private location

        The below example shows how you can define a private location and attach it to a monitor.

        > **NOTE:** It can take up to 10 minutes for a private location to become available.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.synthetics.PrivateLocation("foo",
            name="Sample Private Location",
            description="Sample Private Location Description",
            verified_script_execution=True)
        foo_step_monitor = newrelic.synthetics.StepMonitor("foo",
            name="Sample Step Monitor",
            period="EVERY_6_HOURS",
            status="ENABLED",
            runtime_type="CHROME_BROWSER",
            runtime_type_version="100",
            devices=[
                "DESKTOP",
                "MOBILE_PORTRAIT",
                "TABLET_LANDSCAPE",
            ],
            browsers=["CHROME"],
            location_privates=[{
                "guid": foo.id,
                "vse_password": "secret",
            }],
            steps=[{
                "ordinal": 0,
                "type": "NAVIGATE",
                "values": ["https://google.com"],
            }],
            tags=[{
                "key": "some_key",
                "values": ["some_value"],
            }])
        ```

        ## Import

        A step monitor can be imported using its GUID, using the following command.

        bash

        ```sh
        $ pulumi import newrelic:synthetics/stepMonitor:StepMonitor monitor <guid>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The account in which the Synthetics monitor will be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] browsers: The multiple browsers list on which synthetic monitors will run. Valid values are `CHROME` and `FIREFOX`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] devices: The multiple devices list on which synthetic monitors will run. Valid values are `DESKTOP`, `MOBILE_LANDSCAPE`, `MOBILE_PORTRAIT`, `TABLET_LANDSCAPE` and `TABLET_PORTRAIT`.
        :param pulumi.Input[_builtins.bool] enable_screenshot_on_failure_and_script: Capture a screenshot during job execution.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StepMonitorLocationPrivateArgs', 'StepMonitorLocationPrivateArgsDict']]]] location_privates: The location the monitor will run from. At least one of `locations_public` or `location_private` is required. See Nested locations_private blocks below for details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations_publics: The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. You don't need the `AWS_` prefix as the provider uses NerdGraph. At least one of either `locations_public` or `location_private` is required.
        :param pulumi.Input[_builtins.str] name: The name for the monitor.
        :param pulumi.Input[_builtins.str] period: The interval at which this monitor should run. Valid values are `EVERY_MINUTE`, `EVERY_5_MINUTES`, `EVERY_10_MINUTES`, `EVERY_15_MINUTES`, `EVERY_30_MINUTES`, `EVERY_HOUR`, `EVERY_6_HOURS`, `EVERY_12_HOURS`, or `EVERY_DAY`.
        :param pulumi.Input[_builtins.str] runtime_type: The runtime that the monitor will use to run jobs (`CHROME_BROWSER`).
        :param pulumi.Input[_builtins.str] runtime_type_version: The specific semver version of the runtime type.
        :param pulumi.Input[_builtins.str] status: The run state of the monitor. (`ENABLED` or `DISABLED`).
        :param pulumi.Input[Sequence[pulumi.Input[Union['StepMonitorStepArgs', 'StepMonitorStepArgsDict']]]] steps: The steps that make up the script the monitor will run. See Nested steps blocks below for details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StepMonitorTagArgs', 'StepMonitorTagArgsDict']]]] tags: The tags that will be associated with the monitor. See Nested tag blocks below for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StepMonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.synthetics.StepMonitor("foo",
            name="Sample Step Monitor",
            enable_screenshot_on_failure_and_script=True,
            locations_publics=[
                "US_EAST_1",
                "US_EAST_2",
            ],
            period="EVERY_6_HOURS",
            status="ENABLED",
            runtime_type="CHROME_BROWSER",
            runtime_type_version="100",
            devices=[
                "DESKTOP",
                "MOBILE_PORTRAIT",
                "TABLET_LANDSCAPE",
            ],
            browsers=["CHROME"],
            steps=[{
                "ordinal": 0,
                "type": "NAVIGATE",
                "values": ["https://www.newrelic.com"],
            }],
            tags=[{
                "key": "some_key",
                "values": ["some_value"],
            }])
        ```
        See additional examples.

        ## Additional Examples

        ### Create a monitor with a private location

        The below example shows how you can define a private location and attach it to a monitor.

        > **NOTE:** It can take up to 10 minutes for a private location to become available.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.synthetics.PrivateLocation("foo",
            name="Sample Private Location",
            description="Sample Private Location Description",
            verified_script_execution=True)
        foo_step_monitor = newrelic.synthetics.StepMonitor("foo",
            name="Sample Step Monitor",
            period="EVERY_6_HOURS",
            status="ENABLED",
            runtime_type="CHROME_BROWSER",
            runtime_type_version="100",
            devices=[
                "DESKTOP",
                "MOBILE_PORTRAIT",
                "TABLET_LANDSCAPE",
            ],
            browsers=["CHROME"],
            location_privates=[{
                "guid": foo.id,
                "vse_password": "secret",
            }],
            steps=[{
                "ordinal": 0,
                "type": "NAVIGATE",
                "values": ["https://google.com"],
            }],
            tags=[{
                "key": "some_key",
                "values": ["some_value"],
            }])
        ```

        ## Import

        A step monitor can be imported using its GUID, using the following command.

        bash

        ```sh
        $ pulumi import newrelic:synthetics/stepMonitor:StepMonitor monitor <guid>
        ```

        :param str resource_name: The name of the resource.
        :param StepMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StepMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 browsers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_screenshot_on_failure_and_script: Optional[pulumi.Input[_builtins.bool]] = None,
                 location_privates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StepMonitorLocationPrivateArgs', 'StepMonitorLocationPrivateArgsDict']]]]] = None,
                 locations_publics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_type: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_type_version: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StepMonitorStepArgs', 'StepMonitorStepArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StepMonitorTagArgs', 'StepMonitorTagArgsDict']]]]] = None,
                 use_unsupported_legacy_runtime: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StepMonitorArgs.__new__(StepMonitorArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["browsers"] = browsers
            __props__.__dict__["devices"] = devices
            __props__.__dict__["enable_screenshot_on_failure_and_script"] = enable_screenshot_on_failure_and_script
            __props__.__dict__["location_privates"] = location_privates
            __props__.__dict__["locations_publics"] = locations_publics
            __props__.__dict__["name"] = name
            if period is None and not opts.urn:
                raise TypeError("Missing required property 'period'")
            __props__.__dict__["period"] = period
            __props__.__dict__["runtime_type"] = runtime_type
            __props__.__dict__["runtime_type_version"] = runtime_type_version
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            if steps is None and not opts.urn:
                raise TypeError("Missing required property 'steps'")
            __props__.__dict__["steps"] = steps
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_unsupported_legacy_runtime"] = use_unsupported_legacy_runtime
            __props__.__dict__["guid"] = None
            __props__.__dict__["monitor_id"] = None
            __props__.__dict__["period_in_minutes"] = None
        super(StepMonitor, __self__).__init__(
            'newrelic:synthetics/stepMonitor:StepMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            browsers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            devices: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enable_screenshot_on_failure_and_script: Optional[pulumi.Input[_builtins.bool]] = None,
            guid: Optional[pulumi.Input[_builtins.str]] = None,
            location_privates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StepMonitorLocationPrivateArgs', 'StepMonitorLocationPrivateArgsDict']]]]] = None,
            locations_publics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.str]] = None,
            period_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            runtime_type: Optional[pulumi.Input[_builtins.str]] = None,
            runtime_type_version: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StepMonitorStepArgs', 'StepMonitorStepArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StepMonitorTagArgs', 'StepMonitorTagArgsDict']]]]] = None,
            use_unsupported_legacy_runtime: Optional[pulumi.Input[_builtins.bool]] = None) -> 'StepMonitor':
        """
        Get an existing StepMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The account in which the Synthetics monitor will be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] browsers: The multiple browsers list on which synthetic monitors will run. Valid values are `CHROME` and `FIREFOX`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] devices: The multiple devices list on which synthetic monitors will run. Valid values are `DESKTOP`, `MOBILE_LANDSCAPE`, `MOBILE_PORTRAIT`, `TABLET_LANDSCAPE` and `TABLET_PORTRAIT`.
        :param pulumi.Input[_builtins.bool] enable_screenshot_on_failure_and_script: Capture a screenshot during job execution.
        :param pulumi.Input[_builtins.str] guid: The unique entity identifier of the monitor in New Relic.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StepMonitorLocationPrivateArgs', 'StepMonitorLocationPrivateArgsDict']]]] location_privates: The location the monitor will run from. At least one of `locations_public` or `location_private` is required. See Nested locations_private blocks below for details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations_publics: The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. You don't need the `AWS_` prefix as the provider uses NerdGraph. At least one of either `locations_public` or `location_private` is required.
        :param pulumi.Input[_builtins.str] monitor_id: The monitor id of the synthetics step monitor (not to be confused with the GUID of the monitor).
        :param pulumi.Input[_builtins.str] name: The name for the monitor.
        :param pulumi.Input[_builtins.str] period: The interval at which this monitor should run. Valid values are `EVERY_MINUTE`, `EVERY_5_MINUTES`, `EVERY_10_MINUTES`, `EVERY_15_MINUTES`, `EVERY_30_MINUTES`, `EVERY_HOUR`, `EVERY_6_HOURS`, `EVERY_12_HOURS`, or `EVERY_DAY`.
        :param pulumi.Input[_builtins.int] period_in_minutes: The interval in minutes at which Synthetic monitor should run.
        :param pulumi.Input[_builtins.str] runtime_type: The runtime that the monitor will use to run jobs (`CHROME_BROWSER`).
        :param pulumi.Input[_builtins.str] runtime_type_version: The specific semver version of the runtime type.
        :param pulumi.Input[_builtins.str] status: The run state of the monitor. (`ENABLED` or `DISABLED`).
        :param pulumi.Input[Sequence[pulumi.Input[Union['StepMonitorStepArgs', 'StepMonitorStepArgsDict']]]] steps: The steps that make up the script the monitor will run. See Nested steps blocks below for details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StepMonitorTagArgs', 'StepMonitorTagArgsDict']]]] tags: The tags that will be associated with the monitor. See Nested tag blocks below for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StepMonitorState.__new__(_StepMonitorState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["browsers"] = browsers
        __props__.__dict__["devices"] = devices
        __props__.__dict__["enable_screenshot_on_failure_and_script"] = enable_screenshot_on_failure_and_script
        __props__.__dict__["guid"] = guid
        __props__.__dict__["location_privates"] = location_privates
        __props__.__dict__["locations_publics"] = locations_publics
        __props__.__dict__["monitor_id"] = monitor_id
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_in_minutes"] = period_in_minutes
        __props__.__dict__["runtime_type"] = runtime_type
        __props__.__dict__["runtime_type_version"] = runtime_type_version
        __props__.__dict__["status"] = status
        __props__.__dict__["steps"] = steps
        __props__.__dict__["tags"] = tags
        __props__.__dict__["use_unsupported_legacy_runtime"] = use_unsupported_legacy_runtime
        return StepMonitor(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The account in which the Synthetics monitor will be created.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def browsers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The multiple browsers list on which synthetic monitors will run. Valid values are `CHROME` and `FIREFOX`.
        """
        return pulumi.get(self, "browsers")

    @_builtins.property
    @pulumi.getter
    def devices(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The multiple devices list on which synthetic monitors will run. Valid values are `DESKTOP`, `MOBILE_LANDSCAPE`, `MOBILE_PORTRAIT`, `TABLET_LANDSCAPE` and `TABLET_PORTRAIT`.
        """
        return pulumi.get(self, "devices")

    @_builtins.property
    @pulumi.getter(name="enableScreenshotOnFailureAndScript")
    def enable_screenshot_on_failure_and_script(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Capture a screenshot during job execution.
        """
        return pulumi.get(self, "enable_screenshot_on_failure_and_script")

    @_builtins.property
    @pulumi.getter
    def guid(self) -> pulumi.Output[_builtins.str]:
        """
        The unique entity identifier of the monitor in New Relic.
        """
        return pulumi.get(self, "guid")

    @_builtins.property
    @pulumi.getter(name="locationPrivates")
    def location_privates(self) -> pulumi.Output[Optional[Sequence['outputs.StepMonitorLocationPrivate']]]:
        """
        The location the monitor will run from. At least one of `locations_public` or `location_private` is required. See Nested locations_private blocks below for details.
        """
        return pulumi.get(self, "location_privates")

    @_builtins.property
    @pulumi.getter(name="locationsPublics")
    def locations_publics(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The location the monitor will run from. Check out [this page](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/administration/synthetic-public-minion-ips/) for a list of valid public locations. You don't need the `AWS_` prefix as the provider uses NerdGraph. At least one of either `locations_public` or `location_private` is required.
        """
        return pulumi.get(self, "locations_publics")

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> pulumi.Output[_builtins.str]:
        """
        The monitor id of the synthetics step monitor (not to be confused with the GUID of the monitor).
        """
        return pulumi.get(self, "monitor_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the monitor.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[_builtins.str]:
        """
        The interval at which this monitor should run. Valid values are `EVERY_MINUTE`, `EVERY_5_MINUTES`, `EVERY_10_MINUTES`, `EVERY_15_MINUTES`, `EVERY_30_MINUTES`, `EVERY_HOUR`, `EVERY_6_HOURS`, `EVERY_12_HOURS`, or `EVERY_DAY`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodInMinutes")
    def period_in_minutes(self) -> pulumi.Output[_builtins.int]:
        """
        The interval in minutes at which Synthetic monitor should run.
        """
        return pulumi.get(self, "period_in_minutes")

    @_builtins.property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The runtime that the monitor will use to run jobs (`CHROME_BROWSER`).
        """
        return pulumi.get(self, "runtime_type")

    @_builtins.property
    @pulumi.getter(name="runtimeTypeVersion")
    def runtime_type_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The specific semver version of the runtime type.
        """
        return pulumi.get(self, "runtime_type_version")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The run state of the monitor. (`ENABLED` or `DISABLED`).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def steps(self) -> pulumi.Output[Sequence['outputs.StepMonitorStep']]:
        """
        The steps that make up the script the monitor will run. See Nested steps blocks below for details.
        """
        return pulumi.get(self, "steps")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.StepMonitorTag']]]:
        """
        The tags that will be associated with the monitor. See Nested tag blocks below for details.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="useUnsupportedLegacyRuntime")
    def use_unsupported_legacy_runtime(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "use_unsupported_legacy_runtime")

