# Base class for unit tests.
import unittest
import numpy as np

class BaseTest(unittest.TestCase):
    # AssertAlmostEqual for lists.
    def assertItemsAlmostEqual(self, a, b, places=5):
        a = self.mat_to_list(a)
        b = self.mat_to_list(b)
        for i in range(len(a)):
            self.assertAlmostEqual(a[i], b[i], places)

    # Overriden method to assume lower accuracy.
    def assertAlmostEqual(self, a, b, places=5):
        super(BaseTest, self).assertAlmostEqual(a,b,places=places)

    def mat_to_list(self, mat):
    	"""Convert a numpy matrix to a list.
    	"""
    	if isinstance(mat, (np.matrix, np.ndarray)):
    		return np.asarray(mat).flatten('F').tolist()
    	else:
    		return mat
