# get-danmu

- 这是一个可以获取弹幕和保存弹幕并且能提供弹幕服务的python命令行工具，支持: **腾讯视频**、**爱奇艺**、**优酷**、**B站**、**芒果TV**，欢迎前来学习和指点

## 使用方法

### 1、直接保存在当前目录
```
get-danmu [url]或get-danmu
#支持get-dm替换get-danmu
```
- 可选参数`--start 分钟:秒`指定开始时间，格式`分钟:秒`或`分钟.秒`
- 可选参数`--end 分钟:秒`指定开始时间，格式`分钟:秒`或`分钟.秒`
- 可选参数`--cookie [cookie.txt]`指定cookie文本文件，比如`哔哩哔哩`平台需要指定cookie才能获取到全部弹幕，`优酷`必须要cookie才可获取弹幕，其他无需cookie
-  可选参数`--resettime`或`-R`指定，例如一些视频为了过审加了片头，那么使用了这个参数，会重设弹幕时间为`--start`所指定的时间，即5分钟的弹幕经过`--start`指定后从3分钟开始，带了`--resettime`参数会自动订正将5分钟的弹幕修正为正常进度即2分钟，因此使用该参数时需要先指定`--start`
-  可选参数`--savepath [path]`或`-s [path]`，指定弹幕数据保存到本地指定文件夹
- 可选参数`-S`，指定弹幕存储到本地数据库中，需要指定过了数据库存放位置才可使用
- 可选参数`--type [xml/csv]`，指定弹幕数据的存储格式，可选`xml`和`csv`，存储到数据库时只能存储`csv`格式，默认`csv`

### 2、将数据保存到数据库
> 使用的是本地的文件数据库SQLite
> 使用前需指定数据库存放位置，而弹幕也会随之存储到数据库目录下的danmu_data目录下

```
get-danmu --db [路径]
```

### 3、代理
```
get-danmu --proxy http://localhost:8080   
```
- 清除代理

```
get-danmu --proxy 
```

### 4、清除所有配置
```
get-danmu --clear
```

### 5、管理数据库中的弹幕信息
```
get-danmu --data 
```
- 可选参数`--start 分钟:秒`指定开始时间，格式`分钟:秒`或`分钟.秒`
- 可选参数`--end 分钟:秒`指定开始时间，格式`分钟:秒`或`分钟.秒`
- 可选参数`--cookie [cookie.txt]`指定cookie文本文件，比如`哔哩哔哩`平台需要指定cookie才能获取到全部弹幕，`优酷`必须要cookie才可获取弹幕，其他无需cookie
-  可选参数`--resettime`或`-R`指定，例如一些视频为了过审加了片头，那么使用了这个参数，会重设弹幕时间为`--start`所指定的时间，即5分钟的弹幕经过`--start`指定后从3分钟开始，带了`--resettime`参数会自动订正将5分钟的弹幕修正为正常进度即2分钟，因此使用该参数时需要先指定`--start`

### 6、开启弹幕服务器
> 这也是本项目的核心也是该项目诞生的原因，因为自己搭建了自己的私人影视库后需要看弹幕，而经典的api.dandanplay.net只有动漫类别的弹幕且不及时，由此诞生了本项目，本项目采用的数据返回和请求方式均和api.dandanplay.net提供的api一致，因此在电影和电视剧有着相当大的优势，虽然不支持自动更新，但是get-danmu --data提供了手动管理弹幕的方法和更新，这也就是使用-S参数时默认保存csv格式数据的真实原因，csv在读取速度上比xml更有优势，在对外提供弹幕服务时，处理1万条以内的数据时耗时在0.1左右，而处理十万条弹幕数据时也仅耗时0.5左右，通常热门电影弹幕数据量大约在十万到十五万条之间，所以这个速度还是很可观的

```
get-danmu --runserver [port]
```
- 可选`port`端口，默认端口号为`80`

> 使用`CTL + C`退出服务器，请勿在生产环境使用默认的服务器运行方式，也不建议在公网搭建本弹幕服务器，因为代码没有进行安全审查，无法对市面上的黑客技术或入侵做出反应，同时也没日志系统

### 7，配置备份弹幕服务器
> 因为不可能所有弹幕都要自己手动去下载，毕竟真的很累，由于作者太懒，而有些电视剧剧集又臭又长还多又有些年头，所以无需最新的弹幕，因此部署一个danmu_api服务器，本地再运行本脚本的弹幕服务器，即可补充本地弹幕不足，比如这个剧集有55集，使用本脚本保存了3集剩下的会由本脚本让你的播放器重定向的danmu_api服务器上实现了剩下的52集的弹幕，所以会优先给你的播放器返回本地的弹幕，那么有了danmu_api是不是本脚本就无用了?错，本脚本能让你手动获取到视频最新的弹幕，也可手动一条命令更新弹幕，也可获取较老视频的弹幕，较老的视频danmu_api提供的弹幕量太少只有几百，所以本脚本的优势是和danmu_api互补，配置命令如下

```
get-danmu --redirect http://[danmu_api服务器ip或域名]:9321/密钥
get-danmu --redirect http://1.1.1.1:9321/getdanmu         #示例
get-danmu --redirect   #不传递参数,则清除配置
```



## 更新记录
- 2025-11-16: 发布 v0.3.8版本 修复获取iqiyi弹幕时可能出现某5分钟弹幕无法解析返回空弹幕的情况，删除xmltodict第三方库依赖，增加第三方库lxml的依赖做解析
- 2025-11-14: 发布 v0.3.6版本 修复Yamby获取大于一季时无法直接匹配弹幕的问题，修正调试信息，继续完善帮助文档
- 2025-10-31: 发布 v0.3.5版本 修复获取电影剧集时报错无法返回数据的bug，修复带有空格的剧名可能无法正确找到最佳匹配条目的bug
- 2025-10-28：发布 v0.3.4版本  增加对danmu_api的支持，修正本地数据管理时连续操作后丢失数据的bug
- 2025-10-12：发布 v0.3.2 版本 修正api更新处理逻辑，修正web服务返回数据的标准化使得更多的平台支持
- 2025-10-11：发布 v0.2.0 版本 修正core处理逻辑
- 2025-10-10：发布 v0.0.1 版本（初代版本），完成核心功能

## THE END

- 本脚本仅支持学习使用，如有发现有任何商业用途，一经发现您将受到法律责任。
- 本程序使用的接口全部来源于网络，切不可有任何商业用途，或我程序中有涉及你公司利益的，你可以联系我，我会及时删除源代码，并不再更新。
- **禁止将本工具用于商业用途**，如产生法律纠纷与本人无关，如有侵权，请联系我删除。
- 项目创建者：李先生
- 项目维护者：李先生
- 维护者邮箱：3101978435@qq.com