# -*- coding: utf-8 -*-
# @Author: maoyongfan
# @email: maoyongfan@163.com
# @Date: 2025/3/17 10:42
from PIL import Image, ImageDraw
from pybaselib.utils import IntType


class SaveImg:
    def __init__(self, img_path: str) -> None:
        self.img_path = img_path
        # self.base_img = Image.open(img_path)

    def create_monochrome_image(self, hex_data, width, height, save_path):
        """使用十六进制数据生成 1-bit 黑白图像 此方法OK"""
        bit_data = IntType.hex_to_bits(hex_data)
        print(hex_data)
        print(bit_data)
        print(len(bit_data))

        if len(bit_data) < width * height:
            raise ValueError("提供的十六进制数据不足以填充图像")

        img = Image.new('1', (width, height))  # 创建 1-bit 图像
        pixels = img.load()

        for y in range(height):
            for x in range(width):
                index = y * width + x
                pixels[x, y] = 255 if bit_data[index] == '1' else 0  # 1为白，0为黑

        img.save(save_path)

        return img

    def create_monochrome_1bit_image(self, width, height, save_path):
        # 创建 1-bit 黑白图像（默认填充白色）
        img = Image.new("1", (width, height), 1)  # 1 表示白色，0 表示黑色

        # 获取绘图对象
        draw = ImageDraw.Draw(img)

        # 画一些黑色图案（比如矩形、线条）
        draw.rectangle([10, 10, width - 10, height - 10], outline=0, fill=0)  # 画黑色矩形
        draw.line([(0, 0), (width, height)], fill=1)  # 画白色对角线

        # 保存图片
        img.save(save_path)
        print(f"Monochrome 1-bit image saved at: {save_path}")

    # 创建一个 8x8 的 1-bit 黑白图片
    def create_monochrome_1bit_image_2(self, save_path):
        img = Image.new("1", (8, 8), 1)  # 8x8，默认白色（1）
        pixels = img.load()

        # 创建一个简单的黑白图案（前4行黑，后4行白）
        for y in range(4):
            for x in range(8):
                pixels[x, y] = 0  # 设为黑色

        img.save(save_path)  # BMP 格式更容易直接读取二进制数据
        return "monochrome_1bit.bmp"

    def hex_to_1bit_image(self, hex_data, width, height, save_path):
        """
        有问题,图片数据大于生成图片像素点
        将 1-bit Monochrome 16 进制数据转换为图片
        :param hex_data: 16 进制字符串（每 8-bit 表示 1 字节）
        :param width: 图片宽度
        :param height: 图片高度
        :param save_path: 生成图片的保存路径
        """
        # 去掉空格，转换为字节数据
        binary_data = bytes.fromhex(hex_data.replace(" ", ""))
        print(binary_data)

        # 创建 1-bit 图片
        img = Image.frombytes("1", (width, height), binary_data)

        # 保存图片
        img.save(save_path)
        print(f"Image saved as {save_path}")

        # 显示图片（可选）
        img.show()


if __name__ == "__main__":
    import numpy as np
    import binascii
    hex_data="000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000ffff00ffff00000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ffff00ffff00000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ffff00ffff00000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ffff00ffff00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ffff00ffff00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ffff00ffff00ffff00ffff00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ffff00ffff00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000000000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000000000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000000000000000000000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
    # hex_data = "000000 000000 000000 000000 0000FF FFFFFF 000000 000000 000000 000000 \
    # 000000 000000 000000 000000 000000 000000 000000 000000 000000 000000 000000 00000FF \
    # 0000FF FFFFFF 000000 000000 000000 000000 000000 000000 000000 000000\
    # 000000 000000 000000 000000 000000 0000FF 0000FF 0000FF FFFFFF 000000\
    # 000000 000000 00FF00 00FF00 00FF00 00FF00 00FF00 00FF00 FF33CC\
    # FF33CC FF33CC FF33CC FF33CC FFFFFF 000000 000000 000000 000000 000000\
    # 000000 000000 000000 FF33CC FF33CC FF33CC FF0000 000000 000000 000000\
    # 000000 000000 000000 000000 000000 FF33CC FF33CC FF0000 000000 000000\
    # 000000 000000 000000 000000 000000 000000 000000 FF33CC FF0000\
    # 000000 000000 000000 000000 000000 000000 000000 000000"

    # rgb_values = [int(hex_data[i:i + 2], 16) for i in range(0, len(hex_data), 2)]
    # # 假设图片宽度和高度
    # width, height = 48, 48  # 10x10 图片
    #
    # # 创建一个 NumPy 数组来存储 RGB 数据
    # image_data = np.array(rgb_values * (width * height // len(rgb_values))).reshape((height, width, 3))
    #
    # # 使用 PIL 创建图片
    # img = Image.fromarray(image_data.astype('uint8'))

    # 显示图片
    # img.show()
    hex_data = hex_data.replace(" ", "")  # 移除空格
    # hex_data = hex_data.replace("\n", "")  # 移除空格
    print(hex_data)

    # 将 16 进制转换为字节数据
    byte_data = binascii.unhexlify(hex_data)

    # 计算图片的尺寸（假设 1 行像素）
    width = len(byte_data) // 3  # 每 3 个字节是一个像素
    height = 48  # 仅 1 行

    # 创建 RGB 图片
    image = Image.frombytes("RGB", (48, 48), byte_data)

    # 放大显示
    # image = image.resize((width , height ), Image.NEAREST)
    image.show()



