# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc
import warnings

from . import remote_pb2 as remote__pb2

GRPC_GENERATED_VERSION = '1.63.2'
GRPC_VERSION = grpc.__version__
EXPECTED_ERROR_RELEASE = '1.65.0'
SCHEDULED_RELEASE_DATE = 'June 25, 2024'
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower
    _version_not_supported = first_version_is_lower(GRPC_VERSION, GRPC_GENERATED_VERSION)
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    warnings.warn(
        f'The grpc package installed is at version {GRPC_VERSION},'
        + f' but the generated code in remote_pb2_grpc.py depends on'
        + f' grpcio>={GRPC_GENERATED_VERSION}.'
        + f' Please upgrade your grpc module to grpcio>={GRPC_GENERATED_VERSION}'
        + f' or downgrade your generated code using grpcio-tools<={GRPC_VERSION}.'
        + f' This warning will become an error in {EXPECTED_ERROR_RELEASE},'
        + f' scheduled for release on {SCHEDULED_RELEASE_DATE}.',
        RuntimeWarning
    )


class RemoteServiceStub(object):
    """RemoteService is a service providing RPCs to interact with a remote
    repository that is hosted on another Git server.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.UpdateRemoteMirror = channel.stream_unary(
                '/gitaly.RemoteService/UpdateRemoteMirror',
                request_serializer=remote__pb2.UpdateRemoteMirrorRequest.SerializeToString,
                response_deserializer=remote__pb2.UpdateRemoteMirrorResponse.FromString,
                _registered_method=True)
        self.FindRemoteRepository = channel.unary_unary(
                '/gitaly.RemoteService/FindRemoteRepository',
                request_serializer=remote__pb2.FindRemoteRepositoryRequest.SerializeToString,
                response_deserializer=remote__pb2.FindRemoteRepositoryResponse.FromString,
                _registered_method=True)
        self.FindRemoteRootRef = channel.unary_unary(
                '/gitaly.RemoteService/FindRemoteRootRef',
                request_serializer=remote__pb2.FindRemoteRootRefRequest.SerializeToString,
                response_deserializer=remote__pb2.FindRemoteRootRefResponse.FromString,
                _registered_method=True)


class RemoteServiceServicer(object):
    """RemoteService is a service providing RPCs to interact with a remote
    repository that is hosted on another Git server.
    """

    def UpdateRemoteMirror(self, request_iterator, context):
        """UpdateRemoteMirror compares the references in the target repository and its remote mirror
        repository. Any differences in the references are then addressed by pushing the differing
        references to the mirror. Created and modified references are updated, removed references are
        deleted from the mirror. UpdateRemoteMirror updates all tags. Branches are updated if they match
        the patterns specified in the requests.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FindRemoteRepository(self, request, context):
        """FindRemoteRepository detects whether a repository exists at the given URI. This is done by
        asking git-ls-remote(1) to enumerate the remote's HEAD and then checking that we recognize it
        as a valid reference.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FindRemoteRootRef(self, request, context):
        """FindRemoteRootRef tries to find the root reference of a remote
        repository. The root reference is the default branch as pointed to by
        the remotes HEAD reference. Returns an InvalidArgument error if the
        specified remote does not exist and a NotFound error in case no HEAD
        branch was found.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_RemoteServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'UpdateRemoteMirror': grpc.stream_unary_rpc_method_handler(
                    servicer.UpdateRemoteMirror,
                    request_deserializer=remote__pb2.UpdateRemoteMirrorRequest.FromString,
                    response_serializer=remote__pb2.UpdateRemoteMirrorResponse.SerializeToString,
            ),
            'FindRemoteRepository': grpc.unary_unary_rpc_method_handler(
                    servicer.FindRemoteRepository,
                    request_deserializer=remote__pb2.FindRemoteRepositoryRequest.FromString,
                    response_serializer=remote__pb2.FindRemoteRepositoryResponse.SerializeToString,
            ),
            'FindRemoteRootRef': grpc.unary_unary_rpc_method_handler(
                    servicer.FindRemoteRootRef,
                    request_deserializer=remote__pb2.FindRemoteRootRefRequest.FromString,
                    response_serializer=remote__pb2.FindRemoteRootRefResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'gitaly.RemoteService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class RemoteService(object):
    """RemoteService is a service providing RPCs to interact with a remote
    repository that is hosted on another Git server.
    """

    @staticmethod
    def UpdateRemoteMirror(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_unary(
            request_iterator,
            target,
            '/gitaly.RemoteService/UpdateRemoteMirror',
            remote__pb2.UpdateRemoteMirrorRequest.SerializeToString,
            remote__pb2.UpdateRemoteMirrorResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FindRemoteRepository(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RemoteService/FindRemoteRepository',
            remote__pb2.FindRemoteRepositoryRequest.SerializeToString,
            remote__pb2.FindRemoteRepositoryResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FindRemoteRootRef(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RemoteService/FindRemoteRootRef',
            remote__pb2.FindRemoteRootRefRequest.SerializeToString,
            remote__pb2.FindRemoteRootRefResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
