! This automatically generated Fortran wrapper file allows codes
! written in Fortran to be called directly from C and translates all
! C-style arguments into expected Fortran-style arguments (with
! assumed size, local type declarations, etc.).


MODULE C_FMATH
USE ISO_FORTRAN_ENV , ONLY : RT => REAL32
  IMPLICIT NONE


CONTAINS


  
  SUBROUTINE C_ORTHOGONALIZE(A_DIM_1, A_DIM_2, A, LENGTHS_DIM_1, LENGTHS, RANK_PRESENT, RANK) BIND(C)
    USE FMATH, ONLY: ORTHOGONALIZE
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: A_DIM_1
    INTEGER, INTENT(IN) :: A_DIM_2
    REAL(KIND=RT), INTENT(INOUT), DIMENSION(A_DIM_1,A_DIM_2) :: A
    INTEGER, INTENT(IN) :: LENGTHS_DIM_1
    REAL(KIND=RT), INTENT(OUT), DIMENSION(LENGTHS_DIM_1) :: LENGTHS
    LOGICAL, INTENT(IN) :: RANK_PRESENT
    INTEGER, INTENT(OUT) :: RANK
  
    IF (RANK_PRESENT) THEN
      CALL ORTHOGONALIZE(A=A, LENGTHS=LENGTHS, RANK=RANK)
    ELSE
      CALL ORTHOGONALIZE(A=A, LENGTHS=LENGTHS)
    END IF
  END SUBROUTINE C_ORTHOGONALIZE
  

  
  SUBROUTINE C_SVD(A_DIM_1, A_DIM_2, A, S_DIM_1, S, VT_DIM_1, VT_DIM_2, VT, RANK_PRESENT, RANK, STEPS_PRESENT, STEPS, BIAS_PRESENT,&
& BIAS) BIND(C)
    USE FMATH, ONLY: SVD
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: A_DIM_1
    INTEGER, INTENT(IN) :: A_DIM_2
    REAL(KIND=RT), INTENT(IN), DIMENSION(A_DIM_1,A_DIM_2) :: A
    INTEGER, INTENT(IN) :: S_DIM_1
    REAL(KIND=RT), INTENT(OUT), DIMENSION(S_DIM_1) :: S
    INTEGER, INTENT(IN) :: VT_DIM_1
    INTEGER, INTENT(IN) :: VT_DIM_2
    REAL(KIND=RT), INTENT(OUT), DIMENSION(VT_DIM_1,VT_DIM_2) :: VT
    LOGICAL, INTENT(IN) :: RANK_PRESENT
    INTEGER, INTENT(OUT) :: RANK
    LOGICAL, INTENT(IN) :: STEPS_PRESENT
    INTEGER, INTENT(IN) :: STEPS
    LOGICAL, INTENT(IN) :: BIAS_PRESENT
    REAL(KIND=RT), INTENT(IN) :: BIAS
  
    IF (RANK_PRESENT) THEN
      IF (STEPS_PRESENT) THEN
        IF (BIAS_PRESENT) THEN
          CALL SVD(A=A, S=S, VT=VT, RANK=RANK, STEPS=STEPS, BIAS=BIAS)
        ELSE
          CALL SVD(A=A, S=S, VT=VT, RANK=RANK, STEPS=STEPS)
        END IF
      ELSE
        IF (BIAS_PRESENT) THEN
          CALL SVD(A=A, S=S, VT=VT, RANK=RANK, BIAS=BIAS)
        ELSE
          CALL SVD(A=A, S=S, VT=VT, RANK=RANK)
        END IF
      END IF
    ELSE
      IF (STEPS_PRESENT) THEN
        IF (BIAS_PRESENT) THEN
          CALL SVD(A=A, S=S, VT=VT, STEPS=STEPS, BIAS=BIAS)
        ELSE
          CALL SVD(A=A, S=S, VT=VT, STEPS=STEPS)
        END IF
      ELSE
        IF (BIAS_PRESENT) THEN
          CALL SVD(A=A, S=S, VT=VT, BIAS=BIAS)
        ELSE
          CALL SVD(A=A, S=S, VT=VT)
        END IF
      END IF
    END IF
  END SUBROUTINE C_SVD
  
END MODULE C_FMATH

