# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GitArgs', 'Git']

@pulumi.input_type
class GitArgs:
    def __init__(__self__, *,
                 initialization: pulumi.Input['GitInitializationArgs'],
                 project_id: pulumi.Input[_builtins.str],
                 default_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_repository_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Git resource.
        :param pulumi.Input['GitInitializationArgs'] initialization: A `initialization` block as documented below.
        :param pulumi.Input[_builtins.str] project_id: The project ID or project name.
        :param pulumi.Input[_builtins.str] default_branch: The ref of the default branch. Will be used as the branch name for initialized repositories.
        :param pulumi.Input[_builtins.bool] disabled: The ability to disable or enable the repository. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name of the git repository.
        :param pulumi.Input[_builtins.str] parent_repository_id: The ID of a Git project from which a fork is to be created.
        """
        pulumi.set(__self__, "initialization", initialization)
        pulumi.set(__self__, "project_id", project_id)
        if default_branch is not None:
            pulumi.set(__self__, "default_branch", default_branch)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_repository_id is not None:
            pulumi.set(__self__, "parent_repository_id", parent_repository_id)

    @_builtins.property
    @pulumi.getter
    def initialization(self) -> pulumi.Input['GitInitializationArgs']:
        """
        A `initialization` block as documented below.
        """
        return pulumi.get(self, "initialization")

    @initialization.setter
    def initialization(self, value: pulumi.Input['GitInitializationArgs']):
        pulumi.set(self, "initialization", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The project ID or project name.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ref of the default branch. Will be used as the branch name for initialized repositories.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_branch", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The ability to disable or enable the repository. Defaults to `false`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the git repository.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentRepositoryId")
    def parent_repository_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a Git project from which a fork is to be created.
        """
        return pulumi.get(self, "parent_repository_id")

    @parent_repository_id.setter
    def parent_repository_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_repository_id", value)


@pulumi.input_type
class _GitState:
    def __init__(__self__, *,
                 default_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 initialization: Optional[pulumi.Input['GitInitializationArgs']] = None,
                 is_fork: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_url: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 ssh_url: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 web_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Git resources.
        :param pulumi.Input[_builtins.str] default_branch: The ref of the default branch. Will be used as the branch name for initialized repositories.
        :param pulumi.Input[_builtins.bool] disabled: The ability to disable or enable the repository. Defaults to `false`.
        :param pulumi.Input['GitInitializationArgs'] initialization: A `initialization` block as documented below.
        :param pulumi.Input[_builtins.bool] is_fork: True if the repository was created as a fork.
        :param pulumi.Input[_builtins.str] name: The name of the git repository.
        :param pulumi.Input[_builtins.str] parent_repository_id: The ID of a Git project from which a fork is to be created.
        :param pulumi.Input[_builtins.str] project_id: The project ID or project name.
        :param pulumi.Input[_builtins.str] remote_url: Git HTTPS URL of the repository
        :param pulumi.Input[_builtins.int] size: Size in bytes.
        :param pulumi.Input[_builtins.str] ssh_url: Git SSH URL of the repository.
        :param pulumi.Input[_builtins.str] url: REST API URL of the repository.
        :param pulumi.Input[_builtins.str] web_url: Web link to the repository.
        """
        if default_branch is not None:
            pulumi.set(__self__, "default_branch", default_branch)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if initialization is not None:
            pulumi.set(__self__, "initialization", initialization)
        if is_fork is not None:
            pulumi.set(__self__, "is_fork", is_fork)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_repository_id is not None:
            pulumi.set(__self__, "parent_repository_id", parent_repository_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if remote_url is not None:
            pulumi.set(__self__, "remote_url", remote_url)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if ssh_url is not None:
            pulumi.set(__self__, "ssh_url", ssh_url)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if web_url is not None:
            pulumi.set(__self__, "web_url", web_url)

    @_builtins.property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ref of the default branch. Will be used as the branch name for initialized repositories.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_branch", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The ability to disable or enable the repository. Defaults to `false`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def initialization(self) -> Optional[pulumi.Input['GitInitializationArgs']]:
        """
        A `initialization` block as documented below.
        """
        return pulumi.get(self, "initialization")

    @initialization.setter
    def initialization(self, value: Optional[pulumi.Input['GitInitializationArgs']]):
        pulumi.set(self, "initialization", value)

    @_builtins.property
    @pulumi.getter(name="isFork")
    def is_fork(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if the repository was created as a fork.
        """
        return pulumi.get(self, "is_fork")

    @is_fork.setter
    def is_fork(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_fork", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the git repository.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentRepositoryId")
    def parent_repository_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a Git project from which a fork is to be created.
        """
        return pulumi.get(self, "parent_repository_id")

    @parent_repository_id.setter
    def parent_repository_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_repository_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID or project name.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="remoteUrl")
    def remote_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Git HTTPS URL of the repository
        """
        return pulumi.get(self, "remote_url")

    @remote_url.setter
    def remote_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_url", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size in bytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="sshUrl")
    def ssh_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Git SSH URL of the repository.
        """
        return pulumi.get(self, "ssh_url")

    @ssh_url.setter
    def ssh_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssh_url", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        REST API URL of the repository.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Web link to the repository.
        """
        return pulumi.get(self, "web_url")

    @web_url.setter
    def web_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_url", value)


@pulumi.type_token("azuredevops:index/git:Git")
class Git(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 initialization: Optional[pulumi.Input[Union['GitInitializationArgs', 'GitInitializationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Azure DevOps Repositories can be imported using the repo name or by the repo Guid e.g.

        ```sh
        $ pulumi import azuredevops:index/git:Git example projectName/repoName
        ```

        or

        ```sh
        $ pulumi import azuredevops:index/git:Git example projectName/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_branch: The ref of the default branch. Will be used as the branch name for initialized repositories.
        :param pulumi.Input[_builtins.bool] disabled: The ability to disable or enable the repository. Defaults to `false`.
        :param pulumi.Input[Union['GitInitializationArgs', 'GitInitializationArgsDict']] initialization: A `initialization` block as documented below.
        :param pulumi.Input[_builtins.str] name: The name of the git repository.
        :param pulumi.Input[_builtins.str] parent_repository_id: The ID of a Git project from which a fork is to be created.
        :param pulumi.Input[_builtins.str] project_id: The project ID or project name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Azure DevOps Repositories can be imported using the repo name or by the repo Guid e.g.

        ```sh
        $ pulumi import azuredevops:index/git:Git example projectName/repoName
        ```

        or

        ```sh
        $ pulumi import azuredevops:index/git:Git example projectName/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param GitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 initialization: Optional[pulumi.Input[Union['GitInitializationArgs', 'GitInitializationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitArgs.__new__(GitArgs)

            __props__.__dict__["default_branch"] = default_branch
            __props__.__dict__["disabled"] = disabled
            if initialization is None and not opts.urn:
                raise TypeError("Missing required property 'initialization'")
            __props__.__dict__["initialization"] = initialization
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_repository_id"] = parent_repository_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["is_fork"] = None
            __props__.__dict__["remote_url"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["ssh_url"] = None
            __props__.__dict__["url"] = None
            __props__.__dict__["web_url"] = None
        super(Git, __self__).__init__(
            'azuredevops:index/git:Git',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_branch: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            initialization: Optional[pulumi.Input[Union['GitInitializationArgs', 'GitInitializationArgsDict']]] = None,
            is_fork: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent_repository_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            remote_url: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            ssh_url: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            web_url: Optional[pulumi.Input[_builtins.str]] = None) -> 'Git':
        """
        Get an existing Git resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_branch: The ref of the default branch. Will be used as the branch name for initialized repositories.
        :param pulumi.Input[_builtins.bool] disabled: The ability to disable or enable the repository. Defaults to `false`.
        :param pulumi.Input[Union['GitInitializationArgs', 'GitInitializationArgsDict']] initialization: A `initialization` block as documented below.
        :param pulumi.Input[_builtins.bool] is_fork: True if the repository was created as a fork.
        :param pulumi.Input[_builtins.str] name: The name of the git repository.
        :param pulumi.Input[_builtins.str] parent_repository_id: The ID of a Git project from which a fork is to be created.
        :param pulumi.Input[_builtins.str] project_id: The project ID or project name.
        :param pulumi.Input[_builtins.str] remote_url: Git HTTPS URL of the repository
        :param pulumi.Input[_builtins.int] size: Size in bytes.
        :param pulumi.Input[_builtins.str] ssh_url: Git SSH URL of the repository.
        :param pulumi.Input[_builtins.str] url: REST API URL of the repository.
        :param pulumi.Input[_builtins.str] web_url: Web link to the repository.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitState.__new__(_GitState)

        __props__.__dict__["default_branch"] = default_branch
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["initialization"] = initialization
        __props__.__dict__["is_fork"] = is_fork
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_repository_id"] = parent_repository_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["remote_url"] = remote_url
        __props__.__dict__["size"] = size
        __props__.__dict__["ssh_url"] = ssh_url
        __props__.__dict__["url"] = url
        __props__.__dict__["web_url"] = web_url
        return Git(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> pulumi.Output[_builtins.str]:
        """
        The ref of the default branch. Will be used as the branch name for initialized repositories.
        """
        return pulumi.get(self, "default_branch")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The ability to disable or enable the repository. Defaults to `false`.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def initialization(self) -> pulumi.Output['outputs.GitInitialization']:
        """
        A `initialization` block as documented below.
        """
        return pulumi.get(self, "initialization")

    @_builtins.property
    @pulumi.getter(name="isFork")
    def is_fork(self) -> pulumi.Output[_builtins.bool]:
        """
        True if the repository was created as a fork.
        """
        return pulumi.get(self, "is_fork")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the git repository.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentRepositoryId")
    def parent_repository_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of a Git project from which a fork is to be created.
        """
        return pulumi.get(self, "parent_repository_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The project ID or project name.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="remoteUrl")
    def remote_url(self) -> pulumi.Output[_builtins.str]:
        """
        Git HTTPS URL of the repository
        """
        return pulumi.get(self, "remote_url")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        Size in bytes.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="sshUrl")
    def ssh_url(self) -> pulumi.Output[_builtins.str]:
        """
        Git SSH URL of the repository.
        """
        return pulumi.get(self, "ssh_url")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        REST API URL of the repository.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> pulumi.Output[_builtins.str]:
        """
        Web link to the repository.
        """
        return pulumi.get(self, "web_url")

