# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['VariableGroupPermissionsArgs', 'VariableGroupPermissions']

@pulumi.input_type
class VariableGroupPermissionsArgs:
    def __init__(__self__, *,
                 permissions: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 principal: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 variable_group_id: pulumi.Input[_builtins.str],
                 replace: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a VariableGroupPermissions resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] permissions: the permissions to assign. The following permissions are available.
               
               | Permission  | Description               |
               |-------------|---------------------------|
               | View        | View library item         |
               | Administer  | Administer library item   |
               | Create      | Create library item       |
               | ViewSecrets | View library item secrets |
               | Use         | Use library item          |
               | Owner       | Owner library item        |
        :param pulumi.Input[_builtins.str] principal: The **group** principal to assign the permissions.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.str] variable_group_id: The id of the variable group to assign the permissions.
        :param pulumi.Input[_builtins.bool] replace: Replace (`true`) or merge (`false`) the permissions. Default: `true`
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "principal", principal)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "variable_group_id", variable_group_id)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        the permissions to assign. The following permissions are available.

        | Permission  | Description               |
        |-------------|---------------------------|
        | View        | View library item         |
        | Administer  | Administer library item   |
        | Create      | Create library item       |
        | ViewSecrets | View library item secrets |
        | Use         | Use library item          |
        | Owner       | Owner library item        |
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Input[_builtins.str]:
        """
        The **group** principal to assign the permissions.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="variableGroupId")
    def variable_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the variable group to assign the permissions.
        """
        return pulumi.get(self, "variable_group_id")

    @variable_group_id.setter
    def variable_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "variable_group_id", value)

    @_builtins.property
    @pulumi.getter
    def replace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Replace (`true`) or merge (`false`) the permissions. Default: `true`
        """
        return pulumi.get(self, "replace")

    @replace.setter
    def replace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "replace", value)


@pulumi.input_type
class _VariableGroupPermissionsState:
    def __init__(__self__, *,
                 permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 variable_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VariableGroupPermissions resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] permissions: the permissions to assign. The following permissions are available.
               
               | Permission  | Description               |
               |-------------|---------------------------|
               | View        | View library item         |
               | Administer  | Administer library item   |
               | Create      | Create library item       |
               | ViewSecrets | View library item secrets |
               | Use         | Use library item          |
               | Owner       | Owner library item        |
        :param pulumi.Input[_builtins.str] principal: The **group** principal to assign the permissions.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.bool] replace: Replace (`true`) or merge (`false`) the permissions. Default: `true`
        :param pulumi.Input[_builtins.str] variable_group_id: The id of the variable group to assign the permissions.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)
        if variable_group_id is not None:
            pulumi.set(__self__, "variable_group_id", variable_group_id)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        the permissions to assign. The following permissions are available.

        | Permission  | Description               |
        |-------------|---------------------------|
        | View        | View library item         |
        | Administer  | Administer library item   |
        | Create      | Create library item       |
        | ViewSecrets | View library item secrets |
        | Use         | Use library item          |
        | Owner       | Owner library item        |
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The **group** principal to assign the permissions.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def replace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Replace (`true`) or merge (`false`) the permissions. Default: `true`
        """
        return pulumi.get(self, "replace")

    @replace.setter
    def replace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "replace", value)

    @_builtins.property
    @pulumi.getter(name="variableGroupId")
    def variable_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the variable group to assign the permissions.
        """
        return pulumi.get(self, "variable_group_id")

    @variable_group_id.setter
    def variable_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "variable_group_id", value)


@pulumi.type_token("azuredevops:index/variableGroupPermissions:VariableGroupPermissions")
class VariableGroupPermissions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 variable_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages permissions for a Variable Group

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        project = azuredevops.Project("project",
            name="Testing",
            description="Testing-description",
            visibility="private",
            version_control="Git",
            work_item_template="Agile")
        example = azuredevops.VariableGroup("example",
            project_id=project.id,
            name="test",
            description="Test Description",
            allow_access=True,
            variables=[{
                "name": "key1",
                "value": "val1",
            }])
        tf_project_readers = azuredevops.get_group_output(project_id=project.id,
            name="Readers")
        permissions = azuredevops.VariableGroupPermissions("permissions",
            project_id=project.id,
            variable_group_id=example.id,
            principal=tf_project_readers.id,
            permissions={
                "View": "allow",
                "Administer": "allow",
                "Use": "allow",
            })
        ```

        ## Roles

        The Azure DevOps UI uses roles to assign permissions for variable groups.

        | Role          | Allow Permissions     |
        |---------------|-----------------------|
        | Reader        | View                  |
        | User          | View, Use             |
        | Administrator | View, Use, Administer |

        ## Relevant Links

        * [Azure DevOps Service REST API 7.1 - Security](https://docs.microsoft.com/en-us/rest/api/azure/devops/security/?view=azure-devops-rest-7.1)

        ## PAT Permissions Required

        - **Project & Team**: vso.security_manage - Grants the ability to read, write, and manage security permissions.

        ## Import

        The resource does not support import.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] permissions: the permissions to assign. The following permissions are available.
               
               | Permission  | Description               |
               |-------------|---------------------------|
               | View        | View library item         |
               | Administer  | Administer library item   |
               | Create      | Create library item       |
               | ViewSecrets | View library item secrets |
               | Use         | Use library item          |
               | Owner       | Owner library item        |
        :param pulumi.Input[_builtins.str] principal: The **group** principal to assign the permissions.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.bool] replace: Replace (`true`) or merge (`false`) the permissions. Default: `true`
        :param pulumi.Input[_builtins.str] variable_group_id: The id of the variable group to assign the permissions.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VariableGroupPermissionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages permissions for a Variable Group

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        project = azuredevops.Project("project",
            name="Testing",
            description="Testing-description",
            visibility="private",
            version_control="Git",
            work_item_template="Agile")
        example = azuredevops.VariableGroup("example",
            project_id=project.id,
            name="test",
            description="Test Description",
            allow_access=True,
            variables=[{
                "name": "key1",
                "value": "val1",
            }])
        tf_project_readers = azuredevops.get_group_output(project_id=project.id,
            name="Readers")
        permissions = azuredevops.VariableGroupPermissions("permissions",
            project_id=project.id,
            variable_group_id=example.id,
            principal=tf_project_readers.id,
            permissions={
                "View": "allow",
                "Administer": "allow",
                "Use": "allow",
            })
        ```

        ## Roles

        The Azure DevOps UI uses roles to assign permissions for variable groups.

        | Role          | Allow Permissions     |
        |---------------|-----------------------|
        | Reader        | View                  |
        | User          | View, Use             |
        | Administrator | View, Use, Administer |

        ## Relevant Links

        * [Azure DevOps Service REST API 7.1 - Security](https://docs.microsoft.com/en-us/rest/api/azure/devops/security/?view=azure-devops-rest-7.1)

        ## PAT Permissions Required

        - **Project & Team**: vso.security_manage - Grants the ability to read, write, and manage security permissions.

        ## Import

        The resource does not support import.

        :param str resource_name: The name of the resource.
        :param VariableGroupPermissionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VariableGroupPermissionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 variable_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VariableGroupPermissionsArgs.__new__(VariableGroupPermissionsArgs)

            if permissions is None and not opts.urn:
                raise TypeError("Missing required property 'permissions'")
            __props__.__dict__["permissions"] = permissions
            if principal is None and not opts.urn:
                raise TypeError("Missing required property 'principal'")
            __props__.__dict__["principal"] = principal
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["replace"] = replace
            if variable_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'variable_group_id'")
            __props__.__dict__["variable_group_id"] = variable_group_id
        super(VariableGroupPermissions, __self__).__init__(
            'azuredevops:index/variableGroupPermissions:VariableGroupPermissions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            principal: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            replace: Optional[pulumi.Input[_builtins.bool]] = None,
            variable_group_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VariableGroupPermissions':
        """
        Get an existing VariableGroupPermissions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] permissions: the permissions to assign. The following permissions are available.
               
               | Permission  | Description               |
               |-------------|---------------------------|
               | View        | View library item         |
               | Administer  | Administer library item   |
               | Create      | Create library item       |
               | ViewSecrets | View library item secrets |
               | Use         | Use library item          |
               | Owner       | Owner library item        |
        :param pulumi.Input[_builtins.str] principal: The **group** principal to assign the permissions.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.bool] replace: Replace (`true`) or merge (`false`) the permissions. Default: `true`
        :param pulumi.Input[_builtins.str] variable_group_id: The id of the variable group to assign the permissions.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VariableGroupPermissionsState.__new__(_VariableGroupPermissionsState)

        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["principal"] = principal
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["replace"] = replace
        __props__.__dict__["variable_group_id"] = variable_group_id
        return VariableGroupPermissions(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        the permissions to assign. The following permissions are available.

        | Permission  | Description               |
        |-------------|---------------------------|
        | View        | View library item         |
        | Administer  | Administer library item   |
        | Create      | Create library item       |
        | ViewSecrets | View library item secrets |
        | Use         | Use library item          |
        | Owner       | Owner library item        |
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Output[_builtins.str]:
        """
        The **group** principal to assign the permissions.
        """
        return pulumi.get(self, "principal")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def replace(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Replace (`true`) or merge (`false`) the permissions. Default: `true`
        """
        return pulumi.get(self, "replace")

    @_builtins.property
    @pulumi.getter(name="variableGroupId")
    def variable_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the variable group to assign the permissions.
        """
        return pulumi.get(self, "variable_group_id")

