# -*- coding: utf-8 -*-
# vim: sw=4:ts=4:expandtab
"""
riko.locations
~~~~~~~~~~~~~~
Provides location lookup dictionaries

Attributes:
    LOCATIONS (dict): Location name to info mapping
"""
LOCATIONS = {
    'Asia': {
        'code_2': 'AS',
        'continent': 'Asia'},
    'Africa': {
        'code_2': 'AF',
        'continent': 'Africa'},
    'Europe': {
        'code_2': 'EU',
        'continent': 'Europe'},
    'North America': {
        'code_2': 'NA',
        'continent': 'North America'},
    'South America': {
        'code_2': 'SA',
        'continent': 'South America'},
    'Oceania': {
        'code_2': 'OC',
        'continent': 'Oceania'},
    'Afghanistan': {
        'code_2': 'AF',
        'code_3': 'AFG',
        'continent': 'Asia',
        'country': 'Afghanistan',
        'num': '4'},
    'Albania': {
        'code_2': 'AL',
        'code_3': 'ALB',
        'continent': 'Europe',
        'country': 'Albania',
        'num': '8'},
    'Algeria': {
        'code_2': 'DZ',
        'code_3': 'DZA',
        'continent': 'Africa',
        'country': 'Algeria',
        'num': '12'},
    'American Samoa': {
        'code_2': 'AS',
        'code_3': 'ASM',
        'continent': 'Oceania',
        'country': 'American Samoa',
        'num': '16'},
    'Andorra': {
        'code_2': 'AD',
        'code_3': 'AND',
        'continent': 'Europe',
        'country': 'Andorra',
        'num': '20'},
    'Angola': {
        'code_2': 'AO',
        'code_3': 'AGO',
        'continent': 'Africa',
        'country': 'Angola',
        'num': '24'},
    'Anguilla': {
        'code_2': 'AI',
        'code_3': 'AIA',
        'continent': 'North America',
        'country': 'Anguilla',
        'num': '660'},
    'Antarctica': {
        'code_2': 'AQ',
        'code_3': 'ATA',
        'continent': 'Antarctica',
        'country': 'Antarctica',
        'num': '10'},
    'Antigua and Barbuda': {
        'code_2': 'AG',
        'code_3': 'ATG',
        'continent': 'North America',
        'country': 'Antigua and Barbuda',
        'num': '28'},
    'Argentina': {
        'code_2': 'AR',
        'code_3': 'ARG',
        'continent': 'South America',
        'country': 'Argentina',
        'num': '32'},
    'Armenia': {
        'code_2': 'AM',
        'code_3': 'ARM',
        'continent': 'Europe',
        'country': 'Armenia',
        'num': '51'},
    'Aruba': {
        'code_2': 'AW',
        'code_3': 'ABW',
        'continent': 'North America',
        'country': 'Aruba',
        'num': '533'},
    'Australia': {
        'code_2': 'AU',
        'code_3': 'AUS',
        'continent': 'Oceania',
        'country': 'Australia',
        'num': '36'},
    'Austria': {
        'code_2': 'AT',
        'code_3': 'AUT',
        'continent': 'Europe',
        'country': 'Austria',
        'num': '40'},
    'Azerbaijan': {
        'code_2': 'AZ',
        'code_3': 'AZE',
        'continent': 'Europe',
        'country': 'Azerbaijan',
        'num': '31'},
    'Bahamas': {
        'code_2': 'BS',
        'code_3': 'BHS',
        'continent': 'North America',
        'country': 'Bahamas',
        'num': '44'},
    'Bahrain': {
        'code_2': 'BH',
        'code_3': 'BHR',
        'continent': 'Asia',
        'country': 'Bahrain',
        'num': '48'},
    'Bangladesh': {
        'code_2': 'BD',
        'code_3': 'BGD',
        'continent': 'Asia',
        'country': 'Bangladesh',
        'num': '50'},
    'Barbados': {
        'code_2': 'BB',
        'code_3': 'BRB',
        'continent': 'North America',
        'country': 'Barbados',
        'num': '52'},
    'Belarus': {
        'code_2': 'BY',
        'code_3': 'BLR',
        'continent': 'Europe',
        'country': 'Belarus',
        'num': '112'},
    'Belgium': {
        'code_2': 'BE',
        'code_3': 'BEL',
        'continent': 'Europe',
        'country': 'Belgium',
        'num': '56'},
    'Belize': {
        'code_2': 'BZ',
        'code_3': 'BLZ',
        'continent': 'North America',
        'country': 'Belize',
        'num': '84'},
    'Benin': {
        'code_2': 'BJ',
        'code_3': 'BEN',
        'continent': 'Africa',
        'country': 'Benin',
        'num': '204'},
    'Bermuda': {
        'code_2': 'BM',
        'code_3': 'BMU',
        'continent': 'North America',
        'country': 'Bermuda',
        'num': '60'},
    'Bhutan': {
        'code_2': 'BT',
        'code_3': 'BTN',
        'continent': 'Asia',
        'country': 'Bhutan',
        'num': '64'},
    'Bolivia': {
        'code_2': 'BO',
        'code_3': 'BOL',
        'continent': 'South America',
        'country': 'Bolivia',
        'num': '68'},
    'Bonaire': {
        'code_2': 'BQ',
        'code_3': 'BES',
        'continent': 'North America',
        'country': 'Bonaire',
        'num': '535'},
    'Bosnia and Herzegovina': {
        'code_2': 'BA',
        'code_3': 'BIH',
        'continent': 'Europe',
        'country': 'Bosnia and Herzegovina',
        'num': '70'},
    'Botswana': {
        'code_2': 'BW',
        'code_3': 'BWA',
        'continent': 'Africa',
        'country': 'Botswana',
        'num': '72'},
    'Bouvet Island': {
        'code_2': 'BV',
        'code_3': 'BVT',
        'continent': 'Antarctica',
        'country': 'Bouvet Island',
        'num': '74'},
    'Brazil': {
        'code_2': 'BR',
        'code_3': 'BRA',
        'continent': 'South America',
        'country': 'Brazil',
        'num': '76'},
    'British Virgin Islands': {
        'code_2': 'VG',
        'code_3': 'VGB',
        'continent': 'North America',
        'country': 'British Virgin Islands',
        'num': '92'},
    'Brunei Darussalam': {
        'code_2': 'BN',
        'code_3': 'BRN',
        'continent': 'Asia',
        'country': 'Brunei Darussalam',
        'num': '96'},
    'Bulgaria': {
        'code_2': 'BG',
        'code_3': 'BGR',
        'continent': 'Europe',
        'country': 'Bulgaria',
        'num': '100'},
    'Burkina Faso': {
        'code_2': 'BF',
        'code_3': 'BFA',
        'continent': 'Africa',
        'country': 'Burkina Faso',
        'num': '854'},
    'Burundi': {
        'code_2': 'BI',
        'code_3': 'BDI',
        'continent': 'Africa',
        'country': 'Burundi',
        'num': '108'},
    'Cambodia': {
        'code_2': 'KH',
        'code_3': 'KHM',
        'continent': 'Asia',
        'country': 'Cambodia',
        'num': '116'},
    'Cameroon': {
        'code_2': 'CM',
        'code_3': 'CMR',
        'continent': 'Africa',
        'country': 'Cameroon',
        'num': '120'},
    'Canada': {
        'code_2': 'CA',
        'code_3': 'CAN',
        'continent': 'North America',
        'country': 'Canada',
        'num': '124'},
    'Cape Verde': {
        'code_2': 'CV',
        'code_3': 'CPV',
        'continent': 'Africa',
        'country': 'Cape Verde',
        'num': '132'},
    'Cayman Islands': {
        'code_2': 'KY',
        'code_3': 'CYM',
        'continent': 'North America',
        'country': 'Cayman Islands',
        'num': '136'},
    'Central African Republic': {
        'code_2': 'CF',
        'code_3': 'CAF',
        'continent': 'Africa',
        'country': 'Central African Republic',
        'num': '140'},
    'Chad': {
        'code_2': 'TD',
        'code_3': 'TCD',
        'continent': 'Africa',
        'country': 'Chad',
        'num': '148'},
    'Chagos Archipelago': {
        'code_2': 'IO',
        'code_3': 'IOT',
        'continent': 'Asia',
        'country': 'Chagos Archipelago',
        'num': '86'},
    'Chile': {
        'code_2': 'CL',
        'code_3': 'CHL',
        'continent': 'South America',
        'country': 'Chile',
        'num': '152'},
    'China': {
        'code_2': 'CN',
        'code_3': 'CHN',
        'continent': 'Asia',
        'country': 'China',
        'num': '156'},
    'Christmas Island': {
        'code_2': 'CX',
        'code_3': 'CXR',
        'continent': 'Asia',
        'country': 'Christmas Island',
        'num': '162'},
    'Cocos (Keeling) Islands': {
        'code_2': 'CC',
        'code_3': 'CCK',
        'continent': 'Asia',
        'country': 'Cocos (Keeling) Islands',
        'num': '166'},
    'Colombia': {
        'code_2': 'CO',
        'code_3': 'COL',
        'continent': 'South America',
        'country': 'Colombia',
        'num': '170'},
    'Comoros': {
        'code_2': 'KM',
        'code_3': 'COM',
        'continent': 'Africa',
        'country': 'Comoros',
        'num': '174'},
    'Congo': {
        'code_2': 'CG',
        'code_3': 'COG',
        'continent': 'Africa',
        'country': 'Congo',
        'num': '178'},
    'Cook Islands': {
        'code_2': 'CK',
        'code_3': 'COK',
        'continent': 'Oceania',
        'country': 'Cook Islands',
        'num': '184'},
    'Costa Rica': {
        'code_2': 'CR',
        'code_3': 'CRI',
        'continent': 'North America',
        'country': 'Costa Rica',
        'num': '188'},
    "Cote d'Ivoire": {
        'code_2': 'CI',
        'code_3': 'CIV',
        'continent': 'Africa',
        'country': "Cote d'Ivoire",
        'num': '384'},
    'Croatia': {
        'code_2': 'HR',
        'code_3': 'HRV',
        'continent': 'Europe',
        'country': 'Croatia',
        'num': '191'},
    'Cuba': {
        'code_2': 'CU',
        'code_3': 'CUB',
        'continent': 'North America',
        'country': 'Cuba',
        'num': '192'},
    'Curaçao': {
        'code_2': 'CW',
        'code_3': 'CUW',
        'continent': 'North America',
        'country': 'Curaçao',
        'num': '531'},
    'Cyprus': {
        'code_2': 'CY',
        'code_3': 'CYP',
        'continent': 'Europe',
        'country': 'Cyprus',
        'num': '196'},
    'Czech Republic': {
        'code_2': 'CZ',
        'code_3': 'CZE',
        'continent': 'Europe',
        'country': 'Czech Republic',
        'num': '203'},
    'Democratic Republic of the Congo': {
        'code_2': 'CD',
        'code_3': 'COD',
        'continent': 'Africa',
        'country': 'Democratic Republic of the Congo',
        'num': '180'},
    'Denmark': {
        'code_2': 'DK',
        'code_3': 'DNK',
        'continent': 'Europe',
        'country': 'Denmark',
        'num': '208'},
    'Djibouti': {
        'code_2': 'DJ',
        'code_3': 'DJI',
        'continent': 'Africa',
        'country': 'Djibouti',
        'num': '262'},
    'Dominica': {
        'code_2': 'DM',
        'code_3': 'DMA',
        'continent': 'North America',
        'country': 'Dominica',
        'num': '212'},
    'Dominican Republic': {
        'code_2': 'DO',
        'code_3': 'DOM',
        'continent': 'North America',
        'country': 'Dominican Republic',
        'num': '214'},
    'Ecuador': {
        'code_2': 'EC',
        'code_3': 'ECU',
        'continent': 'South America',
        'country': 'Ecuador',
        'num': '218'},
    'Egypt': {
        'code_2': 'EG',
        'code_3': 'EGY',
        'continent': 'Africa',
        'country': 'Egypt',
        'num': '818'},
    'El Salvador': {
        'code_2': 'SV',
        'code_3': 'SLV',
        'continent': 'North America',
        'country': 'El Salvador',
        'num': '222'},
    'Equatorial Guinea': {
        'code_2': 'GQ',
        'code_3': 'GNQ',
        'continent': 'Africa',
        'country': 'Equatorial Guinea',
        'num': '226'},
    'Eritrea': {
        'code_2': 'ER',
        'code_3': 'ERI',
        'continent': 'Africa',
        'country': 'Eritrea',
        'num': '232'},
    'Estonia': {
        'code_2': 'EE',
        'code_3': 'EST',
        'continent': 'Europe',
        'country': 'Estonia',
        'num': '233'},
    'Ethiopia': {
        'code_2': 'ET',
        'code_3': 'ETH',
        'continent': 'Africa',
        'country': 'Ethiopia',
        'num': '231'},
    'Falkland Islands (Malvinas)': {
        'code_2': 'FK',
        'code_3': 'FLK',
        'continent': 'South America',
        'country': 'Falkland Islands (Malvinas)',
        'num': '238'},
    'Faroe Islands': {
        'code_2': 'FO',
        'code_3': 'FRO',
        'continent': 'Europe',
        'country': 'Faroe Islands',
        'num': '234'},
    'Fiji': {
        'code_2': 'FJ',
        'code_3': 'FJI',
        'continent': 'Oceania',
        'country': 'Fiji',
        'num': '242'},
    'Finland': {
        'code_2': 'FI',
        'code_3': 'FIN',
        'continent': 'Europe',
        'country': 'Finland',
        'num': '246'},
    'France': {
        'code_2': 'FR',
        'code_3': 'FRA',
        'continent': 'Europe',
        'country': 'France',
        'num': '250'},
    'French Guiana': {
        'code_2': 'GF',
        'code_3': 'GUF',
        'continent': 'South America',
        'country': 'French Guiana',
        'num': '254'},
    'French Polynesia': {
        'code_2': 'PF',
        'code_3': 'PYF',
        'continent': 'Oceania',
        'country': 'French Polynesia',
        'num': '258'},
    'French Southern Territories': {
        'code_2': 'TF',
        'code_3': 'ATF',
        'continent': 'Antarctica',
        'country': 'French Southern Territories',
        'num': '260'},
    'Gabon': {
        'code_2': 'GA',
        'code_3': 'GAB',
        'continent': 'Africa',
        'country': 'Gabon',
        'num': '266'},
    'Gambia the': {
        'code_2': 'GM',
        'code_3': 'GMB',
        'continent': 'Africa',
        'country': 'Gambia the',
        'num': '270'},
    'Georgia': {
        'code_2': 'GE',
        'code_3': 'GEO',
        'continent': 'Europe',
        'country': 'Georgia',
        'num': '268'},
    'Germany': {
        'code_2': 'DE',
        'code_3': 'DEU',
        'continent': 'Europe',
        'country': 'Germany',
        'num': '276'},
    'Ghana': {
        'code_2': 'GH',
        'code_3': 'GHA',
        'continent': 'Africa',
        'country': 'Ghana',
        'num': '288'},
    'Gibraltar': {
        'code_2': 'GI',
        'code_3': 'GIB',
        'continent': 'Europe',
        'country': 'Gibraltar',
        'num': '292'},
    'Greece': {
        'code_2': 'GR',
        'code_3': 'GRC',
        'continent': 'Europe',
        'country': 'Greece',
        'num': '300'},
    'Greenland': {
        'code_2': 'GL',
        'code_3': 'GRL',
        'continent': 'North America',
        'country': 'Greenland',
        'num': '304'},
    'Grenada': {
        'code_2': 'GD',
        'code_3': 'GRD',
        'continent': 'North America',
        'country': 'Grenada',
        'num': '308'},
    'Guadeloupe': {
        'code_2': 'GP',
        'code_3': 'GLP',
        'continent': 'North America',
        'country': 'Guadeloupe',
        'num': '312'},
    'Guam': {
        'code_2': 'GU',
        'code_3': 'GUM',
        'continent': 'Oceania',
        'country': 'Guam',
        'num': '316'},
    'Guatemala': {
        'code_2': 'GT',
        'code_3': 'GTM',
        'continent': 'North America',
        'country': 'Guatemala',
        'num': '320'},
    'Guernsey': {
        'code_2': 'GG',
        'code_3': 'GGY',
        'continent': 'Europe',
        'country': 'Guernsey',
        'num': '831'},
    'Guinea': {
        'code_2': 'GN',
        'code_3': 'GIN',
        'continent': 'Africa',
        'country': 'Guinea',
        'num': '324'},
    'Guinea-Bissau': {
        'code_2': 'GW',
        'code_3': 'GNB',
        'continent': 'Africa',
        'country': 'Guinea-Bissau',
        'num': '624'},
    'Guyana': {
        'code_2': 'GY',
        'code_3': 'GUY',
        'continent': 'South America',
        'country': 'Guyana',
        'num': '328'},
    'Haiti': {
        'code_2': 'HT',
        'code_3': 'HTI',
        'continent': 'North America',
        'country': 'Haiti',
        'num': '332'},
    'Heard Island and McDonald Islands': {
        'code_2': 'HM',
        'code_3': 'HMD',
        'continent': 'Antarctica',
        'country': 'Heard Island and McDonald Islands',
        'num': '334'},
    'Holy See (Vatican City State)': {
        'code_2': 'VA',
        'code_3': 'VAT',
        'continent': 'Europe',
        'country': 'Holy See (Vatican City State)',
        'num': '336'},
    'Honduras': {
        'code_2': 'HN',
        'code_3': 'HND',
        'continent': 'North America',
        'country': 'Honduras',
        'num': '340'},
    'Hong Kong': {
        'code_2': 'HK',
        'code_3': 'HKG',
        'continent': 'Asia',
        'country': 'Hong Kong',
        'num': '344'},
    'Hungary': {
        'code_2': 'HU',
        'code_3': 'HUN',
        'continent': 'Europe',
        'country': 'Hungary',
        'num': '348'},
    'Iceland': {
        'code_2': 'IS',
        'code_3': 'ISL',
        'continent': 'Europe',
        'country': 'Iceland',
        'num': '352'},
    'India': {
        'code_2': 'IN',
        'code_3': 'IND',
        'continent': 'Asia',
        'country': 'India',
        'num': '356'},
    'Indonesia': {
        'code_2': 'ID',
        'code_3': 'IDN',
        'continent': 'Asia',
        'country': 'Indonesia',
        'num': '360'},
    'Iran': {
        'code_2': 'IR',
        'code_3': 'IRN',
        'continent': 'Asia',
        'country': 'Iran',
        'num': '364'},
    'Iraq': {
        'code_2': 'IQ',
        'code_3': 'IRQ',
        'continent': 'Asia',
        'country': 'Iraq',
        'num': '368'},
    'Ireland': {
        'code_2': 'IE',
        'code_3': 'IRL',
        'continent': 'Europe',
        'country': 'Ireland',
        'num': '372'},
    'Isle of Man': {
        'code_2': 'IM',
        'code_3': 'IMN',
        'continent': 'Europe',
        'country': 'Isle of Man',
        'num': '833'},
    'Israel': {
        'code_2': 'IL',
        'code_3': 'ISR',
        'continent': 'Asia',
        'country': 'Israel',
        'num': '376'},
    'Italy': {
        'code_2': 'IT',
        'code_3': 'ITA',
        'continent': 'Europe',
        'country': 'Italy',
        'num': '380'},
    'Jamaica': {
        'code_2': 'JM',
        'code_3': 'JAM',
        'continent': 'North America',
        'country': 'Jamaica',
        'num': '388'},
    'Japan': {
        'code_2': 'JP',
        'code_3': 'JPN',
        'continent': 'Asia',
        'country': 'Japan',
        'num': '392'},
    'Jersey': {
        'code_2': 'JE',
        'code_3': 'JEY',
        'continent': 'Europe',
        'country': 'Jersey',
        'num': '832'},
    'Jordan': {
        'code_2': 'JO',
        'code_3': 'JOR',
        'continent': 'Asia',
        'country': 'Jordan',
        'num': '400'},
    'Kazakhstan': {
        'code_2': 'KZ',
        'code_3': 'KAZ',
        'continent': 'Europe',
        'country': 'Kazakhstan',
        'num': '398'},
    'Kenya': {
        'code_2': 'KE',
        'code_3': 'KEN',
        'continent': 'Africa',
        'country': 'Kenya',
        'num': '404'},
    'Kiribati': {
        'code_2': 'KI',
        'code_3': 'KIR',
        'continent': 'Oceania',
        'country': 'Kiribati',
        'num': '296'},
    'Korea': {
        'code_2': 'KR',
        'code_3': 'KOR',
        'continent': 'Asia',
        'country': 'Korea',
        'num': '410'},
    'Kuwait': {
        'code_2': 'KW',
        'code_3': 'KWT',
        'continent': 'Asia',
        'country': 'Kuwait',
        'num': '414'},
    'Kyrgyz Republic': {
        'code_2': 'KG',
        'code_3': 'KGZ',
        'continent': 'Asia',
        'country': 'Kyrgyz Republic',
        'num': '417'},
    'Lao': {
        'code_2': 'LA',
        'code_3': 'LAO',
        'continent': 'Asia',
        'country': 'Lao',
        'num': '418'},
    'Latvia': {
        'code_2': 'LV',
        'code_3': 'LVA',
        'continent': 'Europe',
        'country': 'Latvia',
        'num': '428'},
    'Lebanon': {
        'code_2': 'LB',
        'code_3': 'LBN',
        'continent': 'Asia',
        'country': 'Lebanon',
        'num': '422'},
    'Lesotho': {
        'code_2': 'LS',
        'code_3': 'LSO',
        'continent': 'Africa',
        'country': 'Lesotho',
        'num': '426'},
    'Liberia': {
        'code_2': 'LR',
        'code_3': 'LBR',
        'continent': 'Africa',
        'country': 'Liberia',
        'num': '430'},
    'Libyan Arab Jamahiriya': {
        'code_2': 'LY',
        'code_3': 'LBY',
        'continent': 'Africa',
        'country': 'Libyan Arab Jamahiriya',
        'num': '434'},
    'Liechtenstein': {
        'code_2': 'LI',
        'code_3': 'LIE',
        'continent': 'Europe',
        'country': 'Liechtenstein',
        'num': '438'},
    'Lithuania': {
        'code_2': 'LT',
        'code_3': 'LTU',
        'continent': 'Europe',
        'country': 'Lithuania',
        'num': '440'},
    'Luxembourg': {
        'code_2': 'LU',
        'code_3': 'LUX',
        'continent': 'Europe',
        'country': 'Luxembourg',
        'num': '442'},
    'Macao': {
        'code_2': 'MO',
        'code_3': 'MAC',
        'continent': 'Asia',
        'country': 'Macao',
        'num': '446'},
    'Macedonia': {
        'code_2': 'MK',
        'code_3': 'MKD',
        'continent': 'Europe',
        'country': 'Macedonia',
        'num': '807'},
    'Madagascar': {
        'code_2': 'MG',
        'code_3': 'MDG',
        'continent': 'Africa',
        'country': 'Madagascar',
        'num': '450'},
    'Malawi': {
        'code_2': 'MW',
        'code_3': 'MWI',
        'continent': 'Africa',
        'country': 'Malawi',
        'num': '454'},
    'Malaysia': {
        'code_2': 'MY',
        'code_3': 'MYS',
        'continent': 'Asia',
        'country': 'Malaysia',
        'num': '458'},
    'Maldives': {
        'code_2': 'MV',
        'code_3': 'MDV',
        'continent': 'Asia',
        'country': 'Maldives',
        'num': '462'},
    'Mali': {
        'code_2': 'ML',
        'code_3': 'MLI',
        'continent': 'Africa',
        'country': 'Mali',
        'num': '466'},
    'Malta': {
        'code_2': 'MT',
        'code_3': 'MLT',
        'continent': 'Europe',
        'country': 'Malta',
        'num': '470'},
    'Marshall Islands the': {
        'code_2': 'MH',
        'code_3': 'MHL',
        'continent': 'Oceania',
        'country': 'Marshall Islands the',
        'num': '584'},
    'Martinique': {
        'code_2': 'MQ',
        'code_3': 'MTQ',
        'continent': 'North America',
        'country': 'Martinique',
        'num': '474'},
    'Mauritania': {
        'code_2': 'MR',
        'code_3': 'MRT',
        'continent': 'Africa',
        'country': 'Mauritania',
        'num': '478'},
    'Mauritius': {
        'code_2': 'MU',
        'code_3': 'MUS',
        'continent': 'Africa',
        'country': 'Mauritius',
        'num': '480'},
    'Mayotte': {
        'code_2': 'YT',
        'code_3': 'MYT',
        'continent': 'Africa',
        'country': 'Mayotte',
        'num': '175'},
    'Mexico': {
        'code_2': 'MX',
        'code_3': 'MEX',
        'continent': 'North America',
        'country': 'Mexico',
        'num': '484'},
    'Micronesia': {
        'code_2': 'FM',
        'code_3': 'FSM',
        'continent': 'Oceania',
        'country': 'Micronesia',
        'num': '583'},
    'Moldova': {
        'code_2': 'MD',
        'code_3': 'MDA',
        'continent': 'Europe',
        'country': 'Moldova',
        'num': '498'},
    'Monaco': {
        'code_2': 'MC',
        'code_3': 'MCO',
        'continent': 'Europe',
        'country': 'Monaco',
        'num': '492'},
    'Mongolia': {
        'code_2': 'MN',
        'code_3': 'MNG',
        'continent': 'Asia',
        'country': 'Mongolia',
        'num': '496'},
    'Montenegro': {
        'code_2': 'ME',
        'code_3': 'MNE',
        'continent': 'Europe',
        'country': 'Montenegro',
        'num': '499'},
    'Montserrat': {
        'code_2': 'MS',
        'code_3': 'MSR',
        'continent': 'North America',
        'country': 'Montserrat',
        'num': '500'},
    'Morocco': {
        'code_2': 'MA',
        'code_3': 'MAR',
        'continent': 'Africa',
        'country': 'Morocco',
        'num': '504'},
    'Mozambique': {
        'code_2': 'MZ',
        'code_3': 'MOZ',
        'continent': 'Africa',
        'country': 'Mozambique',
        'num': '508'},
    'Myanmar': {
        'code_2': 'MM',
        'code_3': 'MMR',
        'continent': 'Asia',
        'country': 'Myanmar',
        'num': '104'},
    'Namibia': {
        'code_2': 'NA',
        'code_3': 'NAM',
        'continent': 'Africa',
        'country': 'Namibia',
        'num': '516'},
    'Nauru': {
        'code_2': 'NR',
        'code_3': 'NRU',
        'continent': 'Oceania',
        'country': 'Nauru',
        'num': '520'},
    'Nepal': {
        'code_2': 'NP',
        'code_3': 'NPL',
        'continent': 'Asia',
        'country': 'Nepal',
        'num': '524'},
    'Netherlands Antilles': {
        'code_2': 'AN',
        'code_3': 'ANT',
        'continent': 'North America',
        'country': 'Netherlands Antilles',
        'num': '530'},
    'Netherlands the': {
        'code_2': 'NL',
        'code_3': 'NLD',
        'continent': 'Europe',
        'country': 'Netherlands the',
        'num': '528'},
    'New Caledonia': {
        'code_2': 'NC',
        'code_3': 'NCL',
        'continent': 'Oceania',
        'country': 'New Caledonia',
        'num': '540'},
    'New Zealand': {
        'code_2': 'NZ',
        'code_3': 'NZL',
        'continent': 'Oceania',
        'country': 'New Zealand',
        'num': '554'},
    'Nicaragua': {
        'code_2': 'NI',
        'code_3': 'NIC',
        'continent': 'North America',
        'country': 'Nicaragua',
        'num': '558'},
    'Niger': {
        'code_2': 'NE',
        'code_3': 'NER',
        'continent': 'Africa',
        'country': 'Niger',
        'num': '562'},
    'Nigeria': {
        'code_2': 'NG',
        'code_3': 'NGA',
        'continent': 'Africa',
        'country': 'Nigeria',
        'num': '566'},
    'Niue': {
        'code_2': 'NU',
        'code_3': 'NIU',
        'continent': 'Oceania',
        'country': 'Niue',
        'num': '570'},
    'Norfolk Island': {
        'code_2': 'NF',
        'code_3': 'NFK',
        'continent': 'Oceania',
        'country': 'Norfolk Island',
        'num': '574'},
    'Northern Mariana Islands': {
        'code_2': 'MP',
        'code_3': 'MNP',
        'continent': 'Oceania',
        'country': 'Northern Mariana Islands',
        'num': '580'},
    'Norway': {
        'code_2': 'NO',
        'code_3': 'NOR',
        'continent': 'Europe',
        'country': 'Norway',
        'num': '578'},
    'Oman': {
        'code_2': 'OM',
        'code_3': 'OMN',
        'continent': 'Asia',
        'country': 'Oman',
        'num': '512'},
    'Pakistan': {
        'code_2': 'PK',
        'code_3': 'PAK',
        'continent': 'Asia',
        'country': 'Pakistan',
        'num': '586'},
    'Palau': {
        'code_2': 'PW',
        'code_3': 'PLW',
        'continent': 'Oceania',
        'country': 'Palau',
        'num': '585'},
    'Palestinian': {
        'code_2': 'PS',
        'code_3': 'PSE',
        'continent': 'Asia',
        'country': 'Palestinian',
        'num': '275'},
    'Panama': {
        'code_2': 'PA',
        'code_3': 'PAN',
        'continent': 'North America',
        'country': 'Panama',
        'num': '591'},
    'Papua New Guinea': {
        'code_2': 'PG',
        'code_3': 'PNG',
        'continent': 'Oceania',
        'country': 'Papua New Guinea',
        'num': '598'},
    'Paraguay': {
        'code_2': 'PY',
        'code_3': 'PRY',
        'continent': 'South America',
        'country': 'Paraguay',
        'num': '600'},
    'Peru': {
        'code_2': 'PE',
        'code_3': 'PER',
        'continent': 'South America',
        'country': 'Peru',
        'num': '604'},
    'Philippines the': {
        'code_2': 'PH',
        'code_3': 'PHL',
        'continent': 'Asia',
        'country': 'Philippines the',
        'num': '608'},
    'Pitcairn Islands': {
        'code_2': 'PN',
        'code_3': 'PCN',
        'continent': 'Oceania',
        'country': 'Pitcairn Islands',
        'num': '612'},
    'Poland': {
        'code_2': 'PL',
        'code_3': 'POL',
        'continent': 'Europe',
        'country': 'Poland',
        'num': '616'},
    'Portugal': {
        'code_2': 'PT',
        'code_3': 'PRT',
        'continent': 'Europe',
        'country': 'Portugal',
        'num': '620'},
    'Puerto Rico': {
        'code_2': 'PR',
        'code_3': 'PRI',
        'continent': 'North America',
        'country': 'Puerto Rico',
        'num': '630'},
    'Qatar': {
        'code_2': 'QA',
        'code_3': 'QAT',
        'continent': 'Asia',
        'country': 'Qatar',
        'num': '634'},
    'Reunion': {
        'code_2': 'RE',
        'code_3': 'REU',
        'continent': 'Africa',
        'country': 'Reunion',
        'num': '638'},
    'Romania': {
        'code_2': 'RO',
        'code_3': 'ROU',
        'continent': 'Europe',
        'country': 'Romania',
        'num': '642'},
    'Russian Federation': {
        'code_2': 'RU',
        'code_3': 'RUS',
        'continent': 'Europe',
        'country': 'Russian Federation',
        'num': '643'},
    'Rwanda': {
        'code_2': 'RW',
        'code_3': 'RWA',
        'continent': 'Africa',
        'country': 'Rwanda',
        'num': '646'},
    'Saint Barthelemy': {
        'code_2': 'BL',
        'code_3': 'BLM',
        'continent': 'North America',
        'country': 'Saint Barthelemy',
        'num': '652'},
    'Saint Helena': {
        'code_2': 'SH',
        'code_3': 'SHN',
        'continent': 'Africa',
        'country': 'Saint Helena',
        'num': '654'},
    'Saint Kitts and Nevis': {
        'code_2': 'KN',
        'code_3': 'KNA',
        'continent': 'North America',
        'country': 'Saint Kitts and Nevis',
        'num': '659'},
    'Saint Lucia': {
        'code_2': 'LC',
        'code_3': 'LCA',
        'continent': 'North America',
        'country': 'Saint Lucia',
        'num': '662'},
    'Saint Martin': {
        'code_2': 'MF',
        'code_3': 'MAF',
        'continent': 'North America',
        'country': 'Saint Martin',
        'num': '663'},
    'Saint Pierre and Miquelon': {
        'code_2': 'PM',
        'code_3': 'SPM',
        'continent': 'North America',
        'country': 'Saint Pierre and Miquelon',
        'num': '666'},
    'Saint Vincent and the Grenadines': {
        'code_2': 'VC',
        'code_3': 'VCT',
        'continent': 'North America',
        'country': 'Saint Vincent and the   Grenadines',
        'num': '670'},
    'Samoa': {
        'code_2': 'WS',
        'code_3': 'WSM',
        'continent': 'Oceania',
        'country': 'Samoa',
        'num': '882'},
    'San Marino': {
        'code_2': 'SM',
        'code_3': 'SMR',
        'continent': 'Europe',
        'country': 'San Marino',
        'num': '674'},
    'Sao Tome and Principe': {
        'code_2': 'ST',
        'code_3': 'STP',
        'continent': 'Africa',
        'country': 'Sao Tome and Principe',
        'num': '678'},
    'Saudi Arabia': {
        'code_2': 'SA',
        'code_3': 'SAU',
        'continent': 'Asia',
        'country': 'Saudi Arabia',
        'num': '682'},
    'Senegal': {
        'code_2': 'SN',
        'code_3': 'SEN',
        'continent': 'Africa',
        'country': 'Senegal',
        'num': '686'},
    'Serbia': {
        'code_2': 'RS',
        'code_3': 'SRB',
        'continent': 'Europe',
        'country': 'Serbia',
        'num': '688'},
    'Seychelles': {
        'code_2': 'SC',
        'code_3': 'SYC',
        'continent': 'Africa',
        'country': 'Seychelles',
        'num': '690'},
    'Sierra Leone': {
        'code_2': 'SL',
        'code_3': 'SLE',
        'continent': 'Africa',
        'country': 'Sierra Leone',
        'num': '694'},
    'Singapore': {
        'code_2': 'SG',
        'code_3': 'SGP',
        'continent': 'Asia',
        'country': 'Singapore',
        'num': '702'},
    'Sint Maarten (Netherlands)': {
        'code_2': 'SX',
        'code_3': 'SXM',
        'continent': 'North America',
        'country': 'Sint Maarten (Netherlands)',
        'num': '534'},
    'Slovakia': {
        'code_2': 'SK',
        'code_3': 'SVK',
        'continent': 'Europe',
        'country': 'Slovakia',
        'num': '703'},
    'Slovenia': {
        'code_2': 'SI',
        'code_3': 'SVN',
        'continent': 'Europe',
        'country': 'Slovenia',
        'num': '705'},
    'Solomon Islands': {
        'code_2': 'SB',
        'code_3': 'SLB',
        'continent': 'Oceania',
        'country': 'Solomon Islands',
        'num': '90'},
    'Somalia': {
        'code_2': 'SO',
        'code_3': 'SOM',
        'continent': 'Africa',
        'country': 'Somalia',
        'num': '706'},
    'South Africa': {
        'code_2': 'ZA',
        'code_3': 'ZAF',
        'continent': 'Africa',
        'country': 'South Africa',
        'num': '710'},
    'South Georgia and the South Sandwich Islands': {
        'code_2': 'GS',
        'code_3': 'SGS',
        'continent': 'Antarctica',
        'country': 'South Georgia and the South Sandwich Islands',
        'num': '239'},
    'South Sudan': {
        'code_2': 'SS',
        'code_3': 'SSD',
        'continent': 'Africa',
        'country': 'South Sudan',
        'num': '728'},
    'Spain': {
        'code_2': 'ES',
        'code_3': 'ESP',
        'continent': 'Europe',
        'country': 'Spain',
        'num': '724'},
    'Spratly Islands': {
        'code_2': 'XS',
        'code_3': 'null',
        'continent': 'Asia',
        'country': 'Spratly Islands',
        'num': 'null'},
    'Sri Lanka': {
        'code_2': 'LK',
        'code_3': 'LKA',
        'continent': 'Asia',
        'country': 'Sri Lanka',
        'num': '144'},
    'Sudan': {
        'code_2': 'SD',
        'code_3': 'SDN',
        'continent': 'Africa',
        'country': 'Sudan',
        'num': '736'},
    'Suricountry': {
        'code_2': 'SR',
        'code_3': 'SUR',
        'continent': 'South America',
        'country': 'Suricountry',
        'num': '740'},
    'Svalbard & Jan Mayen Islands': {
        'code_2': 'SJ',
        'code_3': 'SJM',
        'continent': 'Europe',
        'country': 'Svalbard & Jan Mayen Islands',
        'num': '744'},
    'Swaziland': {
        'code_2': 'SZ',
        'code_3': 'SWZ',
        'continent': 'Africa',
        'country': 'Swaziland',
        'num': '748'},
    'Sweden': {
        'code_2': 'SE',
        'code_3': 'SWE',
        'continent': 'Europe',
        'country': 'Sweden',
        'num': '752'},
    'Switzerland': {
        'code_2': 'CH',
        'code_3': 'CHE',
        'continent': 'Europe',
        'country': 'Switzerland',
        'num': '756'},
    'Syrian Arab Republic': {
        'code_2': 'SY',
        'code_3': 'SYR',
        'continent': 'Asia',
        'country': 'Syrian Arab Republic',
        'num': '760'},
    'Taiwan': {
        'code_2': 'TW',
        'code_3': 'TWN',
        'continent': 'Asia',
        'country': 'Taiwan',
        'num': '158'},
    'Tajikistan': {
        'code_2': 'TJ',
        'code_3': 'TJK',
        'continent': 'Asia',
        'country': 'Tajikistan',
        'num': '762'},
    'Tanzania': {
        'code_2': 'TZ',
        'code_3': 'TZA',
        'continent': 'Africa',
        'country': 'Tanzania',
        'num': '834'},
    'Thailand': {
        'code_2': 'TH',
        'code_3': 'THA',
        'continent': 'Asia',
        'country': 'Thailand',
        'num': '764'},
    'Timor-Leste': {
        'code_2': 'TL',
        'code_3': 'TLS',
        'continent': 'Asia',
        'country': 'Timor-Leste',
        'num': '626'},
    'Togo': {
        'code_2': 'TG',
        'code_3': 'TGO',
        'continent': 'Africa',
        'country': 'Togo',
        'num': '768'},
    'Tokelau': {
        'code_2': 'TK',
        'code_3': 'TKL',
        'continent': 'Oceania',
        'country': 'Tokelau',
        'num': '772'},
    'Tonga': {
        'code_2': 'TO',
        'code_3': 'TON',
        'continent': 'Oceania',
        'country': 'Tonga',
        'num': '776'},
    'Trinidad and Tobago': {
        'code_2': 'TT',
        'code_3': 'TTO',
        'continent': 'North America',
        'country': 'Trinidad and Tobago',
        'num': '780'},
    'Tunisia': {
        'code_2': 'TN',
        'code_3': 'TUN',
        'continent': 'Africa',
        'country': 'Tunisia',
        'num': '788'},
    'Turkey': {
        'code_2': 'TR',
        'code_3': 'TUR',
        'continent': 'Europe',
        'country': 'Turkey',
        'num': '792'},
    'Turkmenistan': {
        'code_2': 'TM',
        'code_3': 'TKM',
        'continent': 'Asia',
        'country': 'Turkmenistan',
        'num': '795'},
    'Turks and Caicos Islands': {
        'code_2': 'TC',
        'code_3': 'TCA',
        'continent': 'North America',
        'country': 'Turks and Caicos Islands',
        'num': '796'},
    'Tuvalu': {
        'code_2': 'TV',
        'code_3': 'TUV',
        'continent': 'Oceania',
        'country': 'Tuvalu',
        'num': '798'},
    'Uganda': {
        'code_2': 'UG',
        'code_3': 'UGA',
        'continent': 'Africa',
        'country': 'Uganda',
        'num': '800'},
    'Ukraine': {
        'code_2': 'UA',
        'code_3': 'UKR',
        'continent': 'Europe',
        'country': 'Ukraine',
        'num': '804'},
    'United Arab Emirates': {
        'code_2': 'AE',
        'code_3': 'ARE',
        'continent': 'Asia',
        'country': 'United Arab Emirates',
        'num': '784'},
    'United Kingdom': {
        'code_2': 'GB',
        'code_3': 'GBR',
        'continent': 'Europe',
        'country': 'United Kingdom',
        'num': '826'},
    'United States Minor Outlying Islands': {
        'code_2': 'UM',
        'code_3': 'UMI',
        'continent': 'Oceania',
        'country': 'United States Minor Outlying Islands',
        'num': '581'},
    'United States Virgin Islands': {
        'code_2': 'VI',
        'code_3': 'VIR',
        'continent': 'North America',
        'country': 'United States Virgin Islands',
        'num': '850'},
    'United States of America': {
        'code_2': 'US',
        'code_3': 'USA',
        'continent': 'North America',
        'country': 'United States of America',
        'num': '840'},
    'Uruguay': {
        'code_2': 'UY',
        'code_3': 'URY',
        'continent': 'South America',
        'country': 'Uruguay',
        'num': '858'},
    'Uzbekistan': {
        'code_2': 'UZ',
        'code_3': 'UZB',
        'continent': 'Asia',
        'country': 'Uzbekistan',
        'num': '860'},
    'Vanuatu': {
        'code_2': 'VU',
        'code_3': 'VUT',
        'continent': 'Oceania',
        'country': 'Vanuatu',
        'num': '548'},
    'Venezuela': {
        'code_2': 'VE',
        'code_3': 'VEN',
        'continent': 'South America',
        'country': 'Venezuela',
        'num': '862'},
    'Vietnam': {
        'code_2': 'VN',
        'code_3': 'VNM',
        'continent': 'Asia',
        'country': 'Vietnam',
        'num': '704'},
    'Wallis and Futuna': {
        'code_2': 'WF',
        'code_3': 'WLF',
        'continent': 'Oceania',
        'country': 'Wallis and Futuna',
        'num': '876'},
    'Western Sahara': {
        'code_2': 'EH',
        'code_3': 'ESH',
        'continent': 'Africa',
        'country': 'Western Sahara',
        'num': '732'},
    'Yemen': {
        'code_2': 'YE',
        'code_3': 'YEM',
        'continent': 'Asia',
        'country': 'Yemen',
        'num': '887'},
    'Zambia': {
        'code_2': 'ZM',
        'code_3': 'ZMB',
        'continent': 'Africa',
        'country': 'Zambia',
        'num': '894'},
    'Zimbabwe': {
        'code_2': 'ZW',
        'code_3': 'ZWE',
        'continent': 'Africa',
        'country': 'Zimbabwe',
        'num': '716'},
    'Åland Islands': {
        'code_2': 'AX',
        'code_3': 'ALA',
        'continent': 'Europe',
        'country': 'Åland Islands',
        'num': '248'}
}
