![PyPI Downloads](https://img.shields.io/badge/downloads-50k-blue)
![PyPI](https://img.shields.io/pypi/v/cosmotalker.svg)
[![Socket Badge](https://socket.dev/api/badge/pypi/package/cosmotalker/1.5.1?artifact_id=tar-gz)](https://socket.dev/pypi/package/cosmotalker/overview)
[![License](https://img.shields.io/badge/license-MIT-blue.svg )](https://github.com/bhuvanesh-m-dev/cosmotalker/blob/main/document/LICENSE )
[![Last Commit](https://img.shields.io/github/last-commit/bhuvanesh-m-dev/cosmotalker)](https://github.com/bhuvanesh-m-dev/cosmotalker)
[![Issues](https://img.shields.io/github/issues/bhuvanesh-m-dev/cosmotalker)](https://github.com/bhuvanesh-m-dev/cosmotalker/issues)
[![Stars](https://img.shields.io/github/stars/bhuvanesh-m-dev/cosmotalker)](https://github.com/bhuvanesh-m-dev/cosmotalker/stargazers)
[![Made with Python](https://img.shields.io/badge/Made%20with-Python-blue?logo=python)](https://www.python.org/)  
 [![Typing SVG](https://readme-typing-svg.herokuapp.com?font=Fira+Code&duration=6000&pause=1000&color=DCBDF7&multiline=true&width=460&height=150&lines=Offline+heart%2C+cosmic+art%E2%80%94;Planets+whisper%2C+searches+spark.;Images+bloom%2C+green+quests+ignite%2C;No+net%2C+just+stars+in+terminal+light.;For+coders%2C+dreamers%2C+minds+that+soar%E2%80%94;The+universe%2C+now+at+your+core.)](https://git.io/typing-svg)

# ✨ Welcome to CosmoTalker v2 – Now Smarter, Broader, and Even More User-Friendly!

🚀 **CosmoTalker v2** is officially here!
Explore the **Solar System** and beyond with this **offline-Python library**, now enhanced with a **beta image preview tool**, **advanced search**, **user-friendly functions**, and **real-time space data**.

> ✅ Now ready for **Debian-based Linux systems** via `Cosmo4U`
> 📌 `.apk` for **Android** and `.exe` for **Windows** are rolling out soon!

---   
## 🎥 See CosmoTalker in Motion
<p align="center">
  <a href="https://www.youtube.com/watch?v=71eGpymB1zE" target="_blank">
    <img src="https://img.youtube.com/vi/71eGpymB1zE/maxresdefault.jpg" alt="CosmoTalker Demo Video" width="600">
  </a>
</p>

<p align="center">
  <a href="https://www.youtube.com/watch?v=71eGpymB1zE" target="_blank">▶️ Watch CosmoTalker Demo on YouTube</a>
</p>   

---   
## 🏆 Recognition & Awards

### Best Project Award – TASS (Tamil Nadu Astronomy and Space Science Society) via YASSC 2025  

![Award Badge](https://img.shields.io/badge/TASS-YASSC%202025%20Best%20Project-brightgreen?style=for-the-badge&logo=google-scholar) ![Moon Man of India](https://img.shields.io/badge/Honoured%20by-Moon%20Man%20of%20India-blue?style=for-the-badge&logo=rocket)

- [**CosmoTalker**](https://github.com/bhuvanesh-m-dev/cosmotalker) was selected as the **Best Project** at the *Youth Astronomy and Space Science Congress (YASSC 2025)*.  

- Honoured with a **tribute medal** by the [**Moon Man of India**](https://en.wikipedia.org/wiki/Mylswamy_Annadurai) — the distinguished ISRO scientist who directed **Chandrayaan-1, Chandrayaan-2, and Mangalyaan (Mars Orbiter Mission)**.  

- 📖 Read the full coverage on [Dev.to](https://dev.to/bhuvaneshm_dev/cosmotalker-wins-best-project-at-tass-from-yassc-3a7n).  

- 📹 **Video Proof**:  
  - [LinkedIn Post](https://lnkd.in/dnwmfdg4)  
  - [Direct Video Proof](https://www.youtube.com/shorts/HLuEGEogcEM)  

- 📷 **Memories from YASSC 2025**:  
  - [Event Gallery & Photos with Scientists ](https://lnkd.in/dK2xZTbX)  

---   

**CosmoTalker** is a Python library developed by **[Bhuvanesh M](https://linkedin.com/in/bhuvaneshm-developer)** to bring **space exploration, astronomy data, and scientific facts** directly to your system — no internet required for core features.

Perfect for **space lovers**, **students**, and **offline learners**. All core info is bundled with the module, while online features like space news and real-time updates extend the experience.

---

## 🚀 What's New in v2?

* 🦠 **Improved Solar System Module**
* 🔎 **Enhanced deep search algorithm**
* 📸 **Beta image function** to preview and save cosmic visuals
* 📖 **New wiki summary tool** with fetch speed tracking
* 🔭 **Cosmic event tracker** for SpaceX & satellite data
* 🌐 More intuitive commands for easier interaction

---

## 🔧 Features

* 🌍 Get planet data: `cosmotalker.get("mars")`
* 🔬 Learn science facts: `cosmotalker.get("gravity")`
* 🌐 Perform searches using eco-friendly search: `cosmotalker.search("your query")`
* 📡 Fetch space updates from CelesTrak, NASA APOD, SpaceX, and more
* 📷 Download astronomy images: `cosmotalker.img()` (beta)
* 💼 Wikipedia-powered summaries: `cosmotalker.wiki("black hole")`
* ✅ Works fully **offline** for core data

> 🌱 Eco-friendly search using **Ecosia** (supports tree planting)

---

## 🛆 Installation

```bash
pip install cosmotalker
```

> ✅ Compatible with Python 3.6+

### 🐿 Linux Users:

Install **Cosmo4U** for Debian-based distros (Ubuntu, Kali, Parrot):

Download Cosmo4U from the internet via this URL:
➡️ **[https://bhuvaneshm.in/cosmo4u](https://bhuvaneshm.in/cosmo4u)**

Enjoy Cosmo4U on your Debian system and explore the universe offline!

> 🛠️ Coming Soon:
>
> * 📱 `CosmoTalker.apk` for Android
> * 💻 `CosmoTalker.exe` for Windows

---

## 🧪 Usage Example

```python
import cosmotalker

print(cosmotalker.get("earth"))           # Offline solar system data
print(cosmotalker.feedback())             # Send feedback
print(cosmotalker.apod())                 # Astronomy Picture of the Day
print(cosmotalker.celestrak())            # Satellite tracking
print(cosmotalker.search("yt"))           # Open YouTube in browser
print(cosmotalker.search("words"))        # Eco-friendly web search and download Cosmo4U at bhuvaneshm.in/cosmo4u
print(cosmotalker.get("gravity"))         # Deep science query
print(cosmotalker.spacex())               # SpaceX launch data
print(cosmotalker.wiki("black hole"))     # Wikipedia summary
print(cosmotalker.img())                  # Image viewer (Beta)
```

> 💡 Use `cosmotalker.search()` shortcuts:
> `yt` = YouTube, `wa` = WhatsApp, `gpt` = ChatGPT, `insta`, `fb`, etc.

---

## 🚁 Benchmark Results

```
Offline Response Times:
0.00078s
0.00072s
0.00075s
0.00073s
...
```

---

## 🌐 Project Links

* 🔗 **Explore More**: [bhuvaneshm.in/cosmotalker](https://bhuvaneshm.in/cosmotalker)
* ⭐ **Star the Repo**: [github.com/bhuvanesh-m-dev/cosmotalker](https://github.com/bhuvanesh-m-dev/cosmotalker)

---

## 👨‍💻 Developed By

**Bhuvanesh M**
🚀 CSE Student | 🎐 Astronomy Enthusiast | 🐧 Linux Dev | 🐍 Python Coder

### 🔗 Connect:

* **Portfolio**: [bhuvaneshm.in](https://bhuvaneshm.in/)
* **GitHub**: [@bhuvanesh-m-dev](https://github.com/bhuvanesh-m-dev)
* **LinkedIn**: [bhuvaneshm-developer](https://linkedin.com/in/bhuvaneshm-developer)
* **HackerRank**: [bhuvaneshm\_dev](https://hackerrank.com/profile/bhuvaneshm_dev)
* **YouTube**: [@bhuvaneshm\_dev](https://youtube.com/@bhuvaneshm_dev)
* **LeetCode**: [bhuvaneshm\_dev](https://leetcode.com/u/bhuvaneshm_dev)
* **Dev.to**: [@bhuvaneshm\_dev](https://dev.to/bhuvaneshm_dev)
* **Twitter (X)**: [@bhuvaneshm06](https://x.com/bhuvaneshm06)
* **Instagram**: [@bhuvanesh.m06](https://instagram.com/bhuvanesh.m06)

---

## ✨ Update: `get()` Rebranded as `info()`

The `get()` function is being rebranded to `info()` in upcoming versions.

> 💡 The **new** `info()` **function** will offer:
>
> * Cleaner and more relevant results
> * Enhanced precision
> * Better support for scientific and factual queries

## 🌟 Introducing the Brand New `get()` Function!

🚀 CosmoTalker v2 now features the **revamped `get()` function**, designed to deliver **accurate answers** for your keyword queries in **milliseconds**! Whether you're exploring planets, scientific concepts, or cosmic phenomena, `get()` provides **precise, reliable results** with lightning-fast performance.

### ✨ Why `get()` Stands Out
- **Pinpoint Accuracy**: Returns the most relevant information for your keyword.
- **Blazing Speed**: Responses in ~0.0007 seconds, thanks to optimized offline data processing.
- **Versatile Queries**: Supports queries like planets (`get("mars")`), science facts (`get("gravity")`), and more.
- **Offline Ready**: Core data is bundled, so no internet is needed for most queries.

### 🧪 Example Usage
```python
import cosmotalker

print(cosmotalker.get("earth"))    # Instant data about Earth

#Stay tuned for future enhancements!
```

## 🐧 Install CosmoTalker on Debian/Ubuntu

```bash
sudo apt update && sudo apt install python3-pip -y && pip3 install cosmotalker
```

### 📈 PyPI Downloads Stats

![PyPI - Downloads](https://static.pepy.tech/badge/cosmotalker)  
**Note:** The above badge shows **lifetime downloads** via [pepy.tech](https://pepy.tech/project/cosmotalker).  
However, pepy updates downloads based on a rolling 3-month window, which may show slower growth over time.

---

### 🔍 Accurate Stats (Manual + Screenshot Proof)

I manually track and verify download numbers through multiple sources.  
Below is the manually updated table reflecting actual downloads over time:

| Date       | Total Downloads | Source                    |
|------------|------------------|---------------------------|
| 2024-03-15 | 1.2K             | Initial Launch Week       |
| 2024-06-28 | 21.2K            | Pepy      |
| 2024-07-29 | ~25K (approx)    | Verified with initial source     |

---

📂 **Proof Screenshots Directory**  
You can view proof and mirror screenshots from the following URL:  
➡️ [https://github.com/bhuvanesh-m-dev/cosmotalker/tree/main/document/screenshots](https://github.com/bhuvanesh-m-dev/cosmotalker/tree/main/document/screenshots)

_This directory will be updated periodically with accurate screenshots showing growth, mirror proof (like aliyun, tencent, etc.), and manual logs._

---

🔗 **Mirror Source Example:**  
Aliyun PyPI Mirror for CosmoTalker:  
➡️ [https://mirrors.aliyun.com/pypi/simple/cosmotalker/](https://mirrors.aliyun.com/pypi/simple/cosmotalker/)

---    

### 📎 Additional Sources Used

- [pepy.tech/project/cosmotalker](https://pepy.tech/project/cosmotalker)  
- [pypistats.org/packages/cosmotalker](https://pypistats.org/packages/cosmotalker)
- [https://mirrors.aliyun.com/pypi/simple/cosmotalker](https://github.com/bhuvanesh-m-dev/cosmotalker/blob/main/document/downloads/README.md)
- PyPI mirrors (aliyun, tencent, pypi.python.org analytics)

---

✅ This ensures transparent and trustworthy tracking of **CosmoTalker**'s growth.

---   
## 💬 Offline Chat with `oolit()`

**CosmoTalker** now includes `oolit()`, a fully offline chat interface.

- **Chat without internet**: Interact with CosmoTalker's knowledge base.
- **Easy to use**: Just import and run `cosmotalker.oolit()`.

### Example
```python
import cosmotalker

cosmotalker.oolit()
```

---

