"""
Currency and network display names for NowPayments.

Maps currency codes and network codes to human-readable names.
"""

# Base currency display names
CURRENCY_NAMES = {
    # Major cryptocurrencies
    'BTC': 'Bitcoin',
    'ETH': 'Ethereum',
    'USDT': 'Tether USD',
    'USDC': 'USD Coin',
    'BNB': 'Binance Coin',
    'ADA': 'Cardano',
    'DOT': 'Polkadot',
    'MATIC': 'Polygon',
    'AVAX': 'Avalanche',
    'SOL': 'Solana',
    'LTC': 'Litecoin',
    'BCH': 'Bitcoin Cash',
    'XRP': 'Ripple',
    'DOGE': 'Dogecoin',
    'ATOM': 'Cosmos',
    'LINK': 'Chainlink',
    'UNI': 'Uniswap',
    'AAVE': 'Aave',
    'COMP': 'Compound',
    'MKR': 'Maker',
    'SNX': 'Synthetix',
    'YFI': 'yearn.finance',
    'SUSHI': 'SushiSwap',
    'CRV': 'Curve DAO Token',
    'BAL': 'Balancer',
    'REN': 'Ren',
    'KNC': 'Kyber Network',
    'ZRX': '0x',
    'BAT': 'Basic Attention Token',
    'ENJ': 'Enjin Coin',
    'MANA': 'Decentraland',
    'SAND': 'The Sandbox',
    'AXS': 'Axie Infinity',
    'FTM': 'Fantom',
    'ONE': 'Harmony',
    'NEAR': 'NEAR Protocol',
    'ALGO': 'Algorand',
    'XTZ': 'Tezos',
    'EOS': 'EOS',
    'TRX': 'TRON',
    'VET': 'VeChain',
    'THETA': 'Theta Network',
    'FIL': 'Filecoin',
    'ICP': 'Internet Computer',
    'HBAR': 'Hedera',
    'EGLD': 'MultiversX',
    'FLOW': 'Flow',
    'XLM': 'Stellar',
    'IOTA': 'IOTA',
    'XMR': 'Monero',
    'ZEC': 'Zcash',
    'DASH': 'Dash',
    'ETC': 'Ethereum Classic',
    'BSV': 'Bitcoin SV',
    'NEO': 'Neo',
    'QTUM': 'Qtum',
    'ZIL': 'Zilliqa',
    'ONT': 'Ontology',
    'ICX': 'ICON',
    'WAVES': 'Waves',
    'LSK': 'Lisk',
    'NANO': 'Nano',
    'DGB': 'DigiByte',
    'RVN': 'Ravencoin',
    'SC': 'Siacoin',
    'DCR': 'Decred',
    'ZEN': 'Horizen',
    'KMD': 'Komodo',
    'STRAT': 'Stratis',
    'ARK': 'Ark',
    'NXT': 'Nxt',
    'BTS': 'BitShares',
    'STEEM': 'Steem',
    'SBD': 'Steem Dollars',
    'GNT': 'Golem',
    'REP': 'Augur',
    'CVC': 'Civic',
    'STORJ': 'Storj',
    'FUN': 'FunFair',
    'DNT': 'district0x',
    'MCO': 'Monaco',
    'MTL': 'Metal',
    'PAY': 'TenX',
    'REQ': 'Request Network',
    'SALT': 'SALT',
    'SUB': 'Substratum',
    'POWR': 'Power Ledger',
    'ENG': 'Enigma',
    'BNT': 'Bancor',
    'FUEL': 'Etherparty',
    'MAID': 'MaidSafeCoin',
    'AMP': 'Synereo',
    'XAS': 'Asch',
    'PPT': 'Populous',
    'PART': 'Particl',
    'CLOAK': 'CloakCoin',
    'BLOCK': 'Blocknet',
    'NAV': 'NavCoin',
    'VIBE': 'VIBE',
    'LUN': 'Lunyr',
    'KIN': 'Kin',
    'TUSD': 'TrueUSD',
    'PAX': 'Paxos Standard',
    'GUSD': 'Gemini Dollar',
    'HUSD': 'HUSD',
    'BUSD': 'Binance USD',
    'DAI': 'Dai Stablecoin',
    'FRAX': 'Frax',
    'LUSD': 'Liquity USD',
    'SUSD': 'sUSD',
    'USDN': 'Neutrino USD',
    'RSR': 'Reserve Rights',
    'AMPL': 'Ampleforth',
    'TRIBE': 'Tribe',
    'FEI': 'Fei USD',
}

# Network display names
NETWORK_NAMES = {
    'eth': 'Ethereum',
    'bsc': 'Binance Smart Chain',
    'matic': 'Polygon',
    'arbitrum': 'Arbitrum',
    'optimism': 'Optimism',
    'avalanche': 'Avalanche',
    'fantom': 'Fantom',
    'harmony': 'Harmony',
    'moonbeam': 'Moonbeam',
    'moonriver': 'Moonriver',
    'celo': 'Celo',
    'gnosis': 'Gnosis Chain',
    'aurora': 'Aurora',
    'cronos': 'Cronos',
    'evmos': 'Evmos',
    'milkomeda': 'Milkomeda',
    'syscoin': 'Syscoin NEVM',
    'metis': 'Metis',
    'boba': 'Boba Network',
    'fuse': 'Fuse',
    'telos': 'Telos EVM',
    'kcc': 'KuCoin Community Chain',
    'heco': 'Huobi ECO Chain',
    'okexchain': 'OKEx Chain',
    'xdai': 'xDai',
    'tron': 'TRON',
    'trx': 'TRON',
    'solana': 'Solana',
    'sol': 'Solana',
    'near': 'NEAR Protocol',
    'algorand': 'Algorand',
    'algo': 'Algorand',
    'cardano': 'Cardano',
    'ada': 'Cardano',
    'polkadot': 'Polkadot',
    'dot': 'Polkadot',
    'kusama': 'Kusama',
    'ksm': 'Kusama',
    'cosmos': 'Cosmos Hub',
    'atom': 'Cosmos Hub',
    'osmosis': 'Osmosis',
    'osmo': 'Osmosis',
    'terra': 'Terra',
    'luna': 'Terra',
    'avalanche': 'Avalanche C-Chain',
    'avax': 'Avalanche C-Chain',
    'bitcoin': 'Bitcoin',
    'btc': 'Bitcoin',
    'litecoin': 'Litecoin',
    'ltc': 'Litecoin',
    'bitcoincash': 'Bitcoin Cash',
    'bch': 'Bitcoin Cash',
    'dogecoin': 'Dogecoin',
    'doge': 'Dogecoin',
    'zcash': 'Zcash',
    'zec': 'Zcash',
    'monero': 'Monero',
    'xmr': 'Monero',
    'dash': 'Dash',
    'stellar': 'Stellar',
    'xlm': 'Stellar',
    'ripple': 'Ripple',
    'xrp': 'Ripple',
    'eos': 'EOS',
    'tezos': 'Tezos',
    'xtz': 'Tezos',
    'iota': 'IOTA',
    'miota': 'IOTA',
    'neo': 'Neo',
    'waves': 'Waves',
    'lisk': 'Lisk',
    'lsk': 'Lisk',
    'nano': 'Nano',
    'digibyte': 'DigiByte',
    'dgb': 'DigiByte',
    'ravencoin': 'Ravencoin',
    'rvn': 'Ravencoin',
    'siacoin': 'Siacoin',
    'sc': 'Siacoin',
    'decred': 'Decred',
    'dcr': 'Decred',
    'horizen': 'Horizen',
    'zen': 'Horizen',
    'komodo': 'Komodo',
    'kmd': 'Komodo',
    'stratis': 'Stratis',
    'strat': 'Stratis',
    'ark': 'Ark',
    'nxt': 'Nxt',
    'bitshares': 'BitShares',
    'bts': 'BitShares',
    'steem': 'Steem',
    'vechain': 'VeChain',
    'vet': 'VeChain',
    'theta': 'Theta Network',
    'filecoin': 'Filecoin',
    'fil': 'Filecoin',
    'internetcomputer': 'Internet Computer',
    'icp': 'Internet Computer',
    'hedera': 'Hedera',
    'hbar': 'Hedera',
    'elrond': 'MultiversX',
    'egld': 'MultiversX',
    'flow': 'Flow',
    'zilliqa': 'Zilliqa',
    'zil': 'Zilliqa',
    'ontology': 'Ontology',
    'ont': 'Ontology',
    'icon': 'ICON',
    'icx': 'ICON',
    'qtum': 'Qtum',
    'ethereumclassic': 'Ethereum Classic',
    'etc': 'Ethereum Classic',
    'bitcoinsv': 'Bitcoin SV',
    'bsv': 'Bitcoin SV',
}
