# tetromino shapes and metadata (kick tables?)

pieces = {
    "i": {
        "name": "i",
        "col": "00FFFF",
        "rgb": (0, 255, 255),
        "piece": [           
            "\x1b[38;2;0;255;255m        \x1b[0m",
            "\x1b[38;2;0;255;255m████████\x1b[0m",
        ],
        "rotations": {
            "0": [
            [0, 0, 0, 0],
            [1, 1, 1, 1],
            [0, 0, 0, 0],
            [0, 0, 0, 0],
            ],
            "r": [
            [0, 0, 1, 0],
            [0, 0, 1, 0],
            [0, 0, 1, 0],
            [0, 0, 1, 0],
            ],
            "2": [
            [0, 0, 0, 0],
            [0, 0, 0, 0],
            [1, 1, 1, 1],
            [0, 0, 0, 0],
            ],
            "l": [
            [0, 1, 0, 0],
            [0, 1, 0, 0],
            [0, 1, 0, 0],
            [0, 1, 0, 0],
            ]
        }
    },
    "j": {
        "name": "j",
        "col": "0000FF",
        "rgb": (0, 0, 255),
        "piece": [
            "\x1b[38;2;0;0;255m ██     \x1b[0m",
            "\x1b[38;2;0;0;255m ██████ \x1b[0m",
        ],
        "rotations": {
            "0": [
            [1, 0, 0],
            [1, 1, 1],
            [0, 0, 0],
            ],
            "r": [
            [0, 1, 1],
            [0, 1, 0],
            [0, 1, 0],
            ],
            "2": [
            [0, 0, 0],
            [1, 1, 1],
            [0, 0, 1],
            ],
            "l": [
            [0, 1, 0],
            [0, 1, 0],
            [1, 1, 0],
            ]
        }
    },
    "l": { 
        "name": "l",
        "col": "FFA500",
        "rgb": (255, 165, 0),
        "piece": [
            "\x1b[38;2;255;165;0m     ██ \x1b[0m",
            "\x1b[38;2;255;165;0m ██████ \x1b[0m",
        ],
        "rotations": {
            "0": [
            [0, 0, 1],
            [1, 1, 1],
            [0, 0, 0],
            ],
            "r": [
            [0, 1, 0],
            [0, 1, 0],
            [0, 1, 1],
            ],
            "2": [
            [0, 0, 0],
            [1, 1, 1],
            [1, 0, 0],
            ],
            "l": [
            [1, 1, 0],
            [0, 1, 0],
            [0, 1, 0],
            ]
        }
    },
    "s": {
        "name": "s",
        "col": "00FF00",
        "rgb": (0, 255, 0),  
        "piece": [
            "\x1b[38;2;0;255;0m   ████ \x1b[0m",
            "\x1b[38;2;0;255;0m ████   \x1b[0m",
        ], 
        "rotations": {
            "0": [
            [0, 1, 1],
            [1, 1, 0],
            [0, 0, 0],
            ],
            "r": [
            [0, 1, 0],
            [0, 1, 1],
            [0, 0, 1],
            ],
            "2": [
            [0, 0, 0],
            [0, 1, 1],
            [1, 1, 0],
            ],
            "l": [
            [1, 0, 0],
            [1, 1, 0],
            [0, 1, 0],
            ]
        }
    },
    "z": {
        "name": "z",     # ██
        "col": "FF0000", #  ██
        "rgb": (255, 0, 0),
        "piece": [
            "\x1b[38;2;255;0;0m ████   \x1b[0m",
            "\x1b[38;2;255;0;0m   ████ \x1b[0m",
        ],
        "rotations": {
            "0": [
            [1, 1, 0],
            [0, 1, 1],
            [0, 0, 0],
            ],
            "r": [
            [0, 0, 1],
            [0, 1, 1],
            [0, 1, 0],
            ],
            "2": [
            [0, 0, 0],
            [1, 1, 0],
            [0, 1, 1],
            ],
            "l": [
            [0, 1, 0],
            [1, 1, 0],
            [1, 0, 0],
            ]
        }
    },
    "t": {
        "name": "t",      #  █
        "col": "800080",  # ███
        "rgb": (128, 0, 128),
        "piece": [
            "\x1b[38;2;128;0;128m   ██   \x1b[0m",
            "\x1b[38;2;128;0;128m ██████ \x1b[0m",
        ],
        "rotations": {
            "0": [
            [0, 1, 0],
            [1, 1, 1],
            [0, 0, 0],
            ],
            "r": [
            [0, 1, 0],
            [0, 1, 1],
            [0, 1, 0],
            ],
            "2": [
            [0, 0, 0],
            [1, 1, 1],
            [0, 1, 0],
            ],
            "l": [
            [0, 1, 0],
            [1, 1, 0],
            [0, 1, 0],
            ]
        }
    },
    "o": {
        "name": "o",      # ██
        "col": "FFFF00",  # ██
        "rgb": (255, 255, 0),
        "piece": [
            "\x1b[38;2;255;255;0m  ████  \x1b[0m",
            "\x1b[38;2;255;255;0m  ████  \x1b[0m",
        ],
        "rotations": { # O spins when
            "0": [
            [0, 1, 1, 0],
            [0, 1, 1, 0],
            ],
            "r": [
            [0, 1, 1, 0],
            [0, 1, 1, 0],
            ],
            "2": [
            [0, 1, 1, 0],
            [0, 1, 1, 0],
            ],
            "l": [
            [0, 1, 1, 0],
            [0, 1, 1, 0],
            ]
        }
    }
}

grades = {
    "9": [
        "\x1b[38;2;112;0;0m ╔══════╗\x1b[39m",
        "\x1b[38;2;112;0;0m ║ ┏━━┓ ║\x1b[39m",
        "\x1b[38;2;112;0;0m ║ ┗━━┫ ║\x1b[39m",
        "\x1b[38;2;112;0;0m ║ ╺━━┛ ║\x1b[39m",
        "\x1b[38;2;112;0;0m ╚══════╝\x1b[39m"
    ],
    "8": [
        "\x1b[38;2;131;57;0m ╔══════╗\x1b[39m",
        "\x1b[38;2;131;57;0m ║ ┏━━┓ ║\x1b[39m",
        "\x1b[38;2;131;57;0m ║ ┣━━┫ ║\x1b[39m",
        "\x1b[38;2;131;57;0m ║ ┗━━┛ ║\x1b[39m",
        "\x1b[38;2;131;57;0m ╚══════╝\x1b[39m"
    ],
    "7": [
        "\x1b[38;2;96;80;0m ╔══════╗\x1b[39m",
        "\x1b[38;2;96;80;0m ║ ┏━━┓ ║\x1b[39m",
        "\x1b[38;2;96;80;0m ║   ━┫ ║\x1b[39m",
        "\x1b[38;2;96;80;0m ║    ╹ ║\x1b[39m",
        "\x1b[38;2;96;80;0m ╚══════╝\x1b[39m"
    ],
    "6": [
        "\x1b[38;2;75;90;0m ╔══════╗\x1b[39m",
        "\x1b[38;2;75;90;0m ║ ┏━━┓ ║\x1b[39m",
        "\x1b[38;2;75;90;0m ║ ┣━━┓ ║\x1b[39m",
        "\x1b[38;2;75;90;0m ║ ┗━━┛ ║\x1b[39m",
        "\x1b[38;2;75;90;0m ╚══════╝\x1b[39m"
    ],
    "5": [
        "\x1b[38;2;26;90;0m ╔══════╗\x1b[39m",
        "\x1b[38;2;26;90;0m ║ ┏━━╸ ║\x1b[39m",
        "\x1b[38;2;26;90;0m ║ ┗━━┓ ║\x1b[39m",
        "\x1b[38;2;26;90;0m ║ ┗━━┛ ║\x1b[39m",
        "\x1b[38;2;26;90;0m ╚══════╝\x1b[39m"
    ],
    "4": [
        "\x1b[38;2;16;72;96m ╔══════╗\x1b[39m",
        "\x1b[38;2;16;72;96m ║ ╻  ╻ ║\x1b[39m",
        "\x1b[38;2;16;72;96m ║ ┗━━┫ ║\x1b[39m",
        "\x1b[38;2;16;72;96m ║    ╹ ║\x1b[39m",
        "\x1b[38;2;16;72;96m ╚══════╝\x1b[39m"
    ],
    "3": [
        "\x1b[38;2;6;21;114m ╔══════╗\x1b[39m",
        "\x1b[38;2;6;21;114m ║ ╺━━┓ ║\x1b[39m",
        "\x1b[38;2;6;21;114m ║ ╺━━┫ ║\x1b[39m",
        "\x1b[38;2;6;21;114m ║ ╺━━┛ ║\x1b[39m",
        "\x1b[38;2;6;21;114m ╚══════╝\x1b[39m"
    ],
    "2": [
        "\x1b[38;2;74;16;100m ╔══════╗\x1b[39m",
        "\x1b[38;2;74;16;100m ║ ┏━━┓ ║\x1b[39m",
        "\x1b[38;2;74;16;100m ║ ┏━━┛ ║\x1b[39m",
        "\x1b[38;2;74;16;100m ║ ┗━━╸ ║\x1b[39m",
        "\x1b[38;2;74;16;100m ╚══════╝\x1b[39m"
    ],
    "1": [
        "\x1b[38;2;98;11;75m ╔══════╗\x1b[39m",
        "\x1b[38;2;98;11;75m ║  ━┃  ║\x1b[39m",
        "\x1b[38;2;98;11;75m ║   ┃  ║\x1b[39m",
        "\x1b[38;2;98;11;75m ║  ━━┛ ║\x1b[39m",
        "\x1b[38;2;98;11;75m ╚══════╝\x1b[39m"
    ],
    "S1": [
        "\x1b[38;2;162;50;50m ╔══════╗\x1b[39m",
        "\x1b[38;2;162;50;50m ║┏━┓╺┓ ║\x1b[39m",
        "\x1b[38;2;162;50;50m ║┗━┓ ┃ ║\x1b[39m",
        "\x1b[38;2;162;50;50m ║┗━┛╺┻╸║\x1b[39m",
        "\x1b[38;2;162;50;50m ╚══════╝\x1b[39m"
    ],
    "S2": [
        "\x1b[38;2;181;107;50m ╔══════╗\x1b[39m",
        "\x1b[38;2;181;107;50m ║┏━┓┏━┓║\x1b[39m",
        "\x1b[38;2;181;107;50m ║┗━┓┏━┛║\x1b[39m",
        "\x1b[38;2;181;107;50m ║┗━┛┗━╸║\x1b[39m",
        "\x1b[38;2;181;107;50m ╚══════╝\x1b[39m"
    ],
    "S3": [
        "\x1b[38;2;146;130;50m ╔══════╗\x1b[39m",
        "\x1b[38;2;146;130;50m ║┏━┓┏━┓║\x1b[39m",
        "\x1b[38;2;146;130;50m ║┗━┓╺━┫║\x1b[39m",
        "\x1b[38;2;146;130;50m ║┗━┛┗━┛║\x1b[39m",
        "\x1b[38;2;146;130;50m ╚══════╝\x1b[39m"
    ],
    "S4": [
        "\x1b[38;2;125;140;50m ╔══════╗\x1b[39m",
        "\x1b[38;2;125;140;50m ║┏━┓╻ ╻║\x1b[39m",
        "\x1b[38;2;125;140;50m ║┗━┓┗━┫║\x1b[39m",
        "\x1b[38;2;125;140;50m ║┗━┛  ╹║\x1b[39m",
        "\x1b[38;2;125;140;50m ╚══════╝\x1b[39m"
    ],
    "S5": [
        "\x1b[38;2;76;140;50m ╔══════╗\x1b[39m",
        "\x1b[38;2;76;140;50m ║┏━┓┏━╸║\x1b[39m",
        "\x1b[38;2;76;140;50m ║┗━┓┗━┓║\x1b[39m",
        "\x1b[38;2;76;140;50m ║┗━┛┗━┛║\x1b[39m",
        "\x1b[38;2;76;140;50m ╚══════╝\x1b[39m"
    ],
    "S6": [
        "\x1b[38;2;66;122;146m ╔══════╗\x1b[39m",
        "\x1b[38;2;66;122;146m ║┏━┓┏━┓║\x1b[39m",
        "\x1b[38;2;66;122;146m ║┗━┓┣━┓║\x1b[39m",
        "\x1b[38;2;66;122;146m ║┗━┛┗━┛║\x1b[39m",
        "\x1b[38;2;66;122;146m ╚══════╝\x1b[39m"
    ],
    "S7": [
        "\x1b[38;2;56;71;164m ╔══════╗\x1b[39m",
        "\x1b[38;2;56;71;164m ║┏━┓┏━┓║\x1b[39m",
        "\x1b[38;2;56;71;164m ║┗━┓ ━┫║\x1b[39m",
        "\x1b[38;2;56;71;164m ║┗━┛  ╹║\x1b[39m",
        "\x1b[38;2;56;71;164m ╚══════╝\x1b[39m"
    ],
    "S8": [
        "\x1b[38;2;124;66;150m ╔══════╗\x1b[39m",
        "\x1b[38;2;124;66;150m ║┏━┓┏━┓║\x1b[39m",
        "\x1b[38;2;124;66;150m ║┗━┓┣━┫║\x1b[39m",
        "\x1b[38;2;124;66;150m ║┗━┛┗━┛║\x1b[39m",
        "\x1b[38;2;124;66;150m ╚══════╝\x1b[39m"
    ],
    "S9": [
        "\x1b[38;2;148;61;125m ╔══════╗\x1b[39m",
        "\x1b[38;2;148;61;125m ║┏━┓┏━┓║\x1b[39m",
        "\x1b[38;2;148;61;125m ║┗━┓┗━┫║\x1b[39m",
        "\x1b[38;2;148;61;125m ║┗━┛┗━┛║\x1b[39m",
        "\x1b[38;2;148;61;125m ╚══════╝\x1b[39m"
    ],
    
    "Gm": [
        "\x1b[38;2;245;191;3m ╔══════╗\x1b[39m",
        "\x1b[38;2;245;191;3m ║┏━┛┏┏ ║\x1b[39m",
        "\x1b[38;2;245;191;3m ║┃ ┃┃┃┃║\x1b[39m",
        "\x1b[38;2;245;191;3m ║━━┛┛┛┛║\x1b[39m",
        "\x1b[38;2;245;191;3m ╚══════╝\x1b[39m",
    ],
}

thresholds = {
    "9": 0,
    "8": 400,
    "7": 800,
    "6": 1400,
    "5": 2000,
    "4": 3500,
    "3": 5500,
    "2": 8000,
    "1": 12000,
    "S1": 16000,
    "S2": 22000,
    "S3": 30000,
    "S4": 40000,
    "S5": 52000,
    "S6": 66000,
    "S7": 82000,
    "S8": 100000,
    "S9": 120000,
}

gravity = {
    0: 4,
    30: 6,
    35: 8,
    40: 10,
    50: 12,
    60: 16,
    70: 32,
    80: 48,
    90: 64,
    100: 80,
    120: 96,
    140: 112,
    160: 128,
    170: 144,
    200: 4,
    220: 32,
    230: 64,
    233: 96,
    236: 128,
    239: 160,
    243: 192,
    247: 224,
    251: 256,
    300: 512,
    330: 768,
    360: 1024,
    400: 1280,
    420: 1024,
    450: 768,
    500: 5120
}

ROT_CW  = {"0": "r", "r": "2", "2": "l", "l": "0"}
ROT_CCW = {"0": "l", "l": "2", "2": "r", "r": "0"}
ROT_180 = {"0": "2", "r": "l", "2": "0", "l": "r"}