# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from agentex import Agentex, AsyncAgentex
from agentex.types import (
    TaskMessage,
    MessageListResponse,
)

from ..utils import assert_matches_type

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestMessages:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_create(self, client: Agentex) -> None:
        message = client.messages.create(
            content={
                "author": "user",
                "content": "content",
                "type": "text",
            },
            task_id="task_id",
        )
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_create_with_all_params(self, client: Agentex) -> None:
        message = client.messages.create(
            content={
                "author": "user",
                "content": "content",
                "attachments": [
                    {
                        "file_id": "file_id",
                        "name": "name",
                        "size": 0,
                        "type": "type",
                    }
                ],
                "format": "markdown",
                "style": "static",
                "type": "text",
            },
            task_id="task_id",
            streaming_status="IN_PROGRESS",
        )
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_create(self, client: Agentex) -> None:
        response = client.messages.with_raw_response.create(
            content={
                "author": "user",
                "content": "content",
                "type": "text",
            },
            task_id="task_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        message = response.parse()
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_create(self, client: Agentex) -> None:
        with client.messages.with_streaming_response.create(
            content={
                "author": "user",
                "content": "content",
                "type": "text",
            },
            task_id="task_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            message = response.parse()
            assert_matches_type(TaskMessage, message, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_retrieve(self, client: Agentex) -> None:
        message = client.messages.retrieve(
            "message_id",
        )
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_retrieve(self, client: Agentex) -> None:
        response = client.messages.with_raw_response.retrieve(
            "message_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        message = response.parse()
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_retrieve(self, client: Agentex) -> None:
        with client.messages.with_streaming_response.retrieve(
            "message_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            message = response.parse()
            assert_matches_type(TaskMessage, message, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_path_params_retrieve(self, client: Agentex) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `message_id` but received ''"):
            client.messages.with_raw_response.retrieve(
                "",
            )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_update(self, client: Agentex) -> None:
        message = client.messages.update(
            message_id="message_id",
            content={
                "author": "user",
                "content": "content",
                "type": "text",
            },
            task_id="task_id",
        )
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_update_with_all_params(self, client: Agentex) -> None:
        message = client.messages.update(
            message_id="message_id",
            content={
                "author": "user",
                "content": "content",
                "attachments": [
                    {
                        "file_id": "file_id",
                        "name": "name",
                        "size": 0,
                        "type": "type",
                    }
                ],
                "format": "markdown",
                "style": "static",
                "type": "text",
            },
            task_id="task_id",
            streaming_status="IN_PROGRESS",
        )
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_update(self, client: Agentex) -> None:
        response = client.messages.with_raw_response.update(
            message_id="message_id",
            content={
                "author": "user",
                "content": "content",
                "type": "text",
            },
            task_id="task_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        message = response.parse()
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_update(self, client: Agentex) -> None:
        with client.messages.with_streaming_response.update(
            message_id="message_id",
            content={
                "author": "user",
                "content": "content",
                "type": "text",
            },
            task_id="task_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            message = response.parse()
            assert_matches_type(TaskMessage, message, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_path_params_update(self, client: Agentex) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `message_id` but received ''"):
            client.messages.with_raw_response.update(
                message_id="",
                content={
                    "author": "user",
                    "content": "content",
                    "type": "text",
                },
                task_id="task_id",
            )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_list(self, client: Agentex) -> None:
        message = client.messages.list(
            task_id="task_id",
        )
        assert_matches_type(MessageListResponse, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_list_with_all_params(self, client: Agentex) -> None:
        message = client.messages.list(
            task_id="task_id",
            limit=0,
            page_number=0,
        )
        assert_matches_type(MessageListResponse, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_list(self, client: Agentex) -> None:
        response = client.messages.with_raw_response.list(
            task_id="task_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        message = response.parse()
        assert_matches_type(MessageListResponse, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_list(self, client: Agentex) -> None:
        with client.messages.with_streaming_response.list(
            task_id="task_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            message = response.parse()
            assert_matches_type(MessageListResponse, message, path=["response"])

        assert cast(Any, response.is_closed) is True


class TestAsyncMessages:
    parametrize = pytest.mark.parametrize(
        "async_client", [False, True, {"http_client": "aiohttp"}], indirect=True, ids=["loose", "strict", "aiohttp"]
    )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_create(self, async_client: AsyncAgentex) -> None:
        message = await async_client.messages.create(
            content={
                "author": "user",
                "content": "content",
                "type": "text",
            },
            task_id="task_id",
        )
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_create_with_all_params(self, async_client: AsyncAgentex) -> None:
        message = await async_client.messages.create(
            content={
                "author": "user",
                "content": "content",
                "attachments": [
                    {
                        "file_id": "file_id",
                        "name": "name",
                        "size": 0,
                        "type": "type",
                    }
                ],
                "format": "markdown",
                "style": "static",
                "type": "text",
            },
            task_id="task_id",
            streaming_status="IN_PROGRESS",
        )
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_create(self, async_client: AsyncAgentex) -> None:
        response = await async_client.messages.with_raw_response.create(
            content={
                "author": "user",
                "content": "content",
                "type": "text",
            },
            task_id="task_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        message = await response.parse()
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_create(self, async_client: AsyncAgentex) -> None:
        async with async_client.messages.with_streaming_response.create(
            content={
                "author": "user",
                "content": "content",
                "type": "text",
            },
            task_id="task_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            message = await response.parse()
            assert_matches_type(TaskMessage, message, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_retrieve(self, async_client: AsyncAgentex) -> None:
        message = await async_client.messages.retrieve(
            "message_id",
        )
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_retrieve(self, async_client: AsyncAgentex) -> None:
        response = await async_client.messages.with_raw_response.retrieve(
            "message_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        message = await response.parse()
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_retrieve(self, async_client: AsyncAgentex) -> None:
        async with async_client.messages.with_streaming_response.retrieve(
            "message_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            message = await response.parse()
            assert_matches_type(TaskMessage, message, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_path_params_retrieve(self, async_client: AsyncAgentex) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `message_id` but received ''"):
            await async_client.messages.with_raw_response.retrieve(
                "",
            )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_update(self, async_client: AsyncAgentex) -> None:
        message = await async_client.messages.update(
            message_id="message_id",
            content={
                "author": "user",
                "content": "content",
                "type": "text",
            },
            task_id="task_id",
        )
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_update_with_all_params(self, async_client: AsyncAgentex) -> None:
        message = await async_client.messages.update(
            message_id="message_id",
            content={
                "author": "user",
                "content": "content",
                "attachments": [
                    {
                        "file_id": "file_id",
                        "name": "name",
                        "size": 0,
                        "type": "type",
                    }
                ],
                "format": "markdown",
                "style": "static",
                "type": "text",
            },
            task_id="task_id",
            streaming_status="IN_PROGRESS",
        )
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_update(self, async_client: AsyncAgentex) -> None:
        response = await async_client.messages.with_raw_response.update(
            message_id="message_id",
            content={
                "author": "user",
                "content": "content",
                "type": "text",
            },
            task_id="task_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        message = await response.parse()
        assert_matches_type(TaskMessage, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_update(self, async_client: AsyncAgentex) -> None:
        async with async_client.messages.with_streaming_response.update(
            message_id="message_id",
            content={
                "author": "user",
                "content": "content",
                "type": "text",
            },
            task_id="task_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            message = await response.parse()
            assert_matches_type(TaskMessage, message, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_path_params_update(self, async_client: AsyncAgentex) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `message_id` but received ''"):
            await async_client.messages.with_raw_response.update(
                message_id="",
                content={
                    "author": "user",
                    "content": "content",
                    "type": "text",
                },
                task_id="task_id",
            )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_list(self, async_client: AsyncAgentex) -> None:
        message = await async_client.messages.list(
            task_id="task_id",
        )
        assert_matches_type(MessageListResponse, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_list_with_all_params(self, async_client: AsyncAgentex) -> None:
        message = await async_client.messages.list(
            task_id="task_id",
            limit=0,
            page_number=0,
        )
        assert_matches_type(MessageListResponse, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_list(self, async_client: AsyncAgentex) -> None:
        response = await async_client.messages.with_raw_response.list(
            task_id="task_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        message = await response.parse()
        assert_matches_type(MessageListResponse, message, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_list(self, async_client: AsyncAgentex) -> None:
        async with async_client.messages.with_streaming_response.list(
            task_id="task_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            message = await response.parse()
            assert_matches_type(MessageListResponse, message, path=["response"])

        assert cast(Any, response.is_closed) is True
