# coding: utf-8

"""
    HPE Machine Learning Inference Software (MLIS/Aioli)

    HPE MLIS is *Aioli* -- The AI On-line Inference Platform that enables easy deployment, tracking, and serving of your packaged models regardless of your preferred AI framework.

    The version of the OpenAPI document: 1.1.0
    Contact: community@determined-ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DeploymentModelVersion(BaseModel):
    """
    The DeploymentModelVersion provides model evolution data that track model deployment changes over time.
    """ # noqa: E501
    canary_traffic_percent: Optional[StrictInt] = Field(default=None, description="Percent traffic to pass to the model.", alias="canaryTrafficPercent")
    deployed: Optional[StrictStr] = Field(default=None, description="The deployment time. This is a read-only field and is automatically assigned on creation.")
    deployment_id: Optional[StrictStr] = Field(default=None, description="The deployment ID", alias="deploymentId")
    deployment_name: Optional[StrictStr] = Field(default=None, description="The deployment name", alias="deploymentName")
    model: Optional[StrictStr] = Field(default=None, description="The name of the model.")
    mdl_id: Optional[StrictStr] = Field(default=None, description="The ID of the model.", alias="modelId")
    mdl_version: Optional[StrictStr] = Field(default=None, description="The version of the model.", alias="modelVersion")
    native_app_name: Optional[StrictStr] = Field(default=None, description="The name of the Kubernetes application for the specific service version. Use this name to match the app value in Grafana/Prometheus to obtain logs and metrics for this deployed service version.", alias="nativeAppName")
    __properties: ClassVar[List[str]] = ["canaryTrafficPercent", "deployed", "deploymentId", "deploymentName", "model", "modelId", "modelVersion", "nativeAppName"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DeploymentModelVersion from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DeploymentModelVersion from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "canaryTrafficPercent": obj.get("canaryTrafficPercent"),
            "deployed": obj.get("deployed"),
            "deploymentId": obj.get("deploymentId"),
            "deploymentName": obj.get("deploymentName"),
            "model": obj.get("model"),
            "modelId": obj.get("modelId"),
            "modelVersion": obj.get("modelVersion"),
            "nativeAppName": obj.get("nativeAppName")
        })
        return _obj


