# coding: utf-8

"""
    HPE Machine Learning Inference Software (MLIS/Aioli)

    HPE MLIS is *Aioli* -- The AI On-line Inference Platform that enables easy deployment, tracking, and serving of your packaged models regardless of your preferred AI framework.

    The version of the OpenAPI document: 1.1.0
    Contact: community@determined-ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
from aiolirest.models.autoscaling import Autoscaling
from aiolirest.models.security import Security
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DeploymentRequest(BaseModel):
    """
    Deployment describes the deployment of a service.
    """ # noqa: E501
    arguments: Optional[List[StrictStr]] = Field(default=None, description="Arguments to be added to the service command line")
    auto_scaling: Optional[Autoscaling] = Field(default=None, alias="autoScaling")
    canary_traffic_percent: Optional[StrictInt] = Field(default=None, description="Percent traffic to pass to new model version", alias="canaryTrafficPercent")
    environment: Optional[Dict[str, StrictStr]] = Field(default=None, description="Environment variables added to the service")
    goal_status: Optional[StrictStr] = Field(default='Ready', description="Specifies the intended status to be achieved by the deployment.  Supported values are: * `Ready` - The inference service will be deployed to enable inference calls. * `Paused` - The inference service will be stopped and no longer accept calls.  The default is `Ready`.", alias="goalStatus")
    model: StrictStr = Field(description="PackagedModel name or ID to be deployed.")
    name: StrictStr = Field(description="The deployment name.  It must be a valid subdomain name and consist of lower case alphanumeric characters, '-' or '.', and must start and end with an alphanumeric character.")
    namespace: Optional[StrictStr] = Field(default=None, description="The Kubernetes namespace to be used for the deployment.")
    security: Optional[Security] = None
    __properties: ClassVar[List[str]] = ["arguments", "autoScaling", "canaryTrafficPercent", "environment", "goalStatus", "model", "name", "namespace", "security"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DeploymentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of auto_scaling
        if self.auto_scaling:
            _dict['autoScaling'] = self.auto_scaling.to_dict()
        # override the default output from pydantic by calling `to_dict()` of security
        if self.security:
            _dict['security'] = self.security.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DeploymentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "arguments": obj.get("arguments"),
            "autoScaling": Autoscaling.from_dict(obj.get("autoScaling")) if obj.get("autoScaling") is not None else None,
            "canaryTrafficPercent": obj.get("canaryTrafficPercent"),
            "environment": obj.get("environment"),
            "goalStatus": obj.get("goalStatus") if obj.get("goalStatus") is not None else 'Ready',
            "model": obj.get("model"),
            "name": obj.get("name"),
            "namespace": obj.get("namespace"),
            "security": Security.from_dict(obj.get("security")) if obj.get("security") is not None else None
        })
        return _obj


