# coding: utf-8

"""
    HPE Machine Learning Inference Software (MLIS/Aioli)

    HPE MLIS is *Aioli* -- The AI On-line Inference Platform that enables easy deployment, tracking, and serving of your packaged models regardless of your preferred AI framework.

    The version of the OpenAPI document: 1.1.0
    Contact: community@determined-ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
from aiolirest.models.failure_info import FailureInfo
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DeploymentState(BaseModel):
    """
    Describes the current state of the deployment as managed by KServe
    """ # noqa: E501
    endpoint: Optional[StrictStr] = Field(default=None, description="Endpoint to access inference service.")
    failure_info: Optional[List[FailureInfo]] = Field(default=None, description="List of any failures that have occurred.", alias="failureInfo")
    mdl_id: Optional[StrictStr] = Field(default=None, description="The ID of the deployed packaged model associcated with this state.", alias="modelId")
    native_app_name: Optional[StrictStr] = Field(default=None, description="The name of the Kubernetes application for the specific service version. Use this name to match the app value in Grafana/Prometheus to obtain logs and metrics for this deployed service version.", alias="nativeAppName")
    status: Optional[StrictStr] = Field(default=None, description="Status of a particular service revision. * `Deploying` - Service configuration is in progress. * `Failed` - The service configuration failed. * `Ready` - The service has been successfully configured and is serving. * `Updating` - A new service revision is being rolledout. * `UpdateFailed` - The current service revision failed to rollout due to an error.   The prior version is still serving requests. * `Deleting` - The deployed service is being removed. * `Paused` - The deployed service has been stopped by the user or an external action. * `Unknown` - Unable to determined the status. * `Canceled` - The specified model version of the deployment was canceled by the user.  The inference service is still active, but serving no requests.  This is a read-only property. Must be one of the values: (Deploying,Ready,Updating,UpdateFailed,Failed,Deleting,Paused,Unknown).")
    traffic_percentage: Optional[StrictInt] = Field(default=None, description="Target percentage of traffic intended for this service version when successfully deployed.", alias="trafficPercentage")
    __properties: ClassVar[List[str]] = ["endpoint", "failureInfo", "modelId", "nativeAppName", "status", "trafficPercentage"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DeploymentState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in failure_info (list)
        _items = []
        if self.failure_info:
            for _item in self.failure_info:
                if _item:
                    _items.append(_item.to_dict())
            _dict['failureInfo'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DeploymentState from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "endpoint": obj.get("endpoint"),
            "failureInfo": [FailureInfo.from_dict(_item) for _item in obj.get("failureInfo")] if obj.get("failureInfo") is not None else None,
            "modelId": obj.get("modelId"),
            "nativeAppName": obj.get("nativeAppName"),
            "status": obj.get("status"),
            "trafficPercentage": obj.get("trafficPercentage")
        })
        return _obj


