# coding: utf-8

"""
    HPE Machine Learning Inference Software (MLIS/Aioli)

    HPE MLIS is *Aioli* -- The AI On-line Inference Platform that enables easy deployment, tracking, and serving of your packaged models regardless of your preferred AI framework.

    The version of the OpenAPI document: 1.1.0
    Contact: community@determined-ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DeploymentToken(BaseModel):
    """
    The DeploymentToken defines the JWT token associated with individual deployment endpoint for a given user. When the model is deployed with authorizationRequired=true, the deployment token enables authenticated access to the deployed inference service API for a given user.
    """ # noqa: E501
    deployment: Optional[StrictStr] = Field(default=None, description="The deployment name")
    deployment_id: Optional[StrictStr] = Field(default=None, description="The deployment id", alias="deploymentID")
    description: Optional[StrictStr] = Field(default=None, description="The description of the token.")
    expiration: Optional[StrictStr] = Field(default=None, description="The token expiration time. If timezone is not included, UTC is assumed.")
    id: Optional[StrictStr] = Field(default=None, description="The ID of the token. This is a read-only field and is automatically assigned on creation.")
    modified_at: Optional[StrictStr] = Field(default=None, description="Date-time of last modification of the deployment. This is a read-only field and is automatically updated.", alias="modifiedAt")
    revoked: Optional[StrictBool] = Field(default=False, description="Indicate whether the deployment token is revoked")
    token: Optional[StrictStr] = Field(default=None, description="The signed JWT token.")
    user_id: Optional[StrictInt] = Field(default=None, description="The user id", alias="userID")
    username: Optional[StrictStr] = Field(default=None, description="The user name")
    __properties: ClassVar[List[str]] = ["deployment", "deploymentID", "description", "expiration", "id", "modifiedAt", "revoked", "token", "userID", "username"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DeploymentToken from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DeploymentToken from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "deployment": obj.get("deployment"),
            "deploymentID": obj.get("deploymentID"),
            "description": obj.get("description"),
            "expiration": obj.get("expiration"),
            "id": obj.get("id"),
            "modifiedAt": obj.get("modifiedAt"),
            "revoked": obj.get("revoked") if obj.get("revoked") is not None else False,
            "token": obj.get("token"),
            "userID": obj.get("userID"),
            "username": obj.get("username")
        })
        return _obj


