# coding: utf-8

"""
    HPE Machine Learning Inference Software (MLIS/Aioli)

    HPE MLIS is *Aioli* -- The AI On-line Inference Platform that enables easy deployment, tracking, and serving of your packaged models regardless of your preferred AI framework.

    The version of the OpenAPI document: 1.1.0
    Contact: community@determined-ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class EventInfo(BaseModel):
    """
    EventInfo
    """ # noqa: E501
    event_type: Optional[StrictStr] = Field(default=None, description="Type of the event. * `Normal` - An informational event. * `Warning` - A condition that may require attention.", alias="eventType")
    message: Optional[StrictStr] = Field(default=None, description="Message for the event.")
    reason: Optional[StrictStr] = Field(default=None, description="Common reasons for the event. * `ScalingReplicaSet` - The number of deployed replicas is being increased or decreased. * `Pulling` - Indicates that the container image is being loaded from a registry. * `Pulled` - Container image already present on machine. * `RevisionReady` - Revision becomes ready upon all resources being ready.  Kubernetes official website does not provide a full list of values for Reason. Use the below link for the latest compilation of event Reasons. Ref: https://docs.appdynamics.com/observability/cisco-cloud-observability/en/kubernetes-and-app-service-monitoring/kubernetes-events-collection/events-reason-reference")
    time: Optional[StrictStr] = Field(default=None, description="The time at which the event occurred.")
    __properties: ClassVar[List[str]] = ["eventType", "message", "reason", "time"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of EventInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of EventInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "eventType": obj.get("eventType"),
            "message": obj.get("message"),
            "reason": obj.get("reason"),
            "time": obj.get("time")
        })
        return _obj


