# coding: utf-8

"""
    HPE Machine Learning Inference Software (MLIS/Aioli)

    HPE MLIS is *Aioli* -- The AI On-line Inference Platform that enables easy deployment, tracking, and serving of your packaged models regardless of your preferred AI framework.

    The version of the OpenAPI document: 1.1.0
    Contact: community@determined-ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class ModelResponse(BaseModel):
    """
    Provides a set of values that are returned by querying for models
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="The description of desribing the model")
    display_name: Optional[StrictStr] = Field(default=None, description="The name displayed that is human readable", alias="displayName")
    image: Optional[StrictStr] = Field(default=None, description="The default container image to execute the model (if available).  For NIM models, this is used to identify the model.")
    latest_version_id_str: Optional[StrictStr] = Field(default=None, description="The latest version of the model", alias="latestVersionIdStr")
    latest_version_size_in_bytes: Optional[StrictInt] = Field(default=None, description="The number of bytes for the latest model (if available)", alias="latestVersionSizeInBytes")
    metadata: Optional[Dict[str, StrictStr]] = Field(default=None, description="Other attributes of the model as available")
    format: Optional[StrictStr] = Field(default=None, description="The format of the model", alias="modelFormat")
    name: Optional[StrictStr] = Field(default=None, description="The name used in model specification")
    __properties: ClassVar[List[str]] = ["description", "displayName", "image", "latestVersionIdStr", "latestVersionSizeInBytes", "metadata", "modelFormat", "name"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ModelResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of ModelResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "displayName": obj.get("displayName"),
            "image": obj.get("image"),
            "latestVersionIdStr": obj.get("latestVersionIdStr"),
            "latestVersionSizeInBytes": obj.get("latestVersionSizeInBytes"),
            "metadata": obj.get("metadata"),
            "modelFormat": obj.get("modelFormat"),
            "name": obj.get("name")
        })
        return _obj


