# coding: utf-8

"""
    HPE Machine Learning Inference Software (MLIS/Aioli)

    HPE MLIS is *Aioli* -- The AI On-line Inference Platform that enables easy deployment, tracking, and serving of your packaged models regardless of your preferred AI framework.

    The version of the OpenAPI document: 1.1.0
    Contact: community@determined-ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from pydantic import Field
from aiolirest.models.configuration_resources import ConfigurationResources
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class PackagedModelRequest(BaseModel):
    """
    The PackagedModel describes a specific model that can be loaded. It optionally references a model registry to provide authorization, and other details.
    """ # noqa: E501
    arguments: Optional[List[StrictStr]] = Field(default=None, description="Arguments to be added to the service command line")
    description: Optional[StrictStr] = Field(default=None, description="A description of the model.")
    environment: Optional[Dict[str, StrictStr]] = Field(default=None, description="Environment variables added to the service")
    image: Optional[StrictStr] = Field(default=None, description="Alternate Docker container image servicing the model. Required for a nim or custom model format. Leave blank to use the default image.")
    format: Optional[StrictStr] = Field(default='custom', description="Model format for downloaded models (e.g. from s3, http, etc.). Must be one of the values: (bento-archive, openllm, nim, custom). * `custom` - The packaged model is provided in a container image. * `bento-archive` - The packaged model is a bento archive file (.bento).  It will be downloaded,  expanded, and then  will be served using the `bentolm serve` command in a provided bentoml serving container. * `openllm` - The packaged model will be served using the `openllm serve` command in a  provided openllm serving container. * `nim` - The packaged model will be served using the specified NVIDIA NIM microservices container image.", alias="modelFormat")
    name: StrictStr = Field(description="The name of the model. Must consist of alphanumeric characters, '-', or '.', and must start and end with an alphanumeric character. The length of the model name must be 63 characters or less.")
    registry: Optional[StrictStr] = Field(default=None, description="The name or ID of the model registry.")
    resources: Optional[ConfigurationResources] = None
    url: Optional[StrictStr] = Field(default=None, description="Reference to the bento or model to be served.  Supported schemes are: * `openllm://` - An openllm model name from huggingface.co dynamically loaded and executed with a VLLM backend. * `s3://` - An openllm model path which will be dynamically downloaded from an associated s3  registry bucket and executed with a VLLM backend. * `pvc://` - A persistent volume claim (PVC) mounted when deployed.  This is only supported for the NIM or custom model format.  The syntax is `pvc://<pvc-name>/<path>` with URI parameters `?containerPath=<container-path>` to specify where in the container the PVC should be mounted, and ` ?readOnly` to perform the mount in read-only mode.  The `<pvc-name>` must already exist  in the kubernetes namespace where the packaged model will be deployed.   If the optional  `<path>` is specified, the specified path within the PVC will be mounted.")
    __properties: ClassVar[List[str]] = ["arguments", "description", "environment", "image", "modelFormat", "name", "registry", "resources", "url"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of PackagedModelRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of resources
        if self.resources:
            _dict['resources'] = self.resources.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of PackagedModelRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "arguments": obj.get("arguments"),
            "description": obj.get("description"),
            "environment": obj.get("environment"),
            "image": obj.get("image"),
            "modelFormat": obj.get("modelFormat") if obj.get("modelFormat") is not None else 'custom',
            "name": obj.get("name"),
            "registry": obj.get("registry"),
            "resources": ConfigurationResources.from_dict(obj.get("resources")) if obj.get("resources") is not None else None,
            "url": obj.get("url")
        })
        return _obj


