# coding: utf-8

"""
    HPE Machine Learning Inference Software (MLIS/Aioli)

    HPE MLIS is *Aioli* -- The AI On-line Inference Platform that enables easy deployment, tracking, and serving of your packaged models regardless of your preferred AI framework.

    The version of the OpenAPI document: 1.1.0
    Contact: community@determined-ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class TrainedModelRegistryRequest(BaseModel):
    """
    Provides the metadata that describes how to access a named model registry to enable download of a trained model for deployment.
    """ # noqa: E501
    access_key: Optional[StrictStr] = Field(default=None, description="The access key, username or team name for the registry. * `s3` - The access key/username. * `ngc` - The optional NGC team name.", alias="accessKey")
    bucket: Optional[StrictStr] = Field(default=None, description="The bucket or organization name.  * `s3` - The required S3 bucket name. * `ngc` - The required NGC org name.")
    endpoint_url: Optional[StrictStr] = Field(default=None, description="The registry endpoint (host): * `s3` - The S3 registry endpoint. Required. * `openllm` - The huggingface.co-compatible endpoint (default https://huggingface.co). * `ngc` - The NVIDIA NGC-compatible api endpoint (default https://api.ngc.nvidia.com).", alias="endpointUrl")
    insecure_https: Optional[StrictBool] = Field(default=None, description="For https endpoints, the server certificate will be accepted without validation.", alias="insecureHttps")
    modified_at: Optional[StrictStr] = Field(default=None, description="Date-time of last modification of the registry. This is a read-only field and is automatically updated.", alias="modifiedAt")
    name: StrictStr = Field(description="The name of the registry.  Must begin with a letter, but may contain letters, numbers, and hyphen.")
    secret_key: StrictStr = Field(description="The secret key is the password, secret key, or access token for the registry.  * `s3` - The secret key for the S3 bucket. * `openllm` -  The access token for huggingface.co and is supplied to the launched container via the `HF_TOKEN` environment variable.bucket. * `ngc` - The requied NVIDIA NGC apikey.", alias="secretKey")
    type: StrictStr = Field(description="The type of this model registry. Must be one of the values: (s3, http, openllm, ngc). * `s3` - Configuration to enable access to an s3 bucket. * `openllm` - A registry that provides access to huggingface.co.  It enables automatic download with an `openllm://` URL for openllm packged models, or access to huggingface.co APIs for custom packaged models. * `ngc` -  Configuration to enable direct download from the NVIDA NGC: AI Development Catalog.")
    __properties: ClassVar[List[str]] = ["accessKey", "bucket", "endpointUrl", "insecureHttps", "modifiedAt", "name", "secretKey", "type"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of TrainedModelRegistryRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of TrainedModelRegistryRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accessKey": obj.get("accessKey"),
            "bucket": obj.get("bucket"),
            "endpointUrl": obj.get("endpointUrl"),
            "insecureHttps": obj.get("insecureHttps"),
            "modifiedAt": obj.get("modifiedAt"),
            "name": obj.get("name"),
            "secretKey": obj.get("secretKey"),
            "type": obj.get("type")
        })
        return _obj


