# coding: utf-8

"""
    HPE Machine Learning Inference Software (MLIS/Aioli)

    HPE MLIS is *Aioli* -- The AI On-line Inference Platform that enables easy deployment, tracking, and serving of your packaged models regardless of your preferred AI framework.

    The version of the OpenAPI document: 1.1.0
    Contact: community@determined-ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class User(BaseModel):
    """
    Name and properties of a user.
    """ # noqa: E501
    active: Optional[StrictBool] = Field(default=None, description="Allows for disabling a user without deleting them.   Only active users an login.")
    display_name: StrictStr = Field(description="Display name of the user in the UI.", alias="displayName")
    id: Optional[StrictStr] = Field(default=None, description="The ID of the user. This is a read-only field and is automatically assigned on creation.")
    last_auth_at: Optional[StrictStr] = Field(default=None, description="Date-time of last use of this account. This is a read-only field and is automatically updated.", alias="lastAuthAt")
    modified_at: Optional[StrictStr] = Field(default=None, description="Date-time of last modification of the user configuration. This is a read-only field and is automatically updated.", alias="modifiedAt")
    remote: Optional[StrictBool] = Field(default=None, description="User data comes from a external/remote provider. This is a read-only field and is automatically updated.")
    username: StrictStr = Field(description="The user name used for login.")
    __properties: ClassVar[List[str]] = ["active", "displayName", "id", "lastAuthAt", "modifiedAt", "remote", "username"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of User from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of User from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "active": obj.get("active"),
            "displayName": obj.get("displayName"),
            "id": obj.get("id"),
            "lastAuthAt": obj.get("lastAuthAt"),
            "modifiedAt": obj.get("modifiedAt"),
            "remote": obj.get("remote"),
            "username": obj.get("username")
        })
        return _obj


