# mypy-boto3-sms

[![PyPI - mypy-boto3-sms](https://img.shields.io/pypi/v/mypy-boto3-sms.svg?color=blue)](https://pypi.org/project/mypy-boto3-sms)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-sms.svg?color=blue)](https://pypi.org/project/mypy-boto3-sms)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-sms?color=blue)](https://pypistats.org/packages/mypy-boto3-sms)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.SMS 1.17.61](https://boto3.amazonaws.com/v1/documentation/api/1.17.61/reference/services/sms.html#SMS) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.8.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[auto-generated docs](https://github.com/vemel/mypy_boto3_builder/service_docs/mypy_boto3_sms/README.md)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-sms](#mypy-boto3-sms)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)

## How to install

Install `boto3-stubs` for `SMS` service.

```bash
python -m pip install boto3-stubs[sms]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[sms]` in your environment: `python -m pip install 'boto3-stubs[sms]'`

Both type checking and auto-complete should work for `SMS` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[sms]` in your environment: `python -m pip install 'boto3-stubs[sms]'`

Both type checking and auto-complete should work for `SMS` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[sms]` in your environment: `python -m pip install 'boto3-stubs[sms]'`
- Run `mypy` as usual

Type checking should work for `SMS` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[sms]` in your environment: `python -m pip install 'boto3-stubs[sms]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SMS` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`SMSClient` provides annotations for `boto3.client("sms")`.

```python
import boto3

from mypy_boto3_sms import SMSClient

client: SMSClient = boto3.client("sms")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SMSClient = session.client("sms")
```

### Paginators annotations

`mypy_boto3_sms.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_sms import SMSClient
from mypy_boto3_sms.paginator import (
    GetConnectorsPaginator,
    GetReplicationJobsPaginator,
    GetReplicationRunsPaginator,
    GetServersPaginator,
    ListAppsPaginator,
)

client: SMSClient = boto3.client("sms")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_connectors_paginator: GetConnectorsPaginator = client.get_paginator("get_connectors")
get_replication_jobs_paginator: GetReplicationJobsPaginator = client.get_paginator("get_replication_jobs")
get_replication_runs_paginator: GetReplicationRunsPaginator = client.get_paginator("get_replication_runs")
get_servers_paginator: GetServersPaginator = client.get_paginator("get_servers")
list_apps_paginator: ListAppsPaginator = client.get_paginator("list_apps")
```







### Literals

`mypy_boto3_sms.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_sms.literals import (
    AppLaunchConfigurationStatus,
    AppLaunchStatus,
    AppReplicationConfigurationStatus,
    AppReplicationStatus,
    AppStatus,
    AppValidationStrategy,
    ConnectorCapability,
    ConnectorStatus,
    GetConnectorsPaginatorName,
    GetReplicationJobsPaginatorName,
    GetReplicationRunsPaginatorName,
    GetServersPaginatorName,
    LicenseType,
    ListAppsPaginatorName,
    OutputFormat,
    ReplicationJobState,
    ReplicationRunState,
    ReplicationRunType,
    ScriptType,
    ServerCatalogStatus,
    ServerType,
    ServerValidationStrategy,
    ValidationStatus,
    VmManagerType,
)

def check_value(value: AppLaunchConfigurationStatus) -> bool:
    ...
```



### Typed dictionaries

`mypy_boto3_sms.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_sms.type_defs import (
    AppSummaryTypeDef,
    AppValidationConfigurationTypeDef,
    AppValidationOutputTypeDef,
    ConnectorTypeDef,
    CreateAppResponseTypeDef,
    CreateReplicationJobResponseTypeDef,
    GenerateChangeSetResponseTypeDef,
    GenerateTemplateResponseTypeDef,
    GetAppLaunchConfigurationResponseTypeDef,
    GetAppReplicationConfigurationResponseTypeDef,
    GetAppResponseTypeDef,
    GetAppValidationConfigurationResponseTypeDef,
    GetAppValidationOutputResponseTypeDef,
    GetConnectorsResponseTypeDef,
    GetReplicationJobsResponseTypeDef,
    GetReplicationRunsResponseTypeDef,
    GetServersResponseTypeDef,
    LaunchDetailsTypeDef,
    ListAppsResponseTypeDef,
    NotificationContextTypeDef,
    PaginatorConfigTypeDef,
    ReplicationJobTypeDef,
    ReplicationRunStageDetailsTypeDef,
    ReplicationRunTypeDef,
    ResponseMetadata,
    S3LocationTypeDef,
    SSMOutputTypeDef,
    SSMValidationParametersTypeDef,
    ServerGroupLaunchConfigurationTypeDef,
    ServerGroupReplicationConfigurationTypeDef,
    ServerGroupTypeDef,
    ServerGroupValidationConfigurationTypeDef,
    ServerLaunchConfigurationTypeDef,
    ServerReplicationConfigurationTypeDef,
    ServerReplicationParametersTypeDef,
    ServerTypeDef,
    ServerValidationConfigurationTypeDef,
    ServerValidationOutputTypeDef,
    SourceTypeDef,
    StartOnDemandReplicationRunResponseTypeDef,
    TagTypeDef,
    UpdateAppResponseTypeDef,
    UserDataTypeDef,
    UserDataValidationParametersTypeDef,
    ValidationOutputTypeDef,
    VmServerAddressTypeDef,
    VmServerTypeDef,
)

def get_structure() -> AppSummaryTypeDef:
    return {
      ...
    }
```
