# Refers to `_RAND_INCREASING_TRANSFORMS` in pytorch-image-models
rand_increasing_policies = [
    dict(type='AutoContrast'),
    dict(type='Equalize'),
    dict(type='Invert'),
    dict(type='Rotate', magnitude_key='angle', magnitude_range=(0, 30)),
    dict(type='Posterize', magnitude_key='bits', magnitude_range=(4, 0)),
    dict(type='Solarize', magnitude_key='thr', magnitude_range=(256, 0)),
    dict(type='SolarizeAdd',
         magnitude_key='magnitude',
         magnitude_range=(0, 110)),
    dict(type='ColorTransform',
         magnitude_key='magnitude',
         magnitude_range=(0, 0.9)),
    dict(type='Contrast', magnitude_key='magnitude', magnitude_range=(0, 0.9)),
    dict(type='Brightness',
         magnitude_key='magnitude',
         magnitude_range=(0, 0.9)),
    dict(type='Sharpness', magnitude_key='magnitude',
         magnitude_range=(0, 0.9)),
    dict(type='Shear',
         magnitude_key='magnitude',
         magnitude_range=(0, 0.3),
         direction='horizontal'),
    dict(type='Shear',
         magnitude_key='magnitude',
         magnitude_range=(0, 0.3),
         direction='vertical'),
    dict(type='Translate',
         magnitude_key='magnitude',
         magnitude_range=(0, 0.45),
         direction='horizontal'),
    dict(type='Translate',
         magnitude_key='magnitude',
         magnitude_range=(0, 0.45),
         direction='vertical')
]
