_base_ = [
    '../../_base_/models/mixmim/mixmim_base.py',
    '../../_base_/datasets/imagenet_bs64_swin_224.py',
    '../../_base_/default_runtime.py'
]

# dataset settings
dataset_type = 'ImageNet'
data_root = 'data/imagenet/'

data_preprocessor = dict(
    mean=[123.675, 116.28, 103.53],
    std=[58.395, 57.12, 57.375],
    to_rgb=True,
)

bgr_mean = data_preprocessor['mean'][::-1]
bgr_std = data_preprocessor['std'][::-1]

train_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(type='RandomResizedCrop',
         scale=224,
         backend='pillow',
         interpolation='bicubic'),
    dict(type='RandomFlip', prob=0.5, direction='horizontal'),
    dict(type='RandAugment',
         policies='timm_increasing',
         num_policies=2,
         total_level=10,
         magnitude_level=9,
         magnitude_std=0.5,
         hparams=dict(pad_val=[round(x) for x in bgr_mean],
                      interpolation='bicubic')),
    dict(type='RandomErasing',
         erase_prob=0.25,
         mode='rand',
         min_area_ratio=0.02,
         max_area_ratio=1 / 3,
         fill_color=bgr_mean,
         fill_std=bgr_std),
    dict(type='PackInputs'),
]

train_dataloader = dict(
    batch_size=128,
    num_workers=16,
    dataset=dict(type=dataset_type,
                 data_root=data_root,
                 ann_file='meta/train.txt',
                 data_prefix='train',
                 pipeline=train_pipeline),
    sampler=dict(type='DefaultSampler', shuffle=True),
    persistent_workers=True,
)

test_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(type='ResizeEdge',
         scale=256,
         edge='short',
         backend='pillow',
         interpolation='bicubic'),
    dict(type='CenterCrop', crop_size=224),
    dict(type='PackInputs'),
]

val_dataloader = dict(
    batch_size=64,
    num_workers=8,
    pin_memory=True,
    collate_fn=dict(type='default_collate'),
    dataset=dict(type=dataset_type,
                 data_root=data_root,
                 ann_file='meta/val.txt',
                 data_prefix='val',
                 pipeline=test_pipeline),
    sampler=dict(type='DefaultSampler', shuffle=False),
    persistent_workers=True,
)
test_dataloader = val_dataloader

model = dict(backbone=dict(
    init_cfg=dict(type='Pretrained', checkpoint='', prefix='backbone.')))

# optimizer
optim_wrapper = dict(
    type='OptimWrapper',
    optimizer=dict(type='AdamW',
                   lr=5e-4 * (8 * 128 / 256),
                   betas=(0.9, 0.999),
                   weight_decay=0.05),
    constructor='LearningRateDecayOptimWrapperConstructor',
    paramwise_cfg=dict(
        layer_decay_rate=0.7,
        custom_keys={
            '.ln': dict(decay_mult=0.0),  # do not decay on ln and bias
            '.bias': dict(decay_mult=0.0)
        }))

param_scheduler = [
    dict(type='LinearLR',
         start_factor=1e-6,
         by_epoch=True,
         begin=0,
         end=5,
         convert_to_iter_based=True),
    dict(type='CosineAnnealingLR',
         T_max=95,
         eta_min=1e-6,
         by_epoch=True,
         begin=5,
         end=100,
         convert_to_iter_based=True)
]

train_cfg = dict(by_epoch=True, max_epochs=100, val_interval=10)
val_cfg = dict()
test_cfg = dict()

default_hooks = dict(
    # save checkpoint per epoch.
    checkpoint=dict(type='CheckpointHook', interval=1, max_keep_ckpts=1))
