import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#id App#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#spec App#spec}
    */
    readonly spec?: AppSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#timeouts App#timeouts}
    */
    readonly timeouts?: AppTimeouts;
}
export interface AppSpecAlert {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#disabled App#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#rule App#rule}
    */
    readonly rule: string;
}
export declare function appSpecAlertToTerraform(struct?: AppSpecAlert | cdktf.IResolvable): any;
export declare class AppSpecAlertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecAlert | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecAlert | cdktf.IResolvable | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
}
export declare class AppSpecAlertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecAlert[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecAlertOutputReference;
}
export interface AppSpecDatabase {
    /**
    * The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if cluster_name is not set, a new cluster will be provisioned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#cluster_name App#cluster_name}
    */
    readonly clusterName?: string;
    /**
    * The name of the MySQL or PostgreSQL database to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#db_name App#db_name}
    */
    readonly dbName?: string;
    /**
    * The name of the MySQL or PostgreSQL user to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#db_user App#db_user}
    */
    readonly dbUser?: string;
    /**
    * The database engine to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#engine App#engine}
    */
    readonly engine?: string;
    /**
    * The name of the component
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#name App#name}
    */
    readonly name?: string;
    /**
    * Whether this is a production or dev database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#production App#production}
    */
    readonly production?: boolean | cdktf.IResolvable;
    /**
    * The version of the database engine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#version App#version}
    */
    readonly version?: string;
}
export declare function appSpecDatabaseToTerraform(struct?: AppSpecDatabase | cdktf.IResolvable): any;
export declare class AppSpecDatabaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecDatabase | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecDatabase | cdktf.IResolvable | undefined);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    resetClusterName(): void;
    get clusterNameInput(): string | undefined;
    private _dbName?;
    get dbName(): string;
    set dbName(value: string);
    resetDbName(): void;
    get dbNameInput(): string | undefined;
    private _dbUser?;
    get dbUser(): string;
    set dbUser(value: string);
    resetDbUser(): void;
    get dbUserInput(): string | undefined;
    private _engine?;
    get engine(): string;
    set engine(value: string);
    resetEngine(): void;
    get engineInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _production?;
    get production(): boolean | cdktf.IResolvable;
    set production(value: boolean | cdktf.IResolvable);
    resetProduction(): void;
    get productionInput(): boolean | cdktf.IResolvable | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export declare class AppSpecDatabaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecDatabase[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecDatabaseOutputReference;
}
export interface AppSpecDomain {
    /**
    * The hostname for the domain.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#name App#name}
    */
    readonly name: string;
    /**
    * The type of the domain.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#type App#type}
    */
    readonly type?: string;
    /**
    * Indicates whether the domain includes all sub-domains, in addition to the given domain.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#wildcard App#wildcard}
    */
    readonly wildcard?: boolean | cdktf.IResolvable;
    /**
    * If the domain uses DigitalOcean DNS and you would like App Platform to automatically manage it for you, set this to the name of the domain on your account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#zone App#zone}
    */
    readonly zone?: string;
}
export declare function appSpecDomainToTerraform(struct?: AppSpecDomain | cdktf.IResolvable): any;
export declare class AppSpecDomainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecDomain | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecDomain | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _wildcard?;
    get wildcard(): boolean | cdktf.IResolvable;
    set wildcard(value: boolean | cdktf.IResolvable);
    resetWildcard(): void;
    get wildcardInput(): boolean | cdktf.IResolvable | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
}
export declare class AppSpecDomainList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecDomain[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecDomainOutputReference;
}
export interface AppSpecEnv {
    /**
    * The name of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#key App#key}
    */
    readonly key?: string;
    /**
    * The visibility scope of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#scope App#scope}
    */
    readonly scope?: string;
    /**
    * The type of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#type App#type}
    */
    readonly type?: string;
    /**
    * The value of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#value App#value}
    */
    readonly value?: string;
}
export declare function appSpecEnvToTerraform(struct?: AppSpecEnv | cdktf.IResolvable): any;
export declare class AppSpecEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecEnv | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecEnv | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class AppSpecEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecEnvOutputReference;
}
export interface AppSpecFunctionAlert {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#disabled App#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#operator App#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#rule App#rule}
    */
    readonly rule: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#value App#value}
    */
    readonly value: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#window App#window}
    */
    readonly window: string;
}
export declare function appSpecFunctionAlertToTerraform(struct?: AppSpecFunctionAlert | cdktf.IResolvable): any;
export declare class AppSpecFunctionAlertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecFunctionAlert | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecFunctionAlert | cdktf.IResolvable | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
    private _window?;
    get window(): string;
    set window(value: string);
    get windowInput(): string | undefined;
}
export declare class AppSpecFunctionAlertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecFunctionAlert[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecFunctionAlertOutputReference;
}
export interface AppSpecFunctionCorsAllowOrigins {
    /**
    * Exact string match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#exact App#exact}
    */
    readonly exact?: string;
    /**
    * Prefix-based match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#prefix App#prefix}
    */
    readonly prefix?: string;
    /**
    * RE2 style regex-based match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#regex App#regex}
    */
    readonly regex?: string;
}
export declare function appSpecFunctionCorsAllowOriginsToTerraform(struct?: AppSpecFunctionCorsAllowOriginsOutputReference | AppSpecFunctionCorsAllowOrigins): any;
export declare class AppSpecFunctionCorsAllowOriginsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecFunctionCorsAllowOrigins | undefined;
    set internalValue(value: AppSpecFunctionCorsAllowOrigins | undefined);
    private _exact?;
    get exact(): string;
    set exact(value: string);
    resetExact(): void;
    get exactInput(): string | undefined;
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    private _regex?;
    get regex(): string;
    set regex(value: string);
    resetRegex(): void;
    get regexInput(): string | undefined;
}
export interface AppSpecFunctionCors {
    /**
    * Whether browsers should expose the response to the client-side JavaScript code when the request’s credentials mode is `include`. This configures the Access-Control-Allow-Credentials header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#allow_credentials App#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * The set of allowed HTTP request headers. This configures the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#allow_headers App#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * The set of allowed HTTP methods. This configures the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#allow_methods App#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * The set of HTTP response headers that browsers are allowed to access. This configures the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#expose_headers App#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#max_age App#max_age}
    */
    readonly maxAge?: string;
    /**
    * allow_origins block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#allow_origins App#allow_origins}
    */
    readonly allowOrigins?: AppSpecFunctionCorsAllowOrigins;
}
export declare function appSpecFunctionCorsToTerraform(struct?: AppSpecFunctionCorsOutputReference | AppSpecFunctionCors): any;
export declare class AppSpecFunctionCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecFunctionCors | undefined;
    set internalValue(value: AppSpecFunctionCors | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): string;
    set maxAge(value: string);
    resetMaxAge(): void;
    get maxAgeInput(): string | undefined;
    private _allowOrigins;
    get allowOrigins(): AppSpecFunctionCorsAllowOriginsOutputReference;
    putAllowOrigins(value: AppSpecFunctionCorsAllowOrigins): void;
    resetAllowOrigins(): void;
    get allowOriginsInput(): AppSpecFunctionCorsAllowOrigins | undefined;
}
export interface AppSpecFunctionEnv {
    /**
    * The name of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#key App#key}
    */
    readonly key?: string;
    /**
    * The visibility scope of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#scope App#scope}
    */
    readonly scope?: string;
    /**
    * The type of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#type App#type}
    */
    readonly type?: string;
    /**
    * The value of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#value App#value}
    */
    readonly value?: string;
}
export declare function appSpecFunctionEnvToTerraform(struct?: AppSpecFunctionEnv | cdktf.IResolvable): any;
export declare class AppSpecFunctionEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecFunctionEnv | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecFunctionEnv | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class AppSpecFunctionEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecFunctionEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecFunctionEnvOutputReference;
}
export interface AppSpecFunctionGit {
    /**
    * The name of the branch to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#branch App#branch}
    */
    readonly branch?: string;
    /**
    * The clone URL of the repo.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repo_clone_url App#repo_clone_url}
    */
    readonly repoCloneUrl?: string;
}
export declare function appSpecFunctionGitToTerraform(struct?: AppSpecFunctionGitOutputReference | AppSpecFunctionGit): any;
export declare class AppSpecFunctionGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecFunctionGit | undefined;
    set internalValue(value: AppSpecFunctionGit | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _repoCloneUrl?;
    get repoCloneUrl(): string;
    set repoCloneUrl(value: string);
    resetRepoCloneUrl(): void;
    get repoCloneUrlInput(): string | undefined;
}
export interface AppSpecFunctionGithub {
    /**
    * The name of the branch to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#branch App#branch}
    */
    readonly branch?: string;
    /**
    * Whether to automatically deploy new commits made to the repo
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#deploy_on_push App#deploy_on_push}
    */
    readonly deployOnPush?: boolean | cdktf.IResolvable;
    /**
    * The name of the repo in the format `owner/repo`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repo App#repo}
    */
    readonly repo?: string;
}
export declare function appSpecFunctionGithubToTerraform(struct?: AppSpecFunctionGithubOutputReference | AppSpecFunctionGithub): any;
export declare class AppSpecFunctionGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecFunctionGithub | undefined;
    set internalValue(value: AppSpecFunctionGithub | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _deployOnPush?;
    get deployOnPush(): boolean | cdktf.IResolvable;
    set deployOnPush(value: boolean | cdktf.IResolvable);
    resetDeployOnPush(): void;
    get deployOnPushInput(): boolean | cdktf.IResolvable | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface AppSpecFunctionGitlab {
    /**
    * The name of the branch to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#branch App#branch}
    */
    readonly branch?: string;
    /**
    * Whether to automatically deploy new commits made to the repo
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#deploy_on_push App#deploy_on_push}
    */
    readonly deployOnPush?: boolean | cdktf.IResolvable;
    /**
    * The name of the repo in the format `owner/repo`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repo App#repo}
    */
    readonly repo?: string;
}
export declare function appSpecFunctionGitlabToTerraform(struct?: AppSpecFunctionGitlabOutputReference | AppSpecFunctionGitlab): any;
export declare class AppSpecFunctionGitlabOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecFunctionGitlab | undefined;
    set internalValue(value: AppSpecFunctionGitlab | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _deployOnPush?;
    get deployOnPush(): boolean | cdktf.IResolvable;
    set deployOnPush(value: boolean | cdktf.IResolvable);
    resetDeployOnPush(): void;
    get deployOnPushInput(): boolean | cdktf.IResolvable | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface AppSpecFunctionLogDestinationDatadog {
    /**
    * Datadog API key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#api_key App#api_key}
    */
    readonly apiKey: string;
    /**
    * Datadog HTTP log intake endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#endpoint App#endpoint}
    */
    readonly endpoint?: string;
}
export declare function appSpecFunctionLogDestinationDatadogToTerraform(struct?: AppSpecFunctionLogDestinationDatadogOutputReference | AppSpecFunctionLogDestinationDatadog): any;
export declare class AppSpecFunctionLogDestinationDatadogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecFunctionLogDestinationDatadog | undefined;
    set internalValue(value: AppSpecFunctionLogDestinationDatadog | undefined);
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    get apiKeyInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
}
export interface AppSpecFunctionLogDestinationLogtail {
    /**
    * Logtail token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#token App#token}
    */
    readonly token: string;
}
export declare function appSpecFunctionLogDestinationLogtailToTerraform(struct?: AppSpecFunctionLogDestinationLogtailOutputReference | AppSpecFunctionLogDestinationLogtail): any;
export declare class AppSpecFunctionLogDestinationLogtailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecFunctionLogDestinationLogtail | undefined;
    set internalValue(value: AppSpecFunctionLogDestinationLogtail | undefined);
    private _token?;
    get token(): string;
    set token(value: string);
    get tokenInput(): string | undefined;
}
export interface AppSpecFunctionLogDestinationPapertrail {
    /**
    * Papertrail syslog endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#endpoint App#endpoint}
    */
    readonly endpoint: string;
}
export declare function appSpecFunctionLogDestinationPapertrailToTerraform(struct?: AppSpecFunctionLogDestinationPapertrailOutputReference | AppSpecFunctionLogDestinationPapertrail): any;
export declare class AppSpecFunctionLogDestinationPapertrailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecFunctionLogDestinationPapertrail | undefined;
    set internalValue(value: AppSpecFunctionLogDestinationPapertrail | undefined);
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    get endpointInput(): string | undefined;
}
export interface AppSpecFunctionLogDestination {
    /**
    * Name of the log destination
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#name App#name}
    */
    readonly name: string;
    /**
    * datadog block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#datadog App#datadog}
    */
    readonly datadog?: AppSpecFunctionLogDestinationDatadog;
    /**
    * logtail block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#logtail App#logtail}
    */
    readonly logtail?: AppSpecFunctionLogDestinationLogtail;
    /**
    * papertrail block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#papertrail App#papertrail}
    */
    readonly papertrail?: AppSpecFunctionLogDestinationPapertrail;
}
export declare function appSpecFunctionLogDestinationToTerraform(struct?: AppSpecFunctionLogDestination | cdktf.IResolvable): any;
export declare class AppSpecFunctionLogDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecFunctionLogDestination | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecFunctionLogDestination | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _datadog;
    get datadog(): AppSpecFunctionLogDestinationDatadogOutputReference;
    putDatadog(value: AppSpecFunctionLogDestinationDatadog): void;
    resetDatadog(): void;
    get datadogInput(): AppSpecFunctionLogDestinationDatadog | undefined;
    private _logtail;
    get logtail(): AppSpecFunctionLogDestinationLogtailOutputReference;
    putLogtail(value: AppSpecFunctionLogDestinationLogtail): void;
    resetLogtail(): void;
    get logtailInput(): AppSpecFunctionLogDestinationLogtail | undefined;
    private _papertrail;
    get papertrail(): AppSpecFunctionLogDestinationPapertrailOutputReference;
    putPapertrail(value: AppSpecFunctionLogDestinationPapertrail): void;
    resetPapertrail(): void;
    get papertrailInput(): AppSpecFunctionLogDestinationPapertrail | undefined;
}
export declare class AppSpecFunctionLogDestinationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecFunctionLogDestination[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecFunctionLogDestinationOutputReference;
}
export interface AppSpecFunctionRoutes {
    /**
    * Path specifies an route by HTTP path prefix. Paths must start with / and must be unique within the app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#path App#path}
    */
    readonly path?: string;
    /**
    *  An optional flag to preserve the path that is forwarded to the backend service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#preserve_path_prefix App#preserve_path_prefix}
    */
    readonly preservePathPrefix?: boolean | cdktf.IResolvable;
}
export declare function appSpecFunctionRoutesToTerraform(struct?: AppSpecFunctionRoutes | cdktf.IResolvable): any;
export declare class AppSpecFunctionRoutesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecFunctionRoutes | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecFunctionRoutes | cdktf.IResolvable | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _preservePathPrefix?;
    get preservePathPrefix(): boolean | cdktf.IResolvable;
    set preservePathPrefix(value: boolean | cdktf.IResolvable);
    resetPreservePathPrefix(): void;
    get preservePathPrefixInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class AppSpecFunctionRoutesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecFunctionRoutes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecFunctionRoutesOutputReference;
}
export interface AppSpecFunction {
    /**
    * The name of the component
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#name App#name}
    */
    readonly name: string;
    /**
    * An optional path to the working directory to use for the build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#source_dir App#source_dir}
    */
    readonly sourceDir?: string;
    /**
    * alert block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#alert App#alert}
    */
    readonly alert?: AppSpecFunctionAlert[] | cdktf.IResolvable;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#cors App#cors}
    */
    readonly cors?: AppSpecFunctionCors;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#env App#env}
    */
    readonly env?: AppSpecFunctionEnv[] | cdktf.IResolvable;
    /**
    * git block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#git App#git}
    */
    readonly git?: AppSpecFunctionGit;
    /**
    * github block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#github App#github}
    */
    readonly github?: AppSpecFunctionGithub;
    /**
    * gitlab block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#gitlab App#gitlab}
    */
    readonly gitlab?: AppSpecFunctionGitlab;
    /**
    * log_destination block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#log_destination App#log_destination}
    */
    readonly logDestination?: AppSpecFunctionLogDestination[] | cdktf.IResolvable;
    /**
    * routes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#routes App#routes}
    */
    readonly routes?: AppSpecFunctionRoutes[] | cdktf.IResolvable;
}
export declare function appSpecFunctionToTerraform(struct?: AppSpecFunction | cdktf.IResolvable): any;
export declare class AppSpecFunctionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecFunction | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecFunction | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sourceDir?;
    get sourceDir(): string;
    set sourceDir(value: string);
    resetSourceDir(): void;
    get sourceDirInput(): string | undefined;
    private _alert;
    get alert(): AppSpecFunctionAlertList;
    putAlert(value: AppSpecFunctionAlert[] | cdktf.IResolvable): void;
    resetAlert(): void;
    get alertInput(): cdktf.IResolvable | AppSpecFunctionAlert[] | undefined;
    private _cors;
    get cors(): AppSpecFunctionCorsOutputReference;
    putCors(value: AppSpecFunctionCors): void;
    resetCors(): void;
    get corsInput(): AppSpecFunctionCors | undefined;
    private _env;
    get env(): AppSpecFunctionEnvList;
    putEnv(value: AppSpecFunctionEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | AppSpecFunctionEnv[] | undefined;
    private _git;
    get git(): AppSpecFunctionGitOutputReference;
    putGit(value: AppSpecFunctionGit): void;
    resetGit(): void;
    get gitInput(): AppSpecFunctionGit | undefined;
    private _github;
    get github(): AppSpecFunctionGithubOutputReference;
    putGithub(value: AppSpecFunctionGithub): void;
    resetGithub(): void;
    get githubInput(): AppSpecFunctionGithub | undefined;
    private _gitlab;
    get gitlab(): AppSpecFunctionGitlabOutputReference;
    putGitlab(value: AppSpecFunctionGitlab): void;
    resetGitlab(): void;
    get gitlabInput(): AppSpecFunctionGitlab | undefined;
    private _logDestination;
    get logDestination(): AppSpecFunctionLogDestinationList;
    putLogDestination(value: AppSpecFunctionLogDestination[] | cdktf.IResolvable): void;
    resetLogDestination(): void;
    get logDestinationInput(): cdktf.IResolvable | AppSpecFunctionLogDestination[] | undefined;
    private _routes;
    get routes(): AppSpecFunctionRoutesList;
    putRoutes(value: AppSpecFunctionRoutes[] | cdktf.IResolvable): void;
    resetRoutes(): void;
    get routesInput(): cdktf.IResolvable | AppSpecFunctionRoutes[] | undefined;
}
export declare class AppSpecFunctionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecFunction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecFunctionOutputReference;
}
export interface AppSpecJobAlert {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#disabled App#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#operator App#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#rule App#rule}
    */
    readonly rule: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#value App#value}
    */
    readonly value: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#window App#window}
    */
    readonly window: string;
}
export declare function appSpecJobAlertToTerraform(struct?: AppSpecJobAlert | cdktf.IResolvable): any;
export declare class AppSpecJobAlertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecJobAlert | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecJobAlert | cdktf.IResolvable | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
    private _window?;
    get window(): string;
    set window(value: string);
    get windowInput(): string | undefined;
}
export declare class AppSpecJobAlertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecJobAlert[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecJobAlertOutputReference;
}
export interface AppSpecJobEnv {
    /**
    * The name of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#key App#key}
    */
    readonly key?: string;
    /**
    * The visibility scope of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#scope App#scope}
    */
    readonly scope?: string;
    /**
    * The type of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#type App#type}
    */
    readonly type?: string;
    /**
    * The value of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#value App#value}
    */
    readonly value?: string;
}
export declare function appSpecJobEnvToTerraform(struct?: AppSpecJobEnv | cdktf.IResolvable): any;
export declare class AppSpecJobEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecJobEnv | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecJobEnv | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class AppSpecJobEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecJobEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecJobEnvOutputReference;
}
export interface AppSpecJobGit {
    /**
    * The name of the branch to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#branch App#branch}
    */
    readonly branch?: string;
    /**
    * The clone URL of the repo.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repo_clone_url App#repo_clone_url}
    */
    readonly repoCloneUrl?: string;
}
export declare function appSpecJobGitToTerraform(struct?: AppSpecJobGitOutputReference | AppSpecJobGit): any;
export declare class AppSpecJobGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecJobGit | undefined;
    set internalValue(value: AppSpecJobGit | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _repoCloneUrl?;
    get repoCloneUrl(): string;
    set repoCloneUrl(value: string);
    resetRepoCloneUrl(): void;
    get repoCloneUrlInput(): string | undefined;
}
export interface AppSpecJobGithub {
    /**
    * The name of the branch to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#branch App#branch}
    */
    readonly branch?: string;
    /**
    * Whether to automatically deploy new commits made to the repo
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#deploy_on_push App#deploy_on_push}
    */
    readonly deployOnPush?: boolean | cdktf.IResolvable;
    /**
    * The name of the repo in the format `owner/repo`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repo App#repo}
    */
    readonly repo?: string;
}
export declare function appSpecJobGithubToTerraform(struct?: AppSpecJobGithubOutputReference | AppSpecJobGithub): any;
export declare class AppSpecJobGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecJobGithub | undefined;
    set internalValue(value: AppSpecJobGithub | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _deployOnPush?;
    get deployOnPush(): boolean | cdktf.IResolvable;
    set deployOnPush(value: boolean | cdktf.IResolvable);
    resetDeployOnPush(): void;
    get deployOnPushInput(): boolean | cdktf.IResolvable | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface AppSpecJobGitlab {
    /**
    * The name of the branch to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#branch App#branch}
    */
    readonly branch?: string;
    /**
    * Whether to automatically deploy new commits made to the repo
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#deploy_on_push App#deploy_on_push}
    */
    readonly deployOnPush?: boolean | cdktf.IResolvable;
    /**
    * The name of the repo in the format `owner/repo`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repo App#repo}
    */
    readonly repo?: string;
}
export declare function appSpecJobGitlabToTerraform(struct?: AppSpecJobGitlabOutputReference | AppSpecJobGitlab): any;
export declare class AppSpecJobGitlabOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecJobGitlab | undefined;
    set internalValue(value: AppSpecJobGitlab | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _deployOnPush?;
    get deployOnPush(): boolean | cdktf.IResolvable;
    set deployOnPush(value: boolean | cdktf.IResolvable);
    resetDeployOnPush(): void;
    get deployOnPushInput(): boolean | cdktf.IResolvable | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface AppSpecJobImage {
    /**
    * The registry name. Must be left empty for the DOCR registry type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#registry App#registry}
    */
    readonly registry?: string;
    /**
    * The registry type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#registry_type App#registry_type}
    */
    readonly registryType: string;
    /**
    * The repository name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repository App#repository}
    */
    readonly repository: string;
    /**
    * The repository tag. Defaults to latest if not provided.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#tag App#tag}
    */
    readonly tag?: string;
}
export declare function appSpecJobImageToTerraform(struct?: AppSpecJobImageOutputReference | AppSpecJobImage): any;
export declare class AppSpecJobImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecJobImage | undefined;
    set internalValue(value: AppSpecJobImage | undefined);
    private _registry?;
    get registry(): string;
    set registry(value: string);
    resetRegistry(): void;
    get registryInput(): string | undefined;
    private _registryType?;
    get registryType(): string;
    set registryType(value: string);
    get registryTypeInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export interface AppSpecJobLogDestinationDatadog {
    /**
    * Datadog API key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#api_key App#api_key}
    */
    readonly apiKey: string;
    /**
    * Datadog HTTP log intake endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#endpoint App#endpoint}
    */
    readonly endpoint?: string;
}
export declare function appSpecJobLogDestinationDatadogToTerraform(struct?: AppSpecJobLogDestinationDatadogOutputReference | AppSpecJobLogDestinationDatadog): any;
export declare class AppSpecJobLogDestinationDatadogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecJobLogDestinationDatadog | undefined;
    set internalValue(value: AppSpecJobLogDestinationDatadog | undefined);
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    get apiKeyInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
}
export interface AppSpecJobLogDestinationLogtail {
    /**
    * Logtail token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#token App#token}
    */
    readonly token: string;
}
export declare function appSpecJobLogDestinationLogtailToTerraform(struct?: AppSpecJobLogDestinationLogtailOutputReference | AppSpecJobLogDestinationLogtail): any;
export declare class AppSpecJobLogDestinationLogtailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecJobLogDestinationLogtail | undefined;
    set internalValue(value: AppSpecJobLogDestinationLogtail | undefined);
    private _token?;
    get token(): string;
    set token(value: string);
    get tokenInput(): string | undefined;
}
export interface AppSpecJobLogDestinationPapertrail {
    /**
    * Papertrail syslog endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#endpoint App#endpoint}
    */
    readonly endpoint: string;
}
export declare function appSpecJobLogDestinationPapertrailToTerraform(struct?: AppSpecJobLogDestinationPapertrailOutputReference | AppSpecJobLogDestinationPapertrail): any;
export declare class AppSpecJobLogDestinationPapertrailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecJobLogDestinationPapertrail | undefined;
    set internalValue(value: AppSpecJobLogDestinationPapertrail | undefined);
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    get endpointInput(): string | undefined;
}
export interface AppSpecJobLogDestination {
    /**
    * Name of the log destination
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#name App#name}
    */
    readonly name: string;
    /**
    * datadog block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#datadog App#datadog}
    */
    readonly datadog?: AppSpecJobLogDestinationDatadog;
    /**
    * logtail block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#logtail App#logtail}
    */
    readonly logtail?: AppSpecJobLogDestinationLogtail;
    /**
    * papertrail block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#papertrail App#papertrail}
    */
    readonly papertrail?: AppSpecJobLogDestinationPapertrail;
}
export declare function appSpecJobLogDestinationToTerraform(struct?: AppSpecJobLogDestination | cdktf.IResolvable): any;
export declare class AppSpecJobLogDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecJobLogDestination | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecJobLogDestination | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _datadog;
    get datadog(): AppSpecJobLogDestinationDatadogOutputReference;
    putDatadog(value: AppSpecJobLogDestinationDatadog): void;
    resetDatadog(): void;
    get datadogInput(): AppSpecJobLogDestinationDatadog | undefined;
    private _logtail;
    get logtail(): AppSpecJobLogDestinationLogtailOutputReference;
    putLogtail(value: AppSpecJobLogDestinationLogtail): void;
    resetLogtail(): void;
    get logtailInput(): AppSpecJobLogDestinationLogtail | undefined;
    private _papertrail;
    get papertrail(): AppSpecJobLogDestinationPapertrailOutputReference;
    putPapertrail(value: AppSpecJobLogDestinationPapertrail): void;
    resetPapertrail(): void;
    get papertrailInput(): AppSpecJobLogDestinationPapertrail | undefined;
}
export declare class AppSpecJobLogDestinationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecJobLogDestination[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecJobLogDestinationOutputReference;
}
export interface AppSpecJob {
    /**
    * An optional build command to run while building this component from source.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#build_command App#build_command}
    */
    readonly buildCommand?: string;
    /**
    * The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#dockerfile_path App#dockerfile_path}
    */
    readonly dockerfilePath?: string;
    /**
    * An environment slug describing the type of this app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#environment_slug App#environment_slug}
    */
    readonly environmentSlug?: string;
    /**
    * The amount of instances that this component should be scaled to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#instance_count App#instance_count}
    */
    readonly instanceCount?: number;
    /**
    * The instance size to use for this component.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#instance_size_slug App#instance_size_slug}
    */
    readonly instanceSizeSlug?: string;
    /**
    * The type of job and when it will be run during the deployment process.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#kind App#kind}
    */
    readonly kind?: string;
    /**
    * The name of the component
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#name App#name}
    */
    readonly name: string;
    /**
    * An optional run command to override the component's default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#run_command App#run_command}
    */
    readonly runCommand?: string;
    /**
    * An optional path to the working directory to use for the build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#source_dir App#source_dir}
    */
    readonly sourceDir?: string;
    /**
    * alert block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#alert App#alert}
    */
    readonly alert?: AppSpecJobAlert[] | cdktf.IResolvable;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#env App#env}
    */
    readonly env?: AppSpecJobEnv[] | cdktf.IResolvable;
    /**
    * git block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#git App#git}
    */
    readonly git?: AppSpecJobGit;
    /**
    * github block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#github App#github}
    */
    readonly github?: AppSpecJobGithub;
    /**
    * gitlab block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#gitlab App#gitlab}
    */
    readonly gitlab?: AppSpecJobGitlab;
    /**
    * image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#image App#image}
    */
    readonly image?: AppSpecJobImage;
    /**
    * log_destination block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#log_destination App#log_destination}
    */
    readonly logDestination?: AppSpecJobLogDestination[] | cdktf.IResolvable;
}
export declare function appSpecJobToTerraform(struct?: AppSpecJob | cdktf.IResolvable): any;
export declare class AppSpecJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecJob | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecJob | cdktf.IResolvable | undefined);
    private _buildCommand?;
    get buildCommand(): string;
    set buildCommand(value: string);
    resetBuildCommand(): void;
    get buildCommandInput(): string | undefined;
    private _dockerfilePath?;
    get dockerfilePath(): string;
    set dockerfilePath(value: string);
    resetDockerfilePath(): void;
    get dockerfilePathInput(): string | undefined;
    private _environmentSlug?;
    get environmentSlug(): string;
    set environmentSlug(value: string);
    resetEnvironmentSlug(): void;
    get environmentSlugInput(): string | undefined;
    private _instanceCount?;
    get instanceCount(): number;
    set instanceCount(value: number);
    resetInstanceCount(): void;
    get instanceCountInput(): number | undefined;
    private _instanceSizeSlug?;
    get instanceSizeSlug(): string;
    set instanceSizeSlug(value: string);
    resetInstanceSizeSlug(): void;
    get instanceSizeSlugInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _runCommand?;
    get runCommand(): string;
    set runCommand(value: string);
    resetRunCommand(): void;
    get runCommandInput(): string | undefined;
    private _sourceDir?;
    get sourceDir(): string;
    set sourceDir(value: string);
    resetSourceDir(): void;
    get sourceDirInput(): string | undefined;
    private _alert;
    get alert(): AppSpecJobAlertList;
    putAlert(value: AppSpecJobAlert[] | cdktf.IResolvable): void;
    resetAlert(): void;
    get alertInput(): cdktf.IResolvable | AppSpecJobAlert[] | undefined;
    private _env;
    get env(): AppSpecJobEnvList;
    putEnv(value: AppSpecJobEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | AppSpecJobEnv[] | undefined;
    private _git;
    get git(): AppSpecJobGitOutputReference;
    putGit(value: AppSpecJobGit): void;
    resetGit(): void;
    get gitInput(): AppSpecJobGit | undefined;
    private _github;
    get github(): AppSpecJobGithubOutputReference;
    putGithub(value: AppSpecJobGithub): void;
    resetGithub(): void;
    get githubInput(): AppSpecJobGithub | undefined;
    private _gitlab;
    get gitlab(): AppSpecJobGitlabOutputReference;
    putGitlab(value: AppSpecJobGitlab): void;
    resetGitlab(): void;
    get gitlabInput(): AppSpecJobGitlab | undefined;
    private _image;
    get image(): AppSpecJobImageOutputReference;
    putImage(value: AppSpecJobImage): void;
    resetImage(): void;
    get imageInput(): AppSpecJobImage | undefined;
    private _logDestination;
    get logDestination(): AppSpecJobLogDestinationList;
    putLogDestination(value: AppSpecJobLogDestination[] | cdktf.IResolvable): void;
    resetLogDestination(): void;
    get logDestinationInput(): cdktf.IResolvable | AppSpecJobLogDestination[] | undefined;
}
export declare class AppSpecJobList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecJob[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecJobOutputReference;
}
export interface AppSpecServiceAlert {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#disabled App#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#operator App#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#rule App#rule}
    */
    readonly rule: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#value App#value}
    */
    readonly value: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#window App#window}
    */
    readonly window: string;
}
export declare function appSpecServiceAlertToTerraform(struct?: AppSpecServiceAlert | cdktf.IResolvable): any;
export declare class AppSpecServiceAlertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecServiceAlert | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecServiceAlert | cdktf.IResolvable | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
    private _window?;
    get window(): string;
    set window(value: string);
    get windowInput(): string | undefined;
}
export declare class AppSpecServiceAlertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecServiceAlert[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecServiceAlertOutputReference;
}
export interface AppSpecServiceCorsAllowOrigins {
    /**
    * Exact string match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#exact App#exact}
    */
    readonly exact?: string;
    /**
    * Prefix-based match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#prefix App#prefix}
    */
    readonly prefix?: string;
    /**
    * RE2 style regex-based match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#regex App#regex}
    */
    readonly regex?: string;
}
export declare function appSpecServiceCorsAllowOriginsToTerraform(struct?: AppSpecServiceCorsAllowOriginsOutputReference | AppSpecServiceCorsAllowOrigins): any;
export declare class AppSpecServiceCorsAllowOriginsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecServiceCorsAllowOrigins | undefined;
    set internalValue(value: AppSpecServiceCorsAllowOrigins | undefined);
    private _exact?;
    get exact(): string;
    set exact(value: string);
    resetExact(): void;
    get exactInput(): string | undefined;
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    private _regex?;
    get regex(): string;
    set regex(value: string);
    resetRegex(): void;
    get regexInput(): string | undefined;
}
export interface AppSpecServiceCors {
    /**
    * Whether browsers should expose the response to the client-side JavaScript code when the request’s credentials mode is `include`. This configures the Access-Control-Allow-Credentials header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#allow_credentials App#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * The set of allowed HTTP request headers. This configures the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#allow_headers App#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * The set of allowed HTTP methods. This configures the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#allow_methods App#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * The set of HTTP response headers that browsers are allowed to access. This configures the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#expose_headers App#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#max_age App#max_age}
    */
    readonly maxAge?: string;
    /**
    * allow_origins block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#allow_origins App#allow_origins}
    */
    readonly allowOrigins?: AppSpecServiceCorsAllowOrigins;
}
export declare function appSpecServiceCorsToTerraform(struct?: AppSpecServiceCorsOutputReference | AppSpecServiceCors): any;
export declare class AppSpecServiceCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecServiceCors | undefined;
    set internalValue(value: AppSpecServiceCors | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): string;
    set maxAge(value: string);
    resetMaxAge(): void;
    get maxAgeInput(): string | undefined;
    private _allowOrigins;
    get allowOrigins(): AppSpecServiceCorsAllowOriginsOutputReference;
    putAllowOrigins(value: AppSpecServiceCorsAllowOrigins): void;
    resetAllowOrigins(): void;
    get allowOriginsInput(): AppSpecServiceCorsAllowOrigins | undefined;
}
export interface AppSpecServiceEnv {
    /**
    * The name of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#key App#key}
    */
    readonly key?: string;
    /**
    * The visibility scope of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#scope App#scope}
    */
    readonly scope?: string;
    /**
    * The type of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#type App#type}
    */
    readonly type?: string;
    /**
    * The value of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#value App#value}
    */
    readonly value?: string;
}
export declare function appSpecServiceEnvToTerraform(struct?: AppSpecServiceEnv | cdktf.IResolvable): any;
export declare class AppSpecServiceEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecServiceEnv | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecServiceEnv | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class AppSpecServiceEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecServiceEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecServiceEnvOutputReference;
}
export interface AppSpecServiceGit {
    /**
    * The name of the branch to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#branch App#branch}
    */
    readonly branch?: string;
    /**
    * The clone URL of the repo.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repo_clone_url App#repo_clone_url}
    */
    readonly repoCloneUrl?: string;
}
export declare function appSpecServiceGitToTerraform(struct?: AppSpecServiceGitOutputReference | AppSpecServiceGit): any;
export declare class AppSpecServiceGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecServiceGit | undefined;
    set internalValue(value: AppSpecServiceGit | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _repoCloneUrl?;
    get repoCloneUrl(): string;
    set repoCloneUrl(value: string);
    resetRepoCloneUrl(): void;
    get repoCloneUrlInput(): string | undefined;
}
export interface AppSpecServiceGithub {
    /**
    * The name of the branch to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#branch App#branch}
    */
    readonly branch?: string;
    /**
    * Whether to automatically deploy new commits made to the repo
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#deploy_on_push App#deploy_on_push}
    */
    readonly deployOnPush?: boolean | cdktf.IResolvable;
    /**
    * The name of the repo in the format `owner/repo`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repo App#repo}
    */
    readonly repo?: string;
}
export declare function appSpecServiceGithubToTerraform(struct?: AppSpecServiceGithubOutputReference | AppSpecServiceGithub): any;
export declare class AppSpecServiceGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecServiceGithub | undefined;
    set internalValue(value: AppSpecServiceGithub | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _deployOnPush?;
    get deployOnPush(): boolean | cdktf.IResolvable;
    set deployOnPush(value: boolean | cdktf.IResolvable);
    resetDeployOnPush(): void;
    get deployOnPushInput(): boolean | cdktf.IResolvable | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface AppSpecServiceGitlab {
    /**
    * The name of the branch to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#branch App#branch}
    */
    readonly branch?: string;
    /**
    * Whether to automatically deploy new commits made to the repo
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#deploy_on_push App#deploy_on_push}
    */
    readonly deployOnPush?: boolean | cdktf.IResolvable;
    /**
    * The name of the repo in the format `owner/repo`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repo App#repo}
    */
    readonly repo?: string;
}
export declare function appSpecServiceGitlabToTerraform(struct?: AppSpecServiceGitlabOutputReference | AppSpecServiceGitlab): any;
export declare class AppSpecServiceGitlabOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecServiceGitlab | undefined;
    set internalValue(value: AppSpecServiceGitlab | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _deployOnPush?;
    get deployOnPush(): boolean | cdktf.IResolvable;
    set deployOnPush(value: boolean | cdktf.IResolvable);
    resetDeployOnPush(): void;
    get deployOnPushInput(): boolean | cdktf.IResolvable | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface AppSpecServiceHealthCheck {
    /**
    * The number of failed health checks before considered unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#failure_threshold App#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * The route path used for the HTTP health check ping.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#http_path App#http_path}
    */
    readonly httpPath?: string;
    /**
    * The number of seconds to wait before beginning health checks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#initial_delay_seconds App#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * The number of seconds to wait between health checks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#period_seconds App#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * The number of successful health checks before considered healthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#success_threshold App#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * The number of seconds after which the check times out.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#timeout_seconds App#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
}
export declare function appSpecServiceHealthCheckToTerraform(struct?: AppSpecServiceHealthCheckOutputReference | AppSpecServiceHealthCheck): any;
export declare class AppSpecServiceHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecServiceHealthCheck | undefined;
    set internalValue(value: AppSpecServiceHealthCheck | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _httpPath?;
    get httpPath(): string;
    set httpPath(value: string);
    resetHttpPath(): void;
    get httpPathInput(): string | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
}
export interface AppSpecServiceImage {
    /**
    * The registry name. Must be left empty for the DOCR registry type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#registry App#registry}
    */
    readonly registry?: string;
    /**
    * The registry type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#registry_type App#registry_type}
    */
    readonly registryType: string;
    /**
    * The repository name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repository App#repository}
    */
    readonly repository: string;
    /**
    * The repository tag. Defaults to latest if not provided.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#tag App#tag}
    */
    readonly tag?: string;
}
export declare function appSpecServiceImageToTerraform(struct?: AppSpecServiceImageOutputReference | AppSpecServiceImage): any;
export declare class AppSpecServiceImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecServiceImage | undefined;
    set internalValue(value: AppSpecServiceImage | undefined);
    private _registry?;
    get registry(): string;
    set registry(value: string);
    resetRegistry(): void;
    get registryInput(): string | undefined;
    private _registryType?;
    get registryType(): string;
    set registryType(value: string);
    get registryTypeInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export interface AppSpecServiceLogDestinationDatadog {
    /**
    * Datadog API key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#api_key App#api_key}
    */
    readonly apiKey: string;
    /**
    * Datadog HTTP log intake endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#endpoint App#endpoint}
    */
    readonly endpoint?: string;
}
export declare function appSpecServiceLogDestinationDatadogToTerraform(struct?: AppSpecServiceLogDestinationDatadogOutputReference | AppSpecServiceLogDestinationDatadog): any;
export declare class AppSpecServiceLogDestinationDatadogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecServiceLogDestinationDatadog | undefined;
    set internalValue(value: AppSpecServiceLogDestinationDatadog | undefined);
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    get apiKeyInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
}
export interface AppSpecServiceLogDestinationLogtail {
    /**
    * Logtail token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#token App#token}
    */
    readonly token: string;
}
export declare function appSpecServiceLogDestinationLogtailToTerraform(struct?: AppSpecServiceLogDestinationLogtailOutputReference | AppSpecServiceLogDestinationLogtail): any;
export declare class AppSpecServiceLogDestinationLogtailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecServiceLogDestinationLogtail | undefined;
    set internalValue(value: AppSpecServiceLogDestinationLogtail | undefined);
    private _token?;
    get token(): string;
    set token(value: string);
    get tokenInput(): string | undefined;
}
export interface AppSpecServiceLogDestinationPapertrail {
    /**
    * Papertrail syslog endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#endpoint App#endpoint}
    */
    readonly endpoint: string;
}
export declare function appSpecServiceLogDestinationPapertrailToTerraform(struct?: AppSpecServiceLogDestinationPapertrailOutputReference | AppSpecServiceLogDestinationPapertrail): any;
export declare class AppSpecServiceLogDestinationPapertrailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecServiceLogDestinationPapertrail | undefined;
    set internalValue(value: AppSpecServiceLogDestinationPapertrail | undefined);
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    get endpointInput(): string | undefined;
}
export interface AppSpecServiceLogDestination {
    /**
    * Name of the log destination
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#name App#name}
    */
    readonly name: string;
    /**
    * datadog block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#datadog App#datadog}
    */
    readonly datadog?: AppSpecServiceLogDestinationDatadog;
    /**
    * logtail block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#logtail App#logtail}
    */
    readonly logtail?: AppSpecServiceLogDestinationLogtail;
    /**
    * papertrail block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#papertrail App#papertrail}
    */
    readonly papertrail?: AppSpecServiceLogDestinationPapertrail;
}
export declare function appSpecServiceLogDestinationToTerraform(struct?: AppSpecServiceLogDestination | cdktf.IResolvable): any;
export declare class AppSpecServiceLogDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecServiceLogDestination | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecServiceLogDestination | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _datadog;
    get datadog(): AppSpecServiceLogDestinationDatadogOutputReference;
    putDatadog(value: AppSpecServiceLogDestinationDatadog): void;
    resetDatadog(): void;
    get datadogInput(): AppSpecServiceLogDestinationDatadog | undefined;
    private _logtail;
    get logtail(): AppSpecServiceLogDestinationLogtailOutputReference;
    putLogtail(value: AppSpecServiceLogDestinationLogtail): void;
    resetLogtail(): void;
    get logtailInput(): AppSpecServiceLogDestinationLogtail | undefined;
    private _papertrail;
    get papertrail(): AppSpecServiceLogDestinationPapertrailOutputReference;
    putPapertrail(value: AppSpecServiceLogDestinationPapertrail): void;
    resetPapertrail(): void;
    get papertrailInput(): AppSpecServiceLogDestinationPapertrail | undefined;
}
export declare class AppSpecServiceLogDestinationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecServiceLogDestination[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecServiceLogDestinationOutputReference;
}
export interface AppSpecServiceRoutes {
    /**
    * Path specifies an route by HTTP path prefix. Paths must start with / and must be unique within the app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#path App#path}
    */
    readonly path?: string;
    /**
    *  An optional flag to preserve the path that is forwarded to the backend service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#preserve_path_prefix App#preserve_path_prefix}
    */
    readonly preservePathPrefix?: boolean | cdktf.IResolvable;
}
export declare function appSpecServiceRoutesToTerraform(struct?: AppSpecServiceRoutes | cdktf.IResolvable): any;
export declare class AppSpecServiceRoutesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecServiceRoutes | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecServiceRoutes | cdktf.IResolvable | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _preservePathPrefix?;
    get preservePathPrefix(): boolean | cdktf.IResolvable;
    set preservePathPrefix(value: boolean | cdktf.IResolvable);
    resetPreservePathPrefix(): void;
    get preservePathPrefixInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class AppSpecServiceRoutesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecServiceRoutes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecServiceRoutesOutputReference;
}
export interface AppSpecService {
    /**
    * An optional build command to run while building this component from source.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#build_command App#build_command}
    */
    readonly buildCommand?: string;
    /**
    * The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#dockerfile_path App#dockerfile_path}
    */
    readonly dockerfilePath?: string;
    /**
    * An environment slug describing the type of this app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#environment_slug App#environment_slug}
    */
    readonly environmentSlug?: string;
    /**
    * The internal port on which this service's run command will listen.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#http_port App#http_port}
    */
    readonly httpPort?: number;
    /**
    * The amount of instances that this component should be scaled to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#instance_count App#instance_count}
    */
    readonly instanceCount?: number;
    /**
    * The instance size to use for this component.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#instance_size_slug App#instance_size_slug}
    */
    readonly instanceSizeSlug?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#internal_ports App#internal_ports}
    */
    readonly internalPorts?: number[];
    /**
    * The name of the component
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#name App#name}
    */
    readonly name: string;
    /**
    * An optional run command to override the component's default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#run_command App#run_command}
    */
    readonly runCommand?: string;
    /**
    * An optional path to the working directory to use for the build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#source_dir App#source_dir}
    */
    readonly sourceDir?: string;
    /**
    * alert block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#alert App#alert}
    */
    readonly alert?: AppSpecServiceAlert[] | cdktf.IResolvable;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#cors App#cors}
    */
    readonly cors?: AppSpecServiceCors;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#env App#env}
    */
    readonly env?: AppSpecServiceEnv[] | cdktf.IResolvable;
    /**
    * git block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#git App#git}
    */
    readonly git?: AppSpecServiceGit;
    /**
    * github block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#github App#github}
    */
    readonly github?: AppSpecServiceGithub;
    /**
    * gitlab block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#gitlab App#gitlab}
    */
    readonly gitlab?: AppSpecServiceGitlab;
    /**
    * health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#health_check App#health_check}
    */
    readonly healthCheck?: AppSpecServiceHealthCheck;
    /**
    * image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#image App#image}
    */
    readonly image?: AppSpecServiceImage;
    /**
    * log_destination block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#log_destination App#log_destination}
    */
    readonly logDestination?: AppSpecServiceLogDestination[] | cdktf.IResolvable;
    /**
    * routes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#routes App#routes}
    */
    readonly routes?: AppSpecServiceRoutes[] | cdktf.IResolvable;
}
export declare function appSpecServiceToTerraform(struct?: AppSpecService | cdktf.IResolvable): any;
export declare class AppSpecServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecService | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecService | cdktf.IResolvable | undefined);
    private _buildCommand?;
    get buildCommand(): string;
    set buildCommand(value: string);
    resetBuildCommand(): void;
    get buildCommandInput(): string | undefined;
    private _dockerfilePath?;
    get dockerfilePath(): string;
    set dockerfilePath(value: string);
    resetDockerfilePath(): void;
    get dockerfilePathInput(): string | undefined;
    private _environmentSlug?;
    get environmentSlug(): string;
    set environmentSlug(value: string);
    resetEnvironmentSlug(): void;
    get environmentSlugInput(): string | undefined;
    private _httpPort?;
    get httpPort(): number;
    set httpPort(value: number);
    resetHttpPort(): void;
    get httpPortInput(): number | undefined;
    private _instanceCount?;
    get instanceCount(): number;
    set instanceCount(value: number);
    resetInstanceCount(): void;
    get instanceCountInput(): number | undefined;
    private _instanceSizeSlug?;
    get instanceSizeSlug(): string;
    set instanceSizeSlug(value: string);
    resetInstanceSizeSlug(): void;
    get instanceSizeSlugInput(): string | undefined;
    private _internalPorts?;
    get internalPorts(): number[];
    set internalPorts(value: number[]);
    resetInternalPorts(): void;
    get internalPortsInput(): number[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _runCommand?;
    get runCommand(): string;
    set runCommand(value: string);
    resetRunCommand(): void;
    get runCommandInput(): string | undefined;
    private _sourceDir?;
    get sourceDir(): string;
    set sourceDir(value: string);
    resetSourceDir(): void;
    get sourceDirInput(): string | undefined;
    private _alert;
    get alert(): AppSpecServiceAlertList;
    putAlert(value: AppSpecServiceAlert[] | cdktf.IResolvable): void;
    resetAlert(): void;
    get alertInput(): cdktf.IResolvable | AppSpecServiceAlert[] | undefined;
    private _cors;
    get cors(): AppSpecServiceCorsOutputReference;
    putCors(value: AppSpecServiceCors): void;
    resetCors(): void;
    get corsInput(): AppSpecServiceCors | undefined;
    private _env;
    get env(): AppSpecServiceEnvList;
    putEnv(value: AppSpecServiceEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | AppSpecServiceEnv[] | undefined;
    private _git;
    get git(): AppSpecServiceGitOutputReference;
    putGit(value: AppSpecServiceGit): void;
    resetGit(): void;
    get gitInput(): AppSpecServiceGit | undefined;
    private _github;
    get github(): AppSpecServiceGithubOutputReference;
    putGithub(value: AppSpecServiceGithub): void;
    resetGithub(): void;
    get githubInput(): AppSpecServiceGithub | undefined;
    private _gitlab;
    get gitlab(): AppSpecServiceGitlabOutputReference;
    putGitlab(value: AppSpecServiceGitlab): void;
    resetGitlab(): void;
    get gitlabInput(): AppSpecServiceGitlab | undefined;
    private _healthCheck;
    get healthCheck(): AppSpecServiceHealthCheckOutputReference;
    putHealthCheck(value: AppSpecServiceHealthCheck): void;
    resetHealthCheck(): void;
    get healthCheckInput(): AppSpecServiceHealthCheck | undefined;
    private _image;
    get image(): AppSpecServiceImageOutputReference;
    putImage(value: AppSpecServiceImage): void;
    resetImage(): void;
    get imageInput(): AppSpecServiceImage | undefined;
    private _logDestination;
    get logDestination(): AppSpecServiceLogDestinationList;
    putLogDestination(value: AppSpecServiceLogDestination[] | cdktf.IResolvable): void;
    resetLogDestination(): void;
    get logDestinationInput(): cdktf.IResolvable | AppSpecServiceLogDestination[] | undefined;
    private _routes;
    get routes(): AppSpecServiceRoutesList;
    putRoutes(value: AppSpecServiceRoutes[] | cdktf.IResolvable): void;
    resetRoutes(): void;
    get routesInput(): cdktf.IResolvable | AppSpecServiceRoutes[] | undefined;
}
export declare class AppSpecServiceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecService[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecServiceOutputReference;
}
export interface AppSpecStaticSiteCorsAllowOrigins {
    /**
    * Exact string match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#exact App#exact}
    */
    readonly exact?: string;
    /**
    * Prefix-based match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#prefix App#prefix}
    */
    readonly prefix?: string;
    /**
    * RE2 style regex-based match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#regex App#regex}
    */
    readonly regex?: string;
}
export declare function appSpecStaticSiteCorsAllowOriginsToTerraform(struct?: AppSpecStaticSiteCorsAllowOriginsOutputReference | AppSpecStaticSiteCorsAllowOrigins): any;
export declare class AppSpecStaticSiteCorsAllowOriginsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecStaticSiteCorsAllowOrigins | undefined;
    set internalValue(value: AppSpecStaticSiteCorsAllowOrigins | undefined);
    private _exact?;
    get exact(): string;
    set exact(value: string);
    resetExact(): void;
    get exactInput(): string | undefined;
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    private _regex?;
    get regex(): string;
    set regex(value: string);
    resetRegex(): void;
    get regexInput(): string | undefined;
}
export interface AppSpecStaticSiteCors {
    /**
    * Whether browsers should expose the response to the client-side JavaScript code when the request’s credentials mode is `include`. This configures the Access-Control-Allow-Credentials header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#allow_credentials App#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * The set of allowed HTTP request headers. This configures the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#allow_headers App#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * The set of allowed HTTP methods. This configures the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#allow_methods App#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * The set of HTTP response headers that browsers are allowed to access. This configures the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#expose_headers App#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#max_age App#max_age}
    */
    readonly maxAge?: string;
    /**
    * allow_origins block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#allow_origins App#allow_origins}
    */
    readonly allowOrigins?: AppSpecStaticSiteCorsAllowOrigins;
}
export declare function appSpecStaticSiteCorsToTerraform(struct?: AppSpecStaticSiteCorsOutputReference | AppSpecStaticSiteCors): any;
export declare class AppSpecStaticSiteCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecStaticSiteCors | undefined;
    set internalValue(value: AppSpecStaticSiteCors | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): string;
    set maxAge(value: string);
    resetMaxAge(): void;
    get maxAgeInput(): string | undefined;
    private _allowOrigins;
    get allowOrigins(): AppSpecStaticSiteCorsAllowOriginsOutputReference;
    putAllowOrigins(value: AppSpecStaticSiteCorsAllowOrigins): void;
    resetAllowOrigins(): void;
    get allowOriginsInput(): AppSpecStaticSiteCorsAllowOrigins | undefined;
}
export interface AppSpecStaticSiteEnv {
    /**
    * The name of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#key App#key}
    */
    readonly key?: string;
    /**
    * The visibility scope of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#scope App#scope}
    */
    readonly scope?: string;
    /**
    * The type of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#type App#type}
    */
    readonly type?: string;
    /**
    * The value of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#value App#value}
    */
    readonly value?: string;
}
export declare function appSpecStaticSiteEnvToTerraform(struct?: AppSpecStaticSiteEnv | cdktf.IResolvable): any;
export declare class AppSpecStaticSiteEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecStaticSiteEnv | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecStaticSiteEnv | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class AppSpecStaticSiteEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecStaticSiteEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecStaticSiteEnvOutputReference;
}
export interface AppSpecStaticSiteGit {
    /**
    * The name of the branch to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#branch App#branch}
    */
    readonly branch?: string;
    /**
    * The clone URL of the repo.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repo_clone_url App#repo_clone_url}
    */
    readonly repoCloneUrl?: string;
}
export declare function appSpecStaticSiteGitToTerraform(struct?: AppSpecStaticSiteGitOutputReference | AppSpecStaticSiteGit): any;
export declare class AppSpecStaticSiteGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecStaticSiteGit | undefined;
    set internalValue(value: AppSpecStaticSiteGit | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _repoCloneUrl?;
    get repoCloneUrl(): string;
    set repoCloneUrl(value: string);
    resetRepoCloneUrl(): void;
    get repoCloneUrlInput(): string | undefined;
}
export interface AppSpecStaticSiteGithub {
    /**
    * The name of the branch to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#branch App#branch}
    */
    readonly branch?: string;
    /**
    * Whether to automatically deploy new commits made to the repo
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#deploy_on_push App#deploy_on_push}
    */
    readonly deployOnPush?: boolean | cdktf.IResolvable;
    /**
    * The name of the repo in the format `owner/repo`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repo App#repo}
    */
    readonly repo?: string;
}
export declare function appSpecStaticSiteGithubToTerraform(struct?: AppSpecStaticSiteGithubOutputReference | AppSpecStaticSiteGithub): any;
export declare class AppSpecStaticSiteGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecStaticSiteGithub | undefined;
    set internalValue(value: AppSpecStaticSiteGithub | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _deployOnPush?;
    get deployOnPush(): boolean | cdktf.IResolvable;
    set deployOnPush(value: boolean | cdktf.IResolvable);
    resetDeployOnPush(): void;
    get deployOnPushInput(): boolean | cdktf.IResolvable | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface AppSpecStaticSiteGitlab {
    /**
    * The name of the branch to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#branch App#branch}
    */
    readonly branch?: string;
    /**
    * Whether to automatically deploy new commits made to the repo
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#deploy_on_push App#deploy_on_push}
    */
    readonly deployOnPush?: boolean | cdktf.IResolvable;
    /**
    * The name of the repo in the format `owner/repo`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repo App#repo}
    */
    readonly repo?: string;
}
export declare function appSpecStaticSiteGitlabToTerraform(struct?: AppSpecStaticSiteGitlabOutputReference | AppSpecStaticSiteGitlab): any;
export declare class AppSpecStaticSiteGitlabOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecStaticSiteGitlab | undefined;
    set internalValue(value: AppSpecStaticSiteGitlab | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _deployOnPush?;
    get deployOnPush(): boolean | cdktf.IResolvable;
    set deployOnPush(value: boolean | cdktf.IResolvable);
    resetDeployOnPush(): void;
    get deployOnPushInput(): boolean | cdktf.IResolvable | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface AppSpecStaticSiteRoutes {
    /**
    * Path specifies an route by HTTP path prefix. Paths must start with / and must be unique within the app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#path App#path}
    */
    readonly path?: string;
    /**
    *  An optional flag to preserve the path that is forwarded to the backend service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#preserve_path_prefix App#preserve_path_prefix}
    */
    readonly preservePathPrefix?: boolean | cdktf.IResolvable;
}
export declare function appSpecStaticSiteRoutesToTerraform(struct?: AppSpecStaticSiteRoutes | cdktf.IResolvable): any;
export declare class AppSpecStaticSiteRoutesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecStaticSiteRoutes | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecStaticSiteRoutes | cdktf.IResolvable | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _preservePathPrefix?;
    get preservePathPrefix(): boolean | cdktf.IResolvable;
    set preservePathPrefix(value: boolean | cdktf.IResolvable);
    resetPreservePathPrefix(): void;
    get preservePathPrefixInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class AppSpecStaticSiteRoutesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecStaticSiteRoutes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecStaticSiteRoutesOutputReference;
}
export interface AppSpecStaticSite {
    /**
    * An optional build command to run while building this component from source.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#build_command App#build_command}
    */
    readonly buildCommand?: string;
    /**
    * The name of the document to use as the fallback for any requests to documents that are not found when serving this static site.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#catchall_document App#catchall_document}
    */
    readonly catchallDocument?: string;
    /**
    * The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#dockerfile_path App#dockerfile_path}
    */
    readonly dockerfilePath?: string;
    /**
    * An environment slug describing the type of this app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#environment_slug App#environment_slug}
    */
    readonly environmentSlug?: string;
    /**
    * The name of the error document to use when serving this static site.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#error_document App#error_document}
    */
    readonly errorDocument?: string;
    /**
    * The name of the index document to use when serving this static site.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#index_document App#index_document}
    */
    readonly indexDocument?: string;
    /**
    * The name of the component
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#name App#name}
    */
    readonly name: string;
    /**
    * An optional path to where the built assets will be located, relative to the build context. If not set, App Platform will automatically scan for these directory names: `_static`, `dist`, `public`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#output_dir App#output_dir}
    */
    readonly outputDir?: string;
    /**
    * An optional path to the working directory to use for the build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#source_dir App#source_dir}
    */
    readonly sourceDir?: string;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#cors App#cors}
    */
    readonly cors?: AppSpecStaticSiteCors;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#env App#env}
    */
    readonly env?: AppSpecStaticSiteEnv[] | cdktf.IResolvable;
    /**
    * git block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#git App#git}
    */
    readonly git?: AppSpecStaticSiteGit;
    /**
    * github block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#github App#github}
    */
    readonly github?: AppSpecStaticSiteGithub;
    /**
    * gitlab block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#gitlab App#gitlab}
    */
    readonly gitlab?: AppSpecStaticSiteGitlab;
    /**
    * routes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#routes App#routes}
    */
    readonly routes?: AppSpecStaticSiteRoutes[] | cdktf.IResolvable;
}
export declare function appSpecStaticSiteToTerraform(struct?: AppSpecStaticSite | cdktf.IResolvable): any;
export declare class AppSpecStaticSiteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecStaticSite | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecStaticSite | cdktf.IResolvable | undefined);
    private _buildCommand?;
    get buildCommand(): string;
    set buildCommand(value: string);
    resetBuildCommand(): void;
    get buildCommandInput(): string | undefined;
    private _catchallDocument?;
    get catchallDocument(): string;
    set catchallDocument(value: string);
    resetCatchallDocument(): void;
    get catchallDocumentInput(): string | undefined;
    private _dockerfilePath?;
    get dockerfilePath(): string;
    set dockerfilePath(value: string);
    resetDockerfilePath(): void;
    get dockerfilePathInput(): string | undefined;
    private _environmentSlug?;
    get environmentSlug(): string;
    set environmentSlug(value: string);
    resetEnvironmentSlug(): void;
    get environmentSlugInput(): string | undefined;
    private _errorDocument?;
    get errorDocument(): string;
    set errorDocument(value: string);
    resetErrorDocument(): void;
    get errorDocumentInput(): string | undefined;
    private _indexDocument?;
    get indexDocument(): string;
    set indexDocument(value: string);
    resetIndexDocument(): void;
    get indexDocumentInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _outputDir?;
    get outputDir(): string;
    set outputDir(value: string);
    resetOutputDir(): void;
    get outputDirInput(): string | undefined;
    private _sourceDir?;
    get sourceDir(): string;
    set sourceDir(value: string);
    resetSourceDir(): void;
    get sourceDirInput(): string | undefined;
    private _cors;
    get cors(): AppSpecStaticSiteCorsOutputReference;
    putCors(value: AppSpecStaticSiteCors): void;
    resetCors(): void;
    get corsInput(): AppSpecStaticSiteCors | undefined;
    private _env;
    get env(): AppSpecStaticSiteEnvList;
    putEnv(value: AppSpecStaticSiteEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | AppSpecStaticSiteEnv[] | undefined;
    private _git;
    get git(): AppSpecStaticSiteGitOutputReference;
    putGit(value: AppSpecStaticSiteGit): void;
    resetGit(): void;
    get gitInput(): AppSpecStaticSiteGit | undefined;
    private _github;
    get github(): AppSpecStaticSiteGithubOutputReference;
    putGithub(value: AppSpecStaticSiteGithub): void;
    resetGithub(): void;
    get githubInput(): AppSpecStaticSiteGithub | undefined;
    private _gitlab;
    get gitlab(): AppSpecStaticSiteGitlabOutputReference;
    putGitlab(value: AppSpecStaticSiteGitlab): void;
    resetGitlab(): void;
    get gitlabInput(): AppSpecStaticSiteGitlab | undefined;
    private _routes;
    get routes(): AppSpecStaticSiteRoutesList;
    putRoutes(value: AppSpecStaticSiteRoutes[] | cdktf.IResolvable): void;
    resetRoutes(): void;
    get routesInput(): cdktf.IResolvable | AppSpecStaticSiteRoutes[] | undefined;
}
export declare class AppSpecStaticSiteList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecStaticSite[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecStaticSiteOutputReference;
}
export interface AppSpecWorkerAlert {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#disabled App#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#operator App#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#rule App#rule}
    */
    readonly rule: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#value App#value}
    */
    readonly value: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#window App#window}
    */
    readonly window: string;
}
export declare function appSpecWorkerAlertToTerraform(struct?: AppSpecWorkerAlert | cdktf.IResolvable): any;
export declare class AppSpecWorkerAlertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecWorkerAlert | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecWorkerAlert | cdktf.IResolvable | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
    private _window?;
    get window(): string;
    set window(value: string);
    get windowInput(): string | undefined;
}
export declare class AppSpecWorkerAlertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecWorkerAlert[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecWorkerAlertOutputReference;
}
export interface AppSpecWorkerEnv {
    /**
    * The name of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#key App#key}
    */
    readonly key?: string;
    /**
    * The visibility scope of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#scope App#scope}
    */
    readonly scope?: string;
    /**
    * The type of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#type App#type}
    */
    readonly type?: string;
    /**
    * The value of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#value App#value}
    */
    readonly value?: string;
}
export declare function appSpecWorkerEnvToTerraform(struct?: AppSpecWorkerEnv | cdktf.IResolvable): any;
export declare class AppSpecWorkerEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecWorkerEnv | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecWorkerEnv | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class AppSpecWorkerEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecWorkerEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecWorkerEnvOutputReference;
}
export interface AppSpecWorkerGit {
    /**
    * The name of the branch to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#branch App#branch}
    */
    readonly branch?: string;
    /**
    * The clone URL of the repo.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repo_clone_url App#repo_clone_url}
    */
    readonly repoCloneUrl?: string;
}
export declare function appSpecWorkerGitToTerraform(struct?: AppSpecWorkerGitOutputReference | AppSpecWorkerGit): any;
export declare class AppSpecWorkerGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecWorkerGit | undefined;
    set internalValue(value: AppSpecWorkerGit | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _repoCloneUrl?;
    get repoCloneUrl(): string;
    set repoCloneUrl(value: string);
    resetRepoCloneUrl(): void;
    get repoCloneUrlInput(): string | undefined;
}
export interface AppSpecWorkerGithub {
    /**
    * The name of the branch to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#branch App#branch}
    */
    readonly branch?: string;
    /**
    * Whether to automatically deploy new commits made to the repo
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#deploy_on_push App#deploy_on_push}
    */
    readonly deployOnPush?: boolean | cdktf.IResolvable;
    /**
    * The name of the repo in the format `owner/repo`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repo App#repo}
    */
    readonly repo?: string;
}
export declare function appSpecWorkerGithubToTerraform(struct?: AppSpecWorkerGithubOutputReference | AppSpecWorkerGithub): any;
export declare class AppSpecWorkerGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecWorkerGithub | undefined;
    set internalValue(value: AppSpecWorkerGithub | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _deployOnPush?;
    get deployOnPush(): boolean | cdktf.IResolvable;
    set deployOnPush(value: boolean | cdktf.IResolvable);
    resetDeployOnPush(): void;
    get deployOnPushInput(): boolean | cdktf.IResolvable | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface AppSpecWorkerGitlab {
    /**
    * The name of the branch to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#branch App#branch}
    */
    readonly branch?: string;
    /**
    * Whether to automatically deploy new commits made to the repo
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#deploy_on_push App#deploy_on_push}
    */
    readonly deployOnPush?: boolean | cdktf.IResolvable;
    /**
    * The name of the repo in the format `owner/repo`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repo App#repo}
    */
    readonly repo?: string;
}
export declare function appSpecWorkerGitlabToTerraform(struct?: AppSpecWorkerGitlabOutputReference | AppSpecWorkerGitlab): any;
export declare class AppSpecWorkerGitlabOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecWorkerGitlab | undefined;
    set internalValue(value: AppSpecWorkerGitlab | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _deployOnPush?;
    get deployOnPush(): boolean | cdktf.IResolvable;
    set deployOnPush(value: boolean | cdktf.IResolvable);
    resetDeployOnPush(): void;
    get deployOnPushInput(): boolean | cdktf.IResolvable | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface AppSpecWorkerImage {
    /**
    * The registry name. Must be left empty for the DOCR registry type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#registry App#registry}
    */
    readonly registry?: string;
    /**
    * The registry type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#registry_type App#registry_type}
    */
    readonly registryType: string;
    /**
    * The repository name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#repository App#repository}
    */
    readonly repository: string;
    /**
    * The repository tag. Defaults to latest if not provided.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#tag App#tag}
    */
    readonly tag?: string;
}
export declare function appSpecWorkerImageToTerraform(struct?: AppSpecWorkerImageOutputReference | AppSpecWorkerImage): any;
export declare class AppSpecWorkerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecWorkerImage | undefined;
    set internalValue(value: AppSpecWorkerImage | undefined);
    private _registry?;
    get registry(): string;
    set registry(value: string);
    resetRegistry(): void;
    get registryInput(): string | undefined;
    private _registryType?;
    get registryType(): string;
    set registryType(value: string);
    get registryTypeInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export interface AppSpecWorkerLogDestinationDatadog {
    /**
    * Datadog API key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#api_key App#api_key}
    */
    readonly apiKey: string;
    /**
    * Datadog HTTP log intake endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#endpoint App#endpoint}
    */
    readonly endpoint?: string;
}
export declare function appSpecWorkerLogDestinationDatadogToTerraform(struct?: AppSpecWorkerLogDestinationDatadogOutputReference | AppSpecWorkerLogDestinationDatadog): any;
export declare class AppSpecWorkerLogDestinationDatadogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecWorkerLogDestinationDatadog | undefined;
    set internalValue(value: AppSpecWorkerLogDestinationDatadog | undefined);
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    get apiKeyInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
}
export interface AppSpecWorkerLogDestinationLogtail {
    /**
    * Logtail token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#token App#token}
    */
    readonly token: string;
}
export declare function appSpecWorkerLogDestinationLogtailToTerraform(struct?: AppSpecWorkerLogDestinationLogtailOutputReference | AppSpecWorkerLogDestinationLogtail): any;
export declare class AppSpecWorkerLogDestinationLogtailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecWorkerLogDestinationLogtail | undefined;
    set internalValue(value: AppSpecWorkerLogDestinationLogtail | undefined);
    private _token?;
    get token(): string;
    set token(value: string);
    get tokenInput(): string | undefined;
}
export interface AppSpecWorkerLogDestinationPapertrail {
    /**
    * Papertrail syslog endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#endpoint App#endpoint}
    */
    readonly endpoint: string;
}
export declare function appSpecWorkerLogDestinationPapertrailToTerraform(struct?: AppSpecWorkerLogDestinationPapertrailOutputReference | AppSpecWorkerLogDestinationPapertrail): any;
export declare class AppSpecWorkerLogDestinationPapertrailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpecWorkerLogDestinationPapertrail | undefined;
    set internalValue(value: AppSpecWorkerLogDestinationPapertrail | undefined);
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    get endpointInput(): string | undefined;
}
export interface AppSpecWorkerLogDestination {
    /**
    * Name of the log destination
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#name App#name}
    */
    readonly name: string;
    /**
    * datadog block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#datadog App#datadog}
    */
    readonly datadog?: AppSpecWorkerLogDestinationDatadog;
    /**
    * logtail block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#logtail App#logtail}
    */
    readonly logtail?: AppSpecWorkerLogDestinationLogtail;
    /**
    * papertrail block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#papertrail App#papertrail}
    */
    readonly papertrail?: AppSpecWorkerLogDestinationPapertrail;
}
export declare function appSpecWorkerLogDestinationToTerraform(struct?: AppSpecWorkerLogDestination | cdktf.IResolvable): any;
export declare class AppSpecWorkerLogDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecWorkerLogDestination | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecWorkerLogDestination | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _datadog;
    get datadog(): AppSpecWorkerLogDestinationDatadogOutputReference;
    putDatadog(value: AppSpecWorkerLogDestinationDatadog): void;
    resetDatadog(): void;
    get datadogInput(): AppSpecWorkerLogDestinationDatadog | undefined;
    private _logtail;
    get logtail(): AppSpecWorkerLogDestinationLogtailOutputReference;
    putLogtail(value: AppSpecWorkerLogDestinationLogtail): void;
    resetLogtail(): void;
    get logtailInput(): AppSpecWorkerLogDestinationLogtail | undefined;
    private _papertrail;
    get papertrail(): AppSpecWorkerLogDestinationPapertrailOutputReference;
    putPapertrail(value: AppSpecWorkerLogDestinationPapertrail): void;
    resetPapertrail(): void;
    get papertrailInput(): AppSpecWorkerLogDestinationPapertrail | undefined;
}
export declare class AppSpecWorkerLogDestinationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecWorkerLogDestination[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecWorkerLogDestinationOutputReference;
}
export interface AppSpecWorker {
    /**
    * An optional build command to run while building this component from source.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#build_command App#build_command}
    */
    readonly buildCommand?: string;
    /**
    * The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#dockerfile_path App#dockerfile_path}
    */
    readonly dockerfilePath?: string;
    /**
    * An environment slug describing the type of this app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#environment_slug App#environment_slug}
    */
    readonly environmentSlug?: string;
    /**
    * The amount of instances that this component should be scaled to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#instance_count App#instance_count}
    */
    readonly instanceCount?: number;
    /**
    * The instance size to use for this component.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#instance_size_slug App#instance_size_slug}
    */
    readonly instanceSizeSlug?: string;
    /**
    * The name of the component
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#name App#name}
    */
    readonly name: string;
    /**
    * An optional run command to override the component's default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#run_command App#run_command}
    */
    readonly runCommand?: string;
    /**
    * An optional path to the working directory to use for the build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#source_dir App#source_dir}
    */
    readonly sourceDir?: string;
    /**
    * alert block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#alert App#alert}
    */
    readonly alert?: AppSpecWorkerAlert[] | cdktf.IResolvable;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#env App#env}
    */
    readonly env?: AppSpecWorkerEnv[] | cdktf.IResolvable;
    /**
    * git block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#git App#git}
    */
    readonly git?: AppSpecWorkerGit;
    /**
    * github block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#github App#github}
    */
    readonly github?: AppSpecWorkerGithub;
    /**
    * gitlab block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#gitlab App#gitlab}
    */
    readonly gitlab?: AppSpecWorkerGitlab;
    /**
    * image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#image App#image}
    */
    readonly image?: AppSpecWorkerImage;
    /**
    * log_destination block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#log_destination App#log_destination}
    */
    readonly logDestination?: AppSpecWorkerLogDestination[] | cdktf.IResolvable;
}
export declare function appSpecWorkerToTerraform(struct?: AppSpecWorker | cdktf.IResolvable): any;
export declare class AppSpecWorkerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSpecWorker | cdktf.IResolvable | undefined;
    set internalValue(value: AppSpecWorker | cdktf.IResolvable | undefined);
    private _buildCommand?;
    get buildCommand(): string;
    set buildCommand(value: string);
    resetBuildCommand(): void;
    get buildCommandInput(): string | undefined;
    private _dockerfilePath?;
    get dockerfilePath(): string;
    set dockerfilePath(value: string);
    resetDockerfilePath(): void;
    get dockerfilePathInput(): string | undefined;
    private _environmentSlug?;
    get environmentSlug(): string;
    set environmentSlug(value: string);
    resetEnvironmentSlug(): void;
    get environmentSlugInput(): string | undefined;
    private _instanceCount?;
    get instanceCount(): number;
    set instanceCount(value: number);
    resetInstanceCount(): void;
    get instanceCountInput(): number | undefined;
    private _instanceSizeSlug?;
    get instanceSizeSlug(): string;
    set instanceSizeSlug(value: string);
    resetInstanceSizeSlug(): void;
    get instanceSizeSlugInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _runCommand?;
    get runCommand(): string;
    set runCommand(value: string);
    resetRunCommand(): void;
    get runCommandInput(): string | undefined;
    private _sourceDir?;
    get sourceDir(): string;
    set sourceDir(value: string);
    resetSourceDir(): void;
    get sourceDirInput(): string | undefined;
    private _alert;
    get alert(): AppSpecWorkerAlertList;
    putAlert(value: AppSpecWorkerAlert[] | cdktf.IResolvable): void;
    resetAlert(): void;
    get alertInput(): cdktf.IResolvable | AppSpecWorkerAlert[] | undefined;
    private _env;
    get env(): AppSpecWorkerEnvList;
    putEnv(value: AppSpecWorkerEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | AppSpecWorkerEnv[] | undefined;
    private _git;
    get git(): AppSpecWorkerGitOutputReference;
    putGit(value: AppSpecWorkerGit): void;
    resetGit(): void;
    get gitInput(): AppSpecWorkerGit | undefined;
    private _github;
    get github(): AppSpecWorkerGithubOutputReference;
    putGithub(value: AppSpecWorkerGithub): void;
    resetGithub(): void;
    get githubInput(): AppSpecWorkerGithub | undefined;
    private _gitlab;
    get gitlab(): AppSpecWorkerGitlabOutputReference;
    putGitlab(value: AppSpecWorkerGitlab): void;
    resetGitlab(): void;
    get gitlabInput(): AppSpecWorkerGitlab | undefined;
    private _image;
    get image(): AppSpecWorkerImageOutputReference;
    putImage(value: AppSpecWorkerImage): void;
    resetImage(): void;
    get imageInput(): AppSpecWorkerImage | undefined;
    private _logDestination;
    get logDestination(): AppSpecWorkerLogDestinationList;
    putLogDestination(value: AppSpecWorkerLogDestination[] | cdktf.IResolvable): void;
    resetLogDestination(): void;
    get logDestinationInput(): cdktf.IResolvable | AppSpecWorkerLogDestination[] | undefined;
}
export declare class AppSpecWorkerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSpecWorker[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSpecWorkerOutputReference;
}
export interface AppSpec {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#domains App#domains}
    */
    readonly domains?: string[];
    /**
    * The name of the app. Must be unique across all apps in the same account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#name App#name}
    */
    readonly name: string;
    /**
    * The slug for the DigitalOcean data center region hosting the app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#region App#region}
    */
    readonly region?: string;
    /**
    * alert block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#alert App#alert}
    */
    readonly alert?: AppSpecAlert[] | cdktf.IResolvable;
    /**
    * database block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#database App#database}
    */
    readonly database?: AppSpecDatabase[] | cdktf.IResolvable;
    /**
    * domain block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#domain App#domain}
    */
    readonly domain?: AppSpecDomain[] | cdktf.IResolvable;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#env App#env}
    */
    readonly env?: AppSpecEnv[] | cdktf.IResolvable;
    /**
    * function block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#function App#function}
    */
    readonly function?: AppSpecFunction[] | cdktf.IResolvable;
    /**
    * job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#job App#job}
    */
    readonly job?: AppSpecJob[] | cdktf.IResolvable;
    /**
    * service block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#service App#service}
    */
    readonly service?: AppSpecService[] | cdktf.IResolvable;
    /**
    * static_site block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#static_site App#static_site}
    */
    readonly staticSite?: AppSpecStaticSite[] | cdktf.IResolvable;
    /**
    * worker block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#worker App#worker}
    */
    readonly worker?: AppSpecWorker[] | cdktf.IResolvable;
}
export declare function appSpecToTerraform(struct?: AppSpecOutputReference | AppSpec): any;
export declare class AppSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSpec | undefined;
    set internalValue(value: AppSpec | undefined);
    private _domains?;
    get domains(): string[];
    set domains(value: string[]);
    resetDomains(): void;
    get domainsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _alert;
    get alert(): AppSpecAlertList;
    putAlert(value: AppSpecAlert[] | cdktf.IResolvable): void;
    resetAlert(): void;
    get alertInput(): cdktf.IResolvable | AppSpecAlert[] | undefined;
    private _database;
    get database(): AppSpecDatabaseList;
    putDatabase(value: AppSpecDatabase[] | cdktf.IResolvable): void;
    resetDatabase(): void;
    get databaseInput(): cdktf.IResolvable | AppSpecDatabase[] | undefined;
    private _domain;
    get domain(): AppSpecDomainList;
    putDomain(value: AppSpecDomain[] | cdktf.IResolvable): void;
    resetDomain(): void;
    get domainInput(): cdktf.IResolvable | AppSpecDomain[] | undefined;
    private _env;
    get env(): AppSpecEnvList;
    putEnv(value: AppSpecEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | AppSpecEnv[] | undefined;
    private _function;
    get function(): AppSpecFunctionList;
    putFunction(value: AppSpecFunction[] | cdktf.IResolvable): void;
    resetFunction(): void;
    get functionInput(): cdktf.IResolvable | AppSpecFunction[] | undefined;
    private _job;
    get job(): AppSpecJobList;
    putJob(value: AppSpecJob[] | cdktf.IResolvable): void;
    resetJob(): void;
    get jobInput(): cdktf.IResolvable | AppSpecJob[] | undefined;
    private _service;
    get service(): AppSpecServiceList;
    putService(value: AppSpecService[] | cdktf.IResolvable): void;
    resetService(): void;
    get serviceInput(): cdktf.IResolvable | AppSpecService[] | undefined;
    private _staticSite;
    get staticSite(): AppSpecStaticSiteList;
    putStaticSite(value: AppSpecStaticSite[] | cdktf.IResolvable): void;
    resetStaticSite(): void;
    get staticSiteInput(): cdktf.IResolvable | AppSpecStaticSite[] | undefined;
    private _worker;
    get worker(): AppSpecWorkerList;
    putWorker(value: AppSpecWorker[] | cdktf.IResolvable): void;
    resetWorker(): void;
    get workerInput(): cdktf.IResolvable | AppSpecWorker[] | undefined;
}
export interface AppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/app#create App#create}
    */
    readonly create?: string;
}
export declare function appTimeoutsToTerraform(struct?: AppTimeoutsOutputReference | AppTimeouts | cdktf.IResolvable): any;
export declare class AppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/app digitalocean_app}
*/
export declare class App extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_app";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/app digitalocean_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppConfig = {}
    */
    constructor(scope: Construct, id: string, config?: AppConfig);
    get activeDeploymentId(): string;
    get createdAt(): string;
    get defaultIngress(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get liveUrl(): string;
    get updatedAt(): string;
    get urn(): string;
    private _spec;
    get spec(): AppSpecOutputReference;
    putSpec(value: AppSpec): void;
    resetSpec(): void;
    get specInput(): AppSpec | undefined;
    private _timeouts;
    get timeouts(): AppTimeoutsOutputReference;
    putTimeouts(value: AppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
