import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CdnConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of a DigitalOcean managed TLS certificate for use with custom domains
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/cdn#certificate_id Cdn#certificate_id}
    */
    readonly certificateId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/cdn#certificate_name Cdn#certificate_name}
    */
    readonly certificateName?: string;
    /**
    * fully qualified domain name (FQDN) for custom subdomain, (requires certificate_id)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/cdn#custom_domain Cdn#custom_domain}
    */
    readonly customDomain?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/cdn#id Cdn#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * fully qualified domain name (FQDN) for the origin server
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/cdn#origin Cdn#origin}
    */
    readonly origin: string;
    /**
    * The amount of time the content is cached in the CDN
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/cdn#ttl Cdn#ttl}
    */
    readonly ttl?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/cdn digitalocean_cdn}
*/
export declare class Cdn extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_cdn";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/cdn digitalocean_cdn} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CdnConfig
    */
    constructor(scope: Construct, id: string, config: CdnConfig);
    private _certificateId?;
    get certificateId(): string;
    set certificateId(value: string);
    resetCertificateId(): void;
    get certificateIdInput(): string | undefined;
    private _certificateName?;
    get certificateName(): string;
    set certificateName(value: string);
    resetCertificateName(): void;
    get certificateNameInput(): string | undefined;
    get createdAt(): string;
    private _customDomain?;
    get customDomain(): string;
    set customDomain(value: string);
    resetCustomDomain(): void;
    get customDomainInput(): string | undefined;
    get endpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _origin?;
    get origin(): string;
    set origin(value: string);
    get originInput(): string | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
