import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerRegistryDockerCredentialsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/container_registry_docker_credentials#expiry_seconds ContainerRegistryDockerCredentials#expiry_seconds}
    */
    readonly expirySeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/container_registry_docker_credentials#id ContainerRegistryDockerCredentials#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/container_registry_docker_credentials#registry_name ContainerRegistryDockerCredentials#registry_name}
    */
    readonly registryName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/container_registry_docker_credentials#write ContainerRegistryDockerCredentials#write}
    */
    readonly write?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/container_registry_docker_credentials digitalocean_container_registry_docker_credentials}
*/
export declare class ContainerRegistryDockerCredentials extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_container_registry_docker_credentials";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/container_registry_docker_credentials digitalocean_container_registry_docker_credentials} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerRegistryDockerCredentialsConfig
    */
    constructor(scope: Construct, id: string, config: ContainerRegistryDockerCredentialsConfig);
    get credentialExpirationTime(): string;
    get dockerCredentials(): string;
    private _expirySeconds?;
    get expirySeconds(): number;
    set expirySeconds(value: number);
    resetExpirySeconds(): void;
    get expirySecondsInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _registryName?;
    get registryName(): string;
    set registryName(value: string);
    get registryNameInput(): string | undefined;
    private _write?;
    get write(): boolean | cdktf.IResolvable;
    set write(value: boolean | cdktf.IResolvable);
    resetWrite(): void;
    get writeInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
