import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/container_registry#id ContainerRegistry#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/container_registry#name ContainerRegistry#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/container_registry#region ContainerRegistry#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/container_registry#subscription_tier_slug ContainerRegistry#subscription_tier_slug}
    */
    readonly subscriptionTierSlug: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/container_registry digitalocean_container_registry}
*/
export declare class ContainerRegistry extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_container_registry";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/container_registry digitalocean_container_registry} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerRegistryConfig
    */
    constructor(scope: Construct, id: string, config: ContainerRegistryConfig);
    get createdAt(): string;
    get endpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get serverUrl(): string;
    get storageUsageBytes(): number;
    private _subscriptionTierSlug?;
    get subscriptionTierSlug(): string;
    set subscriptionTierSlug(value: string);
    get subscriptionTierSlugInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
