import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/account#id DataDigitaloceanAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/account digitalocean_account}
*/
export declare class DataDigitaloceanAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/account digitalocean_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanAccountConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDigitaloceanAccountConfig);
    get dropletLimit(): number;
    get email(): string;
    get emailVerified(): cdktf.IResolvable;
    get floatingIpLimit(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get status(): string;
    get statusMessage(): string;
    get uuid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
